//
//	class: CFireBall
//	Desc:  Visual Effect.
//
//	Note: p[eBNgpċOՕt̉΂̋ʂB
//	Author: Mr.K
//	First edition: Jan.26.2006
//
#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include <stdio.h>
#include ".\fireball.h"
#include "BillboardDerived.h"
#include "BurnUp.h"

/*==================================================
*    Lr{[h
*    ̃GtFNgCX^XQƂł邵
*    񋟂B
====================================================*/
CBillboardDerived	*g_pFireBallBillboard1 = NULL;

//-------------------------------------------------------------
//  Name: InitFireBallGraphics
//  Desc: Lr{[hւ̃|C^̏
//-------------------------------------------------------------
void    InitFireBallGraphics(CD3DEnv *pEnv){
    DeleteFireBallGraphics();
    if (g_pFireBallBillboard1 == NULL)
        g_pFireBallBillboard1 = new CBillboardDerived(pEnv,1);
	g_pFireBallBillboard1->SetTexture(0,"FireBall02.dds");
}


//-------------------------------------------------------------
//    Name: DeleteFireBallGraphics
//  Desc: Lr{[hւ̃|C^̏
//-------------------------------------------------------------
void    DeleteFireBallGraphics(){
    if (g_pFireBallBillboard1){
        delete    g_pFireBallBillboard1;
        g_pFireBallBillboard1 = NULL;
    }
}

CFireBall::CFireBall(CD3DEnv *pEnv, D3DXVECTOR3 *pVecSrc, D3DXVECTOR3 *pVecDest)
: CEffect()
{
	m_lpD3DEnv = pEnv;
	m_vecCurrentPos = *pVecSrc;
	m_vecDest = *pVecDest;
	m_vecVelocity = m_vecDest - m_vecCurrentPos;
	FLOAT	fDistance = D3DXVec3Length(&m_vecVelocity);
	D3DXVec3Normalize(&m_vecVelocity, &m_vecVelocity);
	m_vecVelocity *= SPEED_A;
	m_vecVelocity.y = (fDistance * GRAVITY_A) / (2.0f * SPEED_A);
	m_fireADummy.prev = m_fireADummy.next = &m_fireADummy;
	m_lpFireA = &m_fireADummy;
	m_dwPhase = 0;
	m_dwNumParticles = 0;
	m_fBufferedTime = 0;
}

CFireBall::~CFireBall(void)
{
	LPFIRE_PARTICLE_A	pTmp = m_lpFireA->next, pNext;
	while(pTmp != m_lpFireA){
		pNext = pTmp->next;
		delete	pTmp;
		pTmp = pNext;
	}
}

BOOL	CFireBall::Update(FLOAT timeElapsed){
	D3DXVECTOR3	vecTmp, vecOld;
	BOOL	bResult = FALSE;
	if (timeElapsed > 2.0f)
		timeElapsed = 2.0f;
	//	p[eBÑCe[V
	LPFIRE_PARTICLE_A	pTmp,pNext;
	pTmp = m_lpFireA->next;
	while(pTmp != m_lpFireA){
		pNext = pTmp->next;
		pTmp->t += timeElapsed;
		if (pTmp->t >= PARTICLE_LIFETIME_A){
			pTmp->next->prev = pTmp->prev;
			pTmp->prev->next = pTmp->next;
			delete	pTmp;
			m_dwNumParticles --;
		}
		pTmp = pNext;
	}
	FLOAT	fTmp = 0.0f;
	m_fBufferedTime += timeElapsed;

	switch(m_dwPhase){
		case	FIREBALL_PHASE_GO:
			//	eۂ΂
			vecTmp = m_vecDest - m_vecCurrentPos;
			if (D3DXVec3Length(&vecTmp) <= timeElapsed * D3DXVec3Length(&m_vecVelocity)){
				CBurnUp *pBurn = new CBurnUp(m_lpD3DEnv, &m_vecDest);
				::AddEffect(pBurn);
				m_dwPhase = FIREBALL_PHASE_WAIT;
			}
			while(m_fBufferedTime >= BLUR_EMITTING_FREQ){
				m_fBufferedTime -= BLUR_EMITTING_FREQ;
				vecOld = m_vecVelocity;
				m_vecVelocity.y -= GRAVITY_A * BLUR_EMITTING_FREQ;
				m_vecCurrentPos += (vecOld + m_vecVelocity) * BLUR_EMITTING_FREQ * 0.5f;

				pTmp = new FIRE_PARTICLE_A;
				pTmp->prev = m_lpFireA->prev;
				pTmp->next = m_lpFireA;
				m_lpFireA->prev->next = pTmp;
				m_lpFireA->prev = pTmp;

				m_dwNumParticles++;
				pTmp->t = m_fBufferedTime;
				pTmp->p = m_vecCurrentPos;
			}
			break;
		case	FIREBALL_PHASE_WAIT:
			if (m_lpFireA->next == m_lpFireA){
				bResult = TRUE;
			}
			break;
	}

	return	bResult;
}
void	CFireBall::Render(LPDIRECT3DDEVICE9 lpd3ddev){
	D3DXMATRIX	matWorld;
	D3DXMatrixTranslation(&matWorld,m_vecCurrentPos.x, m_vecCurrentPos.y, m_vecCurrentPos.z);

	//	Β萔
	static const FLOAT	fInvFadeBase = 1.0f / (PARTICLE_LIFETIME_A - PARTICLE_START_FO_A);
	static const FLOAT	fInvFadeLifetime = 1.0f / PARTICLE_LIFETIME_A;

	//	ϐ
	D3DCOLOR	diffuse;
	int	alpha;
	FLOAT	fTmp, fSize;
	DWORD	dwW, dwH;
	FLOAT	fW, fH;
	SHORT	sW, sH;

	g_pFireBallBillboard1->GetTextureSize(0,&dwW, &dwH);

	g_pFireBallBillboard1->GetOrdImageSize(0, &sW, &sH);
	fW = ((FLOAT)sW) / dwW;
	fH = ((FLOAT)sH) / dwH;

	g_pFireBallBillboard1->SetBlendingMethod(BILLBOARD_ADD_IN);
	g_pFireBallBillboard1->SetRenderState(lpd3ddev,0);	//	_OXe[g̐ݒ͒x̂ŁEEE
	lpd3ddev->SetRenderState(D3DRS_ZWRITEENABLE, FALSE);
	LPFIRE_PARTICLE_A	pTmp = m_lpFireA->next;
	while(pTmp != m_lpFireA){
		alpha = 255;
		if (pTmp->t > PARTICLE_START_FO_A){
			fTmp = pTmp->t - PARTICLE_START_FO_A;
			fTmp *= fInvFadeBase;
			fTmp = 1.0f - fTmp;
			alpha = (int)((float)alpha * fTmp);
		}
		
		fSize = 0.5f * (1.0f - pTmp->t * fInvFadeLifetime);

		diffuse = D3DCOLOR_ARGB(alpha,255,255,255);
		g_pFireBallBillboard1->SetDiffuse(diffuse);
		D3DXMatrixTranslation(&matWorld, pTmp->p.x,pTmp->p.y,pTmp->p.z);
		g_pFireBallBillboard1->Render2(lpd3ddev,&matWorld,m_lpD3DEnv->GetSystemView(),fSize,fSize,fW, fH, 0);
		pTmp = pTmp->next;
	}
	lpd3ddev->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);
	TCHAR	tmpStr[64];
	_stprintf(tmpStr,_T("Number of particles: %d"),m_dwNumParticles);
	m_lpD3DEnv->SystemD3DFont()->DrawText(20,440,D3DCOLOR_XRGB(255,255,255),tmpStr);
}

