/*
 *	class CFloor
 *		̎NX
 *
 *		First edition: June.20.2005
 *
 */
#ifndef __FLOOR_H__
#define	__FLOOR_H__

#ifndef	__MESH_H__
#include "Mesh.h"
#endif

struct	COLLISIONVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DXVECTOR3	n;	//	normal
};

class CFloor : public CMesh
{
public:
	CFloor(CD3DEnv *pEnv, TCHAR *pFname);
	virtual ~CFloor();
	void	SetWorldMatrix(D3DXMATRIX *pMat);
	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	float	GetBoundingSphere(D3DXVECTOR3 *pVec);
	void	GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	BOOL	ProbeTheGroundAltitude(D3DXVECTOR3 *pVec, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, D3DXVECTOR3 *pVecNormal, FLOAT *pAlt, FLOAT *pDist);
private:
	BOOL	Collide2Box(D3DXVECTOR3 *pMin1, D3DXVECTOR3 *pMax1, D3DXVECTOR3 *pMin2, D3DXVECTOR3 *pMax2);
	void	MatrixTriangleInverseRotation(D3DXMATRIX *pOut, D3DXVECTOR3 *vecZ);
	BOOL	ProbeTheTriangleHeight(COLLISIONVERTEX *pTri, FLOAT *pDist, FLOAT *pAlt, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax, D3DXVECTOR3 *pNormal, FLOAT x, FLOAT y, FLOAT z);
	void	CalcShortestDistanceAndAltitude(D3DXVECTOR3 *vecPos, COLLISIONVERTEX *vecP1, COLLISIONVERTEX *vecP2, float *pAlt, float *pDist, D3DXVECTOR3 *pNormal);
	D3DXMATRIX	m_matWorld;
};
extern void	InitializeLand();

#endif