/*
 *	class
 *
 *		CDeviceInformation
 *
 *		  ̃NX́AVXeɃCXg[ꂽ
 *		OtBbNXfoCXɂĂ̏WA
 *		񋟂@\B
 *
 *		First Edition: August.12.2002
 */
#ifndef	__DeviceInformation_h__
#define	__DeviceInformation_h__

typedef	HRESULT (*ConfirmDeviceCallback)(D3DCAPS9*,DWORD,D3DFORMAT);

//-----------------------------------------------------------------------------
// Name: struct D3DModeInfo
// Desc: fBXvC[hɂĂ̏ۑ
//-----------------------------------------------------------------------------
struct D3DModeInfo
{
    DWORD      Width;				// XN[
    DWORD      Height;				// XN[
    D3DFORMAT  Format;				// sNZtH[}bg
    DWORD      dwBehavior;			// Hardware / Software / Mixed vertex processing
    D3DFORMAT  DepthStencilFormat;	// [xEXeVobt@tH[}bg
};

//-----------------------------------------------------------------------------
// Name: struct D3DDeviceInfo
// Desc: Direct3D foCXɂĂ̏ۑB
//		̃foCXŎgp\ȃ[hɂĂ̏ɂĂ
//		B
//-----------------------------------------------------------------------------
struct D3DDeviceInfo
{
    // Device data
    D3DDEVTYPE   DeviceType;      // foCX^Cv REF, HAL, etc.
    D3DCAPS9     d3dCaps;         // ̃foCX CAPS
    BOOL         bCanDoWindowed;  // EChE[hgp\H

    DWORD        dwNumModes;		//	[h
    D3DModeInfo  *modes;			//	[hz

    DWORD        dwCurrentMode;		//	ݏ
    BOOL         bWindowed;			//	EChEԂH
    D3DMULTISAMPLE_TYPE MultiSampleType;
};

//-----------------------------------------------------------------------------
// Name: struct D3DAdapterInfo
// Desc: rfIJ[hɂĂ̏ۑ\
//-----------------------------------------------------------------------------
struct D3DAdapterInfo
{
    D3DADAPTER_IDENTIFIER9 d3dAdapterIdentifier;
    D3DDISPLAYMODE d3ddmDesktop;	//	̃A_v^̃fXNgbv[h
    DWORD          dwNumDevices;	//	foCX̐
    D3DDeviceInfo  *devices;		//	foCX̔z
    DWORD          dwCurrentDevice;	//	݂̃foCX
};


class	CDeviceInformation
{
	public:
		CDeviceInformation(LPDIRECT3D9 lpd3d, BOOL useD, DWORD minD=16, DWORD minS=0, ConfirmDeviceCallback cb=NULL);
		~CDeviceInformation();
		DWORD	getNumAdapters(){		return	m_dwNumAdapters;	}
		DWORD	getCurrentAdapter(){	return	m_dwAdapter;	}
		D3DAdapterInfo*	getAdapters(){	return	m_Adapters;		}
		BOOL	canWindowed()	{		return	m_bWindowed;	}
	private:
		HRESULT BuildDeviceList();
		void	ReleaseDeviceList();
		HRESULT	ConfirmDevice(D3DCAPS9*pCaps,DWORD dwBehavior, D3DFORMAT fmt);
		BOOL 	FindDepthStencilFormat( UINT iAdapter, D3DDEVTYPE DeviceType,
					    D3DFORMAT TargetFormat, D3DFORMAT* pDepthStencilFormat );
		HRESULT	AddValidModes(D3DDeviceInfo	*pDevice, D3DDISPLAYMODE *modes, D3DFORMAT *formats, DWORD *behavior, D3DFORMAT *fmtDepthStencil, BOOL *confirmed, DWORD numModes, DWORD numFormats);
		void	ConfirmFormats(int iAdapter, D3DDeviceInfo *pDevice, 
					D3DFORMAT *formats, BOOL *confirmed, 
					D3DFORMAT *fmtDepthStencil, DWORD *behavior, 
					DWORD numFormats);
		HRESULT	BuildModes(UINT iAdapter, DWORD dwNumAdapterModes, 
							DWORD *dwNumModes, DWORD *dwNumFormats, 
							D3DDISPLAYMODE *modes, D3DFORMAT *formats,
							D3DFORMAT fmt);
		LPDIRECT3D9	m_lpD3D;
		D3DAdapterInfo	*m_Adapters;
		ConfirmDeviceCallback	m_procCallback;
		DWORD	m_dwNumAllAdapters;		//	SA_v^̐
		DWORD	m_dwNumAdapters;		//	gp\ȃA_v^̐
		DWORD	m_dwAdapter;
		BOOL 	bHALExists;
		BOOL 	bHALIsWindowedCompatible;
		BOOL 	bHALIsDesktopCompatible;
		BOOL 	bHALIsSampleCompatible;
		BOOL	m_bWindowed;
		BOOL	m_bUseDepthBuffer;
		DWORD	m_dwMinDepthBits;
		DWORD	m_dwMinStencilBits;
};
#endif
