// Cursor.cpp: CCursor NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "Cursor.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CCursor::CCursor(CD3DEnv *pEnv)
{
	if (NULL != (m_pBillboard = new CBillboard(pEnv,1)))
		m_pBillboard->SetTexture(0,"cursor.dds");
	m_fX = 0.0f;
	m_fY = 0.0f;
}

CCursor::~CCursor()
{
	SAFE_DELETE(m_pBillboard);
}

BOOL	CCursor::Update(FLOAT timeElapsed,FLOAT x, FLOAT y)
{
	m_fX = x;
	m_fY = y;
	return	true;
}

void	CCursor::Render(LPDIRECT3DDEVICE9 lpd3ddev){
	DWORD	w,h;
	if (m_pBillboard == NULL)
		return;
	m_pBillboard->GetTextureSize(0,&w,&h);
	m_pBillboard->Render(lpd3ddev,m_fX,m_fY,(FLOAT)w,(FLOAT)h,0);
}
