//
//	class: CBurnUp
//	Desc: Explosion.
//
//	Note: p[eBNgpĔGtFNgB
//	Author: Mr.K
//	First edition: Jan.26.2006
//
#include "stdafx.h"
#include <d3dx9.h>
#include <D3DQuickLib.h>
#include <stdio.h>
#include "BillboardDerived.h"
#include ".\burnup.h"

//	܂
extern	CBillboardDerived	*g_pFireBallBillboard1;

CBurnUp::CBurnUp(CD3DEnv *pEnv, D3DXVECTOR3 *pVecPos)
{
	this->m_lpD3DEnv = pEnv;
	this->m_dwNumParticles = 0;
	this->m_dwPhase = 0;
	this->m_fBufferedTime = 0;
	this->m_fireBDummy.next = m_fireBDummy.prev = &m_fireBDummy;
	this->m_lpFireB = &m_fireBDummy;
	m_vecPos = *pVecPos;
	m_fTime = 0;
}

CBurnUp::~CBurnUp(void)
{
	LPFIRE_PARTICLE_B	pTmp = m_lpFireB->next, pNext;
	while(pTmp != m_lpFireB){
		pNext = pTmp->next;
		delete	pTmp;
		pTmp = pNext;
	}
}


BOOL	CBurnUp::Update(FLOAT timeElapsed){
	D3DXVECTOR3	vecTmp, vecOld;
	BOOL	bResult = FALSE;
	if (timeElapsed > 2.0f)
		timeElapsed = 2.0f;
	//	p[eBÑCe[V
	LPFIRE_PARTICLE_B	pTmp,pNext;
	pTmp = m_lpFireB->next;
	while(pTmp != m_lpFireB){
		pNext = pTmp->next;
		pTmp->t += timeElapsed;
		pTmp->v *= pow(0.9f,timeElapsed);
		pTmp->p += pTmp->v * timeElapsed;
		pTmp->p.y += PARTICLE_SPEED_B * timeElapsed;

		if (pTmp->t >= PARTICLE_LIFETIME_B){
			pTmp->next->prev = pTmp->prev;
			pTmp->prev->next = pTmp->next;
			delete	pTmp;
			m_dwNumParticles --;
		}
		pTmp = pNext;
	}
	FLOAT	fTmp = 0.0f;
	m_fBufferedTime += timeElapsed;

	switch(m_dwPhase){
		case	0:
			m_fTime += timeElapsed;
			while (m_fBufferedTime >= PARTICLE_EMIT_INTERVAL){
				m_fBufferedTime -= PARTICLE_EMIT_INTERVAL;
				pTmp = new FIRE_PARTICLE_B;
				
				fTmp = (FLOAT)rand() / (FLOAT)RAND_MAX;
				fTmp = D3DX_PI * 2.0f * fTmp;
				pTmp->v.x = cosf(fTmp);
				pTmp->v.y = 0.0f;
				pTmp->v.z = sinf(fTmp);
				fTmp = (FLOAT)rand() / (FLOAT)RAND_MAX;
				fTmp = PARTICLE_SPREAD_SPEED_B * fTmp;
				pTmp->v *= fTmp;
				pTmp->t = m_fBufferedTime;
				pTmp->p = m_vecPos;
				pTmp->next = m_lpFireB;
				pTmp->prev = m_lpFireB->prev;
				m_lpFireB->prev->next = pTmp;
				m_lpFireB->prev = pTmp;
				m_dwNumParticles++;
			}
			if (m_fTime >= BURNUP_LIFETIME)
				m_dwPhase++;
			break;
		case	1:
			//	p[eBNȂI
			if (m_lpFireB->next == m_lpFireB){
				bResult = TRUE;
			}
			break;
	}

	return	bResult;
}
void	CBurnUp::Render(LPDIRECT3DDEVICE9 lpd3ddev){
	D3DXMATRIX	matWorld;

	//	Β萔
	static const FLOAT	fInvFadeBase = 1.0f / (PARTICLE_LIFETIME_B - PARTICLE_START_FO_B);
	static const FLOAT	fInvFadeLifetime = 1.0f / PARTICLE_LIFETIME_B;

	//	ϐ
	D3DCOLOR	diffuse;
	int	alpha;
	FLOAT	fTmp, fSize;
	DWORD	dwW, dwH;
	FLOAT	fW, fH;
	SHORT	sW, sH;

	g_pFireBallBillboard1->GetTextureSize(0,&dwW, &dwH);

	g_pFireBallBillboard1->GetOrdImageSize(0, &sW, &sH);
	fW = ((FLOAT)sW) / dwW;
	fH = ((FLOAT)sH) / dwH;

	g_pFireBallBillboard1->SetBlendingMethod(BILLBOARD_ADD_IN);
	g_pFireBallBillboard1->SetRenderState(lpd3ddev,0);	//	_OXe[g̐ݒ͒x̂ŁEEE
	lpd3ddev->SetRenderState(D3DRS_ZWRITEENABLE, FALSE);
	LPFIRE_PARTICLE_B	pTmp = m_lpFireB->next;
	while(pTmp != m_lpFireB){
		alpha = 255;
		if (pTmp->t > PARTICLE_START_FO_B){
			fTmp = pTmp->t - PARTICLE_START_FO_B;
			fTmp *= fInvFadeBase;
			fTmp = 1.0f - fTmp;
			alpha = (int)((float)alpha * fTmp);
		}

		fSize = 1.5f * (1.0f - pTmp->t * fInvFadeLifetime);

		diffuse = D3DCOLOR_ARGB(alpha,255,255,255);
		g_pFireBallBillboard1->SetDiffuse(diffuse);
		D3DXMatrixTranslation(&matWorld, pTmp->p.x,pTmp->p.y,pTmp->p.z);
		g_pFireBallBillboard1->Render2(lpd3ddev,&matWorld,m_lpD3DEnv->GetSystemView(),fSize,fSize*1.2f,fW, fH, 0);
		pTmp = pTmp->next;
	}
	lpd3ddev->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);
	TCHAR	tmpStr[64];
	_stprintf(tmpStr,_T("Number of particles: %d"),m_dwNumParticles);
	m_lpD3DEnv->SystemD3DFont()->DrawText(20,400,D3DCOLOR_XRGB(255,255,255),tmpStr);
}

