//
//	class: CBillboardDerived
//	Desc: CBillboard ̔hNX
//
//	Note: p[eBNAĕ`悷P[Xz肵
//		ȕ`B
//
//	Author: Mr.K
//	First edition: Jan.26.2006
//
#include "StdAfx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include ".\billboardderived.h"

CBillboardDerived::CBillboardDerived(CD3DEnv *pEnv,int numTexture)
: CBillboard(pEnv,numTexture)
{
}

CBillboardDerived::~CBillboardDerived(void)
{
}

void	CBillboardDerived::SetRenderState(LPDIRECT3DDEVICE9 lpd3ddev, int texNo){
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
	lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
	if (m_uiBlendMethod == BILLBOARD_ADD_IN)
	    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
	else
	    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

	lpd3ddev->SetRenderState( D3DRS_ALPHATESTENABLE,  TRUE );
    lpd3ddev->SetRenderState( D3DRS_ALPHAREF,         0x08 );
    lpd3ddev->SetRenderState( D3DRS_ALPHAFUNC,  D3DCMP_GREATEREQUAL );
    lpd3ddev->SetRenderState( D3DRS_FILLMODE,   D3DFILL_SOLID );
	lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);

    lpd3ddev->SetRenderState( D3DRS_ALPHATESTENABLE,  TRUE );

	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);

	if (texNo < 0){
	    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
	    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2);
		lpd3ddev->SetTexture(0,NULL);
	}else{
		if (texNo >= (int)this->m_dwNumTextures)
			return;
	    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,  D3DTOP_MODULATE);
		lpd3ddev->SetTexture(0,m_pTexture[texNo].m_lpTex);
	}
	lpd3ddev->SetFVF(BILLBOARDVERTEXFVF);
}


//
//	_OXe[g̐ݒȂŕ`揈
//
void    CBillboardDerived::Render2(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, FLOAT fTexW, FLOAT fTexH, int texNo)
{
	D3DXMATRIX	matCamera,matBillboard;
	matCamera = *pMatWorld * *pMatView;
	MatrixInverseRotation(&matBillboard,&matCamera);
	matBillboard = matBillboard * *pMatWorld;

	if (m_fRotationAngle != 0.0f){
		D3DXMATRIX	matMove, matUnmove;
		D3DXMatrixTranslation(&matMove,0.0f,-0.5f * fH, 0.0f);
		D3DXMatrixTranslation(&matUnmove,0.0f,0.5f * fH, 0.0f);
		matBillboard = matMove * m_matRotation * matUnmove * matBillboard;	//	Kvł΃r{[h]B
	}

	lpd3ddev->SetTransform(D3DTS_WORLD,&matBillboard);

	BILLBOARDVERTEX	vertex[4];
	vertex[3].color = vertex[2].color = vertex[1].color
		= vertex[0].color=m_colorDiffuse;

	vertex[0].p = D3DXVECTOR3(-(fW * 0.5f),fH * 0.75f,0.0f);
	vertex[0].tu = 0;		//	
	vertex[0].tv = 0;		//
	vertex[0].n = D3DXVECTOR3(0.0f,0.0f,-1.0f);

	vertex[1].p = D3DXVECTOR3(-(fW * 0.5f),-fH * 0.25f,0.0f);
	vertex[1].tu = 0;		//	
	vertex[1].tv = fTexH;	//	
	vertex[1].n = D3DXVECTOR3(0.0f,0.0f,-1.0f);

	vertex[2].p = D3DXVECTOR3(fW * 0.5f,fH*0.75f,0.0f);
	vertex[2].tu = fTexW;	//	E
	vertex[2].tv = 0;		//	
	vertex[2].n = D3DXVECTOR3(0.0f,0.0f,-1.0f);


	vertex[3].p = D3DXVECTOR3(fW * 0.5f,-fH * 0.25f,0.0f);
	vertex[3].tu = fTexW;		//	E
	vertex[3].tv = fTexH;		//
	vertex[3].n = D3DXVECTOR3(0.0f,0.0f,-1.0f);

	lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,2,vertex,D3DXGetFVFVertexSize(BILLBOARDVERTEXFVF));
}
