//-----------------------------------------------------------------------------
// File: D3DFont.h
//
// Desc: eNX`gptHgNX
//-----------------------------------------------------------------------------
#ifndef __D3DFONT_H__
#define __D3DFONT_H__
#include <tchar.h>

class	CD3DFont;

//@tHgɎw肷tO
#define D3DFONT_BOLD        0x0001
#define D3DFONT_ITALIC      0x0002

//	tHg̃_OɎw肷tO
#define D3DFONT_FILTERED    0x0004

#ifndef	__D3D9ENV_H__
#include "d3d9env.h"
#endif
#ifndef	__GRAPHICSOBJECT_H__
#include "GraphicsObject.h"
#endif

//-----------------------------------------------------------------------------
// Name: class CD3DFont
// Desc: Rc`ɃeLXg`悷ׂ̃tHgNX.
//-----------------------------------------------------------------------------
class CD3DFont : public CGraphicsObject
{
public:
    // RXgN^EfXgN^
    CD3DFont( CD3DEnv *pEnv, TCHAR* strFontName, DWORD dwHeight, DWORD dwFlags=0L );
    virtual ~CD3DFont();
    // foCXˑIuWFNg̐Ɣj
	virtual	HRESULT DrawText( FLOAT x, FLOAT y, DWORD dwColor, 
                      TCHAR* strText, DWORD dwFlags=0L );
	virtual	HRESULT DrawTextScaled( FLOAT x, FLOAT y, 
                            FLOAT fXScale, FLOAT fYScale, DWORD dwColor, 
                            TCHAR* strText, DWORD dwFlags=0L );
    virtual	HRESULT GetTextExtent( TCHAR* strText, SIZE* pSize );
	//	eNX`̑S̕\ifobOpj
	void	Dump();
protected:
	virtual	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	HRESULT	DeleteDeviceObjects();

    TCHAR   m_strFontName[80];            // tHg
    DWORD   m_dwFontHeight;
    DWORD   m_dwFontFlags;

    LPDIRECT3DTEXTURE9      m_pTexture;   // eNX`IuWFNg
    LPDIRECT3DVERTEXBUFFER9 m_pVB;        // `p_obt@
    DWORD   m_dwTexWidth;                 // Texture TCY
    DWORD   m_dwTexHeight;				  // 
    FLOAT   m_fTextScale;
    FLOAT   m_fTexCoords[128-32][4];

    // Xe[gubN
    LPDIRECT3DSTATEBLOCK9 m_pStateBlockSaved;
    LPDIRECT3DSTATEBLOCK9 m_pStateBlockDrawText;
    DWORD   m_dwSavedStateBlock;
    DWORD   m_dwDrawTextStateBlock;
	CD3DEnv	*m_lpD3DEnv;

};
#endif


