/*
 *	class CBillboard
 *		r{[h̎
 *
 *		First edition: April.30.2004
 *
 */

#ifndef __BILLBOARD_H__
#define	__BILLBOARD_H__
#define	BILLBOARD_IS_UNINITIALIZED	0
#define	BILLBOARD_IS_INITIALIZED		1
#define	BILLBOARD_IS_RESTORED		2

#define	BILLBOARD_SEMI_TRANS		0
#define	BILLBOARD_ADD_IN			1

#ifndef	__GRAPHICSOBJECT_H__
#include "GraphicsObject.h"
#endif

#ifndef	__D3D9ENV_H__
#include "d3d9env.h"
#endif

struct	CBillboardTexture{
	LPDIRECT3DTEXTURE9	m_lpTex;
	USHORT		m_sOrdWidth;
	USHORT		m_sOrdHeight;
	USHORT		m_sTexWidth;
	USHORT		m_sTexHeight;
};

class CBillboard  : public CGraphicsObject
{
public:
	CBillboard(CD3DEnv *pEnv,int numTexture);
	virtual ~CBillboard();
	HRESULT	SetTexture(DWORD dwTexNo, LPSTR fName);
	void	Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, int texNo);
	void	Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, int texNo);
	void	Render(LPDIRECT3DDEVICE9 lpd3ddev,FLOAT x, FLOAT y, FLOAT w, FLOAT h, int texNo);
	HRESULT	GetTextureSize(UINT texNo, DWORD *w, DWORD *h);
	void	GetObjectCenter( D3DXVECTOR3 *pPos);
	void	SetDiffuse(D3DCOLOR	diffuse);
	void	SetBlendingMethod(UINT method);
	UINT	GetBillboardStatus(){	return	m_uiBillboardStatus;	}
protected:
	virtual	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	HRESULT	DeleteDeviceObjects();
private:
	void	MatrixInverseRotation(D3DXMATRIX *pOut, D3DXMATRIX *pMat);
	void	Create();
	CD3DEnv					*m_lpD3DEnv;			//	Direct3D 
	TCHAR					**m_ppFilenames;		//	eNX`t@Cl[
	DWORD					m_dwNumTextures;		//	}eA
	D3DXVECTOR3				m_vObjectCenter;		//	oE_̒S_
	BOOL					m_bUseHWNPatches;		//	
	UINT					m_dwNumSegs;			//	GbW̃ZOgieZ[Vxj
	UINT					m_uiBillboardStatus;	//	bV̏ԕϐ
	CBillboardTexture		*m_pTexture;			//	eLX`
	D3DCOLOR				m_colorDiffuse;			//
	UINT					m_uiBlendMethod;		//	At@ufBO̕@
};

struct	BILLBOARDVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DXVECTOR3	n;	//	normal
	D3DCOLOR	color;
	FLOAT		tu,tv;
};

#endif
