//------------------------------------------
// class: CD3DEnv
//
// Desc: Main Object of this class library that utilizes
//		Direct3D
//
//------------------------------------------
#ifndef	__D3D9ENV_H__
#define	__D3D9ENV_H__

class	CD3DEnv;

#ifndef __D3DFONT_H__
#include "d3dfont.h"
#endif
#ifndef	__DeviceInformation_h__
#include "deviceinformation.h"
#endif
#ifndef	__HIGHRESTIMER_H__
#include "HighResTimer.h"
#endif
#ifndef	__GRAPHICSOBJECT_H__
#include "GraphicsObject.h"
#endif

#define	DIRECTINPUT_VERSION (0x0800)
#include <dinput.h>

#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#define	SAFE_DELETE(o)	{if (o){	delete (o); (o) = NULL;	}}
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }

typedef	void (*AnimationCallback)(float);
typedef	void (*RenderSceneCallback)(LPDIRECT3DDEVICE9 lpd3ddev);
typedef	void (*AnimationCallback2)(float timeElapsed, DWORD userData);
typedef	void (*RenderSceneCallback2)(LPDIRECT3DDEVICE9 lpd3ddev, DWORD dwUser);
class	CTextureDB;
class	CTextureNode;

class	CGraphicsDummyNode : public CGraphicsObject{
public:
	virtual	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	HRESULT	DeleteDeviceObjects();
};

typedef struct	_orderingtable{
	FLOAT	m_fZ;
	short	m_usIndex;
	short	m_usMaterial;
}	OrderingTable;

class	CD3DEnv{
public:
	CD3DEnv();
	virtual	~CD3DEnv();

	virtual HRESULT	InitD3D(HWND hWnd);
	void	ReloadGraphics();

	virtual void	UpdateScene(AnimationCallback animCB = NULL, RenderSceneCallback renderCB = NULL);
	virtual void	RenderSceneWithVP(RECT *rcWindow, RenderSceneCallback renderCB = NULL);
	virtual void	UpdateScene(AnimationCallback2 animCB, RenderSceneCallback2 renderCB, DWORD dwUser);
	virtual void	RenderSceneWithVP(RECT *rcWindow, RenderSceneCallback2 renderCB, DWORD dwUser);

	BOOL	GetDI8KeyState(int key);
	BOOL	TextureDBRegisterNewKey(LPSTR key,CTextureNode **pRet);
	D3DXMATRIX	*GetSystemView(){			return	&m_matView;	}
	D3DXMATRIX	*GetSystemProjection(){		return	&m_matProj;	}
	D3DLIGHT9	*GetSystemLight(){	return	&m_litSysLight;	}
	D3DXVECTOR3	*GetSystemLightDirection();
	D3DCAPS9	*GetCurrentDeviceCaps(){	return	&m_CurrentDeviceCaps;	}
	D3DPRESENT_PARAMETERS	*GetD3DPresentParameters(){	return	&m_d3dprm;	}
	BOOL		IsWindowed()	{	return	m_bWindowed;	}
	BOOL		IsDepthBufferActive(){	return	m_bUseDepthBuffer;	}
	HRESULT	GetD3DDevice(LPDIRECT3DDEVICE9 *pDevice){	m_lpD3DDEV->AddRef();	*pDevice = m_lpD3DDEV;	return	S_OK;	}

	BOOL CALLBACK	EnumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance,
                                     VOID* pContext );
	BOOL CALLBACK	EnumObjectsCallback( const DIDEVICEOBJECTINSTANCE* pdidoi,
                                   VOID* pContext );

	void	AddGraphicsObject(CGraphicsObject *pObj);
	void	RemoveGraphicsObject(CGraphicsObject *pObj);

	TCHAR	*GetAppPathName();
	HRESULT	GetVertexShaderForSkinning(UINT no, LPDIRECT3DVERTEXSHADER9 *ppShader);
	DWORD	GetNumMaxOTFaces();
	OrderingTable *GetOT();
	HRESULT	ResizeOT(DWORD num);
	void	GetFileName(TCHAR *str,TCHAR *filepath);
	void	SetBackgroundColor(D3DCOLOR c){	m_colorBackground = c;	}

	//	@\gz肵\bhQ
	virtual	HRESULT Resize3DEnvironment();
	virtual	HRESULT UserAdjustWindow();
	virtual	HRESULT ToggleFullscreen();
	virtual	HRESULT ForceWindowed();
	virtual	HRESULT	ForceFullscreen();
	virtual	HRESULT AdjustWindow();
	virtual	HRESULT UserSelectNewDevice();
	virtual	void	InitLightParameters();
	virtual	void	SetupLights();
	virtual	void	SetDefaultRenderState(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	void	SetDefaultTransform(LPDIRECT3DDEVICE9 lpd3ddev);
	void		SetAmbientColor(D3DCOLOR c){	m_colAmbient = c;	}
	D3DCOLOR	GetAmbientColor(){	return	m_colAmbient;	}

	//	fobOp\bhQ
	void	RenderBoundingBoxForDebug(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	void	DrawFPS(float timeElapsed);

	//	ȈՎ擾\bhQ
	LPDIRECT3D9			SystemD3D(){	return	m_lpD3D;	}
	LPDIRECT3DDEVICE9	SystemD3DDevice(){	return	m_lpD3DDEV;	}
	CD3DFont*			SystemD3DFont(){	return	m_pFont;	}
	CDeviceInformation*	SystemDeviceInfo(){	return	m_lpDevices;	}
	DWORD				GetBackBufferWidth();
	DWORD				GetBackBufferHeight();

protected:
	virtual	DWORD	SelectMode(D3DModeInfo *modes, DWORD numModes);

	void	ReleaseD3D();
	HRESULT	InitDeviceObjects();
	HRESULT	InvalidateDeviceObjects();
	HRESULT	RestoreDeviceObjects();
	HRESULT	DeleteDeviceObjects();
	void	RestoreSkinnedMeshShaders(LPDIRECT3DDEVICE9 lpd3ddev);
	void	InvalidateSkinnedMeshShaders();

	void	InitFail(HWND hWnd, LPCTSTR szError,...);
	void	PrepareAppPathName();
	virtual	HRESULT Initialize3DEnvironment(HWND hWnd);
	virtual	void	InitDefaultTransform();

	//	dinput ̋@\͐ؗ\
	virtual	HRESULT	InitDI(HWND hWnd);
	virtual	void	ReleaseDI();
	virtual	void	DoIO();
	HWND					m_hWnd;
	D3DPRESENT_PARAMETERS	m_d3dprm;
	LPDIRECT3D9				m_lpD3D;
	LPDIRECT3DDEVICE9		m_lpD3DDEV;

	CD3DFont				*m_pFont;	//	ptHgVXeEE

	LPDIRECTINPUT8			m_lpDI;
	LPDIRECTINPUTDEVICE8	m_pKeyboard;
	LPDIRECTINPUTDEVICE8	m_pJoystick;     
	BYTE					*m_pKeys;
	DWORD					m_dwJoystickDeadzone;
	long					m_lJoystickXMin;
	long					m_lJoystickXCtr;
	long					m_lJoystickXMax;
	long					m_lJoystickYMin;
	long					m_lJoystickYCtr;
	long					m_lJoystickYMax;
	long					m_lJoystickXThreshold;
	long					m_lJoystickYThreshold;
	long					m_lJoyX, m_lJoyY;

	CDeviceInformation	*m_lpDevices;
	D3DAdapterInfo		*m_Adapters;
	DWORD				m_dwNumAdapters;
	DWORD				m_dwAdapter;
	DWORD				m_dwMinDepthBits;
	DWORD				m_dwMinStencilBits;
	DWORD				m_dwWindowStyle;
	RECT				m_rcWindowBounds;
	RECT				m_rcWindowClient;
	D3DCAPS9			m_CurrentDeviceCaps;
	D3DSURFACE_DESC		m_d3dsdBackBuffer;

	D3DXMATRIX			m_matView;
	D3DXMATRIX			m_matProj;

	D3DLIGHT9			m_litSysLight;			//	VXeiLj
	D3DXVECTOR3			m_vecLight;				//	VXe̕
	D3DCOLOR			m_colAmbient;			//	ArGgF

	CHighResTimer		*m_pHighResTimer;
	CTextureDB			*m_pTextureDB;

	CGraphicsObject		*m_pGraphicsObjects;	//	Billboard, Mesh ̑
	CGraphicsDummyNode	m_dummyNode;
	TCHAR				m_strAppPath[MAX_PATH];

	IDirect3DVertexShader9	*m_pVertexShadersForSkinning[4];	//	SkinnedMesh p Shader
	DWORD				m_dwMaxOTFaces;
	OrderingTable		*m_pOrderingTable;

	D3DCOLOR			m_colorBackground;
	BOOL				m_bWindowed;
	BOOL				m_bUseDepthBuffer;
	BOOL				m_bViewportRendered;
#ifdef	_DEBUG
	float debugFpsBuffer[8];
	int	  debugFpsPointer;
#endif
};

#endif