#ifndef	__TextureDB_h__
#define	__TextureDB_h__

class	CTextureNode;
class	CTextureDB{
public:
	CTextureDB();
	~CTextureDB();
	void	DeleteDecendants(CTextureNode *pNode);
	void	DeleteTheNode(CTextureNode *pNode);
	BOOL RegisterNewKey(LPSTR key, CTextureNode **pRet);
	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	HRESULT	InvalidateDeviceObjects();
private:
	HRESULT	RestoreObjectsOfDecendants(LPDIRECT3DDEVICE9 lpd3ddev,CTextureNode *pNode);
	HRESULT	InvalidateObjectsOfDecendants(CTextureNode *pNode);
	DWORD				dwUnique;
	DWORD				dwNumNodes;
	CTextureNode		*m_pNode;
	CTextureNode		*m_pSentinel;
};


class	CTextureNode{
public:
	CTextureNode(LPSTR pStr,LPDIRECT3DTEXTURE9 pTex = NULL){
		m_iRefCount = 1;
		int	len;
		len = _tcslen(pStr);
		m_strFilename = new TCHAR[len+1];
		_tcscpy(m_strFilename,pStr);
		m_pTexture = pTex;
	}
	void	StoreTexture(LPDIRECT3DTEXTURE9 pTex){
		m_pTexture = pTex;
	}
	void	Release();
	LPDIRECT3DTEXTURE9	GetTexture(){
		return	m_pTexture;
	}
private:
	friend class CTextureDB;
	CTextureDB		*m_pTextureDB;
	CTextureNode	**m_ppParent;
	CTextureNode	*m_pLeft;
	CTextureNode	*m_pRight;
	int				m_iRefCount;
	TCHAR			*m_strFilename;
	LPDIRECT3DTEXTURE9	m_pTexture;
};

#endif
