/*
 *	class CWall
 *		ǂ̎NX
 *
 *		First edition: March.09.2004
 *
*/
#ifndef __WALL_H__
#define	__WALL_H__

#ifndef	__MESH_H__
#include "Mesh.h"
#endif

struct	WALLCOLLISIONVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DXVECTOR3	n;	//	normal
};

class CWall : public CMesh
{
public:
	CWall(CD3DEnv *pEnv, TCHAR *pFname);
	virtual ~CWall();
	void	SetWorldMatrix(D3DXMATRIX *pMat);
	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	float	GetBoundingSphere(D3DXVECTOR3 *pVec);
	void	GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	BOOL	ProbeTheWall(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal, FLOAT *pDist);
private:
	BOOL	ProbeTheTriangleDistance(WALLCOLLISIONVERTEX *pTri, FLOAT *pDist, D3DXVECTOR3 *pPos, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, FLOAT fRadius, D3DXVECTOR3 *pNormal);
	BOOL	Collide2Box(D3DXVECTOR3 *pMin1, D3DXVECTOR3 *pMax1, D3DXVECTOR3 *pMin2, D3DXVECTOR3 *pMax2);
	void	MatrixInverseRotation(D3DXMATRIX *pOut, D3DXVECTOR3 *vecX,D3DXVECTOR3 *vecY,D3DXVECTOR3 *vecZ);
	void	CalcShortestDistanceAndAltitude(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, float *pDist, D3DXVECTOR3 *pNormal);
	D3DXMATRIX	m_matWorld;
};
extern void	InitializeWall();

#endif