/*
 *	class CSkinnedMesh
 *		bVɋ@\ǉ郆[eBeB[NX
 *
 *		First edition: February.19.2004
 *
*/
#ifndef	__SKINNEDMESH_H__
#define	__SKINNEDMESH_H__

#ifndef __MESH_H__
#include "Mesh.h"
#endif

#define	SKINNEDMESH_IS_UNINITIALIZED	0
#define	SKINNEDMESH_IS_INITIALIZED		1
#define	SKINNEDMESH_IS_RESTORED		2
class CSkinnedMesh;

//-----------------------------------------------------------------------------
// Name: struct D3DXFRAME_DERIVED
// Desc: D3DXFRAME ̊g\́Aet[gXtH[[V
//		sێł悤ɂĂB
//-----------------------------------------------------------------------------
struct D3DXFRAME_DERIVED: public D3DXFRAME
{
    D3DXMATRIXA16        CombinedTransformationMatrix;
};


//-----------------------------------------------------------------------------
// Name: struct D3DXMESHCONTAINER_DERIVED
// Desc: Structure derived from D3DXMESHCONTAINER so we can add some app-specific
//       info that will be stored with each mesh
//-----------------------------------------------------------------------------
class	CTextureNode;
struct D3DXMESHCONTAINER_DERIVED: public D3DXMESHCONTAINER
{
    CTextureNode			**ppTextures;         
    // SkinMesh info             
    LPD3DXMESH           pOrigMesh;
    LPD3DXATTRIBUTERANGE pAttributeTable;
    DWORD                NumAttributeGroups; 
    DWORD                NumInfl;
    LPD3DXBUFFER         pBoneCombinationBuf;
    D3DXMATRIX**         ppBoneMatrixPtrs;
    D3DXMATRIX*          pBoneOffsetMatrices;
    DWORD                NumPaletteEntries;
    bool                 UseSoftwareVP;
    DWORD                iAttributeSW;     // used to denote the split between SW and HW if necessary for non-indexed skinning
};

//-----------------------------------------------------------------------------
// Name: class CAllocateHierarchy
// Desc: Custom version of ID3DXAllocateHierarchy with custom methods to create
//       frames and meshcontainers.
//-----------------------------------------------------------------------------
class CAllocateHierarchy: public ID3DXAllocateHierarchy
{
public:
    STDMETHOD(CreateFrame)(THIS_ LPCTSTR Name, LPD3DXFRAME *ppNewFrame);
    STDMETHOD(CreateMeshContainer)(THIS_ LPCTSTR Name, LPD3DXMESHDATA pMeshData,
                            LPD3DXMATERIAL pMaterials, LPD3DXEFFECTINSTANCE pEffectInstances, DWORD NumMaterials, 
                            DWORD *pAdjacency, LPD3DXSKININFO pSkinInfo, 
                            LPD3DXMESHCONTAINER *ppNewMeshContainer);
    STDMETHOD(DestroyFrame)(THIS_ LPD3DXFRAME pFrameToFree);
    STDMETHOD(DestroyMeshContainer)(THIS_ LPD3DXMESHCONTAINER pMeshContainerBase);
    CAllocateHierarchy(CSkinnedMesh *p){	m_pParent = p;	}
private:
	CSkinnedMesh	*m_pParent;
};

class CSkinnedMesh : public CMesh
{
	friend	class	CAllocateHierarchy;
public:
	CSkinnedMesh(CD3DEnv *pEnv, TCHAR *fname);
	virtual ~CSkinnedMesh();
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);

	HRESULT	FrameMove(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fElapsedTime);
	HRESULT AdjustAnimation(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView);
	HRESULT	ResetAnimation(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView);
	HRESULT	GetAnimationController(LPD3DXANIMATIONCONTROLLER *p);
	void	SetFog(FLOAT fStart, FLOAT fEnd);
protected:
	virtual	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	HRESULT	DeleteDeviceObjects();
private:
	void	UpdateFrameMatrices(LPD3DXFRAME pFrameBase, LPD3DXMATRIX pParentMatrix);
	HRESULT	AddAnimation(TCHAR *fname);
	void	DrawFrame(LPD3DXFRAME pFrame);
	void	DrawMeshContainer(LPD3DXMESHCONTAINER pMeshContainerBase, LPD3DXFRAME pFrameBase);
	HRESULT	GenerateSkinnedMesh(D3DXMESHCONTAINER_DERIVED *pMeshContainer);
	HRESULT SetupBoneMatrixPointersOnMesh( LPD3DXMESHCONTAINER pMeshContainer );
    HRESULT SetupBoneMatrixPointers( LPD3DXFRAME pFrame );

	LPDIRECT3DDEVICE9			m_lpD3DDeviceTmp;
    LPD3DXFRAME                 m_pFrameRoot;
    LPD3DXANIMATIONCONTROLLER   m_pAnimController;

    D3DXMATRIXA16               m_matView;
    D3DXMATRIXA16               m_matWorld;

	FLOAT	m_fFogStart;
	FLOAT	m_fFogEnd;
};

extern void	InitSkinnedMeshSystem();
extern void	InitSkinnedMeshGraphics(LPDIRECT3DDEVICE9 lpd3ddev);
extern void	RestoreSkinnedMeshGraphics(LPDIRECT3DDEVICE9 lpd3ddev);
extern void	InvalidateSkinnedMeshGraphics();
extern void	DeleteSkinnedMeshGraphics();

#endif