/*
 *		SDI `ŃAvP[VNB
 *		D3DQuickLib A`\zB
 */
#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"

CD3DEnv	*g_pD3DEnv = NULL;
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "D3DQuickLibSample";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Tuto01 - How to Initialize the D3DQuickLib.",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        640 * 2 - client.right,
        480 * 2 - client.bottom,
        false );
    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

	//	D3DQuickLib ̏
	g_pD3DEnv = new CD3DEnv();
	if (FAILED(g_pD3DEnv->InitD3D(hWnd))){
		DestroyWindow(hWnd);
	}

    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
			g_pD3DEnv->UpdateScene();
        }
    }
	//	D3DQuickLib ̏I
	SAFE_DELETE(g_pD3DEnv);
    return (int)msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case    WM_SIZE:
			//	EChEő剻ꂽAtXN[[hɂB
            if (SIZE_MAXIMIZED == wParam){
				g_pD3DEnv->ForceFullscreen();
			}
            break;
        case    WM_SETCURSOR:
			//	tXN[̓J[\\ȂB
			if (g_pD3DEnv->IsWindowed())
				::SetCursor(::LoadCursor(NULL,IDC_ARROW));
			else
				::SetCursor(NULL);
            break;
        case    WM_SYSCHAR:
			//	Alt-Enter ŃtXN[[h֐؂ւ
            if (lParam&0x20000000){
                if (wParam == '\x0d'){
                    g_pD3DEnv->ToggleFullscreen();
                    break;
                }
            }
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_SYSCOMMAND:
			if (!g_pD3DEnv->IsWindowed()){	//	tXN[
				if (wParam != SC_CLOSE)
					break;

				//	WindowOWindow[hɖ߂ĂB
                g_pD3DEnv->ToggleFullscreen();
				Sleep(100);
			}
            return DefWindowProc( hWnd, message, wParam, lParam );

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}
