/*
 *	class CSkinnedMesh
 *		bVɋ@\ǉ郆[eBeB[NX
 *
 *		First edition: February.19.2004
 *
*/
#include "stdafx.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "d3d9env.h"
#include <dxfile.h>
#include <rmxftmpl.h>
#include <rmxfguid.h>
#include <crtdbg.h>
#include "ShaderContainer.h"
#include "SkinnedMesh.h"
#include <tchar.h>
#include "TextureDB.h"
#include "FilenameDecoder.h"

//-----------------------------------------------------------------------------
// Name: AllocateName()
// Desc: mۂāARs[B
//-----------------------------------------------------------------------------
static HRESULT AllocateName( LPCTSTR Name, LPTSTR *pNewName )
{
    UINT uiLength;
	if (Name != NULL){
		uiLength = lstrlen(Name) + 1;
		*pNewName = new TCHAR[uiLength];
		if (*pNewName == NULL)
            return E_OUTOFMEMORY;
        memcpy(*pNewName, Name, uiLength*sizeof(TCHAR));
    }else{
        *pNewName = NULL;
    }
	return S_OK;
}


//-----------------------------------------------------------------------------
// Name: CAllocateHierarchy::CreateFrame()
// Desc: Frame ̐B
//-----------------------------------------------------------------------------
HRESULT CAllocateHierarchy::CreateFrame(LPCTSTR Name, LPD3DXFRAME *ppNewFrame)
{
	HRESULT hr = S_OK;
	SKINNEDMESH_FRAME *pFrame = NULL;

	*ppNewFrame = NULL;

	pFrame = new SKINNEDMESH_FRAME;
	if (pFrame == NULL){
        hr = E_OUTOFMEMORY;
        goto e_Exit;
    }
    hr = AllocateName(Name, &pFrame->Name);
    if (FAILED(hr))
        goto e_Exit;

    // initialize other data members of the frame
    D3DXMatrixIdentity(&pFrame->TransformationMatrix);
    D3DXMatrixIdentity(&pFrame->CombinedTransformationMatrix);

    pFrame->pMeshContainer = NULL;
    pFrame->pFrameSibling = NULL;
    pFrame->pFrameFirstChild = NULL;

    *ppNewFrame = pFrame;
    pFrame = NULL;
    return hr;
e_Exit:
	SAFE_DELETE(pFrame);
    return hr;
}




//-----------------------------------------------------------------------------
// Name: CAllocateHierarchy::CreateMeshContainer()
// Desc: MeshContainer ̐
//-----------------------------------------------------------------------------
#if D3DX_VERSION < 0x0902
HRESULT CAllocateHierarchy::CreateMeshContainer(LPCTSTR Name, 
							LPD3DXMESHDATA pMeshData,
                            LPD3DXMATERIAL pMaterials, 
							LPD3DXEFFECTINSTANCE pEffectInstances,
							DWORD NumMaterials, 
                            DWORD *pAdjacency, 
							LPD3DXSKININFO pSkinInfo, 
                            LPD3DXMESHCONTAINER *ppNewMeshContainer)
#else
HRESULT CAllocateHierarchy::CreateMeshContainer(LPCTSTR Name, 
							CONST D3DXMESHDATA *pMeshData,
                            CONST D3DXMATERIAL *pMaterials, 
							CONST D3DXEFFECTINSTANCE *pEffectInstances,
							DWORD NumMaterials, 
                            CONST DWORD *pAdjacency, 
							LPD3DXSKININFO pSkinInfo, 
                            LPD3DXMESHCONTAINER *ppNewMeshContainer) 
#endif
{
    HRESULT hr;
    CSkinnedMeshContainer *pMeshContainer = NULL;
    UINT NumFaces;
    UINT iMaterial;
    UINT iBone, cBones;
    LPDIRECT3DDEVICE9 pd3dDevice = NULL;

    LPD3DXMESH pMesh = NULL;
    *ppNewMeshContainer = NULL;

    // ̃vÓAPatch Mesh  Progressive Mesh T|[gȂB
    if (pMeshData->Type != D3DXMESHTYPE_MESH){
        hr = E_FAIL;
        goto errot_exit;
    }

    // bVf[^ bVoB
    pMesh = pMeshData->pMesh;

    // FVF ΎgpłȂB
    if (pMesh->GetFVF() == 0){
        hr = E_FAIL;
        goto errot_exit;
    }

    //	m
    pMeshContainer = new CSkinnedMeshContainer;
    if (pMeshContainer == NULL){
        hr = E_OUTOFMEMORY;
        goto errot_exit;
    }
    memset(pMeshContainer, 0, sizeof(CSkinnedMeshContainer));

    // MeshContainer ֖ORs[
    hr = AllocateName(Name, &pMeshContainer->Name);
    if (FAILED(hr))
        goto errot_exit;

    pMesh->GetDevice(&pd3dDevice);
    NumFaces = pMesh->GetNumFaces();

    //	bVɖ@ΒǉB
    if (!(pMesh->GetFVF() & D3DFVF_NORMAL)){
        pMeshContainer->MeshData.Type = D3DXMESHTYPE_MESH;

        //	ԂׁAbV𕡐B
        hr = pMesh->CloneMeshFVF( pMesh->GetOptions(), 
                                    pMesh->GetFVF() | D3DFVF_NORMAL, 
                                    pd3dDevice, &pMeshContainer->MeshData.pMesh );
        if (FAILED(hr))
            goto errot_exit;

        // VbVւ̃|C^擾
        // NOTE: ̃bVւ̃t@X͒ǉĂȂ̂ŁA
		//		ÂbVRelease ͂ȂB
		//		iĂяoŔjBj
        pMesh = pMeshContainer->MeshData.pMesh;

        //	@xNg̎Zo
        D3DXComputeNormals( pMesh, NULL );
    }else{
		// ɖ@ݒ肳Ă΁APɃt@XǉB
        pMeshContainer->MeshData.pMesh = pMesh;
        pMeshContainer->MeshData.Type = D3DXMESHTYPE_MESH;

        pMesh->AddRef();	//	t@Xǉ
					//	Note:̃bV͌ĂяoReleaseB
    }
        
    //	}eÂ߂̃mہB
    pMeshContainer->NumMaterials = max(1, NumMaterials);
    pMeshContainer->pMaterials = new D3DXMATERIAL[pMeshContainer->NumMaterials];
    pMeshContainer->ppTextures = new CTextureNode*[pMeshContainer->NumMaterials];
    pMeshContainer->pAdjacency = new DWORD[NumFaces*3];
    ZeroMemory(pMeshContainer->ppTextures,sizeof(CTextureNode*)*pMeshContainer->NumMaterials);

    if ((pMeshContainer->pAdjacency == NULL) || (pMeshContainer->pMaterials == NULL)){
        hr = E_OUTOFMEMORY;
        goto errot_exit;
    }

    memcpy(pMeshContainer->pAdjacency, pAdjacency, sizeof(DWORD) * NumFaces*3);

    // }eA񂪂΃Rs[B
    if (NumMaterials > 0){
        memcpy(pMeshContainer->pMaterials, pMaterials, sizeof(D3DXMATERIAL) * NumMaterials);
        for (iMaterial = 0; iMaterial < NumMaterials; iMaterial++){
			if (pMeshContainer->pMaterials[iMaterial].pTextureFilename != NULL)
            {
                TCHAR strTexturePath[MAX_PATH] = _T("");
				TCHAR	tmp[MAX_PATH], *p;
				_tcscpy_s( tmp, _countof(tmp), pMeshContainer->pMaterials[iMaterial].pTextureFilename );
				p = tmp;
				if (tmp[0] == _T('\"')){
					++p;
				}
				if ((p[0] == _T('\\') && p[1] == _T('\\')) || (p[1] == _T(':'))){
					m_pParent->m_lpD3DEnv->GetFileName(tmp,NULL);
				}
				_tcscpy_s(strTexturePath,this->m_pParent->m_strMeshPath );
				_tcscat_s(strTexturePath,"\\");
				_tcscat_s(strTexturePath,tmp);

				CFilenameDecoder	*dec = new CFilenameDecoder(strTexturePath,true);
				TCHAR	*text;
				DWORD	dwTemp = 0;
				dec->GetFullname(&dwTemp,NULL);
				text = new TCHAR[dwTemp];
				dec->GetFullname(&dwTemp,text);
				SAFE_DELETE(dec);

				m_pParent->m_lpD3DEnv->TextureDBRegisterNewKey(text,&pMeshContainer->ppTextures[iMaterial]);
				SAFE_DELETE(text);
				//	t@C폜
                 pMeshContainer->pMaterials[iMaterial].pTextureFilename = NULL;
            }
			pMeshContainer->pMaterials[iMaterial].MatD3D.Ambient
				= pMeshContainer->pMaterials[iMaterial].MatD3D.Diffuse;
		}
	}else{
		// bVf[^Ƀ}eA񂪖΃ftHg쐬
        pMeshContainer->pMaterials[0].pTextureFilename = NULL;
        memset(&pMeshContainer->pMaterials[0].MatD3D, 0, sizeof(D3DMATERIAL9));
        pMeshContainer->pMaterials[0].MatD3D.Diffuse.r = 0.5f;
        pMeshContainer->pMaterials[0].MatD3D.Diffuse.g = 0.5f;
        pMeshContainer->pMaterials[0].MatD3D.Diffuse.b = 0.5f;
        pMeshContainer->pMaterials[0].MatD3D.Specular = pMeshContainer->pMaterials[0].MatD3D.Diffuse;
		pMeshContainer->pMaterials[0].MatD3D.Ambient
			= pMeshContainer->pMaterials[0].MatD3D.Diffuse;
    }

	//	XLjOɊւ񂪂΁AۑAHW XLjÖׂ̃ZbgAbvsB
    if (pSkinInfo != NULL){
        pMeshContainer->pSkinInfo = pSkinInfo;
        pSkinInfo->AddRef();

        pMeshContainer->pOrigMesh = pMesh;
        pMesh->AddRef();

		//	̋Ԃ{[Ԃւ̈ړׂ̈̍s̔zB
		//	{[ԁFƂȂ{[̉]__ƂԁEEEɂH
        cBones = pSkinInfo->GetNumBones();
        pMeshContainer->pBoneOffsetMatrices = new D3DXMATRIX[cBones];
        if (pMeshContainer->pBoneOffsetMatrices == NULL){
			hr = E_OUTOFMEMORY;
			goto errot_exit;
        }

		//	{[Ԃւ̕ϊׂ̈̍s擾ĂB
        for (iBone = 0; iBone < cBones; iBone++){
			pMeshContainer->pBoneOffsetMatrices[iBone] = *(pMeshContainer->pSkinInfo->GetBoneOffsetMatrix(iBone));
		}
		//	XLjO擾AHW XLjOs₷悤ɕϊB
		hr = m_pParent->GenerateSkinnedMesh(pMeshContainer);
        if (FAILED(hr))
            goto errot_exit;
    }

    *ppNewMeshContainer = pMeshContainer;
    pMeshContainer = NULL;
errot_exit:
    SAFE_RELEASE(pd3dDevice);
    // G[΁AMeshContainer 폜B
    if (pMeshContainer != NULL){
        DestroyMeshContainer(pMeshContainer);
    }
    return hr;
}

//-----------------------------------------------------------------------------
// Name: CAllocateHierarchy::DestroyFrame()
// Desc: 
//-----------------------------------------------------------------------------
HRESULT CAllocateHierarchy::DestroyFrame(LPD3DXFRAME pFrameToFree) 
{
    SAFE_DELETE_ARRAY( pFrameToFree->Name );
    SAFE_DELETE( pFrameToFree );
    return S_OK; 
}

//-----------------------------------------------------------------------------
// Name: CAllocateHierarchy::DestroyMeshContainer()
// Desc: 
//-----------------------------------------------------------------------------
HRESULT CAllocateHierarchy::DestroyMeshContainer(LPD3DXMESHCONTAINER pMeshContainerBase)
{
    UINT iMaterial;
    CSkinnedMeshContainer *pMeshContainer = (CSkinnedMeshContainer*)pMeshContainerBase;

    SAFE_DELETE_ARRAY( pMeshContainer->Name );
    SAFE_DELETE_ARRAY( pMeshContainer->pAdjacency );
    SAFE_DELETE_ARRAY( pMeshContainer->pMaterials );
    SAFE_DELETE_ARRAY( pMeshContainer->pBoneOffsetMatrices );

    // SẴeNX`
    if (pMeshContainer->ppTextures != NULL)
    {
        for (iMaterial = 0; iMaterial < pMeshContainer->NumMaterials; iMaterial++)
        {
			if (pMeshContainer->ppTextures[iMaterial] ){
				pMeshContainer->ppTextures[iMaterial]->Release();
				pMeshContainer->ppTextures[iMaterial] = NULL;
			}
        }
    }

    SAFE_DELETE_ARRAY( pMeshContainer->ppTextures );
    SAFE_DELETE_ARRAY( pMeshContainer->ppBoneMatrixPtrs );
    SAFE_RELEASE( pMeshContainer->pBoneCombinationBuf );
    SAFE_RELEASE( pMeshContainer->MeshData.pMesh );
    SAFE_RELEASE( pMeshContainer->pSkinInfo );
    SAFE_RELEASE( pMeshContainer->pOrigMesh );
    SAFE_DELETE( pMeshContainer );
    return S_OK;
}

//-------------------------------------------------------------
//	Name: CSkinnedMesh
//  Desc: RXgN^
//-------------------------------------------------------------
CSkinnedMesh::CSkinnedMesh(CD3DEnv *pEnv, TCHAR *fname) : CMesh(pEnv, fname)
{
	m_uiMeshStatus = MESH_IS_UNINITIALIZED;
	D3DXMatrixIdentity(&m_matView);
    m_pFrameRoot = NULL;
    m_pAnimController = NULL;
	m_vObjectCenter = D3DXVECTOR3(0,0,0);
	m_fObjectRadius = 0;
	m_vecObjectMax = m_vObjectCenter;
	m_vecObjectMin = m_vObjectCenter;
	m_lpD3DDeviceTmp = NULL;
	m_fFogStart = 1.0f;	//	Disable the fog
	m_fFogEnd = 0.0f;	//
	D3DXMatrixIdentity(&m_matView);
	D3DXMatrixIdentity(&m_matWorld);
	m_pShaders[0] = pEnv->GetShaderContainer(__uuidof(CLSID_SkinnedMeshVS1));
	m_pShaders[1] = pEnv->GetShaderContainer(__uuidof(CLSID_SkinnedMeshVS2));
	m_pShaders[2] = pEnv->GetShaderContainer(__uuidof(CLSID_SkinnedMeshVS3));
	m_pShaders[3] = pEnv->GetShaderContainer(__uuidof(CLSID_SkinnedMeshVS4));
	m_dwPrimalTextureStage = 0;
	m_bLight = TRUE;
}


CSkinnedMesh::~CSkinnedMesh()
{
	InvalidateDeviceObjects();
	DeleteDeviceObjects();
	SAFE_RELEASE(m_pShaders[0]);
	SAFE_RELEASE(m_pShaders[1]);
	SAFE_RELEASE(m_pShaders[2]);
	SAFE_RELEASE(m_pShaders[3]);
}

//-------------------------------------------------------------
//	Name: InitDeviceObjects
//  Desc: foCXˑIuWFNg̐
//-------------------------------------------------------------
HRESULT	CSkinnedMesh::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
    LPDIRECT3DVERTEXBUFFER9 pVB = NULL;
    BYTE*      pVertices = NULL;
    HRESULT    hr;
    CAllocateHierarchy Alloc(this);

	TCHAR	strMeshPath[512];
	if (m_pFrameRoot != NULL){
		m_uiMeshStatus = MESH_IS_INITIALIZED;
		return S_OK;
	}
    InvalidateDeviceObjects();
    DeleteDeviceObjects();

	//	bV̓ǂݍ
	_tcscpy_s(strMeshPath,_countof(strMeshPath),m_strMeshPath);
    _tcscat_s(strMeshPath,_countof(strMeshPath),_T("\\"));
    _tcscat_s(strMeshPath,_countof(strMeshPath),m_strMeshFilename);

	//	bV̓ǂݍ
	hr = D3DXLoadMeshHierarchyFromX(strMeshPath, D3DXMESH_MANAGED, lpd3ddev, &Alloc, NULL, &m_pFrameRoot, &m_pAnimController);
    if (FAILED(hr))
        return hr;

    hr = SetupBoneMatrixPointers(m_pFrameRoot);
    if (FAILED(hr))
        return hr;

    hr = D3DXFrameCalculateBoundingSphere(m_pFrameRoot, &m_vObjectCenter, &m_fObjectRadius);
    if (FAILED(hr))
        return hr;

	m_vecObjectMin.x = m_vObjectCenter.x - m_fObjectRadius;
	m_vecObjectMin.y = m_vObjectCenter.y - m_fObjectRadius;
	m_vecObjectMin.z = m_vObjectCenter.z - m_fObjectRadius;

	m_vecObjectMax.x = m_vObjectCenter.x + m_fObjectRadius;
	m_vecObjectMax.y = m_vObjectCenter.y + m_fObjectRadius;
	m_vecObjectMax.z = m_vObjectCenter.z + m_fObjectRadius;

	m_uiMeshStatus = MESH_IS_INITIALIZED;
    return hr;
}

//-------------------------------------------------------------
//	Name: RestoreDeviceObjects
//  Desc: foCXˑrfIIuWFNg̐
//-------------------------------------------------------------
HRESULT CSkinnedMesh::GetAnimationController(LPD3DXANIMATIONCONTROLLER *p)
{
	LPD3DXANIMATIONCONTROLLER	pAnim = m_pAnimController;
	*p = pAnim;
	if (pAnim == NULL){
		*p = NULL;
		return	E_FAIL;
	}
	pAnim->AddRef();
	return	S_OK;
}

//-------------------------------------------------------------
//	Name: RestoreDeviceObjects
//  Desc: foCXˑrfIIuWFNg̐
//-------------------------------------------------------------
HRESULT CSkinnedMesh::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	m_uiMeshStatus = MESH_IS_RESTORED;
    return S_OK;
}


//-------------------------------------------------------------
//	Name: InvalidateDeviceObjects
//  Desc: foCXˑrfIIuWFNg̏
//-------------------------------------------------------------
HRESULT CSkinnedMesh::InvalidateDeviceObjects()
{

	m_uiMeshStatus = MESH_IS_INITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: DeleteDeviceObjects
//  Desc: foCXˑIuWFNg̏
//-------------------------------------------------------------
HRESULT CSkinnedMesh::DeleteDeviceObjects()
{
    CAllocateHierarchy Alloc(this);
	if (m_pFrameRoot != NULL){
		D3DXFrameDestroy(m_pFrameRoot, &Alloc);
		m_pFrameRoot = NULL;
	}

    SAFE_RELEASE(m_pAnimController);

	m_uiMeshStatus = MESH_IS_UNINITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void    CSkinnedMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev)
{
	if (m_pFrameRoot == NULL)
		return;
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB

	//	eNX`Xe[WXe[g̐ݒ
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	lpd3ddev->SetSamplerState( 0, D3DSAMP_ADDRESSU,D3DTADDRESS_WRAP);
	lpd3ddev->SetSamplerState( 0, D3DSAMP_ADDRESSV,D3DTADDRESS_WRAP);
	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}

    //	Geforce3  UBYTE4 T|[gȂׁAUBYTE4 ̑ COLOR gpB
    //	vConst.w ͈ӖƂĂ͂Rł邪ACOLOR ɕϊꂽl(255 -> 1.0)
	//	ɍ킹āA255*3ŕ\ĂB
    D3DXVECTOR4 vConst( 1.0f, 0.0f, 0.0f, 765.01f );
	lpd3ddev->SetVertexShaderConstantF(0, (float*)&vConst, 1);

	// L̐ݒ
	D3DXVECTOR4	vLightDir = (D3DXVECTOR4)(*m_lpD3DEnv->GetSystemLightDirection());
	vLightDir.w = 0;
	vLightDir *= -1.0f;
	D3DXVec4Transform(&vLightDir,&vLightDir,&m_matView);
	D3DXVec4Normalize( &vLightDir, &vLightDir);
	lpd3ddev->SetVertexShaderConstantF(1, (float*)&vLightDir, 1);

	// vWFNVs̐ݒ
	D3DXMATRIXA16 matProj;
	D3DXMatrixTranspose(&matProj, m_lpD3DEnv->GetSystemProjection());
	lpd3ddev->SetVertexShaderConstantF(2, (float*)&matProj, 4);

	D3DXVECTOR4	vFog=D3DXVECTOR4(m_fFogStart,m_fFogEnd,1.0f/(m_fFogEnd-m_fFogStart),0);
	lpd3ddev->SetVertexShaderConstantF(6,(float*)&vFog,1);
	m_lpD3DDeviceTmp = lpd3ddev;
    RenderFrame(m_pFrameRoot);
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void    CSkinnedMesh::RenderWithoutMaterials(LPDIRECT3DDEVICE9 lpd3ddev,D3DMATERIAL9 *pMaterial)
{
	if (m_pFrameRoot == NULL)
		return;
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB

	//	eNX`Xe[WXe[g̐ݒ
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG2);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}

    //	Geforce3  UBYTE4 T|[gȂׁAUBYTE4 ̑ COLOR gpB
    //	vConst.w ͈ӖƂĂ͂Rł邪ACOLOR ɕϊꂽl(255 -> 1.0)
	//	ɍ킹āA255*3ŕ\ĂB
    D3DXVECTOR4 vConst( 1.0f, 0.0f, 0.0f, 765.01f );
	lpd3ddev->SetVertexShaderConstantF(0, (float*)&vConst, 1);

	// L̐ݒ
	D3DXVECTOR4	vLightDir = (D3DXVECTOR4)(*m_lpD3DEnv->GetSystemLightDirection());
	vLightDir.w = 0;
	vLightDir *= -1.0f;
	D3DXVec4Transform(&vLightDir,&vLightDir,&m_matView);
	D3DXVec4Normalize( &vLightDir, &vLightDir);
	lpd3ddev->SetVertexShaderConstantF(1, (float*)&vLightDir, 1);

	// vWFNVs̐ݒ
	D3DXMATRIXA16 matProj;
	D3DXMatrixTranspose(&matProj, m_lpD3DEnv->GetSystemProjection());
	lpd3ddev->SetVertexShaderConstantF(2, (float*)&matProj, 4);

	D3DXVECTOR4	vFog=D3DXVECTOR4(m_fFogStart,m_fFogEnd,1.0f/(m_fFogEnd-m_fFogStart),0);
	lpd3ddev->SetVertexShaderConstantF(6,(float*)&vFog,1);
	m_lpD3DDeviceTmp = lpd3ddev;
	FLOAT	oldAlpha = pMaterial->Diffuse.a;
	pMaterial->Diffuse.a = m_fOpacity;
	lpd3ddev->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE, D3DMCS_MATERIAL);
	lpd3ddev->SetMaterial(pMaterial);
    RenderFrame(m_pFrameRoot,pMaterial);
	lpd3ddev->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE, D3DMCS_COLOR1);
	pMaterial->Diffuse.a = oldAlpha;
}

//-----------------------------------------------------------------------------
// Name: RenderMeshContainer()
// Desc: qGL[̃bVRei`悷B
//-----------------------------------------------------------------------------
void CSkinnedMesh::RenderMeshContainer(LPD3DXMESHCONTAINER pMeshContainerBase, LPD3DXFRAME pFrameBase)
{
    CSkinnedMeshContainer *pMeshContainer = (CSkinnedMeshContainer*)pMeshContainerBase;
    SKINNEDMESH_FRAME *pFrame = (SKINNEDMESH_FRAME*)pFrameBase;
    UINT iMaterial;
    UINT iAttrib;
    LPD3DXBONECOMBINATION pBoneComb;
	LPDIRECT3DDEVICE9	lpd3ddev;

	UINT iMatrixIndex;
    UINT iPaletteEntry;
    D3DXMATRIXA16 matTemp;
	HRESULT	hr;

	lpd3ddev = m_lpD3DDeviceTmp;
	if (pMeshContainer->pSkinInfo != NULL)
    {

        if (pMeshContainer->UseSoftwareVP)
        {
            lpd3ddev->SetSoftwareVertexProcessing(TRUE);
        }
		hr = lpd3ddev->SetVertexShader(m_pShaders[pMeshContainer->NumMatrixReference -1]->GetDXVertexShader());
		if (FAILED(hr)){
			_RPT0(_CRT_WARN,"SetVertexShader FAILED\n");
		}
        pBoneComb = reinterpret_cast<LPD3DXBONECOMBINATION>(pMeshContainer->pBoneCombinationBuf->GetBufferPointer());
        for (iAttrib = 0; iAttrib < pMeshContainer->NumAttributes; iAttrib++)
        {
            //	[h}gbNXvZ
            for (iPaletteEntry = 0; iPaletteEntry < pMeshContainer->NumPaletteEntries; ++iPaletteEntry)
            {
                iMatrixIndex = pBoneComb[iAttrib].BoneId[iPaletteEntry];
                if (iMatrixIndex != UINT_MAX)
                {
					//	_W͈U{[ԂɈړĂA{[sɂ胏[hԂɎˉeAŌɃr[sŎˉeB
                    
					matTemp = pMeshContainer->pBoneOffsetMatrices[iMatrixIndex] * (*pMeshContainer->ppBoneMatrixPtrs[iMatrixIndex]);
					D3DXMatrixMultiplyTranspose(&matTemp, &matTemp, &m_matView);
                    lpd3ddev->SetVertexShaderConstantF(iPaletteEntry*3 + 9, (float*)&matTemp, 3);
                }
            }

            //	ArGgƎȔƂB
			if (m_bLight){
				D3DXCOLOR color1(pMeshContainer->pMaterials[pBoneComb[iAttrib].AttribId].MatD3D.Ambient);
				D3DCOLOR	c = m_lpD3DEnv->GetAmbientColor();
				D3DXCOLOR color2(	((c>>16)&0xff) * (1/255.0f), 
									((c>>8)&0xff) * (1/255.0f), 
									((c)&0xff) * (1/255.0f), 1.0);
				D3DXCOLOR ambEmm;
				D3DXColorModulate(&ambEmm, &color1, &color2);
				ambEmm += D3DXCOLOR(pMeshContainer->pMaterials[pBoneComb[iAttrib].AttribId].MatD3D.Emissive);

				//	}eAJ[ƌFB
				D3DXCOLOR	diffuse;
				FLOAT	alpha;
				diffuse = D3DXCOLOR(pMeshContainer->pMaterials[pBoneComb[iAttrib].AttribId].MatD3D.Diffuse);
				alpha = diffuse.a;
				D3DXColorModulate(&diffuse,&diffuse,&D3DXCOLOR(m_lpD3DEnv->GetSystemLight()->Diffuse));
				diffuse.a = alpha * m_fOpacity;

				//	}eA̐FʏZbgB 
				lpd3ddev->SetVertexShaderConstantF(8, (float*)&diffuse, 1);
				lpd3ddev->SetVertexShaderConstantF(7, (float*)&ambEmm, 1);
				//	XyL͌vZĂȂEEEB
				//vConst.y = pMeshContainer->pMaterials[pBoneComb[iAttrib].AttribId].MatD3D.Power;
			}else{
				static FLOAT	fZero[] = {0,0,0,0};
				D3DXCOLOR diffuse = pMeshContainer->pMaterials[pBoneComb[iAttrib].AttribId].MatD3D.Diffuse;
				fZero[3] = m_fOpacity;
				lpd3ddev->SetVertexShaderConstantF(8, (float*)fZero, 1);
				lpd3ddev->SetVertexShaderConstantF(7, (float*)&diffuse,1);
			}
			if (pMeshContainer->ppTextures[pBoneComb[iAttrib].AttribId]){
	            lpd3ddev->SetTexture(m_dwPrimalTextureStage, pMeshContainer->ppTextures[pBoneComb[iAttrib].AttribId]->GetTexture());
			}else{
	            lpd3ddev->SetTexture(m_dwPrimalTextureStage, NULL);
			}
            pMeshContainer->MeshData.pMesh->DrawSubset( iAttrib );

            
        }

        //	\tgEFA_ɐݒ肵Ăꍇ͖߂B
        if (pMeshContainer->UseSoftwareVP)
        {
            lpd3ddev->SetSoftwareVertexProcessing(FALSE);
        }
        lpd3ddev->SetVertexShader(NULL);

    }
    else  //	XLjO񂪖ꍇ͂B
    {
        lpd3ddev->SetTransform(D3DTS_WORLD, &pFrame->CombinedTransformationMatrix);
		hr = lpd3ddev->SetVertexShader(NULL);

        for (iMaterial = 0; iMaterial < pMeshContainer->NumMaterials; iMaterial++)
        {
			FLOAT	oldAlpha = pMeshContainer->pMaterials[iMaterial].MatD3D.Diffuse.a;
			pMeshContainer->pMaterials[iMaterial].MatD3D.Diffuse.a *= m_fOpacity;
            lpd3ddev->SetMaterial( &pMeshContainer->pMaterials[iMaterial].MatD3D );

			if (pMeshContainer->ppTextures[iMaterial])
	            lpd3ddev->SetTexture( 0, pMeshContainer->ppTextures[iMaterial]->GetTexture() );
			else
	            lpd3ddev->SetTexture( 0, NULL);
            pMeshContainer->MeshData.pMesh->DrawSubset(iMaterial);
			pMeshContainer->pMaterials[iMaterial].MatD3D.Diffuse.a = oldAlpha;
        }
    }
}

//-----------------------------------------------------------------------------
// Name: RenderMeshContainer()
// Desc: qGL[̃bVRei`悷B}eA͖
//-----------------------------------------------------------------------------
void CSkinnedMesh::RenderMeshContainer(LPD3DXMESHCONTAINER pMeshContainerBase, LPD3DXFRAME pFrameBase,D3DMATERIAL9 *pMaterial)
{
    CSkinnedMeshContainer *pMeshContainer = (CSkinnedMeshContainer*)pMeshContainerBase;
    SKINNEDMESH_FRAME *pFrame = (SKINNEDMESH_FRAME*)pFrameBase;
    UINT iAttrib;
    LPD3DXBONECOMBINATION pBoneComb;
	LPDIRECT3DDEVICE9	lpd3ddev;

	UINT iMatrixIndex;
    UINT iPaletteEntry;
    D3DXMATRIXA16 matTemp;
	HRESULT	hr;

	lpd3ddev = m_lpD3DDeviceTmp;
	if (pMeshContainer->pSkinInfo != NULL){
        if (pMeshContainer->UseSoftwareVP){
            lpd3ddev->SetSoftwareVertexProcessing(TRUE);
        }
		hr = lpd3ddev->SetVertexShader(m_pShaders[pMeshContainer->NumMatrixReference -1]->GetDXVertexShader());
		if (FAILED(hr)){
			_RPT0(_CRT_WARN,"SetVertexShader FAILED\n");
		}
        pBoneComb = reinterpret_cast<LPD3DXBONECOMBINATION>(pMeshContainer->pBoneCombinationBuf->GetBufferPointer());
        for (iAttrib = 0; iAttrib < pMeshContainer->NumAttributes; iAttrib++)
        {
            //	[h}gbNXvZ
            for (iPaletteEntry = 0; iPaletteEntry < pMeshContainer->NumPaletteEntries; ++iPaletteEntry){
                iMatrixIndex = pBoneComb[iAttrib].BoneId[iPaletteEntry];
                if (iMatrixIndex != UINT_MAX){
					//	_W͈U{[ԂɈړĂA{[sɂ胏[hԂɎˉeAŌɃr[sŎˉeB
					matTemp = pMeshContainer->pBoneOffsetMatrices[iMatrixIndex] * (*pMeshContainer->ppBoneMatrixPtrs[iMatrixIndex]);
					D3DXMatrixMultiplyTranspose(&matTemp, &matTemp, &m_matView);
                    lpd3ddev->SetVertexShaderConstantF(iPaletteEntry*3 + 9, (float*)&matTemp, 3);
                }
            }

			if (m_bLight){
				//	ArGgƎȔƂB
				D3DXCOLOR color1(pMaterial->Ambient);
				D3DCOLOR	c = m_lpD3DEnv->GetAmbientColor();
				D3DXCOLOR color2(	((c>>16)&0xff) * (1/255.0f), 
									((c>>8)&0xff) * (1/255.0f), 
									((c)&0xff) * (1/255.0f), 1.0);
				D3DXCOLOR ambEmm;
				D3DXColorModulate(&ambEmm, &color1, &color2);
				ambEmm += D3DXCOLOR(pMaterial->Emissive);

				//	}eAJ[ƌFB
				D3DXCOLOR	diffuse;
				D3DXColorModulate(&diffuse,&D3DXCOLOR(pMaterial->Diffuse),&D3DXCOLOR(m_lpD3DEnv->GetSystemLight()->Diffuse));
				diffuse.a = pMaterial->Diffuse.a;
				//	}eA̐FʏZbgB 
				lpd3ddev->SetVertexShaderConstantF(8, (float*)&diffuse, 1);
				lpd3ddev->SetVertexShaderConstantF(7, (float*)&ambEmm, 1);
				//	XyL͌vZĂȂEEEB
				//vConst.y = pMeshContainer->pMaterials[pBoneComb[iAttrib].AttribId].MatD3D.Power;
			}else{
				static FLOAT	fZero[] = {0,0,0,0};
				fZero[3] = m_fOpacity;
				lpd3ddev->SetVertexShaderConstantF(8, (float*)fZero, 1);
				lpd3ddev->SetVertexShaderConstantF(7, (float*)&pMaterial->Diffuse,1);
			}
			lpd3ddev->SetTexture(m_dwPrimalTextureStage, NULL);

            pMeshContainer->MeshData.pMesh->DrawSubset( iAttrib );
            
        }

        //	\tgEFA_ɐݒ肵Ăꍇ͖߂B
        if (pMeshContainer->UseSoftwareVP){
            lpd3ddev->SetSoftwareVertexProcessing(FALSE);
        }
        lpd3ddev->SetVertexShader(NULL);

    }
    else  //	XLjO񂪖ꍇ͂B
    {
        lpd3ddev->SetTransform(D3DTS_WORLD, &pFrame->CombinedTransformationMatrix);

		LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
		LPDIRECT3DINDEXBUFFER9	pIB = NULL;
		DWORD	dwNumVertices = pMeshContainer->MeshData.pMesh->GetNumVertices();
		DWORD	dwNumFaces = pMeshContainer->MeshData.pMesh->GetNumFaces();
		if (FAILED(pMeshContainer->MeshData.pMesh->GetVertexBuffer(&pVB))
		|| FAILED(pMeshContainer->MeshData.pMesh->GetIndexBuffer(&pIB))){
			SAFE_RELEASE(pVB);
			SAFE_RELEASE(pIB);
			return;
		}
        lpd3ddev->SetTexture( 0, NULL);

		DWORD	dwFVF = pMeshContainer->MeshData.pMesh->GetFVF();

		lpd3ddev->SetStreamSource(0,pVB,0,D3DXGetFVFVertexSize(dwFVF));
		lpd3ddev->SetIndices(pIB);
		lpd3ddev->SetFVF(dwFVF);
		DWORD	dwNumPrimitives = dwNumFaces;
		DWORD	dwNumToDraw = m_lpD3DEnv->GetCurrentDeviceCaps()->MaxPrimitiveCount;
		DWORD	dwStartIx = 0;
		while(dwNumPrimitives >0){
			if (dwNumToDraw > dwNumPrimitives)
				dwNumToDraw = dwNumPrimitives;

			lpd3ddev->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,
				dwNumVertices,dwStartIx,dwNumToDraw);
			dwStartIx += dwNumToDraw * 3;
			dwNumPrimitives -= dwNumToDraw;
		}

		SAFE_RELEASE(pVB);
		SAFE_RELEASE(pIB);
    }
}

//-----------------------------------------------------------------------------
// Name: RenderFrame()
// Desc: Kw Frame `悷ۂɌĂяoB
//-----------------------------------------------------------------------------
void CSkinnedMesh::RenderFrame(LPD3DXFRAME pFrame)
{
    LPD3DXMESHCONTAINER pMeshContainer;

    pMeshContainer = pFrame->pMeshContainer;
    while (pMeshContainer != NULL){
        RenderMeshContainer(pMeshContainer, pFrame);
        pMeshContainer = pMeshContainer->pNextMeshContainer;
    }

    if (pFrame->pFrameSibling != NULL){
        RenderFrame(pFrame->pFrameSibling);
    }

    if (pFrame->pFrameFirstChild != NULL){
        RenderFrame(pFrame->pFrameFirstChild);
    }
}

//-----------------------------------------------------------------------------
// Name: RenderFrame()
// Desc: Kw Frame `悷ۂɌĂяoB}eA͖
//-----------------------------------------------------------------------------
void CSkinnedMesh::RenderFrame(LPD3DXFRAME pFrame,D3DMATERIAL9 *pMaterial)
{
    LPD3DXMESHCONTAINER pMeshContainer;

    pMeshContainer = pFrame->pMeshContainer;
    while (pMeshContainer != NULL){
        RenderMeshContainer(pMeshContainer, pFrame,pMaterial);
        pMeshContainer = pMeshContainer->pNextMeshContainer;
    }

    if (pFrame->pFrameSibling != NULL){
        RenderFrame(pFrame->pFrameSibling,pMaterial);
    }

    if (pFrame->pFrameFirstChild != NULL){
        RenderFrame(pFrame->pFrameFirstChild,pMaterial);
    }
}

//-----------------------------------------------------------------------------
// Name: FrameMove()
// Desc: XLbVւ̃Aj[VĂяo.
//-----------------------------------------------------------------------------
HRESULT CSkinnedMesh::FrameMove(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fElapsedTime)
{
	HRESULT	hr = S_OK;
     // Setup world matrix
	LPDIRECT3DDEVICE9	lpd3ddev = NULL;
	hr = m_lpD3DEnv->GetD3DDevice(&lpd3ddev);
	if (FAILED(hr)){
		goto	errorExit;
	}
    lpd3ddev->SetTransform( D3DTS_WORLD, pMatWorld );
	if (m_pFrameRoot == NULL)
		goto	errorExit;
	if (m_pAnimController != NULL){
#if	D3DX_VERSION < 0x0902
        m_pAnimController->SetTime(m_pAnimController->GetTime() + fElapsedTime);
#else
		m_pAnimController->AdvanceTime(fElapsedTime,NULL);
#endif
	}
	m_matView = *pMatView;
	m_matWorld = *pMatWorld;
    UpdateFrameMatrices(m_pFrameRoot, pMatWorld);
errorExit:
	SAFE_RELEASE(lpd3ddev);
	return hr;
}
//-----------------------------------------------------------------------------
// Name: ResetAnimation()
// Desc: O[oAj[V̊߂
//-----------------------------------------------------------------------------
HRESULT CSkinnedMesh::ResetAnimation(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView)
{
     // Setup world matrix
	if (m_pFrameRoot == NULL)
		return S_OK;
	if (m_pAnimController != NULL){
#if	D3DX_VERSION < 0x0902
        m_pAnimController->SetTime(0.0f);
#else
		m_pAnimController->ResetTime();
		m_pAnimController->AdvanceTime(0.0f,NULL);
#endif
	}
	m_matView = *pMatView;
	m_matWorld = *pMatWorld;
    UpdateFrameMatrices(m_pFrameRoot, pMatWorld);
    return S_OK;
}
//-----------------------------------------------------------------------------
// Name: AdjustBones()
// Desc: Aj[VRg[𒼐ڑ삵ꍇA
//		_OOɂĂяoB
//-----------------------------------------------------------------------------
HRESULT CSkinnedMesh::AdjustAnimation(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView)
{
     // Setup world matrix
	if (m_pFrameRoot == NULL)
		return S_OK;
	m_matView = *pMatView;
	m_matWorld = *pMatWorld;
    UpdateFrameMatrices(m_pFrameRoot, pMatWorld);
    return S_OK;
}

void CSkinnedMesh::ResetAnimationMatrices(){
	if (m_pFrameRoot == NULL)
		return;

	ResetFrameMatrices(m_pFrameRoot);
}

//-----------------------------------------------------------------------------
// Name: ResetFrameMatrices()
// Desc: t[̕ϊsԂɖ߂
//-----------------------------------------------------------------------------
void CSkinnedMesh::ResetFrameMatrices(LPD3DXFRAME pFrameBase)
{
    SKINNEDMESH_FRAME *pFrame = (SKINNEDMESH_FRAME*)pFrameBase;

	pFrame->TransformationMatrix = pFrame->BackupMatrix;
    if (pFrame->pFrameSibling != NULL)
    {
        ResetFrameMatrices(pFrame->pFrameSibling);
    }

    if (pFrame->pFrameFirstChild != NULL)
    {
        ResetFrameMatrices(pFrame->pFrameFirstChild);
    }
}
//-----------------------------------------------------------------------------
// Name: UpdateFrameMatrices()
// Desc: t[̕ϊsXV
//-----------------------------------------------------------------------------
void CSkinnedMesh::UpdateFrameMatrices(LPD3DXFRAME pFrameBase, LPD3DXMATRIX pParentMatrix)
{
    SKINNEDMESH_FRAME *pFrame = (SKINNEDMESH_FRAME*)pFrameBase;

    if (pParentMatrix != NULL)
        D3DXMatrixMultiply(&pFrame->CombinedTransformationMatrix, &pFrame->TransformationMatrix, pParentMatrix);
    else
        pFrame->CombinedTransformationMatrix = pFrame->TransformationMatrix;

    if (pFrame->pFrameSibling != NULL)
    {
        UpdateFrameMatrices(pFrame->pFrameSibling, pParentMatrix);
    }

    if (pFrame->pFrameFirstChild != NULL)
    {
        UpdateFrameMatrices(pFrame->pFrameFirstChild, &pFrame->CombinedTransformationMatrix);
    }
}

//-----------------------------------------------------------------------------
// Name: GenerateSkinnedMesh()
// Desc: XLjO擾AHWXLjOs₷lɃf[^ϊB
//-----------------------------------------------------------------------------
HRESULT CSkinnedMesh::GenerateSkinnedMesh(CSkinnedMeshContainer *pMeshContainer)
{
    HRESULT hr = S_OK;
	DWORD NewFVF;
    DWORD Flags = D3DXMESHOPT_VERTEXCACHE;

    UINT MaxMatrices = 82; 

	if (pMeshContainer->pSkinInfo == NULL)
        return hr;

	LPDIRECT3DDEVICE9	lpd3ddev = NULL;
	hr = m_lpD3DEnv->GetD3DDevice(&lpd3ddev);
	if (FAILED(hr)){
		goto	e_Exit;
	}
    SAFE_RELEASE( pMeshContainer->MeshData.pMesh );
    SAFE_RELEASE( pMeshContainer->pBoneCombinationBuf );

    pMeshContainer->NumPaletteEntries = min(MaxMatrices, pMeshContainer->pSkinInfo->GetNumBones());

	D3DCAPS9 d3dCaps;
	lpd3ddev->GetDeviceCaps(&d3dCaps);
    if (d3dCaps.VertexShaderVersion >= D3DVS_VERSION(2, 0))
    {
        pMeshContainer->UseSoftwareVP = false;
        Flags |= D3DXMESH_MANAGED;	//	_f[^͕KvɉăfoCXɓ]B
									//	foCXXg̍ē]DirectX ʓ|ĂB
    }
    else
    {
        pMeshContainer->UseSoftwareVP = true;
        Flags |= D3DXMESH_SYSTEMMEM;
    }

    SAFE_RELEASE(pMeshContainer->MeshData.pMesh);

    hr = pMeshContainer->pSkinInfo->ConvertToIndexedBlendedMesh
                                            (
                                            pMeshContainer->pOrigMesh,
                                            Flags, 
                                            pMeshContainer->NumPaletteEntries, 
                                            pMeshContainer->pAdjacency, 
                                            NULL, NULL, NULL,             
                                            &pMeshContainer->NumMatrixReference,
                                            &pMeshContainer->NumAttributes, 
                                            &pMeshContainer->pBoneCombinationBuf, 
                                            &pMeshContainer->MeshData.pMesh);
    if (FAILED(hr))
        goto e_Exit;

    // FVFAo[eNXVF[_ɍ킹B
	DWORD	dwFVF = pMeshContainer->MeshData.pMesh->GetFVF() & D3DFVF_POSITION_MASK;
	BOOL	bWeightIsOne = false;
	if (dwFVF == D3DFVF_XYZB1){
		dwFVF = D3DFVF_XYZB2;
		bWeightIsOne = true;
	}
	NewFVF = dwFVF | D3DFVF_NORMAL | D3DFVF_TEX1 | D3DFVF_LASTBETA_UBYTE4;

	if (NewFVF != pMeshContainer->MeshData.pMesh->GetFVF())
    {
        LPD3DXMESH pMesh;
        hr = pMeshContainer->MeshData.pMesh->CloneMeshFVF(pMeshContainer->MeshData.pMesh->GetOptions(), NewFVF, lpd3ddev, &pMesh);
        if (!FAILED(hr))
        {
			if (bWeightIsOne){
				//	Because ConvertToIndexedBlendedMesh creates a skinmesh without weight information on some system.
				LPDIRECT3DVERTEXBUFFER9	pVB;
				if (SUCCEEDED(pMesh->GetVertexBuffer(&pVB))){
					DWORD	dwStride = D3DXGetFVFVertexSize(pMesh->GetFVF());
					DWORD	dwNumVertex = pMesh->GetNumVertices();
					DWORD	i;
					BYTE	*pVertex;
					if (SUCCEEDED(pVB->Lock(0,0,(VOID**)&pVertex,0))){
						for (i = 0; i < dwNumVertex ; ++i){
							*(FLOAT*)(pVertex + sizeof(FLOAT)*3) = 1.0f;
							pVertex += dwStride;
						}
					}
					pVB->Unlock();
				}
			}
            pMeshContainer->MeshData.pMesh->Release();
			pMeshContainer->MeshData.pMesh = pMesh;
			pMesh = NULL;
		}
    }

    D3DVERTEXELEMENT9 pDecl[MAX_FVF_DECL_SIZE];
    LPD3DVERTEXELEMENT9 pDeclCur;
    hr = pMeshContainer->MeshData.pMesh->GetDeclaration(pDecl);
    if (FAILED(hr))
        goto e_Exit;

	//	_VF[_ UBYTE4 ߂ȂdlȂ̂ŁAD3DCOLOR ɕϊĂB
	pDeclCur = pDecl;
    while (pDeclCur->Stream != 0xff)
    {
        if ((pDeclCur->Usage == D3DDECLUSAGE_BLENDINDICES) && (pDeclCur->UsageIndex == 0))
            pDeclCur->Type = D3DDECLTYPE_D3DCOLOR;
        pDeclCur++;
    }

    hr = pMeshContainer->MeshData.pMesh->UpdateSemantics(pDecl);
    if (FAILED(hr))
        goto e_Exit;
e_Exit:
	SAFE_RELEASE(lpd3ddev);
    return hr;
}

//-----------------------------------------------------------------------------
// Name: SetupBoneMatrixPointersOnMesh()
// Desc: t[̃bVReipɃ{[i|C^jzZbgAbvB
//		_OۂɎgpB
//-----------------------------------------------------------------------------
HRESULT CSkinnedMesh::SetupBoneMatrixPointersOnMesh(LPD3DXMESHCONTAINER pMeshContainerBase)
{
    UINT iBone, cBones;
    SKINNEDMESH_FRAME *pFrame;

    CSkinnedMeshContainer *pMeshContainer = (CSkinnedMeshContainer*)pMeshContainerBase;

    if (pMeshContainer->pSkinInfo != NULL)
    {
        cBones = pMeshContainer->pSkinInfo->GetNumBones();

        pMeshContainer->ppBoneMatrixPtrs = new D3DXMATRIX*[cBones];
        if (pMeshContainer->ppBoneMatrixPtrs == NULL)
            return E_OUTOFMEMORY;

        for (iBone = 0; iBone < cBones; iBone++)
        {
            pFrame = (SKINNEDMESH_FRAME*)D3DXFrameFind(m_pFrameRoot, pMeshContainer->pSkinInfo->GetBoneName(iBone));
            if (pFrame == NULL)
                return E_FAIL;

            pMeshContainer->ppBoneMatrixPtrs[iBone] = &pFrame->CombinedTransformationMatrix;
        }
    }

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: SetupBoneMatrixPointers()
// Desc: St[񂵁At[̃bVReip
//		{[si|C^j̔zZbgAbvB
//		̔z̃f[^_OۂɎgpB
//-----------------------------------------------------------------------------
HRESULT CSkinnedMesh::SetupBoneMatrixPointers(LPD3DXFRAME pFrame)
{
    HRESULT hr;

    if (pFrame->pMeshContainer != NULL)
    {
        hr = SetupBoneMatrixPointersOnMesh(pFrame->pMeshContainer);
        if (FAILED(hr))
            return hr;
    }
	((SKINNEDMESH_FRAME *)pFrame)->BackupMatrix = pFrame->TransformationMatrix;
    if (pFrame->pFrameSibling != NULL)
    {
        hr = SetupBoneMatrixPointers(pFrame->pFrameSibling);
        if (FAILED(hr))
            return hr;
    }

    if (pFrame->pFrameFirstChild != NULL)
    {
        hr = SetupBoneMatrixPointers(pFrame->pFrameFirstChild);
        if (FAILED(hr))
            return hr;
    }

    return S_OK;
}

void CSkinnedMesh::SetFog(FLOAT fStart, FLOAT fEnd){
	m_fFogStart = fStart;
	m_fFogEnd = fEnd;
}

//-----------------------------------------------------------------------------
//	Name: RenderBones
//	Desc: {[`悷B
//-----------------------------------------------------------------------------
void	CSkinnedMesh::RenderBones(LPDIRECT3DDEVICE9 lpd3ddev){
	this->m_lpD3DDeviceTmp = lpd3ddev;
    lpd3ddev->SetRenderState( D3DRS_LIGHTING, FALSE );
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	RenderBone(m_pFrameRoot, &m_matWorld);
}
void	CSkinnedMesh::RenderBone(LPD3DXFRAME pFrameBase, LPD3DXMATRIX pParentMatrix){
    SKINNEDMESH_FRAME *pFrame = (SKINNEDMESH_FRAME*)pFrameBase;
	if (pFrameBase != m_pFrameRoot){
		D3DXVECTOR3	arrayVec[2];
		arrayVec[1] = arrayVec[0] = D3DXVECTOR3(0,0,0);

		D3DXVec3TransformCoord(&arrayVec[0],&arrayVec[0],pParentMatrix);
		D3DXVec3TransformCoord(&arrayVec[1],&arrayVec[1],&pFrame->CombinedTransformationMatrix);
		m_lpD3DEnv->RenderLine3D((D3DXVECTOR3*)arrayVec,D3DCOLOR_XRGB(255,255,255));
	}
	if (pFrame->pFrameSibling != NULL)
    {
		RenderBone(pFrame->pFrameSibling, pParentMatrix);
    }

    if (pFrame->pFrameFirstChild != NULL)
    {
		RenderBone(pFrame->pFrameFirstChild, &pFrame->CombinedTransformationMatrix);
    }
}

/*
 *	RpCeXgpi`FbNj
 *	Name: AddAnimation
 *	Desc: w肳ꂽxt@CAAj[Vǂݍ݁A
 *		݂ SkinnedMesh ɒǉB
 *  
 *	D3DXSaveMeshToX gĕۑΕ̃VOgbNAj[V
 *  f[^A̃}`gbNAj[Vt@C
 *	̍쐬ł͂Bi`FbNj
 */
HRESULT	CSkinnedMesh::AddAnimation(TCHAR *fname){
 	TCHAR	filepath[MAX_PATH];
	TCHAR	filename[MAX_PATH];
	TCHAR	filepath2[MAX_PATH];
    CAllocateHierarchy Alloc(this);
    LPD3DXFRAME	pFrameToDelete = NULL;
    LPD3DXANIMATIONCONTROLLER pAnimMixerToDelete = NULL;
    LPD3DXANIMATIONCONTROLLER pAnimMixer = NULL;
    LPD3DXANIMATIONSET pAnimSet;
    UINT iAnimSet;
    UINT cAnimSets;
	HRESULT	hr;
	LPDIRECT3DDEVICE9	lpd3ddev = NULL;
	hr = m_lpD3DEnv->GetD3DDevice(&lpd3ddev);
	if (FAILED(hr)){
		goto	errorExit;
	}
	_tcscpy_s(filepath,_countof(filepath),m_lpD3DEnv->GetAppPathName());
	_tcscpy_s(filename,_countof(filename),fname);
	m_lpD3DEnv->GetFileName(filename,filepath2);
	if (filepath[0] != '\0'){
		_tcscat_s(filepath,_countof(filepath),_T("\\"));
		_tcscat_s(filepath,_countof(filepath),filepath2);
	}
	_tcscat_s(filepath,_countof(filepath),"\\");
	_tcscat_s(filepath,_countof(filepath),filename);

	// load the file to get the animation data
    hr = D3DXLoadMeshHierarchyFromX(filepath, D3DXMESH_SYSTEMMEM, lpd3ddev, &Alloc, NULL, (LPD3DXFRAME*)&pFrameToDelete, &pAnimMixerToDelete);
    if (FAILED(hr))
 		goto	errorExit;

    if (pAnimMixerToDelete == NULL)
    {
        MessageBox(NULL, "No animation data in file!", "Warning", MB_OK);
		goto	errorExit;
    }

    cAnimSets = pAnimMixerToDelete->GetNumAnimationSets();

#if	D3DX_VERSION < 0x0902
	//	9.0 SDK
	hr = m_pAnimController->CloneAnimationController(
                                m_pAnimController->GetMaxNumMatrices(),
                                m_pAnimController->GetMaxNumAnimationSets() + cAnimSets,
                                m_pAnimController->GetMaxNumTracks(),
                                m_pAnimController->GetMaxNumEvents(),
                                &pAnimMixer);
#else
	//	9.0c SDK
    hr = m_pAnimController->CloneAnimationController(
                                m_pAnimController->GetMaxNumAnimationOutputs(),
                                m_pAnimController->GetMaxNumAnimationSets() + cAnimSets,
                                m_pAnimController->GetMaxNumTracks(),
                                m_pAnimController->GetMaxNumEvents(),
                                &pAnimMixer);
#endif
	if (FAILED(hr))
		goto	errorExit;

    SAFE_RELEASE(m_pAnimController);
    m_pAnimController = pAnimMixer;
    pAnimMixer = NULL;
    

    for (iAnimSet = 0; iAnimSet < cAnimSets; iAnimSet++)
    {
        pAnimMixerToDelete->GetAnimationSet(iAnimSet, &pAnimSet);
        m_pAnimController->RegisterAnimationSet(pAnimSet);

        SAFE_RELEASE(pAnimSet);
    }
#if	D3DX_VERSION < 0x0902
    m_pAnimController->SetTime(m_pAnimController->GetTime());
#else
	m_pAnimController->AdvanceTime(0.0f,NULL);
#endif
	hr = S_OK;
errorExit:
    SAFE_RELEASE(pAnimMixerToDelete);
	if (pFrameToDelete != NULL)
		D3DXFrameDestroy(pFrameToDelete, &Alloc);
	SAFE_RELEASE(lpd3ddev);
    return hr;
}


void	CSkinnedMesh::SetLightEnable(DWORD dwNum,BOOL bLight){
	dwNum;

	m_bLight = bLight;
}
