//------------------------------------------
// class: CD3DEnv
//
// Desc: Main Object of this class library that utilizes
//		Direct3D
//
//------------------------------------------
#ifndef	__D3D9ENV_H__
#define	__D3D9ENV_H__

typedef	LPDIRECT3DDEVICE9	LPGXDEVICE;
typedef	LPDIRECT3DSURFACE9	LPGXSURFACE;
typedef	D3DCAPS9			GXCAPS;
typedef D3DXMATRIX			GXMATRIX;
typedef	D3DXVECTOR3			GXVECTOR3;
typedef D3DXVECTOR4			GXVECTOR4;
typedef D3DPRESENT_PARAMETERS	GXPRESENT_PARAMETERS;
typedef D3DCOLOR			GXCOLOR;
typedef D3DXCOLOR			GXCOLORX;
typedef	D3DLIGHT9			GXLIGHT;


class	CD3DEnv;

#ifndef __D3DFONT_H__
#include "d3dfont.h"
#endif
#ifndef	__DeviceInformation_h__
#include "deviceinformation.h"
#endif
#ifndef	__HIGHRESTIMER_H__
#include "HighResTimer.h"
#endif
#ifndef	__GRAPHICSOBJECT_H__
#include "GraphicsObject.h"
#endif

#define	DIRECTINPUT_VERSION (0x0800)
#include <dinput.h>

#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#define	SAFE_DELETE(o)	{if (o){	delete (o); (o) = NULL;	}}
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }

typedef	void (*AnimationCallback)(float);
typedef	void (*RenderSceneCallback)(LPDIRECT3DDEVICE9 lpdevice);
typedef	void (*AnimationCallback2)(float timeElapsed, PVOID lpUser);
typedef	void (*RenderSceneCallback2)(LPDIRECT3DDEVICE9 lpdevice, PVOID lpUser);
typedef void (*LoadGraphicsCallback)(PVOID lpUser);

class	CTextureDB;
class	CTextureNode;
class	CContainerDB;
class	CContainer;
class	CShaderContainer;

#define	D3DQUICKLIB_MAX_NUM_JOYBUTTON	(26+3)

typedef struct	_orderingtable{
	FLOAT	m_fZ;
	short	m_usIndex;
	short	m_usMaterial;
}	OrderingTable;

class	CD3DEnv{
public:
	CD3DEnv();
	virtual	~CD3DEnv();

	virtual HRESULT	InitD3D(HWND hWnd);
	void	ReloadGraphics();
	void	LoadGraphics();
	void	AsyncLoadGraphics(LoadGraphicsCallback cb, PVOID lpUser);

	virtual void	UpdateScene(AnimationCallback animCB = NULL, RenderSceneCallback renderCB = NULL);
	virtual void	RenderSceneWithVP(RECT *rcWindow, RenderSceneCallback renderCB = NULL, BOOL bClear = TRUE);
	virtual void	UpdateScene(AnimationCallback2 animCB, RenderSceneCallback2 renderCB, PVOID lpUser);
	virtual void	RenderSceneWithVP(RECT *rcWindow, RenderSceneCallback2 renderCB, PVOID lpUser, BOOL bClear = TRUE);
	virtual void	RenderSceneIntoSurface(LPDIRECT3DSURFACE9 pSurface, D3DCOLOR bgcolor, RenderSceneCallback2 renderCB, PVOID lpUser);
	BOOL	GetDI8KeyState(int key);
	BOOL	TextureDBRegisterNewKey(LPSTR key,CTextureNode **pRet);
	D3DXMATRIX	*GetSystemView(){			return	&m_matView;	}
	D3DXMATRIX	*GetSystemProjection(){		return	&m_matProj;	}
	D3DLIGHT9	*GetSystemLight(){	return	&m_litSysLight;	}
	D3DXVECTOR3	*GetSystemLightDirection();
	D3DCAPS9	*GetCurrentDeviceCaps(){	return	&m_CurrentDeviceCaps;	}
	D3DPRESENT_PARAMETERS	*GetD3DPresentParameters(){	return	&m_d3dprm;	}
	BOOL		IsWindowed()	{	return	m_bWindowed;	}
	BOOL		IsDepthBufferActive(){	return	m_bUseDepthBuffer;	}
	HRESULT	GetD3DDevice(LPDIRECT3DDEVICE9 *pDevice){	m_lpD3DDEV->AddRef();	*pDevice = m_lpD3DDEV;	return	S_OK;	}

	BOOL CALLBACK	EnumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance,
                                     VOID* pContext );
	BOOL CALLBACK	EnumObjectsCallback( const DIDEVICEOBJECTINSTANCE* pdidoi,
                                   VOID* pContext );

	void	AddGraphicsObject(CGraphicsObject *pObj);
	void	RemoveGraphicsObject(CGraphicsObject *pObj);

	TCHAR	*GetAppPathName();

	DWORD	GetNumMaxOTFaces();
	OrderingTable *GetOT();
	HRESULT	RequireOT(DWORD num);
	HRESULT	ResizeOT(DWORD num);
	HRESULT	RequireSharedRenderingBuffer(DWORD size);
	DWORD	GetSharedRenderingBufferSize();
	BYTE	*GetSharedRenderingBuffer();
	void	GetFileName(TCHAR *str,TCHAR *filepath);
	void	SetBackgroundColor(D3DCOLOR c){	m_colorBackground = c;	}

	//	@\gz肵\bhQ
	virtual	HRESULT Resize3DEnvironment();
	virtual	HRESULT UserAdjustWindow();
	virtual	HRESULT ToggleFullscreen();
	virtual	HRESULT ForceWindowed();
	virtual	HRESULT	ForceFullscreen();
	virtual	HRESULT AdjustWindow();
	virtual	HRESULT UserSelectNewDevice();
	virtual	void	InitLightParameters();
	virtual	void	SetupLights();
	virtual	void	SetDefaultRenderState(LPDIRECT3DDEVICE9 lpdevice);
	virtual	void	SetDefaultTransform(LPDIRECT3DDEVICE9 lpdevice);
	virtual	HRESULT	CheckDeviceFormat(DWORD usage, D3DRESOURCETYPE rtype, D3DFORMAT format);
	void		SetAmbientColor(D3DCOLOR c){	m_colAmbient = c;	}
	D3DCOLOR	GetAmbientColor(){	return	m_colAmbient;	}

	void	RenderTriangle3D(D3DXVECTOR3 *p,D3DCOLOR c, D3DXMATRIX *pMat=NULL);
	void	RenderQuadrilateral3D(D3DXVECTOR3 *p,D3DCOLOR c, D3DXMATRIX *pMat=NULL);
	void	RenderLine3D(D3DXVECTOR3 *p, D3DCOLOR c, D3DXMATRIX *pMat = NULL);
	//	fobOp\bhQ
	void	RenderBoundingBoxForDebug(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	void	DrawFPS(float timeElapsed);

	//	ȈՎ擾\bhQ
	LPDIRECT3D9			SystemD3D(){	return	m_lpD3D;	}
	LPDIRECT3DDEVICE9	SystemD3DDevice(){	return	m_lpD3DDEV;	}
	CD3DFont*			SystemD3DFont(){	return	m_pFont;	}
	CDeviceInformation*	SystemDeviceInfo(){	return	m_lpDevices;	}
	DWORD				GetBackBufferWidth();
	DWORD				GetBackBufferHeight();
	D3DFORMAT			GetBackBufferFormat();
	D3DDEVTYPE			GetDeviceType();
	HWND				GetHWND(){	return	m_hWnd;	}
	//void				SetDeviceConfirmFunction(ConfirmDeviceCallback pFunc);
	virtual	CContainerDB	*SystemShaderDB(){	return	m_pContainerDB;	}
	virtual	CShaderContainer	*GetShaderContainer(GUID guid);
	virtual	CContainer	*GetContainer(GUID guid);
	virtual	BOOL	ConfirmDevice(D3DCAPS9 *pCaps,DWORD dwBehavior,D3DFORMAT fmt);
	virtual void	SetJoyButtonToKeyMap(int bno, BYTE key);
	virtual FLOAT	GetElapsedTime();
	virtual void	ResetTimer();

	void	EnterLoadingSection();
	void	LeaveLoadingSection();

protected:
	virtual	DWORD	SelectMode(D3DModeInfo *modes, DWORD numModes);

	void	ReleaseD3D();
	HRESULT	InitDeviceObjects();
	HRESULT	InvalidateDeviceObjects();
	HRESULT	RestoreDeviceObjects();
	HRESULT	DeleteDeviceObjects();
	void	InitSystemShaders();
	void	ReleaseSystemShaders();

	//
	//	Device dependent objects under system control.
	//	to prevent user reload these objects.
	//
	void	ReloadSystemGraphics();
	HRESULT	InitSystemDeviceObjects();
	HRESULT	InvalidateSystemDeviceObjects();
	HRESULT	RestoreSystemDeviceObjects();
	HRESULT	DeleteSystemDeviceObjects();

	virtual	void InitFail(HWND hWnd, LPCTSTR szError,...);
	void	PrepareAppPathName();
	virtual	HRESULT Initialize3DEnvironment(HWND hWnd);
	virtual	void	InitDefaultTransform();

	//	dinput ̋@\͐ؗ\
	virtual	HRESULT	InitDI(HWND hWnd);
	virtual	void	ReleaseDI();
	virtual	void	DoIO();

	//
	//  Agr[g
	//
	HWND					m_hWnd;
	D3DPRESENT_PARAMETERS	m_d3dprm;
	LPDIRECT3D9				m_lpD3D;
	LPDIRECT3DDEVICE9		m_lpD3DDEV;

	CD3DFont				*m_pFont;	//	ptHgVXeEE

	LPDIRECTINPUT8			m_lpDI;
	LPDIRECTINPUTDEVICE8	m_pKeyboard;
	LPDIRECTINPUTDEVICE8	m_pJoystick; 
	DWORD					m_dwNumButtonsOnJoystick;
	BYTE					m_pJoyToKeyMap[D3DQUICKLIB_MAX_NUM_JOYBUTTON];
	BYTE					*m_pKeys;
	DWORD					m_dwJoystickDeadzone;
	long					m_lJoystickXMin;
	long					m_lJoystickXCtr;
	long					m_lJoystickXMax;
	long					m_lJoystickYMin;
	long					m_lJoystickYCtr;
	long					m_lJoystickYMax;
	long					m_lJoystickXThreshold;
	long					m_lJoystickYThreshold;
	long					m_lJoyX, m_lJoyY;

	CDeviceInformation	*m_lpDevices;
	D3DAdapterInfo		*m_Adapters;
	DWORD				m_dwNumAdapters;
	DWORD				m_dwAdapter;
	DWORD				m_dwMinDepthBits;
	DWORD				m_dwMinStencilBits;
	DWORD				m_dwWindowStyle;
	RECT				m_rcWindowBounds;
	RECT				m_rcWindowClient;
	D3DCAPS9			m_CurrentDeviceCaps;
	D3DSURFACE_DESC		m_d3dsdBackBuffer;

	D3DXMATRIX			m_matView;
	D3DXMATRIX			m_matProj;

	D3DLIGHT9			m_litSysLight;			//	VXeiLj
	D3DXVECTOR3			m_vecLight;				//	VXe̕
	D3DCOLOR			m_colAmbient;			//	ArGgF

	CHighResTimer		*m_pHighResTimer;

	CRITICAL_SECTION	m_crLoading;			//  Critical section.
	CTextureDB			*m_pTextureDB;

	CGraphicsObject		*m_pGraphicsObjects;	//	Billboard, Mesh ̑
	CGraphicsObject		m_dummyNode;

	CGraphicsObject		*m_pSystemGraphicsObjects;	//	System font  system shader
	CGraphicsObject		m_systemDummyNode;

	TCHAR				*m_strAppPath;

	CShaderContainer	*m_pSkinnedMeshVS1;		//	VXepVF[_
	CShaderContainer	*m_pSkinnedMeshVS2;
	CShaderContainer	*m_pSkinnedMeshVS3;
	CShaderContainer	*m_pSkinnedMeshVS4;
	CShaderContainer	*m_pUVScrollMeshVS;

	DWORD				m_dwMaxOTFaces;
	//OrderingTable		*m_pOrderingTable;
	DWORD				m_dwSharedRenderingBufferSize;
	BYTE				*m_pSharedRenderingBuffer;

	CContainerDB		*m_pContainerDB;
	D3DCOLOR			m_colorBackground;
	BOOL				m_bWindowed;
	BOOL				m_bUseDepthBuffer;
	BOOL				m_bViewportRendered;

#ifdef	_DEBUG
	float debugFpsBuffer[8];
	int	  debugFpsPointer;
#endif
};

//
//	VF[_錾
//
struct __declspec(uuid("{88461081-0327-4c3b-8170-c30b3f78612e}"))	CLSID_ScrollMeshVS;
struct __declspec(uuid("{34deca65-f06b-4f0d-8134-df1f5393640d}"))	CLSID_SkinnedMeshVS1;
struct __declspec(uuid("{1653b8f3-658e-4ebd-a774-a2bc00328449}"))	CLSID_SkinnedMeshVS2;
struct __declspec(uuid("{dc2648e0-aff6-4a43-be62-e4c3496391a1}"))	CLSID_SkinnedMeshVS3;
struct __declspec(uuid("{d77d48ff-de30-43ac-bf90-d02d3a274d13}"))	CLSID_SkinnedMeshVS4;

#endif