/*
 *	class CWall
 *		ǂ̎NX
 *
 *		First edition: March.09.2004
 *
*/
#ifndef __WALL_H__
#define	__WALL_H__

#ifndef	__MESH_H__
#include "Mesh.h"
#endif

struct	WALLCOLLISIONVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DXVECTOR3	n;	//	normal
};

struct	COLLISIONINFO{
	D3DXVECTOR3	n;		//	ʖ@
	FLOAT		amount;	//	Hݗ
	WALLCOLLISIONVERTEX	vertices[3];	//	|SobNAbv
};


class CWall : public CMesh
{
public:
	CWall(CD3DEnv *pEnv, TCHAR *pFname);
	virtual ~CWall();
	virtual void	SetWorldMatrix(D3DXMATRIX *pMat);
	virtual void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual float	GetBoundingSphere(D3DXVECTOR3 *pVec);
	virtual void	GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	virtual BOOL	ProbeTheWall(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal, FLOAT *pDist);
	virtual BOOL	ProbeTheWallSinkDepth(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal, FLOAT *pDepth);
	virtual BOOL	ProbeTheWallSinkDepthWithMotion(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal, FLOAT *pDepth);
	virtual BOOL	CheckCollisionWithSegment(D3DXVECTOR3 *pVec1, D3DXVECTOR3 *pVec2, FLOAT fRadius);
	virtual BOOL	CheckCollisionWithSegment(D3DXVECTOR3 *pVec1, D3DXVECTOR3 *pVec2, FLOAT fErrorCapacity, D3DXVECTOR3 *pVecOut);
	static  FLOAT	CalcDistanceSegmentToSegment(D3DXVECTOR3 *pveca0, D3DXVECTOR3*pveca1, D3DXVECTOR3 *pveca, D3DXVECTOR3 *pvecb0, D3DXVECTOR3 *pvecb1, D3DXVECTOR3 *pvecb);

	virtual BOOL	ProbeTheTriangleDistanceWithSegment2(WALLCOLLISIONVERTEX *pTri, D3DXVECTOR3 *pvec1, D3DXVECTOR3 *pvec2, FLOAT fErrorCapacity, D3DXVECTOR3 *pVecOut, FLOAT *pT);
protected:
	virtual BOOL	ProbeTheWallSinkDepthBase(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal, FLOAT *pDepth);
	static  FLOAT	CalcDistanceTwoParallelSegments(D3DXVECTOR3 *pveca0, D3DXVECTOR3*pveca1, D3DXVECTOR3 *pveca, D3DXVECTOR3 *pvecb0, D3DXVECTOR3 *pvecb1, D3DXVECTOR3 *pvecb);
	virtual BOOL	ProbeTheTriangleDistanceWithSegment(WALLCOLLISIONVERTEX *pTri, FLOAT *pDist, D3DXVECTOR3 *pVec1, D3DXVECTOR3 *pVec2, FLOAT fRadius);
	virtual BOOL	ProbeTheTriangleDistance(WALLCOLLISIONVERTEX *pTri, FLOAT *pDist, D3DXVECTOR3 *pPos, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, FLOAT fRadius, D3DXVECTOR3 *pNormal);
	virtual void	ProbeTheTriangleNearestPosition(WALLCOLLISIONVERTEX *pTri, D3DXVECTOR3 *pPos, D3DXVECTOR3 *pPosOut);
	virtual void	CalcNearestPosition(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, D3DXVECTOR3 *pPosOut, float *pDist);

	virtual void	MatrixInverseRotation(D3DXMATRIX *pOut, D3DXVECTOR3 *vecX,D3DXVECTOR3 *vecY,D3DXVECTOR3 *vecZ);
	virtual void	CalcShortestDistance(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, float *pDist, D3DXVECTOR3 *pNormal);
	virtual void	CalcShortestDistance2(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, float *pDist);
	D3DXMATRIX		m_matWorld;
	COLLISIONINFO	*m_pCollisionInfo;
	DWORD			m_dwSizeCollisionInfo;
	DWORD			m_dwNumCollisionInfo;
	D3DXVECTOR3		m_vecDirMin;
	D3DXVECTOR3		m_vecDirMax;
	BOOL	Collide2Box(D3DXVECTOR3 *pMin1, D3DXVECTOR3 *pMax1, D3DXVECTOR3 *pMin2, D3DXVECTOR3 *pMax2){
		static	const BOOL	bFalse = false;	
		BOOL	bHit = TRUE;
		__asm{
			fild	bFalse;				//	st(3) := 0
			fild	bHit;				//	st(2) := 1
			mov	esi,	pMin1;
			mov	edi,	pMax2;
			fld	float ptr[edi];			//	st(1):=pMax2->x
			fld	float ptr[esi];			//	st(0):=pMin1->x
			fcomip	st, st(1);
			fstp	st(0);
			fcmovnbe	st(0),st(1);	//	if (pMin1->x > pMax2->x)	then bHit = FALSE;

			fld	float ptr[edi+4];		//	st(1):= pMax2->y
			fld float ptr[esi+4];		//	st(0):= pMin1->y
			fcomip	st,st(1);
			fstp	st(0);
			fcmovnbe	st(0),st(1);	//	if (pMin1->y > pMax2->y)	then bHit = FALSE;	

			fld	float ptr[edi+8];		//	st(1):= pMax2->z
			fld float ptr[esi+8];		//	st(0):= pMin1->z
			fcomip	st,st(1);
			fstp	st(0);
			fcmovnbe	st(0),st(1);	//	if (pMin1->z > pMax2->z)	then bHit = FALSE;	

			mov	esi,	pMax1;
			mov	edi,	pMin2;
			fld	float ptr[edi];			//st(1):=pMin2->x
			fld	float ptr[esi];			//st(0):=pMax1->x
			fcomip	st,st(1);
			fstp	st(0);
			fcmovb	st(0),st(1);		//	if (pMax1->x < pMin2->x)	then bHit = FALSE;

			fld	float ptr[edi+4];		//st(1):=pMin2->y
			fld	float ptr[esi+4];		//st(0):=pMax1->y
			fcomip	st,st(1);
			fstp	st(0);
			fcmovb	st(0),st(1);		//	if (pMax1->y < pMin2->y)	then bHit = FALSE;

			fld	float ptr[edi+8];		//st(1):=pMin2->z
			fld	float ptr[esi+8];		//st(0):=pMax1->z
			fcomip	st,st(1);
			fstp	st(0);
			fcmovb	st(0),st(1);		//	if (pMax1->z < pMin2->z)	then bHit = FALSE;

			fistp	bHit	;
			fstp	st(0)	;
		}
		return	bHit;
	}
	void	CalcPolygonBoundingBox(D3DXVECTOR3 *pVertices, DWORD dwPitch, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax){
		__asm{
			mov	esi, pVertices;
			mov edi, pMin;
			mov ebx, pMax;
			
			mov	eax, dword ptr [esi];
			mov	dword ptr [edi], eax;		/*	pMin->x = pVertices[0].p.x;	*/
			mov	dword ptr [ebx], eax;		/*	pMax->x = pVertices[0].p.x;	*/
			mov	eax, dword ptr [esi+4];
			mov	dword ptr [edi+4], eax;		/*	pMin->y = pVertices[0].p.y;	*/
			mov	dword ptr [ebx+4], eax;		/*	pMax->y = pVertices[0].p.y;	*/
			mov	eax, dword ptr [esi+8];
			mov	dword ptr [edi+8], eax;		/*	pMin->z = pVertices[0].p.z;	*/
			mov	dword ptr [ebx+8], eax;		/*	pMax->z = pVertices[0].p.z;	*/
			add	esi, dwPitch;				/*	pVertices++	*/
			/*if (vecMin.x > pTri[1].p.x)	vecMin.x = pTri[1].p.x;*/
			fld		float ptr [esi];		/*	st(1) = pTri[1].p.x*/
			fld		float ptr [edi];		/*	st(0) = pMin->x;*/
			fcomi	st,st(1);				
			fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[1].p.x then st(0):=st(1)*/
			fstp	float ptr [edi];		/*	pMin->x = st(0)*/
			/*if (pMax->x < pTri[1].p.x)	pMax->x = pTri[1].p.x;*/
			fld		float ptr [ebx];		/* st(0) = pMax->x;*/
			fcomi	st,st(1);				/*	*/
			fcmovb	st(0),st(1);			/*	pMax->x < pTri[1].p.x then st(0):=st(1)*/
			fstp	float ptr [ebx];		/*	*/
			fstp	st(0)					/*	*/
			/*if (pMin->y > pTri[1].p.y)	pMin->y = pTri[1].p.y;*/
			fld		[esi+4];				/* st(1) = pTri[1].p.y*/
			fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
			fcomi	st,st(1);				/*	if (pMin->y > pTri[1].p.y) st(0) = pTri[1].p.y;*/
			fcmovnbe	st(0),st(1);
			fstp	float ptr [edi+4];
			/*if (pMax->y < pTri[1].p.y)	pMax->y = pTri[1].p.y;*/
			fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
			fcomi	st,st(1);				/**/
			fcmovb	st(0),st(1);			/*	if pMax->y < pTri[1].p.y st(0) = pTri[1].p.y*/
			fstp	float ptr [ebx+4];
			fstp	st(0)
			/*if (pMin->z > pTri[1].p.z)	pMin->z = pTri[1].p.z;*/
			fld		float ptr [esi+8];		/* st(1) = pTri[1].p.z*/
			fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
			fcomi	st,st(1);				/**/
			fcmovnbe	st(0),st(1);		/*	if pTri[1].p.z > pMin->z st(0) = pTri[1].p.z*/
			fstp	float ptr [edi+8];
			/*if (pMax->z < pTri[1].p.z)	pMax->z = pTri[1].p.z;*/
			fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
			fcomi	st,st(1);	/**/
			fcmovb	st(0),st(1);			/*	if pMax->z < pTri[1].p.z st(0) = pTri[1].x*/
			fstp	float ptr [ebx+8];
			fstp	st(0)

			add	esi, dwPitch;			/*	pVertices++*/
			/*if (vecMin.x > pTri[2].p.x)	vecMin.x = pTri[2].p.x;*/
			fld		float ptr [esi];		/*	st(1) = pTri[2].p.x*/
			fld		float ptr [edi];		/*	st(0) = pMin->x*/;
			fcomi	st,st(1);				
			fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[2].p.x then st(0):=st(1)*/
			fstp	float ptr [edi];		/*	pMin->x = st(0)*/
			/*if (pMax->x < pTri[2].p.x)	pMax->x = pTri[2].p.x;*/
			fld		float ptr [ebx];		/* st(0) = pMax->x;*/
			fcomi	st,st(1);				
			fcmovb	st(0),st(1);			/*	pMax->x < pTri[2].p.x then st(0):=st(1)*/
			fstp	float ptr [ebx];		/*	*/
			fstp	st(0)					/*	*/
			/*if (pMin->y > pTri[2].p.y)	pMin->y = pTri[2].p.y;*/
			fld		[esi+4];				/* st(1) = pTri[2].p.y*/
			fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
			fcomi	st,st(1);				/*	if (pMin->y > pTri[2].p.y) st(0) = pTri[2].p.y;*/
			fcmovnbe	st(0),st(1);
			fstp	float ptr [edi+4];
			/*if (pMax->y < pTri[2].p.y)	pMax->y = pTri[2].p.y;*/
			fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
			fcomi	st,st(1);				
			fcmovb	st(0),st(1);			/*	if pMax->y < pTri[2].p.y st(0) = pTri[2].p.y*/
			fstp	float ptr [ebx+4];
			fstp	st(0)
			/*if (pMin->z > pTri[2].p.z)	pMin->z = pTri[2].p.z;*/
			fld		float ptr [esi+8];		/* st(1) = pTri[2].p.z*/
			fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
			fcomi	st,st(1);				
			fcmovnbe	st(0),st(1);		/*	if pTri[2].p.z > pMin->z st(0) = pTri[2].p.z*/
			fstp	float ptr [edi+8];
			/*if (pMax->z < pTri[2].p.z)	pMax->z = pTri[2].p.z;*/
			fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
			fcomi	st,st(1);				
			fcmovb	st(0),st(1);			/*	if pMax->z < pTri[2].p.z st(0) = pTri[2].x*/
			fstp	float ptr [ebx+8];	
			fstp	st(0)
		}
	}
};

#endif