#pragma once

#ifndef	__HIERARCHICALMESH_H__
#define	__HIERARCHICALMESH_H__

#ifndef __MESH_H__
#include "Mesh.h"
#endif

class CHierarchicalMesh;
class CContainer;
class CMeshFrameTracker;
//-----------------------------------------------------------------------------
// Name: struct SKINNEDMESH_FRAME
// Desc: D3DXFRAME ̔h\́Aet[gXtH[[V
//		sێł悤ɂĂB
//-----------------------------------------------------------------------------
struct HIERARCHICAL_FRAME: public D3DXFRAME
{
    D3DXMATRIXA16       CombinedTransformationMatrix;
	D3DXMATRIXA16		BackupMatrix;
};


//-----------------------------------------------------------------------------
// Name: struct CSkinnedMeshContainer
// Desc: D3DXMESHCONTAINER ̔hNXB
//-----------------------------------------------------------------------------
class	CTextureNode;
struct CMeshContainer: public D3DXMESHCONTAINER
{
    CTextureNode**		 ppTextures;         
    LPD3DXMESH           pOrigMesh;
};

//-----------------------------------------------------------------------------
// Name: class CAllocateHierarchy
// Desc: ID3DXAllocateHierarchy ̊gNX
//-----------------------------------------------------------------------------
#if	D3DX_VERSION < 0x0902
class CAllocateHierarchy: public ID3DXAllocateHierarchy
{
public:
    STDMETHOD(CreateFrame)(THIS_ LPCTSTR Name, LPD3DXFRAME *ppNewFrame);
    STDMETHOD(CreateMeshContainer)(THIS_ LPCTSTR Name, LPD3DXMESHDATA pMeshData,
                            LPD3DXMATERIAL pMaterials, LPD3DXEFFECTINSTANCE pEffectInstances, DWORD NumMaterials, 
                            DWORD *pAdjacency, LPD3DXSKININFO pSkinInfo, 
                            LPD3DXMESHCONTAINER *ppNewMeshContainer);
    STDMETHOD(DestroyFrame)(THIS_ LPD3DXFRAME pFrameToFree);
    STDMETHOD(DestroyMeshContainer)(THIS_ LPD3DXMESHCONTAINER pMeshContainerBase);
    CAllocateHierarchy(CSkinnedMesh *p){	m_pParent = p;	}
private:
	CSkinnedMesh	*m_pParent;
};
#else
class CAllocateHierarchy2: public ID3DXAllocateHierarchy
{
public:
    STDMETHOD(CreateFrame)(THIS_ LPCTSTR Name, LPD3DXFRAME *ppNewFrame);
    STDMETHOD(CreateMeshContainer)(THIS_ LPCSTR Name,
		CONST D3DXMESHDATA *pMeshData,
		CONST D3DXMATERIAL *pMaterials,
		CONST D3DXEFFECTINSTANCE *pEffectInstances,
		DWORD NumMaterials,
		CONST DWORD *pAdjacency,
		LPD3DXSKININFO pSkinInfo,
		LPD3DXMESHCONTAINER *ppNewMeshContainer);

    STDMETHOD(DestroyFrame)(THIS_ LPD3DXFRAME pFrameToFree);
    STDMETHOD(DestroyMeshContainer)(THIS_ LPD3DXMESHCONTAINER pMeshContainerBase);
    CAllocateHierarchy2(CHierarchicalMesh *p){	m_pParent = p;	}
private:

	CHierarchicalMesh	*m_pParent;
};
#endif


class CHierarchicalMesh : public CMesh
{
	friend	class	CAllocateHierarchy2;
	friend	class	CMeshFrameTracker;
public:
	CHierarchicalMesh(CD3DEnv *pEnv, TCHAR *pFilenae);
	virtual ~CHierarchicalMesh(void);
	void	UpdateMatrix(D3DXMATRIX	*pMat);
	void	RenderFrame(LPDIRECT3DDEVICE9 lpd3ddev,D3DXFRAME *pFrame);
	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	void	RenderMeshContainer(LPDIRECT3DDEVICE9 lpd3ddev, LPD3DXMESHCONTAINER pMeshContainerBase, LPD3DXFRAME pFrameBase);
protected:
	virtual	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	HRESULT	DeleteDeviceObjects();
	virtual	void	UpdateFrameMatrices(LPD3DXFRAME pFrameBase, LPD3DXMATRIX pParentMatrix);
	LPD3DXFRAME	m_pFrameRoot;
	D3DXMATRIX	m_matWorld;
};


#endif