//-----------------------------------------------------------------------------
// File: D3DFont.cpp
//
// Desc: eNX`gptHgNXB
//	TL_̃NbsO͌݊ʂőd_IɃ`FbNǂEEE
//
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include <tchar.h>
#include <d3d9.h>
#include <D3DX9.h>
#include "D3DFont.h"

#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}

//-----------------------------------------------------------------------------
// Custom vertex types for rendering text
//-----------------------------------------------------------------------------

inline FONT2DVERTEX InitFont2DVertex( const D3DXVECTOR4& p, D3DCOLOR color,
                                      FLOAT tu, FLOAT tv )
{
    FONT2DVERTEX v;   v.p = p;   v.color = color;   v.tu = tu;   v.tv = tv;
    return v;
}


//-----------------------------------------------------------------------------
// Name: CD3DFont()
// Desc: Font class constructor
//-----------------------------------------------------------------------------
CD3DFont::CD3DFont(  CD3DEnv *pEnv, TCHAR* strFontName, DWORD dwHeight, DWORD dwFlags )
{
    _tcscpy_s( m_strFontName, _countof(m_strFontName), strFontName );
    m_dwFontHeight         = dwHeight;
    m_dwFontFlags          = dwFlags;
    m_pTexture             = NULL;

	m_lpD3DEnv = pEnv;
	m_dwState = D3DFONT_DELETED;
	pEnv->AddGraphicsObject(this);
}

void	CD3DFont::ResizeFont( DWORD dwHeight, DWORD dwFlags ){
	//	Enter exclusive section.
	m_lpD3DEnv->EnterLoadingSection();
	m_dwFontHeight         = dwHeight;
    m_dwFontFlags          = dwFlags;
	InvalidateDeviceObjects();
	DeleteDeviceObjects();
	SAFE_RELEASE(m_pTexture);
	//  Leave exclusive section.
	m_lpD3DEnv->LeaveLoadingSection();
}


//-----------------------------------------------------------------------------
// Name: ~CD3DFont()
// Desc: Font class destructor
//-----------------------------------------------------------------------------
CD3DFont::~CD3DFont()
{
    InvalidateDeviceObjects();
    DeleteDeviceObjects();
	m_lpD3DEnv->RemoveGraphicsObject(this);
}




//-----------------------------------------------------------------------------
// Name: InitDeviceObjects()
// Desc: foCXˑIuWFNgiVXej̏
//-----------------------------------------------------------------------------
HRESULT CD3DFont::InitDeviceObjects( LPDIRECT3DDEVICE9 lpd3ddev )
{
    HRESULT hr;

    m_fTextScale  = 1.0f; // Draw fonts into texture without scaling
	HDC		hDC = NULL;
	HBITMAP hbmBitmap = NULL;
	HFONT hFont = NULL;
	DWORD dwBold   = (m_dwFontFlags&D3DFONT_BOLD)   ? FW_BOLD : FW_NORMAL;
    DWORD dwItalic = (m_dwFontFlags&D3DFONT_ITALIC) ? TRUE    : FALSE;

	if (m_pTexture != NULL)
		return	S_OK;

    hDC       = CreateCompatibleDC( NULL );
	INT	nHeight;
	if (m_dwFontFlags & D3DFONT_SIZE_IN_PIXELS){
		nHeight = (INT)(m_dwFontHeight);
	}else{
		__int64	tmp64 = m_dwFontHeight;
		tmp64 *= (INT)(GetDeviceCaps(hDC, LOGPIXELSY));
		nHeight    = (INT)(tmp64 / 72);	//	tHg * dpi * testScale / 72
	}

	// Large fonts need larger textures
    if( nHeight > 64 )
        m_dwTexWidth = m_dwTexHeight = 1024;
    else if( nHeight > 32 )
        m_dwTexWidth = m_dwTexHeight = 512;
    else
        m_dwTexWidth  = m_dwTexHeight = 256;

    // If requested texture is too big, use a smaller texture and smaller font,
    // and scale up when rendering.
    D3DCAPS9 d3dCaps;
    lpd3ddev->GetDeviceCaps( &d3dCaps );

    if( m_dwTexWidth > d3dCaps.MaxTextureWidth )
    {
        m_fTextScale = (FLOAT)d3dCaps.MaxTextureWidth / (FLOAT)m_dwTexWidth;
        m_dwTexWidth = m_dwTexHeight = d3dCaps.MaxTextureWidth;
    }
	nHeight = (INT)(nHeight * m_fTextScale);

    // Create a new texture for the font
    hr = lpd3ddev->CreateTexture( m_dwTexWidth, m_dwTexHeight, 1,
                                      0, D3DFMT_A4R4G4B4,
                                      D3DPOOL_MANAGED, &m_pTexture, NULL );
	if (SUCCEEDED(hr)){
		// rbg}bv쐬̂߂̏
		DWORD*      pBitmapBits;
		BITMAPINFO bmi;
		ZeroMemory( &bmi.bmiHeader,  sizeof(BITMAPINFOHEADER) );
		bmi.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
		bmi.bmiHeader.biWidth       =  (int)m_dwTexWidth;
		bmi.bmiHeader.biHeight      = -(int)m_dwTexHeight;
		bmi.bmiHeader.biPlanes      = 1;
		bmi.bmiHeader.biCompression = BI_RGB;
		bmi.bmiHeader.biBitCount    = 32;

		// rbg}bv̍쐬
		hbmBitmap = CreateDIBSection( hDC, &bmi, DIB_RGB_COLORS,
											(VOID**)&pBitmapBits, NULL, 0 );
		SetMapMode( hDC, MM_TEXT );

		//	ANTIALIASED_QUALITYw肵ătHg𐶐B
		//	A`GCAXtHg𓾂悤Ƃ邪A
		//	A`GCAXƂ͕ۏ؂ȂB
		hFont    = CreateFont( -nHeight, 0, 0, 0, dwBold, dwItalic,
							FALSE, FALSE, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
							CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY,
							VARIABLE_PITCH, m_strFontName );
		if( NULL==hFont ){
			hr = E_FAIL;
		}else{
			SelectObject( hDC, hbmBitmap );
			SelectObject( hDC, hFont );

			// eLXgvpeB[̐ݒ
			SetTextColor( hDC, RGB(255,255,255) );
			SetBkColor(   hDC, 0x00000000 );
			SetTextAlign( hDC, TA_TOP );

			//	eNX`WۑȂAo͉\ȕrbg}bv
			//	o͂Ă䂭B
			DWORD x = 0;
			DWORD y = 0;
			TCHAR str[2] = _T("x");
			SIZE size;

			for( TCHAR c=32; c<127; c++ )
			{
				str[0] = c;
				GetTextExtentPoint32( hDC, str, 1, &size );

				if( (DWORD)(x+size.cx+1) > m_dwTexWidth )
				{
					x  = 0;
					y += size.cy+1;
				}

				ExtTextOut( hDC, x+0, y+0, ETO_OPAQUE, NULL, str, 1, NULL );

				m_fTexCoords[c-32][0] = ((FLOAT)(x+0))/m_dwTexWidth;
				m_fTexCoords[c-32][1] = ((FLOAT)(y+0))/m_dwTexHeight;
				m_fTexCoords[c-32][2] = ((FLOAT)(x+0+size.cx))/m_dwTexWidth;
				m_fTexCoords[c-32][3] = ((FLOAT)(y+0+size.cy))/m_dwTexHeight;

				x += size.cx+1;
			}

			// Lock the surface and write the alpha values for the set pixels
			D3DLOCKED_RECT d3dlr;
			m_pTexture->LockRect( 0, &d3dlr, 0, 0 );
			WORD* pDst16 = (WORD*)d3dlr.pBits;
			BYTE bAlpha; // 4-bit measure of pixel intensity

			for( y=0; y < m_dwTexHeight; y++ )
			{
				for( x=0; x < m_dwTexWidth; x++ )
				{
					bAlpha = (BYTE)((pBitmapBits[m_dwTexWidth*y + x] & 0xff) >> 4);
					if (bAlpha > 0)
					{
						*pDst16++ = (bAlpha << 12) | 0x0fff;
					}
					else
					{
						*pDst16++ = 0x0000;
					}
				}
			}

			// Done updating texture, so clean up used objects
			m_pTexture->UnlockRect(0);
			hr = S_OK;
		}
	}
	if (hbmBitmap)
	    DeleteObject( hbmBitmap );
	if (hFont)
		DeleteObject( hFont );
	if (hDC)
	    DeleteDC( hDC );
	m_dwState = D3DFONT_INITIALIZED;
    return hr;
}




//-----------------------------------------------------------------------------
// Name: RestoreDeviceObjects()
// Desc:
//-----------------------------------------------------------------------------
HRESULT CD3DFont::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	if (m_dwState == D3DFONT_DELETED){
		InitDeviceObjects(lpd3ddev);
	}
	m_dwState = D3DFONT_RESTORED;
	return	S_OK;
}




//-----------------------------------------------------------------------------
// Name: InvalidateDeviceObjects()
// Desc: Destroys all device-dependent objects
//-----------------------------------------------------------------------------
HRESULT CD3DFont::InvalidateDeviceObjects()
{
	m_dwState = D3DFONT_INITIALIZED;
    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: DeleteDeviceObjects()
// Desc: Destroys all device-dependent objects
//-----------------------------------------------------------------------------
HRESULT CD3DFont::DeleteDeviceObjects()
{
    SAFE_RELEASE( m_pTexture );
	m_dwState = D3DFONT_DELETED;
    return S_OK;
}


void	CD3DFont::SetRenderingState(LPDIRECT3DDEVICE9 lpd3ddev){
    lpd3ddev->SetTexture( 0, m_pTexture );
    lpd3ddev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    lpd3ddev->SetRenderState( D3DRS_SRCBLEND,   D3DBLEND_SRCALPHA );
    lpd3ddev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_INVSRCALPHA );
    lpd3ddev->SetRenderState( D3DRS_ALPHATESTENABLE,  TRUE );
    lpd3ddev->SetRenderState( D3DRS_ALPHAREF,         0x08 );
    lpd3ddev->SetRenderState( D3DRS_ALPHAFUNC,  D3DCMP_GREATEREQUAL );
    lpd3ddev->SetRenderState( D3DRS_FILLMODE,   D3DFILL_SOLID );
	lpd3ddev->SetRenderState( D3DRS_CULLMODE,   D3DCULL_NONE );
    lpd3ddev->SetRenderState( D3DRS_ZENABLE,          FALSE );
    lpd3ddev->SetRenderState( D3DRS_STENCILENABLE,    FALSE );
    lpd3ddev->SetRenderState( D3DRS_CLIPPING,         TRUE );
    lpd3ddev->SetRenderState( D3DRS_CLIPPLANEENABLE,  FALSE );
    lpd3ddev->SetRenderState( D3DRS_VERTEXBLEND,      FALSE );
    lpd3ddev->SetRenderState( D3DRS_INDEXEDVERTEXBLENDENABLE, FALSE );
    lpd3ddev->SetRenderState( D3DRS_FOGENABLE,        FALSE );
    lpd3ddev->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
    lpd3ddev->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    lpd3ddev->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    lpd3ddev->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE );
    lpd3ddev->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
    lpd3ddev->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
    lpd3ddev->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, 0 );
    lpd3ddev->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );
    lpd3ddev->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE );
    lpd3ddev->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

	lpd3ddev->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    lpd3ddev->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    lpd3ddev->SetSamplerState( 0, D3DSAMP_MIPFILTER, D3DTEXF_NONE );
}

//-----------------------------------------------------------------------------
// Name: GetTextExtent()
// Desc: Get the dimensions of a text string
//-----------------------------------------------------------------------------
HRESULT CD3DFont::GetTextExtent( TCHAR* strText, SIZE* pSize )
{
    if( NULL==strText || NULL==pSize )
        return E_FAIL;

    FLOAT fRowWidth  = 0.0f;
    FLOAT fRowHeight = (m_fTexCoords[0][3]-m_fTexCoords[0][1])*m_dwTexHeight;
    FLOAT fWidth     = 0.0f;
    FLOAT fHeight    = fRowHeight;

    while( *strText )
    {
        TCHAR c = *strText++;

        if( c == _T('\n') )
        {
            fRowWidth = 0.0f;
            fHeight  += fRowHeight;
        }
        if( c < _T(' ') )
            continue;

        FLOAT tx1 = m_fTexCoords[c-32][0];
        FLOAT tx2 = m_fTexCoords[c-32][2];

        fRowWidth += (tx2-tx1)*m_dwTexWidth;

        if( fRowWidth > fWidth )
            fWidth = fRowWidth;
    }

    pSize->cx = (int)fWidth;
    pSize->cy = (int)fHeight;

    return S_OK;
}


//-----------------------------------------------------------------------------
// Name: DrawText()
// Desc: QceLXg̕`
//-----------------------------------------------------------------------------
HRESULT CD3DFont::DrawText( FLOAT sx, FLOAT sy, DWORD dwColor,
                            TCHAR* strText, DWORD dwFlags )
{
	return	DrawTextClippedScaled(NULL,sx,sy,1.0f,1.0f,dwColor,strText,dwFlags);
}

//-----------------------------------------------------------------------------
// Name: DrawTextClipped()
// Desc: QceLXg̕`E`NbsO@\
//-----------------------------------------------------------------------------
HRESULT CD3DFont::DrawTextClipped( LPRECT clipRect, FLOAT sx, FLOAT sy, DWORD dwColor,
                            TCHAR* strText, DWORD dwFlags )
{
	return	DrawTextClippedScaled(clipRect,sx,sy,1.0f,1.0f,dwColor,strText,dwFlags);
}

//-----------------------------------------------------------------------------
// Name: DrawText()
// Desc: QceLXg̕`EXP[O@\
//-----------------------------------------------------------------------------
HRESULT CD3DFont::DrawTextScaled( FLOAT sx, FLOAT sy, FLOAT scaleX, FLOAT scaleY, DWORD dwColor,
                            TCHAR* strText, DWORD dwFlags )
{
	return	DrawTextClippedScaled(NULL,sx,sy,scaleX,scaleY,dwColor,strText,dwFlags);
}

//-----------------------------------------------------------------------------
// Name: DrawTextClippedScaled()
// Desc: QceLXg̕`E`NbsOEXP[O@\
//-----------------------------------------------------------------------------
HRESULT CD3DFont::DrawTextClippedScaled( LPRECT clipRect, FLOAT sx, FLOAT sy, FLOAT scaleX, FLOAT scaleY, DWORD dwColor,
                            TCHAR* strText, DWORD dwFlags )
{
	LPDIRECT3DDEVICE9	lpd3ddev = NULL;
	HRESULT	hr;
    FLOAT fStartX = sx;
 	FONT2DVERTEX	vertices[4];
	FLOAT	fTexWidth, fTexHeight;
	FLOAT	fTexWidthInv, fTexHeightInv;
	hr = m_lpD3DEnv->GetD3DDevice(&lpd3ddev);
	if (FAILED(hr))
		goto	errorExit;

	if (fabs(scaleX) < FLT_MIN)
		goto	errorExit;

	if (fabs(scaleY) < FLT_MIN)
		goto	errorExit;

	FLOAT	fScaleInvX = 1.0f / scaleX;
	FLOAT	fScaleInvY = 1.0f / scaleY;

	//	_Oݒ
	SetRenderingState(lpd3ddev);
	lpd3ddev->SetFVF(D3DFVF_FONT2DVERTEX);
    lpd3ddev->SetVertexShader( NULL );
	lpd3ddev->SetPixelShader( NULL);

    // Set filter states
    if( dwFlags & D3DFONT_FILTERED )
    {
        lpd3ddev->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
        lpd3ddev->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
    }
	fTexWidth = m_dwTexWidth / m_fTextScale;
	fTexHeight = m_dwTexHeight / m_fTextScale;
	fTexWidthInv = 1.0f / fTexWidth;
	fTexHeightInv = 1.0f / fTexHeight;
    while( *strText )
    {
        TCHAR c = *strText++;

        if( c == _T('\n') )
        {
            sx = fStartX;
            sy += (m_fTexCoords[0][3]-m_fTexCoords[0][1])*m_dwTexHeight*scaleY;
        }
        if( c < _T(' ') )
            continue;

		if (c >= 128)
			continue;

		FLOAT tx1 = m_fTexCoords[c-32][0];
        FLOAT ty1 = m_fTexCoords[c-32][1];
        FLOAT tx2 = m_fTexCoords[c-32][2];
        FLOAT ty2 = m_fTexCoords[c-32][3];

        FLOAT w = (tx2-tx1) * fTexWidth;
        FLOAT h = (ty2-ty1) * fTexHeight;
		w *= scaleX;
		h *= scaleY;

		FLOAT	t,l,b,r;
		t = sy - 0.5f;
		l = sx - 0.5f;
		b = sy + h - 0.5f;
		r = sx + w - 0.5f;
        sx += w;
		if (clipRect != NULL){
			FLOAT	fTmp;
			if (t > clipRect->bottom)
				continue;
			if (b < clipRect->top)
				continue;
			if (l > clipRect->right)
				continue;
			if (r < clipRect->left)
				continue;
			if (t < clipRect->top){
				fTmp = clipRect->top - t;
				fTmp *= fScaleInvY;
				ty1 += fTmp * fTexHeightInv;
				t = (FLOAT)clipRect->top;
			}
			if (b > clipRect->bottom){
				fTmp = b - clipRect->bottom;
				fTmp *= fScaleInvY;
				ty2 -= fTmp * fTexHeightInv;
				b = (FLOAT)clipRect->bottom;
			}
			if (l < clipRect->left){
				fTmp = clipRect->left - l;
				fTmp *= fScaleInvX;
				tx1 += fTmp * fTexWidthInv;
				l = (FLOAT)clipRect->left;
			}
			if ( r > clipRect->right){
				fTmp = r - clipRect->right;
				fTmp *= fScaleInvX;
				tx2 -= fTmp * fTexWidthInv;
				r = (FLOAT)clipRect->right;
			}
		}
		vertices[0] = InitFont2DVertex( D3DXVECTOR4(l,t,0.0f,1.0f), dwColor, tx1, ty1 );
		vertices[1] = InitFont2DVertex( D3DXVECTOR4(l,b,0.0f,1.0f), dwColor, tx1, ty2 );
		vertices[2] = InitFont2DVertex( D3DXVECTOR4(r,b,0.0f,1.0f), dwColor, tx2, ty2 );
		vertices[3] = InitFont2DVertex( D3DXVECTOR4(r,t,0.0f,1.0f), dwColor, tx2, ty1 );
		hr = lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,2,vertices,sizeof(FONT2DVERTEX));
    }

	hr = S_OK;
errorExit:
	SAFE_RELEASE(lpd3ddev);
    return hr;
}


void CD3DFont::Dump(){
	FONT2DVERTEX	vertices[4];
	LPDIRECT3DDEVICE9	lpd3ddev = NULL;
	HRESULT	hr;

	hr = m_lpD3DEnv->GetD3DDevice(&lpd3ddev);
	if (FAILED(hr))
		goto	errorExit;

	vertices[0].p = D3DXVECTOR4(0.0f,0.0f,0.0f,1.0f);
	vertices[0].color = D3DCOLOR_ARGB(255,255,255,255);
	vertices[0].tu = 0.0f;
	vertices[0].tv = 0.0f;
	vertices[1].p = D3DXVECTOR4(0.0f,300.0f,0.0f,1.0f);
	vertices[1].color = D3DCOLOR_ARGB(255,255,255,255);
	vertices[1].tu = 0.0f;
	vertices[1].tv = 1.0f;
	vertices[2].p = D3DXVECTOR4(300.0f,300.0f,0.0f,1.0f);
	vertices[2].color = D3DCOLOR_ARGB(255,255,255,255);
	vertices[2].tu = 1.0f;
	vertices[2].tv = 1.0f;
	vertices[3].p = D3DXVECTOR4(300.0f,0.0f,0.0f,1.0f);
	vertices[3].color = D3DCOLOR_ARGB(255,255,255,255);
	vertices[3].tu = 1.0f;
	vertices[3].tv = 0.0f;

	SetRenderingState(lpd3ddev);
    lpd3ddev->SetFVF( D3DFVF_FONT2DVERTEX );
	lpd3ddev->SetVertexShader(NULL);
	lpd3ddev->SetPixelShader(NULL);
	lpd3ddev->SetRenderState( D3DRS_CULLMODE,   D3DCULL_NONE );
	lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,2,vertices,sizeof(FONT2DVERTEX));

	hr = S_OK;
errorExit:
	SAFE_RELEASE(lpd3ddev);
	return;
}


