/*
 *		class	CD3DEnv
 *		desc:	Direct3D {vO
 *
 *		First edition: February.19.2004
 */

#include "StdAfx.h"
#include <stdio.h>
#include <stdarg.h>
#include <math.h>
#include <d3dx9.h>
#include <mmsystem.h>
#include <tchar.h>
#include <time.h>
#include <process.h>
#include <crtdbg.h>
#include "d3dfont.h"	//	ptHg
#include "d3d9env.h"
#include "DeviceInformation.h"
#include "HighResTimer.h"
#include "SkinnedMesh.h"		//	RcOtBbNXf[^ǗVXe
#include "TextureDB.h"
#include "Billboard.h"	//	r{[hǗVXe
#include "ContainerDB.h"
#include "VertexShaderFromMemory.h"

#include "FilenameDecoder.h"
/*
 *		萔}N
 */
#define	CAMERA_Z	(-7.0f)

/*
 *		֐錾
 */
HRESULT ConfirmDevice(D3DCAPS9*pCaps,DWORD dwBehavior, D3DFORMAT fmt, LPVOID ref);

//-------------------------------------------------------------
//	Name: CD3DEnv
//	Desc: RXgN^EfXgN^
//-------------------------------------------------------------
CD3DEnv::CD3DEnv(){
	m_hWnd = NULL;

	m_lpD3D = NULL;
	m_lpD3DDEV = NULL;

	m_pFont = NULL;

	m_lpDI = NULL;
	m_pKeyboard = NULL;
	m_pJoystick = NULL;
	m_lpDevices = NULL;
	m_Adapters = NULL;
	m_dwNumAdapters	= 0;
	m_dwAdapter		= 0L;
	m_bWindowed = TRUE;
	m_bUseDepthBuffer   = TRUE;
	m_dwMinDepthBits    = 16;
	m_dwMinStencilBits  = 0;
	m_pHighResTimer = NULL;
	m_pTextureDB = NULL;
	m_dummyNode.m_pNext = &m_dummyNode;
	m_dummyNode.m_pPrev = &m_dummyNode;
	m_pGraphicsObjects = &m_dummyNode;

	m_systemDummyNode.m_pNext = &m_systemDummyNode;
	m_systemDummyNode.m_pPrev = &m_systemDummyNode;
	m_pSystemGraphicsObjects = &m_systemDummyNode;

	m_dwMaxOTFaces = 0;
	m_dwSharedRenderingBufferSize = 0;
	m_pSharedRenderingBuffer = NULL;
	m_pKeys = NULL;
	m_lJoyX = 0;
	m_lJoyY = 0;
	m_colorBackground = D3DCOLOR_XRGB(0,0,0);
	m_pContainerDB = NULL;
	m_pSkinnedMeshVS1 = NULL;
	m_pSkinnedMeshVS2 = NULL;
	m_pSkinnedMeshVS3 = NULL;
	m_pSkinnedMeshVS4 = NULL;
	m_pUVScrollMeshVS = NULL;

	m_strAppPath = NULL;

	PrepareAppPathName();
	InitializeCriticalSection(&m_crLoading);

#ifdef	_DEBUG
	ZeroMemory((VOID*)debugFpsBuffer,sizeof(debugFpsBuffer));
	debugFpsPointer = 0;
#endif
}
CD3DEnv::~CD3DEnv(){
	ReleaseD3D();
	DeleteCriticalSection(&m_crLoading);
	SAFE_DELETE(m_strAppPath);
}

#if	0
//-------------------------------------------------------------
//	Name: SetDeviceConfirmFunction
//  Desc: foCX\͊mFpR[obN֐̕ύX
//-------------------------------------------------------------
void	CD3DEnv::SetDeviceConfirmFunction(ConfirmDeviceCallback pFunc){
	m_pConfirmDeviceFunction = pFunc;
}
#endif

BOOL	CD3DEnv::ConfirmDevice(D3DCAPS9 *pCaps,DWORD dwBehavior,D3DFORMAT fmt){
	if( (dwBehavior & D3DCREATE_HARDWARE_VERTEXPROCESSING ) ||
        (dwBehavior & D3DCREATE_MIXED_VERTEXPROCESSING ) )
    {
        if( pCaps->VertexShaderVersion < D3DVS_VERSION(2,0) )
            return	E_FAIL;
    }
	if( pCaps->PixelShaderVersion < D3DPS_VERSION(1,1) )
		return	E_FAIL;
	return S_OK;
}

//-------------------------------------------------------------
//  Method: EnterLoadingSection
//  Description: Enter to loading section exclusively.
//	Edition: Jan.02.2012
//-------------------------------------------------------------
void	CD3DEnv::EnterLoadingSection(){
	EnterCriticalSection(&m_crLoading);
}

//-------------------------------------------------------------
//  Method: LeaveLoadingSection
//  Description: Enter to loading section exclusively.
//	Edition: Jan.02.2012
//-------------------------------------------------------------
void	CD3DEnv::LeaveLoadingSection(){
	LeaveCriticalSection(&m_crLoading);
}

//-------------------------------------------------------------
//	Name: ReleaseD3D
//  Desc: Direct3D ̏I
//-------------------------------------------------------------
void	CD3DEnv::ReleaseD3D()
{
	EnterLoadingSection();
	InvalidateDeviceObjects();
	DeleteDeviceObjects();
	LeaveLoadingSection();

	if (m_pTextureDB != NULL){
		delete	m_pTextureDB;
		m_pTextureDB = NULL;
	}
	ReleaseSystemShaders();
	SAFE_DELETE(m_pContainerDB);
	SAFE_DELETE(m_pFont);
	ReleaseDI();
	SAFE_RELEASE(m_lpD3DDEV);
	SAFE_RELEASE(m_lpD3D);
	if (m_lpDevices){
		delete	m_lpDevices;
		m_lpDevices = NULL;
	}
	if (m_pHighResTimer != NULL){
		delete m_pHighResTimer;
		m_pHighResTimer = NULL;
	}
}

#define TITLE               "Direct3D Miss"

//-----------------------------------------------------------------------------
// Name: InitFail()
// sɌĂ΂֐
//-----------------------------------------------------------------------------
void	CD3DEnv::InitFail(HWND hWnd, LPCTSTR szError,...)
{
    char                        szBuff[128];
    va_list                     vl;

    va_start(vl, szError);
    vsprintf_s(szBuff, _countof(szBuff),szError, vl);
    MessageBox(hWnd, szBuff, "Direct3D Initialization Failure", MB_OK);
    ReleaseD3D();
//	DestroyWindow(hWnd);
    va_end(vl);
    return;
}


//-------------------------------------------------------------
//	Name: ConfirmDevice
//  Desc: foCX̋@\mFׂ̈̃R[obN
//		NX CDeviceInformation gpB
//-------------------------------------------------------------
HRESULT ConfirmDevice(D3DCAPS9*pCaps,DWORD dwBehavior, D3DFORMAT fmt, LPVOID ref)
{ 
	return	((CD3DEnv*)ref)->ConfirmDevice(pCaps,dwBehavior,fmt);
}

//-------------------------------------------------------------
//	Name: InitD3D
//  Desc: Direct3D ̏
//-------------------------------------------------------------
HRESULT	CD3DEnv::InitD3D(HWND	hWnd)
{
	m_hWnd = hWnd;
	if (m_hWnd == NULL){
		InitFail(m_hWnd,"Failed to create Direct3D");
		return	E_FAIL;
	}
	//  Create the texture data base.
	m_pTextureDB = new CTextureDB();

	//  Create the system font
	//	font is device independent until reloaded.
	//	Cheat the graphics resource management system.

	CGraphicsObject	*pSave = m_pGraphicsObjects;
	m_pGraphicsObjects = m_pSystemGraphicsObjects;
	m_pFont = new CD3DFont(this, _T("Arial"), 16, D3DFONT_SIZE_IN_PIXELS);
	m_pGraphicsObjects = pSave;

	srand((unsigned int)time(NULL));
	rand();

	m_lpD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if (!m_lpD3D){
		InitFail(m_hWnd,"Failed to create Direct3D");
		return	E_FAIL;
	}
	m_dwWindowStyle = GetWindowLong( m_hWnd, GWL_STYLE );
    GetWindowRect( m_hWnd, &m_rcWindowBounds );
    GetClientRect( m_hWnd, &m_rcWindowClient );

	m_lpDevices = new CDeviceInformation(m_lpD3D, m_bUseDepthBuffer,
									m_dwMinDepthBits, m_dwMinStencilBits,
									::ConfirmDevice,this);
    if ((NULL == m_lpDevices)||( NULL == (m_Adapters = m_lpDevices->getAdapters())))
    {
		InitFail(m_hWnd, "BuildDeviceList Failed.");
		return	E_FAIL;
    }
	m_dwNumAdapters = m_lpDevices->getNumAdapters();
	m_dwAdapter = m_lpDevices->getCurrentAdapter();

	//	Create device with hardware geometry engine.
	if (FAILED(Initialize3DEnvironment(m_hWnd))){
		InitFail(m_hWnd, "CreateDevice Failed.");
		return	E_FAIL;
	}
	if (FAILED(m_lpD3DDEV->GetDeviceCaps(&m_CurrentDeviceCaps))){
		InitFail(m_hWnd, "GetDeviceCaps Failed.");
		return	E_FAIL;
	}
	if (FAILED(InitDI(m_hWnd))){
		InitFail(m_hWnd, "Failed to Initialize DirectInput8");
		return	E_FAIL;
	}

	m_pContainerDB = new CContainerDB(this);

	InitSystemShaders();

	AdjustWindow();

	//  rԊJn
	EnterLoadingSection();

	InitSystemDeviceObjects();
	RestoreSystemDeviceObjects();

	//  rI
	LeaveLoadingSection();

	m_pHighResTimer = new CHighResTimer();

	return	S_OK;
}


//-----------------------------------------------------------------------------
// Name: GetPreferablePresentationInterval()
// Desc: ]܂v[e[VC^[oZoB
//-----------------------------------------------------------------------------
UINT	GetPreferablePresentationInterval(D3DDeviceInfo *pDevInfo, BOOL isWindowed){
   const UINT iCandidatesW[] = { 
        D3DPRESENT_INTERVAL_ONE,
        D3DPRESENT_INTERVAL_DEFAULT
    };
   const UINT iCandidatesF[] = { 
        D3DPRESENT_INTERVAL_ONE,
        D3DPRESENT_INTERVAL_DEFAULT
    };
	UINT	iRet;
	UINT	ArraySize;
	UINT	*iCandidates;
	if (isWindowed){
		ArraySize = sizeof(iCandidatesW);
		iCandidates = (UINT*)iCandidatesW;
	}else{
		ArraySize = sizeof(iCandidatesF);
		iCandidates = (UINT*)iCandidatesF;
	}
	ArraySize /= sizeof(UINT);
    for( UINT i = 0; i < ArraySize; i++ )
    {
        iRet = iCandidates[i];
        // ӁI D3DPRESENT_INTERVAL_DEFAULT ̓[Ȃ̂
		//	Caps  _ZŃ`FbN鎖͂łȂB
        //	AD3DPRESENT_INTERVAL_DEFAULT ͏Ɏgp\łB
        if( iRet == D3DPRESENT_INTERVAL_DEFAULT ||
            (pDevInfo->d3dCaps.PresentationIntervals & iRet) )
        {
			break;
        }
    }
	return	iRet;
}



//-----------------------------------------------------------------------------
// Name: Initialize3DEnvironment()
// Desc: 3D foCX̏
//-----------------------------------------------------------------------------
HRESULT CD3DEnv::Initialize3DEnvironment(HWND hWnd)
{
    HRESULT hr;

	if (m_Adapters == NULL)
		return	E_FAIL;
    D3DAdapterInfo* pAdapterInfo = &m_Adapters[m_dwAdapter];
    D3DDeviceInfo*  pDeviceInfo  = &pAdapterInfo->devices[pAdapterInfo->dwCurrentDevice];
	pDeviceInfo->dwCurrentMode = SelectMode(pDeviceInfo->modes,pDeviceInfo->dwNumModes);
	D3DModeInfo*    pModeInfo    = &pDeviceInfo->modes[pDeviceInfo->dwCurrentMode];

    // Direct3D v[e[Vp[^̐ݒ
    ZeroMemory( &m_d3dprm, sizeof(m_d3dprm) );
    m_d3dprm.Windowed               = pDeviceInfo->bWindowed;
    m_d3dprm.BackBufferCount        = 1;
    m_d3dprm.MultiSampleType        = pDeviceInfo->MultiSampleType;
    m_d3dprm.SwapEffect             = D3DSWAPEFFECT_DISCARD;
    m_d3dprm.EnableAutoDepthStencil = m_bUseDepthBuffer;
    m_d3dprm.AutoDepthStencilFormat = pModeInfo->DepthStencilFormat;
    m_d3dprm.hDeviceWindow          = hWnd;
    if( m_d3dprm.Windowed ){
        m_d3dprm.BackBufferWidth  = m_rcWindowClient.right - m_rcWindowClient.left;
        m_d3dprm.BackBufferHeight = m_rcWindowClient.bottom - m_rcWindowClient.top;
        m_d3dprm.BackBufferFormat = pAdapterInfo->d3ddmDesktop.Format;
		m_d3dprm.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;
		m_bWindowed = true;
	} else {
        m_d3dprm.BackBufferWidth  = pModeInfo->Width;
        m_d3dprm.BackBufferHeight = pModeInfo->Height;
        m_d3dprm.BackBufferFormat = pModeInfo->Format;
		m_d3dprm.FullScreen_RefreshRateInHz = pModeInfo->RefreshRate;
		m_bWindowed = false;
    }
	m_d3dprm.PresentationInterval = GetPreferablePresentationInterval(pDeviceInfo,m_d3dprm.Windowed);

    // foCX
    hr = m_lpD3D->CreateDevice( m_dwAdapter, pDeviceInfo->DeviceType,
                               hWnd, pModeInfo->dwBehavior/*|D3DCREATE_MULTITHREADED*/ ,
							   &m_d3dprm,
                               &m_lpD3DDEV );
    if( SUCCEEDED(hr) ){
        if( m_bWindowed )
        {
            SetWindowPos( hWnd, HWND_NOTOPMOST,
                          m_rcWindowBounds.left, m_rcWindowBounds.top,
                          ( m_rcWindowBounds.right - m_rcWindowBounds.left ),
                          ( m_rcWindowBounds.bottom - m_rcWindowBounds.top ),
                          SWP_SHOWWINDOW );
        }

		//  After device lost system's device objects must be restored first.
		//  
		hr = InitSystemDeviceObjects();
        if( SUCCEEDED(hr) )
            hr = RestoreSystemDeviceObjects();

		if ( SUCCEEDED(hr) )
			hr = InitDeviceObjects();
        if( SUCCEEDED(hr) )
            hr = RestoreDeviceObjects();

		if( SUCCEEDED(hr) ){
            return S_OK;
        }

        // ĎsOɃfoCXˑIuWFNgj
        InvalidateDeviceObjects();
        DeleteDeviceObjects();
		InvalidateSystemDeviceObjects();
		DeleteSystemDeviceObjects();

		SAFE_RELEASE( m_lpD3DDEV );
		return	hr;
	}

    // foCXɎs\tgEFAX^CUɕύX
    if( pDeviceInfo->DeviceType == D3DDEVTYPE_HAL )
    {
	    TCHAR strMsg[512];
		_tcscpy_s( strMsg,_countof(strMsg), _T("\n\n\tgEFAX^CUɐ؂ւ܂B\n")
						_T("\tgEGAfoCXDirect3DSɃT|[g\n")
						_T("܂͒ᑬłB") );
		MessageBox(NULL,strMsg,"Direct3D warning",MB_ICONERROR|MB_OK);

        m_dwAdapter = 0L;
        pAdapterInfo = &m_Adapters[m_dwAdapter];

		//	\tgEGAfoCX̌
        for( UINT i=0L; i<pAdapterInfo->dwNumDevices; i++ )
        {
            if( pAdapterInfo->devices[i].DeviceType == D3DDEVTYPE_REF )
            {
                pAdapterInfo->dwCurrentDevice = i;
                pDeviceInfo = &pAdapterInfo->devices[i];
				m_bWindowed = pDeviceInfo->bWindowed;
                break;
            }
        }

        if( pAdapterInfo->devices[pAdapterInfo->dwCurrentDevice].DeviceType ==
            D3DDEVTYPE_REF )
        {
            hr = Initialize3DEnvironment(hWnd);
        }
    }
    return hr;
}

//-----------------------------------------------------------------------------
// Name: UpdateScene()
// Desc: t[E`揈
//-----------------------------------------------------------------------------
void	CD3DEnv::UpdateScene(AnimationCallback animCB, RenderSceneCallback renderCB)
{
	HRESULT	hr;
	float	timeElapsed;

	m_bViewportRendered = false;
	if (m_pHighResTimer == NULL)
		return;

	timeElapsed=m_pHighResTimer->GetElapsedTimeAndReset();

	DoIO();
	if (animCB != NULL)
		animCB(timeElapsed);
	if( FAILED( hr = m_lpD3DDEV->TestCooperativeLevel() ) )
    {
        if( D3DERR_DEVICELOST == hr )
            return;

        if( D3DERR_DEVICENOTRESET == hr )
        {
            // EBhE[hł́APɃfXNgbṽ[hɐݒ
            if( m_bWindowed )
            {
                D3DAdapterInfo* pAdapterInfo = &m_Adapters[m_dwAdapter];
                m_lpD3D->GetAdapterDisplayMode( m_dwAdapter, &pAdapterInfo->d3ddmDesktop );
                m_d3dprm.BackBufferFormat = pAdapterInfo->d3ddmDesktop.Format;
            }

            if( FAILED( hr = Resize3DEnvironment() ) )
                return;
			_RPT0(_CRT_WARN,"Window resized.\n");
        }
        return;
    }

	if (!m_bViewportRendered){
		D3DVIEWPORT9	vpDefault;

		vpDefault.Width = m_d3dsdBackBuffer.Width;
		vpDefault.Height = m_d3dsdBackBuffer.Height;
		vpDefault.MinZ = 0.0f;
		vpDefault.MaxZ = 1.0f;
		vpDefault.X = 0;
		vpDefault.Y = 0;

		m_lpD3DDEV->SetViewport(&vpDefault);
		if (m_bUseDepthBuffer)
			m_lpD3DDEV->Clear(0,NULL,D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,m_colorBackground,1.0f,0);
		else
			m_lpD3DDEV->Clear(0,NULL,D3DCLEAR_TARGET,m_colorBackground,1.0f,0);

		if (SUCCEEDED(m_lpD3DDEV->BeginScene())){
			SetDefaultRenderState(m_lpD3DDEV);
			SetupLights();
			SetDefaultTransform(m_lpD3DDEV);
			if (renderCB != NULL)
				renderCB(m_lpD3DDEV);

			m_lpD3DDEV->EndScene();
		}
	}
	if (FAILED(m_lpD3DDEV->Present(NULL,NULL,NULL,NULL))){
		Resize3DEnvironment();
		_RPT0(_CRT_WARN,"Device Reset.\n");
	}
}
//-----------------------------------------------------------------------------
// Name: UpdateScene()
// Desc: t[E`揈i[U[f[^gp\o[Wj
//-----------------------------------------------------------------------------
void	CD3DEnv::UpdateScene(AnimationCallback2 animCB, RenderSceneCallback2 renderCB, PVOID lpUser)
{
	HRESULT	hr;
	float	timeElapsed;

	m_bViewportRendered = false;
	if (m_pHighResTimer == NULL)
		return;

	timeElapsed=m_pHighResTimer->GetElapsedTimeAndReset();

	DoIO();
	if (animCB != NULL)
		animCB(timeElapsed,lpUser);
	if( FAILED( hr = m_lpD3DDEV->TestCooperativeLevel() ) )
    {
        if( D3DERR_DEVICELOST == hr )
            return;

        if( D3DERR_DEVICENOTRESET == hr )
        {
            // EBhE[hł́APɃfXNgbṽ[hɐݒ
            if( m_bWindowed )
            {
                D3DAdapterInfo* pAdapterInfo = &m_Adapters[m_dwAdapter];
                m_lpD3D->GetAdapterDisplayMode( m_dwAdapter, &pAdapterInfo->d3ddmDesktop );
                m_d3dprm.BackBufferFormat = pAdapterInfo->d3ddmDesktop.Format;
            }

            if( FAILED( hr = Resize3DEnvironment() ) )
                return;
			_RPT0(_CRT_WARN,"Window resized.\n");
        }
        return;
    }

	if (!m_bViewportRendered){
		D3DVIEWPORT9	vpDefault;

		vpDefault.Width = m_d3dsdBackBuffer.Width;
		vpDefault.Height = m_d3dsdBackBuffer.Height;
		vpDefault.MinZ = 0.0f;
		vpDefault.MaxZ = 1.0f;
		vpDefault.X = 0;
		vpDefault.Y = 0;

		m_lpD3DDEV->SetViewport(&vpDefault);
		if (m_bUseDepthBuffer)
			m_lpD3DDEV->Clear(0,NULL,D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,m_colorBackground,1.0f,0);
		else
			m_lpD3DDEV->Clear(0,NULL,D3DCLEAR_TARGET,m_colorBackground,1.0f,0);

		if (SUCCEEDED(m_lpD3DDEV->BeginScene())){
			SetDefaultRenderState(m_lpD3DDEV);
			SetupLights();
			SetDefaultTransform(m_lpD3DDEV);
			if (renderCB != NULL)
				renderCB(m_lpD3DDEV,lpUser);

			m_lpD3DDEV->EndScene();
		}
	}
	if (FAILED(m_lpD3DDEV->Present(NULL,NULL,NULL,NULL))){
		Resize3DEnvironment();
		_RPT0(_CRT_WARN,"Device Reset.\n");
	}
}

//---------------------------------------------------------------------
// Name: RenderSceneWithVP()
// Desc: r[|[ggpă_Os
//---------------------------------------------------------------------
void	CD3DEnv::RenderSceneWithVP(RECT *rcWindow, RenderSceneCallback renderCB, BOOL bClear)
{
	m_bViewportRendered = TRUE;
	D3DVIEWPORT9	vpTmp,vpOrd;
	HRESULT			hr;
	if( FAILED( hr = m_lpD3DDEV->TestCooperativeLevel() ) )
		return;

	m_lpD3DDEV->GetViewport(&vpOrd);

	vpTmp.Width = rcWindow->right - rcWindow->left;
	vpTmp.Height = rcWindow->bottom - rcWindow->top;
	vpTmp.X = rcWindow->left;
	vpTmp.Y = rcWindow->top;
	vpTmp.MinZ = 0.0f;
	vpTmp.MaxZ = 1.0f;
	D3DRECT	rc;
	rc.x1 = rcWindow->left;
	rc.y1 = rcWindow->top;
	rc.x2 = rcWindow->right;
	rc.y2 = rcWindow->bottom;

	m_lpD3DDEV->SetViewport(&vpTmp);
	if (bClear){
		if (m_bUseDepthBuffer)
			m_lpD3DDEV->Clear(1,&rc,D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,m_colorBackground,1.0f,0);
		else
			m_lpD3DDEV->Clear(1,&rc,D3DCLEAR_TARGET,m_colorBackground,1.0f,0);
	}
	if (SUCCEEDED(m_lpD3DDEV->BeginScene())){
		SetDefaultRenderState(m_lpD3DDEV);
		SetupLights();
		SetDefaultTransform(m_lpD3DDEV);
		if (renderCB != NULL)
			renderCB(m_lpD3DDEV);

		m_lpD3DDEV->EndScene();
	}

	m_lpD3DDEV->SetViewport(&vpOrd);
}

//---------------------------------------------------------------------
// Name: RenderSceneWithVP()
// Desc: r[|[ggpă_OsA
//		[U[f[^tB
//---------------------------------------------------------------------
void	CD3DEnv::RenderSceneWithVP(RECT *rcWindow, RenderSceneCallback2 renderCB, PVOID lpUser, BOOL bClear)
{
	m_bViewportRendered = TRUE;
	D3DVIEWPORT9	vpTmp;

	vpTmp.Width = rcWindow->right - rcWindow->left;
	vpTmp.Height = rcWindow->bottom - rcWindow->top;
	vpTmp.X = rcWindow->left;
	vpTmp.Y = rcWindow->top;
	vpTmp.MinZ = 0.0f;
	vpTmp.MaxZ = 1.0f;

	m_lpD3DDEV->SetViewport(&vpTmp);
	if (bClear){
		if (m_bUseDepthBuffer)
			m_lpD3DDEV->Clear(0,NULL,D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,m_colorBackground,1.0f,0);
		else
			m_lpD3DDEV->Clear(0,NULL,D3DCLEAR_TARGET,m_colorBackground,1.0f,0);
	}

	if (SUCCEEDED(m_lpD3DDEV->BeginScene())){
		SetDefaultRenderState(m_lpD3DDEV);
		SetupLights();
		SetDefaultTransform(m_lpD3DDEV);
		if (renderCB != NULL)
			renderCB(m_lpD3DDEV, lpUser);

		m_lpD3DDEV->EndScene();
	}
}

//---------------------------------------------------------------------
// Name: RenderSceneWithVP()
// Desc: r[|[ggpă_OsA
//		[U[f[^tB
//---------------------------------------------------------------------
void	CD3DEnv::RenderSceneIntoSurface(LPDIRECT3DSURFACE9 pSurface, D3DCOLOR bgcolor, RenderSceneCallback2 renderCB, PVOID lpUser)
{
	LPDIRECT3DSURFACE9	pSurface0;
	HRESULT	hr;

	if( FAILED( hr = m_lpD3DDEV->TestCooperativeLevel() ) )
		return;

	D3DVIEWPORT9	vpDefault;
	vpDefault.Width = m_d3dsdBackBuffer.Width;
	vpDefault.Height = m_d3dsdBackBuffer.Height;
	vpDefault.MinZ = 0.0f;
	vpDefault.MaxZ = 1.0f;
	vpDefault.X = 0;
	vpDefault.Y = 0;

	m_lpD3DDEV->SetViewport(&vpDefault);

	if (m_bUseDepthBuffer){
		hr = m_lpD3DDEV->Clear(0,NULL,D3DCLEAR_ZBUFFER,bgcolor,1.0f,0);
	}

	m_lpD3DDEV->ColorFill(pSurface,NULL,bgcolor);
	if (FAILED(hr))
		return;

	if (FAILED(m_lpD3DDEV->GetRenderTarget(0,&pSurface0)))
		return;

	hr = m_lpD3DDEV->SetRenderTarget(0,pSurface);
	if (FAILED(hr))
		return;

	if (SUCCEEDED(m_lpD3DDEV->BeginScene())){
		if (renderCB != NULL)
			renderCB(m_lpD3DDEV, lpUser);

		m_lpD3DDEV->EndScene();
	}
	m_lpD3DDEV->SetRenderTarget(0,pSurface0);
	pSurface0->Release();
}
//-----------------------------------------------------------------------------
// Name: GetDeviceType()
// Desc: foCX^CvԂ
//-----------------------------------------------------------------------------
D3DDEVTYPE CD3DEnv::GetDeviceType()
{
	if (m_Adapters == NULL)
		return	D3DDEVTYPE_REF;
    D3DAdapterInfo* pAdapterInfo = &m_Adapters[m_dwAdapter];
    D3DDeviceInfo*  pDeviceInfo  = &pAdapterInfo->devices[pAdapterInfo->dwCurrentDevice];
	return	pDeviceInfo->DeviceType;
}
//-----------------------------------------------------------------------------
// Name: GetBackBufferWidth()
// Desc: obNobt@̕擾
//-----------------------------------------------------------------------------
DWORD	CD3DEnv::GetBackBufferWidth()
{
	return	m_d3dsdBackBuffer.Width;
}

//-----------------------------------------------------------------------------
// Name: GetBackBufferHeight()
// Desc: obNobt@̕擾
//-----------------------------------------------------------------------------
DWORD	CD3DEnv::GetBackBufferHeight()
{
	return	m_d3dsdBackBuffer.Height;
}
//-----------------------------------------------------------------------------
// Name: GetBackBufferFormat()
// Desc: obNobt@̕擾
//-----------------------------------------------------------------------------
D3DFORMAT	CD3DEnv::GetBackBufferFormat()
{
	return	m_d3dsdBackBuffer.Format;
}

//-----------------------------------------------------------------------------
// Name: CheckDeviceFormat()
// Desc: foCX̌݊mFB
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::CheckDeviceFormat(DWORD usage, D3DRESOURCETYPE rtype, D3DFORMAT format)
{
	if (m_Adapters == NULL)
		return	E_FAIL;

    D3DAdapterInfo* pAdapterInfo = &m_Adapters[m_dwAdapter];
    D3DDeviceInfo*  pDeviceInfo  = &pAdapterInfo->devices[pAdapterInfo->dwCurrentDevice];

	return m_lpD3D->CheckDeviceFormat(m_dwAdapter,pDeviceInfo->DeviceType,m_d3dsdBackBuffer.Format,usage,rtype,format);
}

//-----------------------------------------------------------------------------
// Name: SetDefaultRenderState()
// Desc: _O@̐ݒEZbg
//-----------------------------------------------------------------------------
void	CD3DEnv::SetDefaultRenderState(LPDIRECT3DDEVICE9 lpd3ddev)
{
	if (m_bUseDepthBuffer)
		lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
	else
		lpd3ddev->SetRenderState(D3DRS_ZENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_DITHERENABLE, TRUE );
	lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	lpd3ddev->SetRenderState(D3DRS_BLENDOP,FALSE);
	D3DMATERIAL9	mat;
	mat.Diffuse.r = 1.0f;
	mat.Diffuse.g = 1.0f;
	mat.Diffuse.b = 1.0f;
	mat.Diffuse.a = 0.0f;
	mat.Ambient.r = 0.0f;
	mat.Ambient.g = 0.0f;
	mat.Ambient.b = 0.0f;
	mat.Ambient.a = 0.0f;
	mat.Specular.r = 0.0f;
	mat.Specular.g = 0.0f;
	mat.Specular.b = 0.0f;
	mat.Specular.a = 0.0f;
	mat.Emissive.r = 0.0f;
	mat.Emissive.g = 0.0f;
	mat.Emissive.b = 0.0f;
	mat.Emissive.a = 0.0f;
	mat.Power = 0.0f;
	lpd3ddev->SetMaterial(&mat);
}
//-----------------------------------------------------------------------------
// Name: SetDefaultTransform()
// Desc: ϊ}gNX̐ݒEZbg
//-----------------------------------------------------------------------------
void	CD3DEnv::InitDefaultTransform()
{
	float aspect;
	D3DXMatrixLookAtLH(&m_matView,&D3DXVECTOR3(0,0.0f,CAMERA_Z),
                                  &D3DXVECTOR3( 0.0f, 0.0f, 0.0f ), 
                                  &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
	aspect = (float)m_d3dsdBackBuffer.Width / (float)m_d3dsdBackBuffer.Height;
    D3DXMatrixPerspectiveFovLH( &m_matProj, D3DX_PI/4, aspect, 1.0f, 100.0f );
}

//-----------------------------------------------------------------------------
// Name: SetDefaultTransform()
// Desc: ϊ}gNX̐ݒEZbg
//-----------------------------------------------------------------------------
void	CD3DEnv::SetDefaultTransform(LPDIRECT3DDEVICE9 lpd3ddev)
{
	lpd3ddev->SetTransform(D3DTS_VIEW,&m_matView);
	lpd3ddev->SetTransform(D3DTS_PROJECTION,&m_matProj);
}

//-----------------------------------------------------------------------------
// Name: InitLightParameters()
// Desc: V[̌ݒ肷B
//-----------------------------------------------------------------------------
VOID CD3DEnv::InitLightParameters()
{
    D3DXVECTOR3 vecDir;
    ZeroMemory( &m_litSysLight, sizeof(D3DLIGHT9) );
    m_litSysLight.Type       = D3DLIGHT_DIRECTIONAL;
    m_litSysLight.Diffuse.r  = 1.0f;
    m_litSysLight.Diffuse.g  = 1.0f;
    m_litSysLight.Diffuse.b  = 1.0f;
	m_litSysLight.Diffuse.a  = 1.0f;
	vecDir = D3DXVECTOR3(	-1.0f,
							-2.0f,
							1.0f	);
    D3DXVec3Normalize( (D3DXVECTOR3*)&m_litSysLight.Direction, &vecDir );
    m_litSysLight.Range       = 1000.0f;
	m_colAmbient = D3DCOLOR_RGBA(96,96,96,255);
}

//-----------------------------------------------------------------------------
// Name: SetupLights()
// Desc: V[̌ݒ肷B
//-----------------------------------------------------------------------------
VOID CD3DEnv::SetupLights()
{
	HRESULT	hr;
	hr = m_lpD3DDEV->SetLight( 0, &m_litSysLight );
    hr = m_lpD3DDEV->LightEnable( 0, TRUE );
    m_lpD3DDEV->SetRenderState( D3DRS_LIGHTING, TRUE );
    m_lpD3DDEV->SetRenderState( D3DRS_AMBIENT, m_colAmbient);
}

D3DXVECTOR3	*CD3DEnv::GetSystemLightDirection(){
	m_vecLight = (D3DXVECTOR3)m_litSysLight.Direction;
	return	&m_vecLight;	
}


//-----------------------------------------------------------------------------
// Name: ReloadGraphics
// Desc: SOtBbNXf[^̍ēǂݍ
//-----------------------------------------------------------------------------
void	CD3DEnv::ReloadGraphics()
{
	//  rJn
	EnterLoadingSection();

	InvalidateDeviceObjects();
	DeleteDeviceObjects();
	InitDeviceObjects();
	RestoreDeviceObjects();

	//  rI
	LeaveLoadingSection();
}

//-----------------------------------------------------------------------------
// Name: ReloadSystemGraphics
// Desc: SVXeOtBbNXf[^̍ēǂݍ
//-----------------------------------------------------------------------------
void	CD3DEnv::ReloadSystemGraphics()
{
	//  rJn
	EnterLoadingSection();

	InvalidateSystemDeviceObjects();
	DeleteSystemDeviceObjects();
	InitSystemDeviceObjects();
	RestoreSystemDeviceObjects();

	//  rI
	LeaveLoadingSection();
}

//-----------------------------------------------------------------------------
// Name: LoadGraphics
// Desc: OtBbNXf[^̒ǉǂݍ
//-----------------------------------------------------------------------------
void	CD3DEnv::LoadGraphics()
{
	//  rJn
	EnterLoadingSection();

	InitDeviceObjects();
	RestoreDeviceObjects();

	//  rI
	LeaveLoadingSection();
}

//-----------------------------------------------------------------------------
// Name:InitDeviceObjects
// Desc:  foCXˑVXeIuWFNg̏B
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::InitDeviceObjects()
{
	//  rJn
	EnterLoadingSection();

	CGraphicsObject	*pObj = m_pGraphicsObjects->m_pNext;
	while(pObj != m_pGraphicsObjects){
		pObj->InitDeviceObjects(m_lpD3DDEV);
		pObj = pObj->m_pNext;
	}

	//  rI
	LeaveLoadingSection();
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name:RestoreDeviceObjects
// Desc:  foCXˑrfIIuWFNg̓ǂݍ
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::RestoreDeviceObjects()
{
	//  rJn
	EnterLoadingSection();

	//LPDIRECT3DSURFACE9 pBackBuffer;
    //m_lpD3DDEV->GetBackBuffer( 0, 0, D3DBACKBUFFER_TYPE_MONO, &pBackBuffer );
    //pBackBuffer->GetDesc( &m_d3dsdBackBuffer );
    //pBackBuffer->Release();
	m_pTextureDB->RestoreDeviceObjects(m_lpD3DDEV);

	CGraphicsObject	*pObj = m_pGraphicsObjects->m_pNext;
	while(pObj != m_pGraphicsObjects){
		pObj->RestoreDeviceObjects(m_lpD3DDEV);
		pObj = pObj->m_pNext;
	}
	//InitDefaultTransform();
	//InitLightParameters();

	LeaveLoadingSection();
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name:InvalidateDeviceObjects
// Desc:  foCXˑrfIIuWFNg̔j
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::InvalidateDeviceObjects()
{
	//  rJn
	EnterLoadingSection();

	CGraphicsObject	*pObj = m_pGraphicsObjects->m_pNext;
	while(pObj != m_pGraphicsObjects){
		pObj->InvalidateDeviceObjects();
		pObj = pObj->m_pNext;
	}
	if (m_pTextureDB){
		m_pTextureDB->InvalidateDeviceObjects();
	}

	//  rI
	LeaveLoadingSection();

	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name:DeleteDeviceObjects
// Desc:  foCXˑVXeIuWFNg̔j
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::DeleteDeviceObjects()
{
	//  rJn
	EnterLoadingSection();

	CGraphicsObject	*pObj = m_pGraphicsObjects->m_pNext;
	while(pObj != m_pGraphicsObjects){
		pObj->DeleteDeviceObjects();
		pObj = pObj->m_pNext;
	}
	SAFE_DELETE_ARRAY(m_pSharedRenderingBuffer);
	m_dwMaxOTFaces = 0;
	m_dwSharedRenderingBufferSize = 0;
	//  rI
	LeaveLoadingSection();

	return	S_OK;
}


//-----------------------------------------------------------------------------
// Name:InitSystemDeviceObjects
// Desc:  foCXˑVXeIuWFNg̏B
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::InitSystemDeviceObjects()
{
	//  rJn
	EnterLoadingSection();

	CGraphicsObject	*pObj = m_pSystemGraphicsObjects->m_pNext;
	while(pObj != m_pSystemGraphicsObjects){
		pObj->InitDeviceObjects(m_lpD3DDEV);
		pObj = pObj->m_pNext;
	}

	//  rI
	LeaveLoadingSection();

	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name:RestoreSystemDeviceObjects
// Desc:  foCXˑrfIIuWFNg̓ǂݍ
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::RestoreSystemDeviceObjects()
{
	//  rJn
	EnterLoadingSection();

	LPDIRECT3DSURFACE9 pBackBuffer;
    m_lpD3DDEV->GetBackBuffer( 0, 0, D3DBACKBUFFER_TYPE_MONO, &pBackBuffer );
    pBackBuffer->GetDesc( &m_d3dsdBackBuffer );
    pBackBuffer->Release();
	//m_pTextureDB->RestoreDeviceObjects(m_lpD3DDEV);

	CGraphicsObject	*pObj = m_pSystemGraphicsObjects->m_pNext;
	while(pObj != m_pSystemGraphicsObjects){
		pObj->RestoreDeviceObjects(m_lpD3DDEV);
		pObj = pObj->m_pNext;
	}

	//  rI
	LeaveLoadingSection();

	InitDefaultTransform();
	InitLightParameters();

	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name:InvalidateSystemDeviceObjects
// Desc:  foCXˑrfIIuWFNg̔j
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::InvalidateSystemDeviceObjects()
{
	//  rJn
	EnterLoadingSection();

	CGraphicsObject	*pObj = m_pSystemGraphicsObjects->m_pNext;
	while(pObj != m_pSystemGraphicsObjects){
		pObj->InvalidateDeviceObjects();
		pObj = pObj->m_pNext;
	}

	//  rI
	LeaveLoadingSection();

	//  system objetcts can't use texture database.
	//	because texture db is under user's objects.
	//if (m_pTextureDB){
	//	m_pTextureDB->InvalidateDeviceObjects();
	//}
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name:DeleteSystemDeviceObjects
// Desc:  foCXˑVXeIuWFNg̔j
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::DeleteSystemDeviceObjects()
{
	//  r
	EnterLoadingSection();

	CGraphicsObject	*pObj = m_pSystemGraphicsObjects->m_pNext;
	while(pObj != m_pSystemGraphicsObjects){
		pObj->DeleteDeviceObjects();
		pObj = pObj->m_pNext;
	}

	//  rI
	LeaveLoadingSection();

	//  System can't use the ordering table
	//  because ordering table is under user's control.
	//SAFE_DELETE_ARRAY(m_pSharedRenderingBuffer);
	//m_dwMaxOTFaces = 0;
	//m_dwSharedRenderingBufferSize = 0;
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name: Resize3DEnvironment
// Desc: 3D `̃TCYύXEZbg
//-----------------------------------------------------------------------------
HRESULT CD3DEnv::Resize3DEnvironment()
{
    HRESULT hr;
	D3DAdapterInfo* pAdapterInfo = &m_Adapters[m_dwAdapter];
	D3DDeviceInfo*  pDeviceInfo  = &pAdapterInfo->devices[pAdapterInfo->dwCurrentDevice];
	D3DModeInfo*    pModeInfo    = &pDeviceInfo->modes[pDeviceInfo->dwCurrentMode];

	hr = InvalidateSystemDeviceObjects();
	if (SUCCEEDED(hr))
		hr = InvalidateDeviceObjects();
	if (FAILED(hr))
		return	hr;

    m_d3dprm.hDeviceWindow			= m_hWnd;
    m_d3dprm.MultiSampleType		= pDeviceInfo->MultiSampleType;
    m_d3dprm.AutoDepthStencilFormat	= pModeInfo->DepthStencilFormat;

	m_d3dprm.PresentationInterval = GetPreferablePresentationInterval(pDeviceInfo,m_d3dprm.Windowed);
	if( m_d3dprm.Windowed )
	{
		m_d3dprm.BackBufferWidth  = m_rcWindowClient.right;
		m_d3dprm.BackBufferHeight = m_rcWindowClient.bottom;
        m_d3dprm.BackBufferFormat = pAdapterInfo->d3ddmDesktop.Format;
		m_d3dprm.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;
	}else{
        m_d3dprm.BackBufferWidth  = pModeInfo->Width;
        m_d3dprm.BackBufferHeight = pModeInfo->Height;
        m_d3dprm.BackBufferFormat = pModeInfo->Format;
		m_d3dprm.FullScreen_RefreshRateInHz = pModeInfo->RefreshRate;
	}

    //@foCX̃Zbg
    if( FAILED( hr = m_lpD3DDEV->Reset( &m_d3dprm ) ) )
        return hr;

	//  After device lost system's device objects must be restored first.
	//  
	hr = RestoreSystemDeviceObjects();
	if (SUCCEEDED(hr))
		hr = RestoreDeviceObjects();

	if( FAILED(hr) )
        return hr;
	Sleep(100);
	if (m_pHighResTimer != NULL)
		m_pHighResTimer->Reset();
    return S_OK;
}

//-----------------------------------------------------------------------------
// Name: ForceFullscreen
// Desc: tXN[[h֕ύX
//-----------------------------------------------------------------------------
HRESULT	CD3DEnv::ForceFullscreen()
{
	if (m_bWindowed)
		return	ToggleFullscreen();
	return	S_OK;
}
//-----------------------------------------------------------------------------
// Name: ToggleFullScreen()
// Desc: tXN[^EChE[hؑ
//-----------------------------------------------------------------------------
HRESULT CD3DEnv::ToggleFullscreen()
{
	//	݂̃A_v^E[h̎擾
	if (m_Adapters == NULL)
		return	E_FAIL;
    D3DAdapterInfo* pAdapterInfo = &m_Adapters[m_dwAdapter];
    D3DDeviceInfo*  pDeviceInfo  = &pAdapterInfo->devices[pAdapterInfo->dwCurrentDevice];
    D3DModeInfo*    pModeInfo    = &pDeviceInfo->modes[pDeviceInfo->dwCurrentMode];

    //	EChE[hؑ֎݂̃foCXEChE[hΉ
	//	ł΃foCX؂ւB
    if( !m_bWindowed && !pDeviceInfo->bCanDoWindowed )
        return ForceWindowed();

    // EChE^tXN[[hؑ
    m_bWindowed = !m_bWindowed;
	pDeviceInfo->bWindowed = m_bWindowed;

	//	Direct3D p[^̐ݒ
    m_d3dprm.Windowed               = pDeviceInfo->bWindowed;
//    m_d3dprm.MultiSampleType        = pDeviceInfo->MultiSampleType;
//    m_d3dprm.AutoDepthStencilFormat = pModeInfo->DepthStencilFormat;
    m_d3dprm.hDeviceWindow          = m_hWnd;
#if	0
	if( m_d3dprm.Windowed )
    {
        m_d3dprm.BackBufferWidth  = m_rcWindowClient.right - m_rcWindowClient.left;
        m_d3dprm.BackBufferHeight = m_rcWindowClient.bottom - m_rcWindowClient.top;
        m_d3dprm.BackBufferFormat = pAdapterInfo->d3ddmDesktop.Format;
    }
    else
    {
        m_d3dprm.BackBufferWidth  = pModeInfo->Width;
        m_d3dprm.BackBufferHeight = pModeInfo->Height;
        m_d3dprm.BackBufferFormat = pModeInfo->Format;
    }
#endif
	//	EChETCYEX^C̒
	AdjustWindow();

    // foCX̃TCY
    if( FAILED( Resize3DEnvironment() ) )
    {
        if( m_bWindowed )
            return ForceWindowed();
        else
            return E_FAIL;
    }
	if( m_d3dprm.Windowed )
		AdjustWindow();
	if (m_pHighResTimer != NULL)
		m_pHighResTimer->Reset();
    return S_OK;
}


//-----------------------------------------------------------------------------
// Name: ForceWindowed()
// Desc: IɃEBhE[hɐ؂ւB
//		݂̃foCXŖȂ΁AfoCX؂ւB
//-----------------------------------------------------------------------------
HRESULT CD3DEnv::ForceWindowed()
{
    HRESULT hr;
 	if (m_Adapters == NULL)
		return	E_FAIL;
	D3DAdapterInfo* pAdapterInfoCur = &m_Adapters[m_dwAdapter];
    D3DDeviceInfo*  pDeviceInfoCur  = &pAdapterInfoCur->devices[pAdapterInfoCur->dwCurrentDevice];
    BOOL bFoundDevice = FALSE;

    if( pDeviceInfoCur->bWindowed )
    {
        bFoundDevice = TRUE;
    }
    else
    {
        //	EChE`\ȃfoCXTB
        D3DAdapterInfo* pAdapterInfo;
        DWORD dwAdapter;
        D3DDeviceInfo* pDeviceInfo;
        DWORD dwDevice;
        for( dwAdapter = 0; dwAdapter < m_dwNumAdapters; dwAdapter++ )
        {
            pAdapterInfo = &m_Adapters[dwAdapter];
            for( dwDevice = 0; dwDevice < pAdapterInfo->dwNumDevices; dwDevice++ )
            {
                pDeviceInfo = &pAdapterInfo->devices[dwDevice];
                if( pDeviceInfo->bWindowed )
                {
                    m_dwAdapter = dwAdapter;
                    pDeviceInfoCur = pDeviceInfo;
                    pAdapterInfo->dwCurrentDevice = dwDevice;
                    bFoundDevice = TRUE;
                    break;
                }
            }
            if( bFoundDevice )
                break;
        }
    }

    if( !bFoundDevice )
        return E_FAIL;

    pDeviceInfoCur->bWindowed = TRUE;
    m_bWindowed = TRUE;

    InvalidateDeviceObjects();
    DeleteDeviceObjects();

    InvalidateSystemDeviceObjects();
    DeleteSystemDeviceObjects();

	if( m_lpD3DDEV->Release() > 0L )
        return E_FAIL;

    if( FAILED( hr = Initialize3DEnvironment(m_hWnd) ) )
        return E_FAIL;
	if (m_pHighResTimer != NULL)
		m_pHighResTimer->Reset();
    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: AdjustWindow()
// Desc: EChE[hEtXN[[h̐؂ւׁ̈AEChE
//		X^C𒲐B
//-----------------------------------------------------------------------------
HRESULT CD3DEnv::AdjustWindow()
{
    if( m_bWindowed ){
        //	EChE[hp
        SetWindowLong( m_hWnd, GWL_STYLE, m_dwWindowStyle );
	    SetWindowPos( m_hWnd, HWND_NOTOPMOST,
                  m_rcWindowBounds.left, m_rcWindowBounds.top,
                  ( m_rcWindowBounds.right - m_rcWindowBounds.left ),
                  ( m_rcWindowBounds.bottom - m_rcWindowBounds.top ),
                  SWP_SHOWWINDOW|SWP_DRAWFRAME );
    }else{
        //	tXN[[hp
        SetWindowLong( m_hWnd, GWL_STYLE, WS_POPUP|WS_SYSMENU|WS_VISIBLE );
		HWND	hWnd;
		RECT	rcScreen;
		hWnd = ::GetDesktopWindow();
		if (::GetWindowRect(hWnd,&rcScreen)){
			SetWindowPos( m_hWnd, HWND_NOTOPMOST,
                      rcScreen.left, rcScreen.top,
                      ( rcScreen.right - rcScreen.left ),
                      ( rcScreen.bottom - rcScreen.top ),
                      SWP_SHOWWINDOW );
		}
	}
    return S_OK;
}

//-----------------------------------------------------------------------------
// Name: UserSelectNewDevice()
// Desc: 쐬
//		Q[ɕăIWĩj[ʂ
//		쐬ƗǂB
//-----------------------------------------------------------------------------
HRESULT CD3DEnv::UserSelectNewDevice()
{
    return S_OK;
}

//-----------------------------------------------------------------------------
// Name: UserAdjustWindow()
// Desc: EChETCYύXp֐
//-----------------------------------------------------------------------------
HRESULT CD3DEnv::UserAdjustWindow(){
	if (!m_bWindowed)
		return S_OK;
	::GetWindowRect(m_hWnd,&m_rcWindowBounds);
	::GetClientRect(m_hWnd,&m_rcWindowClient);
	return Resize3DEnvironment();
}

//-----------------------------------------------------------------------------
// Name: DrawFPS()
// Desc: fobOp\bhAۂ̎sxbԃt[ŕ\
//-----------------------------------------------------------------------------
void CD3DEnv::DrawFPS(float timeElapsed)
{
	if (m_pFont != NULL){
#ifdef	_DEBUG
		RECT    r;
		r.left = 10;
		r.top = 10;
		r.right = r.left + 360;
		r.bottom = r.top + 16;
		float	fFps = 0.0f;
		debugFpsBuffer[debugFpsPointer] = timeElapsed;
		debugFpsPointer = (debugFpsPointer + 1) % 8;
		TCHAR	strFps[128];
		for (int i = 0; i < 8 ; ++i){
			fFps += debugFpsBuffer[i];
		}
		fFps = 1.0f / fFps;
		fFps *= 8 * 60;
		sprintf_s(strFps,_countof(strFps),"fps:%f",fFps);
		if (m_pFont)
			m_pFont->DrawText((float)r.left,(float)r.top,D3DCOLOR_XRGB(255,255,255), strFps);
#endif
	}
}

//-----------------------------------------------------------------------------
// Name: RenderBoundingCubeForDebug()
// Desc: fobOp֐A[hWnŕ\ꂽL[u
//		V[փ_OB
//-----------------------------------------------------------------------------
//	fobOp|S̐錾
struct	CUBELVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DCOLOR	color;
};
#define	FVF_CUBELVERTEX	(D3DFVF_XYZ|D3DFVF_DIFFUSE)
void	CD3DEnv::RenderBoundingBoxForDebug(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax)
{
	D3DXVECTOR3	pVec[8];
	pVec[3].z = pVec[2].z = pVec[1].z = pVec[0].z = pMin->z;
	pVec[1].x = pVec[0].x = pMin->x;
	pVec[3].x = pVec[2].x = pMax->x;
	pVec[2].y = pVec[1].y = pMax->y;
	pVec[3].y = pVec[0].y = pMin->y;
	
	pVec[7].z = pVec[6].z = pVec[5].z = pVec[4].z = pMax->z;
	pVec[5].x = pVec[4].x = pMin->x;
	pVec[7].x = pVec[6].x = pMax->x;
	pVec[6].y = pVec[5].y = pMax->y;
	pVec[7].y = pVec[4].y = pMin->y;
	CUBELVERTEX	pVertice[5];
	pVertice[4].p = pVertice[0].p = pVec[3];
	pVertice[1].p = pVec[0];
	pVertice[2].p = pVec[1];
	pVertice[3].p = pVec[2];
	UINT	i;
	for(i = 0; i < 5 ; ++i){
		pVertice[i].color = D3DCOLOR_RGBA(255,255,255,255);
	}
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG2);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
    m_lpD3DDEV->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    m_lpD3DDEV->SetRenderState(D3DRS_LIGHTING, FALSE );

	D3DXMATRIX matIdent;
	D3DXMatrixIdentity(&matIdent);
	m_lpD3DDEV->SetTransform( D3DTS_WORLD, &matIdent );
	m_lpD3DDEV->SetFVF(FVF_CUBELVERTEX);
	m_lpD3DDEV->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
	m_lpD3DDEV->DrawPrimitiveUP(D3DPT_LINESTRIP,4,pVertice,D3DXGetFVFVertexSize(FVF_CUBELVERTEX));

	pVertice[4].p = pVertice[0].p = pVec[7];
	pVertice[1].p = pVec[4];
	pVertice[2].p = pVec[5];
	pVertice[3].p = pVec[6];
	m_lpD3DDEV->DrawPrimitiveUP(D3DPT_LINESTRIP,4,pVertice,D3DXGetFVFVertexSize(FVF_CUBELVERTEX));


	for (i = 0 ; i < 2 ; ++ i){
		for (UINT j = 0; j < 2; ++j){
			pVertice[j*2].p = pVec[j+(i*2)];
			pVertice[j*2 + 1].p = pVec[j+(i*2)+4];
			m_lpD3DDEV->DrawPrimitiveUP(D3DPT_LINELIST,2,pVertice,D3DXGetFVFVertexSize(FVF_CUBELVERTEX));
		}
	}
}

struct	TRIANGLELVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DXVECTOR3	n;	//	normal
	D3DCOLOR	color;
};
#define	FVF_TRIANGLELVERTEX	(D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_DIFFUSE)

void	CD3DEnv::RenderTriangle3D(D3DXVECTOR3 *p,D3DCOLOR c, D3DXMATRIX *pMat)
{
	TRIANGLELVERTEX	vertex[3];

	if (pMat == NULL){
		D3DXMATRIX matIdent;
		D3DXMatrixIdentity(&matIdent);
		m_lpD3DDEV->SetTransform( D3DTS_WORLD, &matIdent );
	}else{
		m_lpD3DDEV->SetTransform( D3DTS_WORLD, pMat );
	}
	D3DXVECTOR3	vecNormal, vec1, vec2;
	vec1 = p[1] - p[0];
	vec2 = p[2] - p[0];
	D3DXVec3Cross(&vecNormal,&vec1,&vec2);
	D3DXVec3Normalize(&vecNormal, &vecNormal);
	for (int i = 0; i < 3 ; ++i){
		vertex[i].p = p[i];
		vertex[i].n = vecNormal;
		vertex[i].color = c;
	}
	m_lpD3DDEV->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG2);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
	m_lpD3DDEV->SetFVF(FVF_TRIANGLELVERTEX);
	m_lpD3DDEV->DrawPrimitiveUP(D3DPT_TRIANGLELIST,1,vertex,D3DXGetFVFVertexSize(FVF_TRIANGLELVERTEX));
}

void	CD3DEnv::RenderQuadrilateral3D(D3DXVECTOR3 *p,D3DCOLOR c, D3DXMATRIX *pMat)
{
	TRIANGLELVERTEX	vertex[4];

	if (pMat == NULL){
		D3DXMATRIX matIdent;
		D3DXMatrixIdentity(&matIdent);
		m_lpD3DDEV->SetTransform( D3DTS_WORLD, &matIdent );
	}else{
		m_lpD3DDEV->SetTransform( D3DTS_WORLD, pMat );
	}
	D3DXVECTOR3	vecNormal, vec1, vec2;
	vec1 = p[1] - p[0];
	vec2 = p[2] - p[0];
	D3DXVec3Cross(&vecNormal,&vec1,&vec2);
	D3DXVec3Normalize(&vecNormal, &vecNormal);
	for (int i = 0; i < 4 ; ++i){
		vertex[i].p = p[i];
		vertex[i].n = vecNormal;
		vertex[i].color = c;
	}
	m_lpD3DDEV->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG2);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
	m_lpD3DDEV->SetFVF(FVF_TRIANGLELVERTEX);
	m_lpD3DDEV->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,2,vertex,D3DXGetFVFVertexSize(FVF_TRIANGLELVERTEX));
}

void	CD3DEnv::RenderLine3D(D3DXVECTOR3 *p,D3DCOLOR c, D3DXMATRIX *pMat)
{
	CUBELVERTEX	vertex[2];

	if (pMat == NULL){
		D3DXMATRIX matIdent;
		D3DXMatrixIdentity(&matIdent);
		m_lpD3DDEV->SetTransform( D3DTS_WORLD, &matIdent );
	}else{
		m_lpD3DDEV->SetTransform( D3DTS_WORLD, pMat );
	}
	for (int i = 0; i < 2 ; ++i){
		vertex[i].p = p[i];
		vertex[i].color = c;
	}
	m_lpD3DDEV->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG2);
    m_lpD3DDEV->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
	m_lpD3DDEV->SetFVF(FVF_CUBELVERTEX);
	m_lpD3DDEV->DrawPrimitiveUP(D3DPT_LINELIST,1,vertex,D3DXGetFVFVertexSize(FVF_CUBELVERTEX));
}
/*
 *		ch֘A
 */
BOOL CALLBACK	EnumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance, VOID* pContext );
BOOL CALLBACK	EnumObjectsCallback( const DIDEVICEOBJECTINSTANCE* pdidoi, VOID* pContext );
//-----------------------------------------------------------------------------
// Name: InitDI()
// Desc: DirectInput8 ̏B
//-----------------------------------------------------------------------------
HRESULT CD3DEnv::InitDI(HWND hWnd)
{
	HRESULT	hr;
	m_pKeys = new BYTE[256];
	ZeroMemory(m_pKeys,256);
	hr = DirectInput8Create((HINSTANCE)GetWindowLong(hWnd,GWL_HINSTANCE),
			DIRECTINPUT_VERSION,
			IID_IDirectInput8,
			(void**)&m_lpDI,
			NULL);
	if (FAILED(hr)){
		m_lpDI=NULL;
		return	hr;
	}
	hr = m_lpDI->CreateDevice(GUID_SysKeyboard,&m_pKeyboard,NULL);
	if (FAILED(hr)){
		m_pKeyboard=NULL;
		return	hr;
	}
	hr = m_pKeyboard->SetCooperativeLevel(hWnd,DISCL_FOREGROUND|DISCL_NONEXCLUSIVE);
	if (FAILED(hr)){
		return	hr;
	}
	hr = m_pKeyboard->SetDataFormat(&c_dfDIKeyboard);
	if (FAILED(hr)){
		return	hr;
	}
	hr = m_pKeyboard->Acquire();
	if (FAILED(hr)){
		if (hr != DIERR_OTHERAPPHASPRIO)
			return	hr;
	}

	if( FAILED( hr = m_lpDI->EnumDevices( DI8DEVCLASS_GAMECTRL, 
                                         ::EnumJoysticksCallback,
                                         (VOID*)this, DIEDFL_ATTACHEDONLY ) ) )
        return hr;

	if (m_pJoystick==NULL){
		return	S_OK;
	}

	if( FAILED( hr = m_pJoystick->SetDataFormat( &c_dfDIJoystick2 ) ) )
		return hr;

	if( FAILED( hr = m_pJoystick->SetCooperativeLevel( hWnd, DISCL_EXCLUSIVE | 
																DISCL_FOREGROUND ) ) )
       return hr;

	//	ł݊m
	m_dwJoystickDeadzone = 2500;
	m_lJoystickXMin = -1000;
	m_lJoystickXMin = 0;
	m_lJoystickXMax = 1000;
	m_lJoystickYMin = -1000;
	m_lJoystickYMin = 0;
	m_lJoystickYMax = 1000;
	m_dwNumButtonsOnJoystick = 0;

	int i=0;
	m_pJoyToKeyMap[i++] = DIK_SPACE;
	while (i < D3DQUICKLIB_MAX_NUM_JOYBUTTON){
		m_pJoyToKeyMap[i++] = 0;
	}

	if( FAILED( hr = m_pJoystick->EnumObjects( ::EnumObjectsCallback, 
                                                (VOID*)this, DIDFT_ALL ) ) )
        return hr;
	if (m_dwNumButtonsOnJoystick == 0)
		m_dwNumButtonsOnJoystick = 1;
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name: ReleaseDI()
// Desc: DirectInput8 ̏IB
//-----------------------------------------------------------------------------
void	CD3DEnv::ReleaseDI()
{
	SAFE_DELETE_ARRAY(m_pKeys);
	if (m_pJoystick){
		m_pJoystick->Unacquire();
		m_pJoystick->Release();
		m_pJoystick = NULL;
	}
	if (m_pKeyboard){
		m_pKeyboard->Unacquire();
		m_pKeyboard->Release();
		m_pKeyboard = NULL;
	}
	if (m_lpDI){
		m_lpDI->Release();
		m_lpDI = NULL;
	}
}

//-----------------------------------------------------------------------------
// Name: SetJoyButtonToKeyMap
// Desc: WCXeBbÑ{^L[ɃATC
//-----------------------------------------------------------------------------
void	CD3DEnv::SetJoyButtonToKeyMap(int bno,BYTE key){
	if (bno < 0)
		return;
	if (bno >= D3DQUICKLIB_MAX_NUM_JOYBUTTON)
		return;
	m_pJoyToKeyMap[bno] = key;
}
//-----------------------------------------------------------------------------
// Name: DoIO()
// Desc: L[͏B
//-----------------------------------------------------------------------------
void	CD3DEnv::DoIO()
{
	BOOL	notyet = true;
	HRESULT	hr;
	if (m_pKeys){
		do{
			hr = m_pKeyboard->GetDeviceState(256,m_pKeys);
			if (FAILED(hr)){
				if ((hr == DIERR_INPUTLOST)||(hr == DIERR_NOTACQUIRED)){
					hr = m_pKeyboard->Acquire();
					if (FAILED(hr))
						goto DoJoystick;	//	͂Ƃ肠߂B
				}else
					goto DoJoystick;		//	
			}else
				notyet = false;
		}while(notyet);
	}
DoJoystick:
	if (m_pJoystick){
		hr = m_pJoystick->Poll();
		if( FAILED(hr) )  
		{
			hr = m_pJoystick->Acquire();
			while( hr == DIERR_INPUTLOST ) 
				hr = m_pJoystick->Acquire();
			return;
		}

		//
		//	WCXeBbN̓ǂݏoB
		//
		DIJOYSTATE2 js;          // DInput joystick state 
		if( FAILED( hr = m_pJoystick->GetDeviceState( sizeof(DIJOYSTATE2), &js ) ) )
			return;

		//	WCXeBbÑf[^߁B
		//	ʂ͂܂łȂėǂA
		//	ł邩݊ƂB
		if (js.lX >= (m_lJoystickXCtr+m_lJoystickXThreshold)){
			m_pKeys[DIK_RIGHT] = 0xff;
		}
		if (js.lX <= (m_lJoystickXCtr-m_lJoystickXThreshold)){
			m_pKeys[DIK_LEFT] = 0xff;
		}
		if (js.lY >= (m_lJoystickYCtr+m_lJoystickYThreshold)){
			m_pKeys[DIK_DOWN] = 0xff;
		}
		if (js.lY <= (m_lJoystickYCtr-m_lJoystickYThreshold)){
			m_pKeys[DIK_UP] = 0xff;
		}
		int i;
		for (i = 0; i < (int)m_dwNumButtonsOnJoystick ; ++i){
			if (js.rgbButtons[i]&0x80)
				m_pKeys[m_pJoyToKeyMap[i]] = 0xff;
		}

		m_lJoyX = js.lX;
		m_lJoyY = js.lY;
	}

	return;
}

//-----------------------------------------------------------------------------
// Name: GetDI8KeyState()
// Desc: DirectInput ɂē͂ꂽL[Ԃ擾B
//-----------------------------------------------------------------------------
BOOL	CD3DEnv::GetDI8KeyState(int key){
	if (m_pKeys == NULL)
		return	false;
	return	0!=m_pKeys[key];
}

//-----------------------------------------------------------------------------
// Name: EnumJoysticksCallback()
// Desc: VXeɐڑꂽWCXeBbNɁAĂяoB
//-----------------------------------------------------------------------------
BOOL CALLBACK	EnumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance, VOID* pContext ){
	CD3DEnv	*ref = (CD3DEnv*)pContext;
	return	ref->EnumJoysticksCallback(pdidInstance,NULL);
}

//-----------------------------------------------------------------------------
// Name: EnumObjectsCallback()
// Desc: Joystick ɃCXg[ꂽRg[mFׂ́A
//		R[obN֐
//-----------------------------------------------------------------------------
BOOL CALLBACK	EnumObjectsCallback( const DIDEVICEOBJECTINSTANCE* pdidoi, VOID* pContext ){
	CD3DEnv	*ref = (CD3DEnv*)pContext;
	return	ref->EnumObjectsCallback(pdidoi,NULL);
}

//-----------------------------------------------------------------------------
// Name: EnumJoysticksCallback()
// Desc: VXeɐڑꂽWCXeBbNɁAĂяoB
//-----------------------------------------------------------------------------
BOOL CALLBACK CD3DEnv::EnumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance,
                                     VOID* pContext )
{
    HRESULT hr;
	//	nꂽWCXeBbNɑ΂āAC^[tFCX擾B

    hr = m_lpDI->CreateDevice( pdidInstance->guidInstance, &m_pJoystick, NULL );

	//	sȂÃWCXeBbN͎gpłȂB
    if( FAILED(hr) ) 
        return DIENUM_CONTINUE;


    return DIENUM_STOP;	//	WCXeBbN͈łnj
}

//-----------------------------------------------------------------------------
// Name: EnumObjectsCallback()
// Desc: Joystick ɃCXg[ꂽRg[mFׂ́A
//		R[obN֐
//-----------------------------------------------------------------------------
BOOL CALLBACK CD3DEnv::EnumObjectsCallback( const DIDEVICEOBJECTINSTANCE* pdidoi,
                                   VOID* pContext )
{
    HWND hDlg = (HWND)pContext;
    if( pdidoi->dwType & DIDFT_AXIS )
    {
		HRESULT hr;
		long threshold;
        DIPROPRANGE diprg; 
        diprg.diph.dwSize       = sizeof(DIPROPRANGE); 
        diprg.diph.dwHeaderSize = sizeof(DIPROPHEADER); 
        diprg.diph.dwHow        = DIPH_BYID; 
        diprg.diph.dwObj        = pdidoi->dwType; // Specify the enumerated axis
        diprg.lMin              = -1000; 
        diprg.lMax              = +1000; 
    
        m_pJoystick->SetProperty( DIPROP_RANGE, &diprg.diph );	//	vpeB[ǂݏopȂ玸sB

		DIPROPDWORD dipdw;
		dipdw.diph.dwSize       = sizeof(DIPROPDWORD);
		dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
        diprg.diph.dwHow        = DIPH_BYID; 
        diprg.diph.dwObj        = pdidoi->dwType; // Specify the enumerated axis
		hr = m_pJoystick->GetProperty( DIPROP_DEADZONE, &dipdw.diph );
		if ((SUCCEEDED(hr))&&(dipdw.dwData > m_dwJoystickDeadzone)){
			m_dwJoystickDeadzone = dipdw.dwData;
		}
		m_pJoystick->GetProperty( DIPROP_RANGE, &diprg.diph );
		if (pdidoi->guidType == GUID_XAxis){
			m_lJoystickXMin = diprg.lMin;
			m_lJoystickXCtr = (diprg.lMax+diprg.lMin) >> 1;
			m_lJoystickXMax = diprg.lMax;
			threshold = m_lJoystickXMax - m_lJoystickXCtr;
			threshold = (threshold * (long)m_dwJoystickDeadzone) / 10000;
			threshold = (m_lJoystickXMax - m_lJoystickXCtr + threshold) / 2;
			m_lJoystickXThreshold = threshold;
		}
		if (pdidoi->guidType == GUID_YAxis){
			m_lJoystickYMin = diprg.lMin;
			m_lJoystickYCtr = (diprg.lMax+diprg.lMin) >> 1;
			m_lJoystickYMax = diprg.lMax;
			long threshold;
			threshold = m_lJoystickYMax - m_lJoystickYCtr;
			threshold = (threshold * (long)m_dwJoystickDeadzone) / 10000;
			threshold = (m_lJoystickYMax - m_lJoystickYCtr + threshold) / 2;
			m_lJoystickYThreshold = threshold;
		}
	}else if (pdidoi->dwType & DIDFT_BUTTON){
		m_dwNumButtonsOnJoystick++;	
	}

    return DIENUM_CONTINUE;
}

//-----------------------------------------------------------------------------
// Name: TextureDBRegisterNewKey()
// Desc: eNX`f[^x[XɐVeNX`ǉ
//-----------------------------------------------------------------------------
BOOL	CD3DEnv::TextureDBRegisterNewKey(LPSTR key,CTextureNode **pRet){
	return	m_pTextureDB->RegisterNewKey(key,pRet);
}


DWORD CD3DEnv::SelectMode(D3DModeInfo *modes, DWORD numModes){
	DWORD	dwCurrent = 0;
	// 𑜓x 640x480 ̃[hlƂB
	//(sNZtH[}bg16rbgt[[g60̃[hD悷)
	for(DWORD m=0L; m<numModes; m++ ){
		if( modes[m].Width==640 && modes[m].Height==480 )
		{
			dwCurrent = m;
			if( modes[m].Format == D3DFMT_R5G6B5 ||
				modes[m].Format == D3DFMT_X1R5G5B5 ||
				modes[m].Format == D3DFMT_A1R5G5B5 )
			{
				if (modes[m].RefreshRate == PREFERABLE_REFRESH_RATE){
					break;
				}
			}
		}
	}
	return	dwCurrent;
}

//-----------------------------------------------------------------------------
// Name: AddGraphicsObject()
// Desc: eNX`f[^x[XɐVeNX`ǉ
//-----------------------------------------------------------------------------
void	CD3DEnv::AddGraphicsObject(CGraphicsObject *pObj){
	//  rJn	
	EnterLoadingSection();

	pObj->m_pNext = m_pGraphicsObjects;
	pObj->m_pPrev = m_pGraphicsObjects->m_pPrev;
	m_pGraphicsObjects->m_pPrev->m_pNext = pObj;
	m_pGraphicsObjects->m_pPrev = pObj;

	//  rI
	LeaveLoadingSection();
}

//-----------------------------------------------------------------------------
// Name: RemoveGraphicsObject()
// Desc: eNX`f[^x[XɐVeNX`ǉ
//-----------------------------------------------------------------------------
void	CD3DEnv::RemoveGraphicsObject(CGraphicsObject *pObj){

	//  rJn	
	EnterLoadingSection();

	if (pObj != m_pGraphicsObjects){
		pObj->m_pPrev->m_pNext = pObj->m_pNext;
		pObj->m_pNext->m_pPrev = pObj->m_pPrev;
	}

	//  rI
	LeaveLoadingSection();
}

//-------------------------------------------------------------
//	Name: PrepareAppPathName
//  Desc: R}hC擾ANpXۑ
//-------------------------------------------------------------
void	CD3DEnv::PrepareAppPathName()
{
	int l,i;
	int	len;

	TCHAR *str,*c;
	SAFE_DELETE(m_strAppPath);
	len = _tcslen(::GetCommandLine()) + 1;
	m_strAppPath = new TCHAR[len];
	str = m_strAppPath;

	lstrcpy( str, ::GetCommandLine());  // NAvP[V̐΃pX擾B 
	l = (int)strlen(str);
	if (str[0]=='\"'){
		for(i = 0; i < l; ++i){
			str[i] = str[i+1];
		}
		--l;
	}  // " Ŏn܂ĂAꕶ߂B 
	c = strrchr(str,'\\');
	if (c){
		*c=0;
	}else{ 
		m_strAppPath[0]=0;
	}
	if (m_strAppPath != NULL && m_strAppPath[0] != _T('\0')){
		CFilenameDecoder *dec = new CFilenameDecoder(m_strAppPath);
		SAFE_DELETE(m_strAppPath);
		DWORD	dwLength = 0;
		dec->GetFullname(&dwLength,NULL);
		m_strAppPath = new TCHAR[dwLength];
		dec->GetFullname(&dwLength,m_strAppPath);
		delete dec;
	}
}

//-------------------------------------------------------------
//	Name: GetAppPathName
//  Desc: NpXԂ
//-------------------------------------------------------------
TCHAR	*CD3DEnv::GetAppPathName()
{
	return	m_strAppPath;
}

//-------------------------------------------------------------
//	Name: GetFileName
//  Desc: ΃pXł΁ApXt̃t@C̃pX菜
//		t@Ĉ݂ɂB
//-------------------------------------------------------------
void CD3DEnv::GetFileName(TCHAR *str,TCHAR *filepath)
{
    int     l,i;
    TCHAR    *c;
	l = (int)_tcslen(str);
	//	Õ_uNH[e[V폜
	if ((str[0]=='\"')&&(str[l-1]=='\"')){
		for(i = 0; i < (l - 1) ; ++i){
			str[i] = str[i+1];
		}
		--l;
		str[l] = 0;
	}else
		++l;
	//	t@Ct̃pXo
	if (filepath != NULL){
		_tcscpy_s(filepath,l,str);
		c = _tcsrchr(filepath,'\\');
		if (c){
			*c='\0';
		}else{
			filepath[0] = '\0';
		}
		//	
		l = _tcslen(filepath);
		if (l > 3){
			if (filepath[1] == ':'){
				filepath[0] = '\0';
			}
		}
	}

	//	
	c = _tcsrchr(str,'\\');
	if (c){
		c++;
		i = 0;
		while('\0' != (str[i++] = *c++));
	}
}

#include "shaderdata.c"
//-------------------------------------------------------------
//	Name: InitSystemShaders
//	Desc: VXe̊ǗɂVF[_擾B
//-------------------------------------------------------------
void	CD3DEnv::InitSystemShaders()
{
	//	r
	EnterLoadingSection();

	//  VXeVF[_́AVXeǗɂ悤ɂB
	CGraphicsObject	*pSave = m_pGraphicsObjects;
	m_pGraphicsObjects = m_pSystemGraphicsObjects;

	m_pSkinnedMeshVS1 = new CVertexShaderFromMemory(this,skinmesh1_vsh,sizeof(skinmesh1_vsh),__uuidof(CLSID_SkinnedMeshVS1));
	m_pSkinnedMeshVS2 = new CVertexShaderFromMemory(this,skinmesh2_vsh,sizeof(skinmesh2_vsh),__uuidof(CLSID_SkinnedMeshVS2));
	m_pSkinnedMeshVS3 = new CVertexShaderFromMemory(this,skinmesh3_vsh,sizeof(skinmesh3_vsh),__uuidof(CLSID_SkinnedMeshVS3));
	m_pSkinnedMeshVS4 = new CVertexShaderFromMemory(this,skinmesh4_vsh,sizeof(skinmesh4_vsh),__uuidof(CLSID_SkinnedMeshVS4));
	m_pUVScrollMeshVS = new CVertexShaderFromMemory(this,uvscroll_vsh,sizeof(uvscroll_vsh),__uuidof(CLSID_ScrollMeshVS));

	m_pGraphicsObjects = pSave;

	//	rI
	LeaveLoadingSection();
}
//-------------------------------------------------------------
//	Name: ReleaseSystemShaders
//	Desc: VXe̊ǗɂVF[_擾B
//-------------------------------------------------------------
void	CD3DEnv::ReleaseSystemShaders(){
	//  r
	EnterLoadingSection();

	SAFE_RELEASE(m_pSkinnedMeshVS1);
	SAFE_RELEASE(m_pSkinnedMeshVS2);
	SAFE_RELEASE(m_pSkinnedMeshVS3);
	SAFE_RELEASE(m_pSkinnedMeshVS4);
	SAFE_RELEASE(m_pUVScrollMeshVS);

	//	rI
	LeaveLoadingSection();
}


//-------------------------------------------------------------
//	Name: GetShaderContainer
//	Desc: VXe̊ǗɂVF[_擾B
//-------------------------------------------------------------
CShaderContainer *CD3DEnv::GetShaderContainer(GUID guid){
	return	(CShaderContainer*)m_pContainerDB->GetContainer(guid);
}

//-------------------------------------------------------------
//	Name: GetContainer
//	Desc: VXe̊ǗɂReiipobt@j擾B
//-------------------------------------------------------------
CContainer *CD3DEnv::GetContainer(GUID guid){
	return	m_pContainerDB->GetContainer(guid);
}

//-------------------------------------------------------------
//	Name: GetNumMaxOTFaces
//	Desc: v~eBũI[_Oe[u̐Ԃ
//-------------------------------------------------------------
DWORD	CD3DEnv::GetNumMaxOTFaces(){
	return	m_dwMaxOTFaces;
}

//-------------------------------------------------------------
//	Name: ResizeOT
//	Desc: v~eBũI[_Oe[ũTCYύX
//-------------------------------------------------------------
HRESULT CD3DEnv::ResizeOT(DWORD num){
	RequireOT(num);
	return	S_OK;
}

//-------------------------------------------------------------
//	Name: ResizeOT
//	Desc: v~eBũI[_Oe[ũTCYύX
//-------------------------------------------------------------
HRESULT CD3DEnv::RequireOT(DWORD num){
	//  rJn
	EnterLoadingSection();

	if (num > m_dwMaxOTFaces){
		RequireSharedRenderingBuffer(num*sizeof(OrderingTable));
		m_dwMaxOTFaces = num;
	}
	//	rI
	LeaveLoadingSection();
	return	S_OK;
}

OrderingTable *CD3DEnv::GetOT(){
	return	(OrderingTable*)m_pSharedRenderingBuffer;
}

HRESULT	CD3DEnv::RequireSharedRenderingBuffer(DWORD size){
	//  rJn
	EnterLoadingSection();

	if (size > m_dwSharedRenderingBufferSize){
		SAFE_DELETE_ARRAY(m_pSharedRenderingBuffer);
		m_pSharedRenderingBuffer = new BYTE[size];
		m_dwSharedRenderingBufferSize = size;
	}

	//	rI
	LeaveLoadingSection();
	return	S_OK;
}
DWORD	CD3DEnv::GetSharedRenderingBufferSize(){
	return	m_dwSharedRenderingBufferSize;
}
BYTE	*CD3DEnv::GetSharedRenderingBuffer(){
	return	m_pSharedRenderingBuffer;
}
//------------------------------------------
// class: CGraphicsObject
// Desc: Generic link list node class
//------------------------------------------
CGraphicsObject::CGraphicsObject(){
}
CGraphicsObject::~CGraphicsObject(){
}

//-----------------------------------------------------------------------------
// class: CGraphicsObject
// Name: InitDeviceObjects()
// Desc: _~[m[hp̃_~[\bhiĂяo鎖͖j
//-----------------------------------------------------------------------------
HRESULT	CGraphicsObject::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{	
	return	S_OK;	
}
//-----------------------------------------------------------------------------
// class: CGraphicsObject
// Name: RestoreDeviceObjects()
// Desc: _~[m[hp̃_~[\bhiĂяo鎖͖j
//-----------------------------------------------------------------------------
HRESULT	CGraphicsObject::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	return	S_OK;
}

//-----------------------------------------------------------------------------
// class: CGraphicsObject
// Name: InvalidateDeviceObjects()
// Desc: _~[m[hp̃_~[\bhiĂяo鎖͖j
//-----------------------------------------------------------------------------
HRESULT	CGraphicsObject::InvalidateDeviceObjects()
{
	return	S_OK;
}
//-----------------------------------------------------------------------------
// class: CGraphicsObject
// Name: DeleteDeviceObjects()
// Desc: _~[m[hp̃_~[\bhiĂяo鎖͖j
//-----------------------------------------------------------------------------
HRESULT	CGraphicsObject::DeleteDeviceObjects()
{
	return	S_OK;
}

//----------------------------------------------------------
// class: CD3DEnv
// Name:  GetElapsedTime()
// Desc:  Ot[Ă̌oߎԂ擾
//----------------------------------------------------------
FLOAT CD3DEnv::GetElapsedTime(){
	return m_pHighResTimer->GetElapsedTime();
}

//----------------------------------------------------------
// class: CD3DEnv
// Name:  ResetTimer()
// Desc:  oߎԃ^C}[̏
//----------------------------------------------------------
void CD3DEnv::ResetTimer(){
	m_pHighResTimer->Reset();
}