/*
 *	class CWall
 *		n`̎NXiǁj
 *
 *		First edition: February.19.2004
 *
 */
#include "stdafx.h"

#include <tchar.h>
#include <d3dx9.h>
#include "Wall.h"

//-------------------------------------------------------------
//	Name: CWall
//  Desc: RXgN^
//-------------------------------------------------------------
CWall::CWall(CD3DEnv *pEnv, TCHAR *fname) : CMesh(pEnv, fname)
{
	D3DXMatrixIdentity(&m_matWorld);
	m_pCollisionInfo = new COLLISIONINFO[10];
	m_dwSizeCollisionInfo = 10;
	m_dwNumCollisionInfo = 0;
}

CWall::~CWall()
{
	SAFE_DELETE(m_pCollisionInfo);
}


//-------------------------------------------------------------
//	Name: SetWorldMatrix
//  Desc: t[
//-------------------------------------------------------------
void	CWall::SetWorldMatrix(D3DXMATRIX *pMat)
{
	m_matWorld = *pMat;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void	CWall::Render(LPDIRECT3DDEVICE9 lpd3ddev)
{
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );

	lpd3ddev->SetTransform( D3DTS_WORLD, &m_matWorld );
	CMesh::Render(lpd3ddev);
#if	0
	//	fobOpɃoE_{bNX\B
	D3DXVECTOR3	vecMin, vecMax;
	GetBoundingBox(&vecMin,&vecMax);
	RenderBoundingBoxForDebug(&vecMin,&vecMax);
#endif
}

//-------------------------------------------------------------
//	Name: GetBoundingSphere
//  Desc: 蔻ׂ̈̋񋟂
//	Return: float a, D3DXVECTOR3 S
//-------------------------------------------------------------
float	CWall::GetBoundingSphere(D3DXVECTOR3 *pVec)
{
	//	bV̒S_擾
	CMesh::GetObjectCenter(pVec);

	//	[hW֕ϊ
	D3DXVec3TransformCoord(pVec, pVec, &m_matWorld);

	//	aԂ
	return	GetRadius();
}

//-------------------------------------------------------------
//	Name: GetBoundingBox
//  Desc: 蔻ׂ̈̃oE_{bNX񋟂
//		oE_{bNX́A[hWŕ\B
//-------------------------------------------------------------
void	CWall::GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax)
{
	D3DXVECTOR3	pVec[8];
	D3DXVECTOR3	vecMin, vecMax;
	UINT	i;
	CMesh::GetBoundingBox(&vecMin, &vecMax);

	pVec[3].z = pVec[2].z = pVec[1].z = pVec[0].z = vecMin.z;
	pVec[1].x = pVec[0].x = vecMin.x;
	pVec[3].x = pVec[2].x = vecMax.x;
	pVec[2].y = pVec[1].y = vecMax.y;
	pVec[3].y = pVec[0].y = vecMin.y;

	pVec[7].z = pVec[6].z = pVec[5].z = pVec[4].z = vecMax.z;
	pVec[5].x = pVec[4].x = vecMin.x;
	pVec[7].x = pVec[6].x = vecMax.x;
	pVec[6].y = pVec[5].y = vecMax.y;
	pVec[7].y = pVec[4].y = vecMin.y;

	//	[hW֕ϊ
	for (i = 0; i < 8 ; ++i){
		D3DXVec3TransformCoord(&pVec[i], &pVec[i], &m_matWorld);
	}
	vecMin.x = vecMin.y = vecMin.z = FLT_MAX;
	vecMax.x = vecMax.y = vecMax.z = -FLT_MAX;
	for (i = 0; i < 8 ; ++i){
		if (vecMin.x > pVec[i].x){
			vecMin.x = pVec[i].x;
		}
		if (vecMin.y > pVec[i].y){
			vecMin.y = pVec[i].y;
		}
		if (vecMin.z > pVec[i].z){
			vecMin.z = pVec[i].z;
		}
		if (vecMax.x < pVec[i].x){
			vecMax.x = pVec[i].x;
		}
		if (vecMax.y < pVec[i].y){
			vecMax.y = pVec[i].y;
		}
		if (vecMax.z < pVec[i].z){
			vecMax.z = pVec[i].z;
		}
	}
	*pMin = vecMin;
	*pMax = vecMax;
}
//-------------------------------------------------------------
//	Name: ProbeTheWallSinkDepth
//  Desc: w肳ꂽ̕ǖʂւ̂߂荞ݗʂƁA
//		߂荞ݒn_̖@xNgԂB
//		͈͂́Aw肳ꂽ͂ރ{bNX͈͓̔ɌB
//		LN^[̓ɊւĂ͍lȂ
//
//	̃|SƐڐGꍇɁẢeāA
//	z̈ꖇ̕ǂz肷o[WB
//	񖇂̃|SspȂƃ}YCB
//-------------------------------------------------------------
BOOL CWall::ProbeTheWallSinkDepth(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal,FLOAT *pDepth)
{
	pVecNormal->x = 0;
	pVecNormal->y = 0;
	pVecNormal->z = 0;
	return ProbeTheWallSinkDepthBase(pVec,fRadius,pVecNormal,pDepth);
}

//-------------------------------------------------------------
//	Name: ProbeTheWallSinkDepthWithMotion
//  Desc: w肳ꂽ̕ǖʂւ̂߂荞ݗʂƁA
//		߂荞ݒn_̖@xNgԂB
//		͈͂́Aw肳ꂽ͂ރ{bNX͈͓̔ɌB
//		iKȂjpVecNormal Ɋi[ČĂяo
//		
//@LN^[̓ɖ߂ʂ␳
//	LN^[ĂȂ͓蔻肵Ȃ_ɂ
//-------------------------------------------------------------
BOOL CWall::ProbeTheWallSinkDepthWithMotion(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal,FLOAT *pDepth)
{
	FLOAT	dx = pVecNormal->x;
	FLOAT	dy = pVecNormal->y;
	FLOAT	dz = pVecNormal->z;
	if ((dx*dx + dy*dy + dz*dz) == 0)
		return	false;
	return ProbeTheWallSinkDepthBase(pVec,fRadius,pVecNormal,pDepth);
}

//-------------------------------------------------------------
//	Name: CreateCollisionInfo
//	Desc: n`Ƃ̂蔻sʂA
//		m_pCollisionInfo Ɋi[B
//		ċAEēs
//	Param:	pVec    v[üʒu
//			fRadius v[u̔a
//-------------------------------------------------------------
int CWall::CreateCollisionInfo16(D3DXVECTOR3 *pVec, FLOAT fRadius){
	int	num = 0;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	DWORD	numFaces;
	DWORD	dwStride,dwMeshFVF;
	FLOAT	fDist;

	numFaces = GetNumFaces();
	dwMeshFVF = GetFVF();
	dwStride = D3DXGetFVFVertexSize(dwMeshFVF);

	//	EGCgt_ɂ͑ΉĂȂEEEEAGɂȂ̂邽߁B
	if (dwMeshFVF & ((~D3DFVF_XYZ)&(D3DFVF_XYZB1|D3DFVF_XYZB2|D3DFVF_XYZB3|D3DFVF_XYZB4|D3DFVF_XYZB5)))
		return 0;

	m_dwNumCollisionInfo = 0;
	//m_vecDirMin= D3DXVECTOR3(FLT_MAX,FLT_MAX,FLT_MAX);
	//m_vecDirMax= D3DXVECTOR3(-FLT_MAX,-FLT_MAX,-FLT_MAX);
	GetVertexBuffer(&pVB);
	GetIndexBuffer(&pIB);

	WORD	*pIx;
	BYTE	*pVertex;
	int		iIndex;
	D3DXVECTOR3	vecMin, vecMax, vecBoxMin, vecBoxMax;
	D3DXVECTOR3	vecTmp, vec3Tmp;
	D3DXVECTOR3	vecNormalTmp;

	vecBoxMin = *pVec - D3DXVECTOR3(fRadius,fRadius,fRadius);
	vecBoxMax = *pVec + D3DXVECTOR3(fRadius,fRadius,fRadius);

	WALLCOLLISIONVERTEX	vecVertice[3];

	pIB->Lock(0,0,(VOID**)&pIx, 0);
	pVB->Lock(0,0,(VOID**)&pVertex, 0);

	UINT	i,j;
	for(i = 0; i < numFaces; ++i){
		for (j = 0; j < 3 ; ++j){
			iIndex = (int)*pIx++;
			vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + (iIndex*dwStride));
			vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + (iIndex*dwStride));
			D3DXVec3TransformCoord(&vecVertice[j].p,&vecVertice[j].p,&m_matWorld);
		}
		//	|Sƃv[u̐ڐG\AABBňꎟ肷
#if	0
		//	ǂ݂₷ق
		CalcPolygonBoundingBox((D3DXVECTOR3*)vecVertice,sizeof(WALLCOLLISIONVERTEX),&vecMin, &vecMax);
		if (!Collide2Box(&vecMin,&vecMax,&vecBoxMin,&vecBoxMax)){
			continue;	//	qbg\Ύ̃|S
		}
#else
		//	葁ق
		BOOL	bHit = TRUE;
		static const BOOL	bFalse = FALSE;	//	AZuŎgp
		static const DWORD	dwPitch = sizeof(WALLCOLLISIONVERTEX);	//	AZuŎgp
		__asm{
			lea	esi, vecVertice;
			lea edi, vecMin;
			lea ebx, vecMax;
				
			mov	eax, dword ptr [esi];
			mov	dword ptr [edi], eax;		/*	pMin->x = pVertices[0].p.x;	*/
			mov	dword ptr [ebx], eax;		/*	pMax->x = pVertices[0].p.x;	*/
			mov	eax, dword ptr [esi+4];
			mov	dword ptr [edi+4], eax;		/*	pMin->y = pVertices[0].p.y;	*/
			mov	dword ptr [ebx+4], eax;		/*	pMax->y = pVertices[0].p.y;	*/
			mov	eax, dword ptr [esi+8];
			mov	dword ptr [edi+8], eax;		/*	pMin->z = pVertices[0].p.z;	*/
			mov	dword ptr [ebx+8], eax;		/*	pMax->z = pVertices[0].p.z;	*/
			add	esi, dwPitch;				/*	pVertices++	*/
			/*if (vecMin.x > pTri[1].p.x)	vecMin.x = pTri[1].p.x;*/
			fld		float ptr [esi];		/*	st(1) = pTri[1].p.x*/
			fld		float ptr [edi];		/*	st(0) = pMin->x;*/
			fcomi	st,st(1);				
			fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[1].p.x then st(0):=st(1)*/
			fstp	float ptr [edi];		/*	pMin->x = st(0)*/
			/*if (pMax->x < pTri[1].p.x)	pMax->x = pTri[1].p.x;*/
			fld		float ptr [ebx];		/* st(0) = pMax->x;*/
			fcomi	st,st(1);				/*	*/
			fcmovb	st(0),st(1);			/*	pMax->x < pTri[1].p.x then st(0):=st(1)*/
			fstp	float ptr [ebx];		/*	*/
			fstp	st(0)					/*	*/
			/*if (pMin->y > pTri[1].p.y)	pMin->y = pTri[1].p.y;*/
			fld		[esi+4];				/* st(1) = pTri[1].p.y*/
			fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
			fcomi	st,st(1);				/*	if (pMin->y > pTri[1].p.y) st(0) = pTri[1].p.y;*/
			fcmovnbe	st(0),st(1);
			fstp	float ptr [edi+4];
			/*if (pMax->y < pTri[1].p.y)	pMax->y = pTri[1].p.y;*/
			fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
			fcomi	st,st(1);				/**/
			fcmovb	st(0),st(1);			/*	if pMax->y < pTri[1].p.y st(0) = pTri[1].p.y*/
			fstp	float ptr [ebx+4];
			fstp	st(0)
			/*if (pMin->z > pTri[1].p.z)	pMin->z = pTri[1].p.z;*/
			fld		float ptr [esi+8];		/* st(1) = pTri[1].p.z*/
			fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
			fcomi	st,st(1);				/**/
			fcmovnbe	st(0),st(1);		/*	if pTri[1].p.z > pMin->z st(0) = pTri[1].p.z*/
			fstp	float ptr [edi+8];
			/*if (pMax->z < pTri[1].p.z)	pMax->z = pTri[1].p.z;*/
			fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
			fcomi	st,st(1);	/**/
			fcmovb	st(0),st(1);			/*	if pMax->z < pTri[1].p.z st(0) = pTri[1].x*/
			fstp	float ptr [ebx+8];
			fstp	st(0)

			add	esi, dwPitch;			/*	pVertices++*/
			/*if (vecMin.x > pTri[2].p.x)	vecMin.x = pTri[2].p.x;*/
			fld		float ptr [esi];		/*	st(1) = pTri[2].p.x*/
			fld		float ptr [edi];		/*	st(0) = pMin->x*/;
			fcomi	st,st(1);				
			fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[2].p.x then st(0):=st(1)*/
			fstp	float ptr [edi];		/*	pMin->x = st(0)*/
			/*if (pMax->x < pTri[2].p.x)	pMax->x = pTri[2].p.x;*/
			fld		float ptr [ebx];		/* st(0) = pMax->x;*/
			fcomi	st,st(1);				
			fcmovb	st(0),st(1);			/*	pMax->x < pTri[2].p.x then st(0):=st(1)*/
			fstp	float ptr [ebx];		/*	*/
			fstp	st(0)					/*	*/
			/*if (pMin->y > pTri[2].p.y)	pMin->y = pTri[2].p.y;*/
			fld		[esi+4];				/* st(1) = pTri[2].p.y*/
			fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
			fcomi	st,st(1);				/*	if (pMin->y > pTri[2].p.y) st(0) = pTri[2].p.y;*/
			fcmovnbe	st(0),st(1);
			fstp	float ptr [edi+4];
			/*if (pMax->y < pTri[2].p.y)	pMax->y = pTri[2].p.y;*/
			fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
			fcomi	st,st(1);				
			fcmovb	st(0),st(1);			/*	if pMax->y < pTri[2].p.y st(0) = pTri[2].p.y*/
			fstp	float ptr [ebx+4];
			fstp	st(0)
			/*if (pMin->z > pTri[2].p.z)	pMin->z = pTri[2].p.z;*/
			fld		float ptr [esi+8];		/* st(1) = pTri[2].p.z*/
			fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
			fcomi	st,st(1);				
			fcmovnbe	st(0),st(1);		/*	if pTri[2].p.z > pMin->z st(0) = pTri[2].p.z*/
			fstp	float ptr [edi+8];
			/*if (pMax->z < pTri[2].p.z)	pMax->z = pTri[2].p.z;*/
			fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
			fcomi	st,st(1);				
			fcmovb	st(0),st(1);			/*	if pMax->z < pTri[2].p.z st(0) = pTri[2].x*/
			fstp	float ptr [ebx+8];	
			fstp	st(0)

			//	Collide2Box

			fild	bFalse;				//	st(3) := 0
			fild	bHit;				//	st(2) := 1
			lea	esi,	vecMin;
			lea	edi,	vecBoxMax;
			fld	float ptr[edi];			//	st(1):=pMax2->x
			fld	float ptr[esi];			//	st(0):=pMin1->x
			fcomip	st, st(1);
			fstp	st(0);
			fcmovnbe	st(0),st(1);	//	if (pMin1->x > pMax2->x)	then bHit = FALSE;

			fld	float ptr[edi+4];		//	st(1):= pMax2->y
			fld float ptr[esi+4];		//	st(0):= pMin1->y
			fcomip	st,st(1);
			fstp	st(0);
			fcmovnbe	st(0),st(1);	//	if (pMin1->y > pMax2->y)	then bHit = FALSE;	

			fld	float ptr[edi+8];		//	st(1):= pMax2->z
			fld float ptr[esi+8];		//	st(0):= pMin1->z
			fcomip	st,st(1);
			fstp	st(0);
			fcmovnbe	st(0),st(1);	//	if (pMin1->z > pMax2->z)	then bHit = FALSE;	

			lea	esi,	vecMax;
			lea	edi,	vecBoxMin;
			fld	float ptr[edi];			//st(1):=pMin2->x
			fld	float ptr[esi];			//st(0):=pMax1->x
			fcomip	st,st(1);
			fstp	st(0);
			fcmovb	st(0),st(1);		//	if (pMax1->x < pMin2->x)	then bHit = FALSE;

			fld	float ptr[edi+4];		//st(1):=pMin2->y
			fld	float ptr[esi+4];		//st(0):=pMax1->y
			fcomip	st,st(1);
			fstp	st(0);
			fcmovb	st(0),st(1);		//	if (pMax1->y < pMin2->y)	then bHit = FALSE;

			fld	float ptr[edi+8];		//st(1):=pMin2->z
			fld	float ptr[esi+8];		//st(0):=pMax1->z
			fcomip	st,st(1);
			fstp	st(0);
			fcmovb	st(0),st(1);		//	if (pMax1->z < pMin2->z)	then bHit = FALSE;

			fistp	bHit	;
			fstp	st(0)	;
		}
		if (!bHit)
			continue;
#endif
		for (j = 0; j < 3 ; ++j){
			D3DXVec3TransformNormal(&vecTmp,&vecVertice[j].n,&m_matWorld);
			vecVertice[j].n = vecTmp;
		}
		if (ProbeTheTriangleDistance(vecVertice,&fDist,pVec,&vecBoxMin,&vecBoxMax,fRadius,&vecNormalTmp,&vec3Tmp)){
			vecTmp = vec3Tmp - *pVec;
			if (D3DXVec3Dot(&vecNormalTmp,&vecTmp) < FLT_MIN){	//	zރ|S͖
				m_pCollisionInfo[num].n        = vecNormalTmp;
				m_pCollisionInfo[num].amount = fRadius - fDist;	//	߂
				m_pCollisionInfo[num].nearest  = vec3Tmp;
				WALLCOLLISIONVERTEX *psrc, *pdest;
				pdest = m_pCollisionInfo[num++].vertices;
				psrc = vecVertice;
				*pdest++ = *psrc++;
				*pdest++ = *psrc++;
				*pdest++ = *psrc++;

				if (num >= (int)m_dwSizeCollisionInfo){
					COLLISIONINFO	*pInfo = m_pCollisionInfo;
					DWORD	dwSize;
					dwSize = m_dwSizeCollisionInfo + 10;
					m_pCollisionInfo = new COLLISIONINFO[dwSize];
					::CopyMemory((VOID*)m_pCollisionInfo,pInfo,sizeof(COLLISIONINFO) * m_dwSizeCollisionInfo);
					delete	pInfo;
					m_dwSizeCollisionInfo = dwSize;
				}
			}
		}
	}
	m_dwNumCollisionInfo = num;
	pVB->Unlock();
	pIB->Unlock();

	SAFE_RELEASE(pVB);
	SAFE_RELEASE(pIB);
	return	num;
}

//-------------------------------------------------------------
//	Name: CalcGoBackDir
//	Desc: CollisionInfo 񂵂āAv[u߂肷B
//	Param:	
//			pVecMotion  v[üړ
//			pVecNormal	߂ׂ
//			fRadius		a
//	Return:	true	//	Ԓl͐M
//			false	//	ԒlɐMȂ
//-------------------------------------------------------------
BOOL	CWall::CalcGoBackDir(D3DXVECTOR3 *pVecPos,D3DXVECTOR3 *pVecMotion, D3DXVECTOR3 *pVecNormal, FLOAT fRadius){
	int	iNumCollisionInfo = (long)m_dwNumCollisionInfo;
	D3DXVECTOR3	vecDirMin= D3DXVECTOR3(FLT_MAX,FLT_MAX,FLT_MAX);
	D3DXVECTOR3	vecDirMax= D3DXVECTOR3(-FLT_MAX,-FLT_MAX,-FLT_MAX);
	D3DXVECTOR3	vecNormal;
	COLLISIONINFO	*p;
	BOOL	bRet = true;	//	M
	//	̃|SƂ̐ڐGz肳邽߁A
	//	|S痣邽߂̖߂ʂƖ߂
	//	XYZ ̒ԒlpĖ߂ƂASY
	p = m_pCollisionInfo;
	for (int i = 0; i < iNumCollisionInfo ; ++i){
		vecNormal = p->n * p->amount;
		vecDirMin.x = min(vecNormal.x,vecDirMin.x);
		vecDirMin.y = min(vecNormal.y,vecDirMin.y);
		vecDirMin.z = min(vecNormal.z,vecDirMin.z);
		vecDirMax.x = max(vecNormal.x,vecDirMax.x);
		vecDirMax.y = max(vecNormal.y,vecDirMax.y);
		vecDirMax.z = max(vecNormal.z,vecDirMax.z);
		++p;
	}
	vecNormal.x = (vecDirMin.x + vecDirMax.x) * 0.5f;
	vecNormal.y = (vecDirMin.y + vecDirMax.y) * 0.5f;
	vecNormal.z = (vecDirMin.z + vecDirMax.z) * 0.5f;
	if (D3DXVec3Length(&vecNormal) > FLT_MIN){
		D3DXVec3Normalize(&vecNormal, &vecNormal);
		//	M̃`FbN
		//	|Sɋ܂邩H
		FLOAT l = D3DXVec3Length(pVecMotion);
		if (l > FLT_MIN){
			D3DXVECTOR3	vecReverse = *pVecMotion / (-l);
			FLOAT	fDot;
			D3DXVECTOR3	vecN1, vecN2;
			D3DXVECTOR3	vecM1, vecM2;
			D3DXVECTOR3	vecP1, vecP2;
			D3DXVECTOR3	vecVertical,vecTmp;
			BOOL	b1, b2;
			//fDot = D3DXVec3Dot(&vecReverse,&vecNormal);
			for (int i = 0; i < iNumCollisionInfo ; ++i){
				vecN1 = m_pCollisionInfo[i].n;
				vecP1 = m_pCollisionInfo[i].nearest;
				vecM1 = *pVecPos - vecP1;
				D3DXVec3Normalize(&vecM1,&vecM1);
				for (int j = i+1 ; j < iNumCollisionInfo ; ++j){
					//	QxNgԂ̊֌W`FbN
					vecN2 = m_pCollisionInfo[j].n;
					vecP2 = m_pCollisionInfo[j].nearest;
					vecM2 = *pVecPos - vecP2;
					D3DXVec3Cross(&vecVertical,&vecN1, &vecN2);
					l = D3DXVec3Length(&vecVertical);
					if (l > FLT_MIN){
						fDot = D3DXVec3Dot(&vecN1, &vecN2);
						if (fDot < FLT_MIN){	//	@̂Ȃp90xȏiӂ̂Ȃp90xj
							vecVertical /= l;	//	m[}CY
							D3DXVec3Normalize(&vecM2,&vecM2);
							if (D3DXVec3Dot(&vecM1,&vecM2)< 0.5f){	//	ŋߓ_̊J60xȏ
								D3DXVec3Cross(&vecTmp,&vecReverse,&vecM1);
								b1 = D3DXVec3Dot(&vecTmp,&vecVertical) > 0;
								D3DXVec3Cross(&vecTmp,&vecReverse,&vecM2);
								b2 = D3DXVec3Dot(&vecTmp,&vecVertical) > 0;
								if (b1 != b2){	//	ʖ@is̋txNgł
									bRet = false;	//	
								}
							}
						}
					}
				}
			}
		}
	}else{
		//	ςƁA@قƂǂOɂȂĂ܂Ƃ́A
		//	߂ʂԑ傫iԋ߂j|S̖@߂ƂđI
		FLOAT	fMax = -FLT_MAX;
		p = m_pCollisionInfo;
		for (int i = 0; i < iNumCollisionInfo ; ++i){
			if (p->amount > fMax){
				vecNormal = p->n;
				fMax = p->amount;
			}
			++p;
		}
		bRet = false;
	}

	*pVecNormal = vecNormal;
	return	bRet;
}

//-------------------------------------------------------------
//	Name: AdjustDepth
//	Desc: ړʂ̍ŏI
//	Param:	
//			pVec		v[u̍W
//			fRadius		v[u̔a
//			pVecNormal	߂ׂ
//			pDepth		ǂ̖@ɖ߂ׂ߂荞ݗ
//	return:
//			true		M
//			false		MȂ
//-------------------------------------------------------------
BOOL	CWall::AdjustDepth(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal, FLOAT *pDepth){
	//	߂(vecNormal)A߂ʂ𒲐
	COLLISIONINFO *p = m_pCollisionInfo;
	FLOAT	fMove=-FLT_MAX;
	FLOAT	fMoveSynth = 0;
	D3DXVECTOR3	vecTmp,vecTmp2;
	FLOAT	fDot, fTmp;
	D3DXVECTOR3	vecNormal = *pVecNormal;
	int	iNumCollisionInfo = m_dwNumCollisionInfo;
	BOOL	bRet = true;	//	M

	for (int i = 0; i < iNumCollisionInfo; ++i){
		fDot = D3DXVec3Dot(&vecNormal,&(p->n));
		if (fDot > FLT_MIN){	//	pẼ|S͖
			fMove = p->amount / fDot;
			//	sp̖߂␳
			if (fMove > fRadius*2.0f)
				fMove = fRadius*2.0f;
			//	ړ̍WvZ
			D3DXVECTOR3	vecNewPos,vecRewind;
			vecNewPos = *pVec + (fMove * vecNormal);	//  pVec: v[uW
			vecTmp2 = p->nearest;

			vecRewind = -vecNormal;	//	߂̖߂

			//	T:ŒZ_	P:v[uW	V:߂@D = P-T Ƃ
			//	V^2t^2+2DVt+(D^2-r^2) = 0 Zoi̎͊TOŐmłȂj
			double a, b, c, d, t, t1,t2;
			a = vecRewind.x * vecRewind.x + vecRewind.y * vecRewind.y + vecRewind.z * vecRewind.z;
			d = vecNewPos.x - vecTmp2.x;
			c = d * d;
			d = vecNewPos.y - vecTmp2.y;
			c += d * d;
			d = vecNewPos.z - vecTmp2.z;
			c += d * d;
			c = c - fRadius * fRadius;
			b  = 2.0*(vecNewPos.x - vecTmp2.x)*vecRewind.x;
			b += 2.0*(vecNewPos.y - vecTmp2.y)*vecRewind.y;
			b += 2.0*(vecNewPos.z - vecTmp2.z)*vecRewind.z;

			d = b * b - 4 * a * c;
			if (d < 0){
				//	͂̃|S̓XLbv
				fTmp = 0;
			}else{
				d = sqrt(d);
				t1 = -b+d;
				t2 = -b-d;
				t1 /= 2.0 * a;
				t2 /= 2.0 * a;
				if (t1 >= 0 && t2 >= 0){
					t = min(t1,t2);
					fTmp = (float)t;
				}else{
					//	łȂ\͍lɂ
					fTmp = 0;
				}
			}
			if (fMove >= fTmp)
				fMove -= fTmp;
			if (fMove > fMoveSynth){
				fMoveSynth = fMove;
			}
		}
		++p;
	}
	*pDepth = fMoveSynth;
	return bRet;
}

//-------------------------------------------------------------
//	Name: ProbeTheWallSinkDepthBase
//  Desc: w肳ꂽ̕ǖʂւ̂߂荞ݗʂƁA
//		߂荞ݒn_̖@xNgԂB
//		͈͂́Aw肳ꂽ͂ރ{bNX͈͓̔ɌB
//		pVecNormal ɂ͂蔻̑Ώۋiv[uƌĂԁj
//		ړʂLxNgœ
//		̃|SƐڐGꍇɁẢeāA
//		z̈ꖇ̕ǂz肷o[WB
//		񖇂̃|SspȂƃ}YCB
//		CWall ̃tB[hrŎgp邽߁AċAEē
//		łȂ
//-------------------------------------------------------------
BOOL CWall::ProbeTheWallSinkDepthBase(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal,FLOAT *pDepth)
{
	D3DXVECTOR3	vecNormal;
	D3DXVECTOR3	vecBoxMin, vecBoxMax;
	D3DXVECTOR3	vecMin, vecMax;
	D3DINDEXBUFFER_DESC	ixDesc;
	HRESULT	hr;
	FLOAT	fMoveSynth=0;
	int	iNumCollisionInfo = 0;

	if (m_pMeshSysMem == NULL)
		return	false;

	FLOAT	l = D3DXVec3Length(&vecNormal);

	vecBoxMin = *pVec - D3DXVECTOR3(fRadius,fRadius,fRadius);
	vecBoxMax = *pVec + D3DXVECTOR3(fRadius,fRadius,fRadius);

	GetBoundingBox(&vecMin, &vecMax);
	//	^ꂽƂ̒n`̃oE_{bNXƂ
	//	Փ˔
	if (!Collide2Box(&vecMin,&vecMax,&vecBoxMin,&vecBoxMax)){
		return	false;
	}

	//	CfbNXobt@̌`mFB
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	GetIndexBuffer(&pIB);
	hr = pIB->GetDesc(&ixDesc);
	SAFE_RELEASE(pIB);

	vecNormal = D3DXVECTOR3(0,0,0);

	if (ixDesc.Format == D3DFMT_INDEX16){
		iNumCollisionInfo = CreateCollisionInfo16(pVec,fRadius);
	}else if (ixDesc.Format != D3DFMT_INDEX32){
		return	false;
	}

	//	qbg
	if (iNumCollisionInfo <= 0)
		return	false;

	if (iNumCollisionInfo == 1){
		*pVecNormal = m_pCollisionInfo->n;
		*pDepth = m_pCollisionInfo->amount;
		return	true;
	}

	//	̃|SɃqbg鎞

	//	߂Zo
	if (!CalcGoBackDir(pVec, pVecNormal,&vecNormal,fRadius)){
		//	vZłȂƂ́AړOɖ߂
		vecNormal = -*pVecNormal;
		*pVecNormal = vecNormal/l;
		//*pDepth = l;
		//return	true;
	}

	//	ǂɑ΂Ė߂ʂ̍ŏI
	if (l > FLT_MIN && !AdjustDepth(pVec, fRadius, &vecNormal,&fMoveSynth)){
		//	vZłȂƂ́AړOɖ߂
		vecNormal = -*pVecNormal;
		*pVecNormal = vecNormal/l;
		*pDepth = l;
		return	true;
	}

	*pDepth = fMoveSynth;
	*pVecNormal = vecNormal;
	if (fabs(fMoveSynth) < FLT_MIN)
		return	false;

	return	true;
}

//-------------------------------------------------------------
//	Name: ProbeTheWall
//  Desc: w肳ꂽǖʂƐڐGꍇA̐ڐG
//		|SƋ̒SƂ̋ԂB
//		܂A߂荞ݒn_̖@xNgԂB
//-------------------------------------------------------------
BOOL	CWall::ProbeTheWall(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal,FLOAT *pDist)
{
	FLOAT	fDepth;
	if (!ProbeTheWallSinkDepth(pVec,fRadius,pVecNormal,&fDepth))
		return	false;
	*pDist = fRadius - fDepth;
	return	true;
}


//-------------------------------------------------------------
//	Name: ProbeTheTriangleDistance
//  Desc: w肳ꂽƃ|S̍ŒZԂB
//		͈͂́Aw肳ꂽ̃oE_{bNX͈͓̔
//		B̍WńA[hWnɓꂳ
//		Ȃ΂ȂȂBXΔt
//	Param: 
//		pTri |S3_
//		pDist ŏ
//		pPos  v[uW
//		pBoxMin  v[uAABB min
//		pBoxMax  v[uAABB max
//		fRadius  v[ua
//		pNormal  @
//		pNearestPos	ŋߓ_W
//-------------------------------------------------------------
BOOL	CWall::ProbeTheTriangleDistance(WALLCOLLISIONVERTEX *pTri, FLOAT *pDist, D3DXVECTOR3 *pPos, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, FLOAT fRadius, D3DXVECTOR3 *pNormal,D3DXVECTOR3 *pNearestPos)
{
	D3DXVECTOR3	vecMin, vecMax, vecTmp, vecPos;
	FLOAT		len1, len2, len3, dx, dy, dz;
	FLOAT		fDist,fTmp;
	BOOL	bF0=false, bF1=false, bF2=false;
	D3DXVECTOR3	vecNormal, vecDir1, vecDir2;
	WALLCOLLISIONVERTEX	vTmp;

	vecPos = *pPos;

	//	eӂ̒ZoB
	dx = pTri[1].p.x - pTri[0].p.x;
	dy = pTri[1].p.y - pTri[0].p.y;
	dz = pTri[1].p.z - pTri[0].p.z;
	len1 = dx * dx + dy * dy + dz * dz;
	dx = pTri[2].p.x - pTri[1].p.x;
	dy = pTri[2].p.y - pTri[1].p.y;
	dz = pTri[2].p.z - pTri[1].p.z;
	len2 = dx * dx + dy * dy + dz * dz;
	dx = pTri[0].p.x - pTri[2].p.x;
	dy = pTri[0].p.y - pTri[2].p.y;
	dz = pTri[0].p.z - pTri[2].p.z;
	len3 = dx * dx + dy * dy + dz * dz;

	//	|Sȏ傫̂ݔΏۂƂB
	if ((fabs(len1) >= FLT_MIN)&&(fabs(len2) >= FLT_MIN)&&(fabs(len3) >= FLT_MIN)){

		//	ʖ@ZoB
		vecDir1 = pTri[1].p - pTri[0].p;
		vecDir2 = pTri[2].p - pTri[0].p;
		D3DXVec3Cross(&vecNormal,&vecDir1,&vecDir2);

		//	ʖ@ZołȂ́AŒZ_̓|S̕ӏ
		if ((fabs(vecNormal.x) + fabs(vecNormal.y) + fabs(vecNormal.z) ) <= FLT_MIN)
			goto	TRIANGLE_HAS_NO_AREA;
		
		//	ʖ@𐳋K
		D3DXVec3Normalize(&vecNormal,&vecNormal);

		vecDir1 = vecPos - pTri[0].p;
		vecDir2 = vecNormal;
		fDist = D3DXVec3Dot(&vecDir1,&vecDir2);
		if (fDist < -FLT_MIN)
			return	false;
		if (fDist > fRadius)
			return	false;

		//	ʏ̍ŋߓ_Zo
		*pNearestPos = vecPos - (vecNormal * fDist);

		vecDir1 = vecPos - pTri[0].p;
		vecDir2 = pTri[1].p - pTri[0].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		fTmp = D3DXVec3Dot(&vecTmp,&vecNormal);
		if (fTmp > -FLT_MIN){
			bF0=TRUE;
		}
		vecDir1 = vecPos - pTri[1].p;
		vecDir2 = pTri[2].p - pTri[1].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		fTmp = D3DXVec3Dot(&vecTmp,&vecNormal);
		if (fTmp > -FLT_MIN){
			bF1=TRUE;
		}

		vecDir1 = vecPos - pTri[2].p;
		vecDir2 = pTri[0].p - pTri[2].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		fTmp = D3DXVec3Dot(&vecTmp,&vecNormal);
		if (fTmp > -FLT_MIN){
			bF2=TRUE;
		}

		if (!bF0 && !bF1 && !bF2){
			*pDist = fDist;
			*pNormal = vecNormal;
			return	TRUE;
		}
		fDist = FLT_MAX;
		if (bF0){
			CalcShortestDistance(&vecPos,&pTri[1], &pTri[0], &fTmp,&vecTmp,pNormal);
			if (fTmp < fDist){
				fDist = fTmp;
				*pNearestPos = vecTmp;
			}
		}
		if (bF1){
			CalcShortestDistance(&vecPos,&pTri[2], &pTri[1], &fTmp,&vecTmp,pNormal);
			if (fTmp < fDist){
				fDist = fTmp;
				*pNearestPos = vecTmp;
			}
		}
		if (bF2){
			CalcShortestDistance(&vecPos,&pTri[0], &pTri[2], &fTmp,&vecTmp,pNormal);
			if (fTmp < fDist){
				fDist = fTmp;
				*pNearestPos = vecTmp;
			}
		}
		if (fDist < FLT_MAX){
			fDist = (FLOAT)sqrt(fDist);
			if (fDist > fRadius)
				return	FALSE;
			*pNormal = vecNormal;
			*pDist = fDist;
			return	TRUE;
		}
	}
TRIANGLE_HAS_NO_AREA:
	//	|Sɗ
	FLOAT	fDistTmp, fDistMin;
	D3DXVECTOR3	vecNormalTmp;
	CalcShortestDistance(&vecPos,&pTri[1], &pTri[0], &fDistMin,pNormal,pNearestPos);
	CalcShortestDistance(&vecPos,&pTri[2], &pTri[1], &fDistTmp,&vecNormalTmp,&vecTmp);
	if (fDistTmp < fDistMin){
		*pNormal = vecNormalTmp;
		*pNearestPos = vecTmp;
		fDistMin = fDistTmp;
	}
	CalcShortestDistance(&vecPos,&pTri[0], &pTri[2], &fDistTmp,&vecNormalTmp,&vecTmp);
	if (fDistTmp < fDistMin){
		*pNormal = vecNormalTmp;
		*pNearestPos = vecTmp;
		fDistMin = fDistTmp;
	}

	fDist = sqrt(fDistMin);
	if (fDist > fRadius)		//	20060611 oOC
		return	false;
	*pDist = fDist;
	D3DXVec3Normalize(pNormal,pNormal);
	return	true;
}

//-------------------------------------------------------------
//	Name: CalcShortestDistance
//  Desc: w肳ꂽƁA_Ƃ̊Ԃ̍ŏ߂B
//		͂RcōsȂB
//		vecPos v[uW
//		vecP1  WP
//		vecP2  WQ
//		pDist  ŏ	î߁AlAj
//		pPosOut  ŋߓ_
//		pNormal @
//-------------------------------------------------------------
void	CWall::CalcShortestDistance(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, float *pDist, D3DXVECTOR3 *pPosOut, D3DXVECTOR3 *pNormal){
	double	t;
	double	dx1, dy1, dz1, dx2, dy2, dz2;
	double	len, len1, len2;	
	double	px, py, pz;

	dx1 = vecP2->p.x - vecP1->p.x;
	dy1 = vecP2->p.y - vecP1->p.y;
	dz1 = vecP2->p.z - vecP1->p.z;

	dx2 = vecPos->x -vecP1->p.x;
	dy2 = vecPos->y -vecP1->p.y;
	dz2 = vecPos->z -vecP1->p.z;

	len = dx1*dx1 + dy1*dy1 + dz1*dz1;
	if (len < FLT_MIN){
		*pDist = (float)(dx2*dx2 + dy2*dy2 + dz2 * dz2);
		*pNormal = vecP1->n;
		*pPosOut = vecP1->p;
		D3DXVec3Normalize(pNormal,pNormal);
		return;
	}

	//	̔Cӂ̓_vecPos Ŏ_Ƃ̋A
	//	Zo鎮āA
	//	ꂪOɂȂ_߂ƁAŒZł_
	//	߂鎖łB
	t = dx1 * dx2 + dy1*dy2 + dz1*dz2;
	t /= len;
	if ((t >= 0.0f) && (t <= 1.0f)){
		//	̓_ŏꍇ

		//	ŏƂȂP1-P2 ̓_߂
		px = vecP1->p.x + (dx1*t);
		py = vecP1->p.y + (dy1*t);
		pz = vecP1->p.z + (dz1*t);
		pPosOut->x = (FLOAT)px;
		pPosOut->y = (FLOAT)py;
		pPosOut->z = (FLOAT)pz;

		//	߂ꂽ_Ƃ̋Zo
		dx1 = px - vecPos->x;		//	߂ꂽ_Ƃ
		dy1 = py - vecPos->y;		//	Zo
		dz1 = pz - vecPos->z;		//
		len = dx1*dx1 + dy1*dy1 + dz1*dz1;
		*pDist = (float)len;		//	Ăяo
		*pNormal = vecP1->n + ((vecP2->n - vecP1->n) * (float)t);
		D3DXVec3Normalize(pNormal, pNormal);
		return;
	}else{
		//	ꂩ̒_ŏłꍇB
		dx1  = vecP2->p.x - vecPos->x;
		dy1  = vecP2->p.y - vecPos->y;
		dz1  = vecP2->p.z - vecPos->z;
		len1  = dx2*dx2 + dy2 * dy2 + dz2*dz2;	//	P1 ܂ł̋
		len2 = dx1*dx1 + dy1 * dy1 + dz1*dz1;	//	P2 ܂ł̋
		if ( len2 < len1 ){
			//	P2܂ł̋ƁAP2 ̍xԂ
			*pNormal = vecP2->n;
			*pDist = (float)len2;
			*pPosOut = vecP2->p;
			D3DXVec3Normalize(pNormal,pNormal);
			return;
		}
		//	P1 ܂ł̋ƁAP1 ̍xԂ
		*pDist   = (float)len1;
		*pNormal = vecP1->n;
		*pPosOut = vecP1->p;
		D3DXVec3Normalize(pNormal,pNormal);
	}
	return;
}




//-------------------------------------------------------------
//	Name: MatrixInverseRotation
//  Desc: R{̃xNg vecX, vecY, vecZ 󂯎A
//		̃xNgꂼAwExEy
//		sɂȂ悤ȉ]}gNXZoB
//-------------------------------------------------------------
void	CWall::MatrixInverseRotation(D3DXMATRIX *pOut, D3DXVECTOR3 *vecX,D3DXVECTOR3 *vecY,D3DXVECTOR3 *vecZ)
{
	pOut->_11 = vecX->x;
	pOut->_21 = vecX->y;
	pOut->_31 = vecX->z;
	pOut->_41 = 0.0f;

	pOut->_12 = vecY->x;
	pOut->_22 = vecY->y;
	pOut->_32 = vecY->z;
	pOut->_42 = 0.0f;

	pOut->_13 = vecZ->x;
	pOut->_23 = vecZ->y;
	pOut->_33 = vecZ->z;
	pOut->_43 = 0.0f;

	pOut->_14 = 0.0f;
	pOut->_24 = 0.0f;
	pOut->_34 = 0.0f;
	pOut->_44 = 1.0f;
}

//-------------------------------------------------------------
//	Name: CheckCollisionWithSegment
//  Desc: n`ƐƂ̓蔻sB
//		蔻̂݁B
//	<<<<<<   쐬  >>>>>>
//		pVec1   :
//		pVec2   : 
//		fRadius : ̑
//-------------------------------------------------------------
BOOL CWall::CheckCollisionWithSegment(D3DXVECTOR3 *pVec1, D3DXVECTOR3 *pVec2,FLOAT fRadius)
{
	D3DXVECTOR3	vecMin, vecMax;
	D3DXVECTOR3	vecBoxMin, vecBoxMax;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	D3DINDEXBUFFER_DESC	ixDesc;
	DWORD	numFaces;
	DWORD	dwStride,dwMeshFVF;
	FLOAT	fDist = FLT_MAX;	//	ŒZZoɎgp
	BOOL	bRet = false;
	HRESULT	hr;
	D3DXVECTOR4	vecTmp;
	D3DXVECTOR3	vec3Tmp;
	static const BOOL	bFalse = false;
	static const DWORD	dwPitch = sizeof(WALLCOLLISIONVERTEX);
	WALLCOLLISIONVERTEX	vecVertice[3];

	if (m_pMeshSysMem == NULL)
		return	false;

	//	̃oEfBO{bNX쐬
	vecBoxMin.x = pVec1->x;
	vecBoxMin.y = pVec1->y;
	vecBoxMin.z = pVec1->z;
	vecBoxMax.x = pVec1->x;
	vecBoxMax.y = pVec1->y;
	vecBoxMax.z = pVec1->z;

	if (vecBoxMin.x > pVec2->x)	vecBoxMin.x = pVec2->x;
	if (vecBoxMin.y > pVec2->y)	vecBoxMin.y = pVec2->y;
	if (vecBoxMin.z > pVec2->z)	vecBoxMin.z = pVec2->z;
	if (vecBoxMax.x < pVec2->x)	vecBoxMax.x = pVec2->x;
	if (vecBoxMax.y < pVec2->y)	vecBoxMax.y = pVec2->y;
	if (vecBoxMax.z < pVec2->z)	vecBoxMax.z = pVec2->z;

	vecBoxMin -= D3DXVECTOR3(fRadius,fRadius,fRadius);
	vecBoxMax += D3DXVECTOR3(fRadius,fRadius,fRadius);

	//	n`̃oEfBO{bNX
	GetBoundingBox(&vecMin, &vecMax);

	//	^ꂽƂ̒n`̃oE_{bNXƂ
	//	Փ˔
	if (!Collide2Box(&vecMin,&vecMax,&vecBoxMin,&vecBoxMax)){
		return	false;
	}

	//	bVʂɃ|S𒊏oB
	numFaces = GetNumFaces();
	dwStride = D3DXGetFVFVertexSize(GetFVF());
	dwMeshFVF = GetFVF();
	GetVertexBuffer(&pVB);
	GetIndexBuffer(&pIB);
	hr = pIB->GetDesc(&ixDesc);

	//	EGCgt_ɂ͑ΉĂȂEEEEAGɂȂ̂邽߁B
	if (dwMeshFVF & ((~D3DFVF_XYZ)&(D3DFVF_XYZB1|D3DFVF_XYZB2|D3DFVF_XYZB3|D3DFVF_XYZB4|D3DFVF_XYZB5)))
		goto	UNSUPPORTED_VERTEX_FORMAT;

	if (ixDesc.Format == D3DFMT_INDEX16){
		WORD	*pIx;
		BYTE	*pVertex;
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		UINT	i,j;

		for(i = 0; i < numFaces; ++i){
			for (j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
				D3DXVec3TransformCoord(&vecVertice[j].p,&vecVertice[j].p,&m_matWorld);
			}
			//	|S̃oE_{bNXZo
			BOOL	bHit = TRUE;
			__asm{
				lea	esi, vecVertice;
				lea edi, vecMin;
				lea ebx, vecMax;
				
				mov	eax, dword ptr [esi];
				mov	dword ptr [edi], eax;		/*	pMin->x = pVertices[0].p.x;	*/
				mov	dword ptr [ebx], eax;		/*	pMax->x = pVertices[0].p.x;	*/
				mov	eax, dword ptr [esi+4];
				mov	dword ptr [edi+4], eax;		/*	pMin->y = pVertices[0].p.y;	*/
				mov	dword ptr [ebx+4], eax;		/*	pMax->y = pVertices[0].p.y;	*/
				mov	eax, dword ptr [esi+8];
				mov	dword ptr [edi+8], eax;		/*	pMin->z = pVertices[0].p.z;	*/
				mov	dword ptr [ebx+8], eax;		/*	pMax->z = pVertices[0].p.z;	*/
				add	esi, dwPitch;				/*	pVertices++	*/
				/*if (vecMin.x > pTri[1].p.x)	vecMin.x = pTri[1].p.x;*/
				fld		float ptr [esi];		/*	st(1) = pTri[1].p.x*/
				fld		float ptr [edi];		/*	st(0) = pMin->x;*/
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[1].p.x then st(0):=st(1)*/
				fstp	float ptr [edi];		/*	pMin->x = st(0)*/
				/*if (pMax->x < pTri[1].p.x)	pMax->x = pTri[1].p.x;*/
				fld		float ptr [ebx];		/* st(0) = pMax->x;*/
				fcomi	st,st(1);				/*	*/
				fcmovb	st(0),st(1);			/*	pMax->x < pTri[1].p.x then st(0):=st(1)*/
				fstp	float ptr [ebx];		/*	*/
				fstp	st(0)					/*	*/
				/*if (pMin->y > pTri[1].p.y)	pMin->y = pTri[1].p.y;*/
				fld		[esi+4];				/* st(1) = pTri[1].p.y*/
				fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
				fcomi	st,st(1);				/*	if (pMin->y > pTri[1].p.y) st(0) = pTri[1].p.y;*/
				fcmovnbe	st(0),st(1);
				fstp	float ptr [edi+4];
				/*if (pMax->y < pTri[1].p.y)	pMax->y = pTri[1].p.y;*/
				fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
				fcomi	st,st(1);				/**/
				fcmovb	st(0),st(1);			/*	if pMax->y < pTri[1].p.y st(0) = pTri[1].p.y*/
				fstp	float ptr [ebx+4];
				fstp	st(0)
				/*if (pMin->z > pTri[1].p.z)	pMin->z = pTri[1].p.z;*/
				fld		float ptr [esi+8];		/* st(1) = pTri[1].p.z*/
				fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
				fcomi	st,st(1);				/**/
				fcmovnbe	st(0),st(1);		/*	if pTri[1].p.z > pMin->z st(0) = pTri[1].p.z*/
				fstp	float ptr [edi+8];
				/*if (pMax->z < pTri[1].p.z)	pMax->z = pTri[1].p.z;*/
				fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
				fcomi	st,st(1);	/**/
				fcmovb	st(0),st(1);			/*	if pMax->z < pTri[1].p.z st(0) = pTri[1].x*/
				fstp	float ptr [ebx+8];
				fstp	st(0)

				add	esi, dwPitch;			/*	pVertices++*/
				/*if (vecMin.x > pTri[2].p.x)	vecMin.x = pTri[2].p.x;*/
				fld		float ptr [esi];		/*	st(1) = pTri[2].p.x*/
				fld		float ptr [edi];		/*	st(0) = pMin->x*/;
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[2].p.x then st(0):=st(1)*/
				fstp	float ptr [edi];		/*	pMin->x = st(0)*/
				/*if (pMax->x < pTri[2].p.x)	pMax->x = pTri[2].p.x;*/
				fld		float ptr [ebx];		/* st(0) = pMax->x;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	pMax->x < pTri[2].p.x then st(0):=st(1)*/
				fstp	float ptr [ebx];		/*	*/
				fstp	st(0)					/*	*/
				/*if (pMin->y > pTri[2].p.y)	pMin->y = pTri[2].p.y;*/
				fld		[esi+4];				/* st(1) = pTri[2].p.y*/
				fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
				fcomi	st,st(1);				/*	if (pMin->y > pTri[2].p.y) st(0) = pTri[2].p.y;*/
				fcmovnbe	st(0),st(1);
				fstp	float ptr [edi+4];
				/*if (pMax->y < pTri[2].p.y)	pMax->y = pTri[2].p.y;*/
				fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	if pMax->y < pTri[2].p.y st(0) = pTri[2].p.y*/
				fstp	float ptr [ebx+4];
				fstp	st(0)
				/*if (pMin->z > pTri[2].p.z)	pMin->z = pTri[2].p.z;*/
				fld		float ptr [esi+8];		/* st(1) = pTri[2].p.z*/
				fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	if pTri[2].p.z > pMin->z st(0) = pTri[2].p.z*/
				fstp	float ptr [edi+8];
				/*if (pMax->z < pTri[2].p.z)	pMax->z = pTri[2].p.z;*/
				fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	if pMax->z < pTri[2].p.z st(0) = pTri[2].x*/
				fstp	float ptr [ebx+8];	
				fstp	st(0)

				//	Collide2Box

				fild	bFalse;				//	st(3) := 0
				fild	bHit;				//	st(2) := 1
				lea	esi,	vecMin;
				lea	edi,	vecBoxMax;
				fld	float ptr[edi];			//	st(1):=pMax2->x
				fld	float ptr[esi];			//	st(0):=pMin1->x
				fcomip	st, st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->x > pMax2->x)	then bHit = FALSE;

				fld	float ptr[edi+4];		//	st(1):= pMax2->y
				fld float ptr[esi+4];		//	st(0):= pMin1->y
				fcomip	st,st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->y > pMax2->y)	then bHit = FALSE;	

				fld	float ptr[edi+8];		//	st(1):= pMax2->z
				fld float ptr[esi+8];		//	st(0):= pMin1->z
				fcomip	st,st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->z > pMax2->z)	then bHit = FALSE;	

				lea	esi,	vecMax;
				lea	edi,	vecBoxMin;
				fld	float ptr[edi];			//st(1):=pMin2->x
				fld	float ptr[esi];			//st(0):=pMax1->x
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->x < pMin2->x)	then bHit = FALSE;

				fld	float ptr[edi+4];		//st(1):=pMin2->y
				fld	float ptr[esi+4];		//st(0):=pMax1->y
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->y < pMin2->y)	then bHit = FALSE;

				fld	float ptr[edi+8];		//st(1):=pMin2->z
				fld	float ptr[esi+8];		//st(0):=pMax1->z
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->z < pMin2->z)	then bHit = FALSE;

				fistp	bHit	;
				fstp	st(0)	;
			}
			if (!bHit)
				continue;

			for (j = 0; j < 3 ; ++j){
				vecTmp.x = vecVertice[j].n.x;
				vecTmp.y = vecVertice[j].n.y;
				vecTmp.z = vecVertice[j].n.z;
				vecTmp.w = 0.0f;
				D3DXVec4Transform(&vecTmp,&vecTmp,&m_matWorld);
				vecVertice[j].n = (D3DXVECTOR3)vecTmp;
			}

			//	Op`Ƃ̓蔻
			if (ProbeTheTriangleDistanceWithSegment(vecVertice,&fDist,pVec1,pVec2,fRadius)){
				bRet = true;
				break;
			}

		}
		pVB->Unlock();
		pIB->Unlock();
	}else{
		DWORD	*pIx;
		BYTE	*pVertex;
		if (ixDesc.Format != D3DFMT_INDEX32){
			goto	UNSUPPORTED_INDEX_BUFFER;
		}
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		UINT	i,j;

		for(i = 0; i < numFaces; ++i){
			for (j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
				D3DXVec3TransformCoord(&vecVertice[j].p,&vecVertice[j].p,&m_matWorld);
			}
			BOOL	bHit = TRUE;
			__asm{
				lea	esi, vecVertice;
				lea edi, vecMin;
				lea ebx, vecMax;
				
				mov	eax, dword ptr [esi];
				mov	dword ptr [edi], eax;		/*	pMin->x = pVertices[0].p.x;	*/
				mov	dword ptr [ebx], eax;		/*	pMax->x = pVertices[0].p.x;	*/
				mov	eax, dword ptr [esi+4];
				mov	dword ptr [edi+4], eax;		/*	pMin->y = pVertices[0].p.y;	*/
				mov	dword ptr [ebx+4], eax;		/*	pMax->y = pVertices[0].p.y;	*/
				mov	eax, dword ptr [esi+8];
				mov	dword ptr [edi+8], eax;		/*	pMin->z = pVertices[0].p.z;	*/
				mov	dword ptr [ebx+8], eax;		/*	pMax->z = pVertices[0].p.z;	*/
				add	esi, dwPitch;				/*	pVertices++	*/
				/*if (vecMin.x > pTri[1].p.x)	vecMin.x = pTri[1].p.x;*/
				fld		float ptr [esi];		/*	st(1) = pTri[1].p.x*/
				fld		float ptr [edi];		/*	st(0) = pMin->x;*/
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[1].p.x then st(0):=st(1)*/
				fstp	float ptr [edi];		/*	pMin->x = st(0)*/
				/*if (pMax->x < pTri[1].p.x)	pMax->x = pTri[1].p.x;*/
				fld		float ptr [ebx];		/* st(0) = pMax->x;*/
				fcomi	st,st(1);				/*	*/
				fcmovb	st(0),st(1);			/*	pMax->x < pTri[1].p.x then st(0):=st(1)*/
				fstp	float ptr [ebx];		/*	*/
				fstp	st(0)					/*	*/
				/*if (pMin->y > pTri[1].p.y)	pMin->y = pTri[1].p.y;*/
				fld		[esi+4];				/* st(1) = pTri[1].p.y*/
				fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
				fcomi	st,st(1);				/*	if (pMin->y > pTri[1].p.y) st(0) = pTri[1].p.y;*/
				fcmovnbe	st(0),st(1);
				fstp	float ptr [edi+4];
				/*if (pMax->y < pTri[1].p.y)	pMax->y = pTri[1].p.y;*/
				fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
				fcomi	st,st(1);				/**/
				fcmovb	st(0),st(1);			/*	if pMax->y < pTri[1].p.y st(0) = pTri[1].p.y*/
				fstp	float ptr [ebx+4];
				fstp	st(0)
				/*if (pMin->z > pTri[1].p.z)	pMin->z = pTri[1].p.z;*/
				fld		float ptr [esi+8];		/* st(1) = pTri[1].p.z*/
				fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
				fcomi	st,st(1);				/**/
				fcmovnbe	st(0),st(1);		/*	if pTri[1].p.z > pMin->z st(0) = pTri[1].p.z*/
				fstp	float ptr [edi+8];
				/*if (pMax->z < pTri[1].p.z)	pMax->z = pTri[1].p.z;*/
				fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
				fcomi	st,st(1);	/**/
				fcmovb	st(0),st(1);			/*	if pMax->z < pTri[1].p.z st(0) = pTri[1].x*/
				fstp	float ptr [ebx+8];
				fstp	st(0)

				add	esi, dwPitch;			/*	pVertices++*/
				/*if (vecMin.x > pTri[2].p.x)	vecMin.x = pTri[2].p.x;*/
				fld		float ptr [esi];		/*	st(1) = pTri[2].p.x*/
				fld		float ptr [edi];		/*	st(0) = pMin->x*/;
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[2].p.x then st(0):=st(1)*/
				fstp	float ptr [edi];		/*	pMin->x = st(0)*/
				/*if (pMax->x < pTri[2].p.x)	pMax->x = pTri[2].p.x;*/
				fld		float ptr [ebx];		/* st(0) = pMax->x;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	pMax->x < pTri[2].p.x then st(0):=st(1)*/
				fstp	float ptr [ebx];		/*	*/
				fstp	st(0)					/*	*/
				/*if (pMin->y > pTri[2].p.y)	pMin->y = pTri[2].p.y;*/
				fld		[esi+4];				/* st(1) = pTri[2].p.y*/
				fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
				fcomi	st,st(1);				/*	if (pMin->y > pTri[2].p.y) st(0) = pTri[2].p.y;*/
				fcmovnbe	st(0),st(1);
				fstp	float ptr [edi+4];
				/*if (pMax->y < pTri[2].p.y)	pMax->y = pTri[2].p.y;*/
				fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	if pMax->y < pTri[2].p.y st(0) = pTri[2].p.y*/
				fstp	float ptr [ebx+4];
				fstp	st(0)
				/*if (pMin->z > pTri[2].p.z)	pMin->z = pTri[2].p.z;*/
				fld		float ptr [esi+8];		/* st(1) = pTri[2].p.z*/
				fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	if pTri[2].p.z > pMin->z st(0) = pTri[2].p.z*/
				fstp	float ptr [edi+8];
				/*if (pMax->z < pTri[2].p.z)	pMax->z = pTri[2].p.z;*/
				fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	if pMax->z < pTri[2].p.z st(0) = pTri[2].x*/
				fstp	float ptr [ebx+8];	
				fstp	st(0)

				//	Collide2Box

				fild	bFalse;				//	st(3) := 0
				fild	bHit;				//	st(2) := 1
				lea	esi,	vecMin;
				lea	edi,	vecBoxMax;
				fld	float ptr[edi];			//	st(1):=pMax2->x
				fld	float ptr[esi];			//	st(0):=pMin1->x
				fcomip	st, st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->x > pMax2->x)	then bHit = FALSE;

				fld	float ptr[edi+4];		//	st(1):= pMax2->y
				fld float ptr[esi+4];		//	st(0):= pMin1->y
				fcomip	st,st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->y > pMax2->y)	then bHit = FALSE;	

				fld	float ptr[edi+8];		//	st(1):= pMax2->z
				fld float ptr[esi+8];		//	st(0):= pMin1->z
				fcomip	st,st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->z > pMax2->z)	then bHit = FALSE;	

				lea	esi,	vecMax;
				lea	edi,	vecBoxMin;
				fld	float ptr[edi];			//st(1):=pMin2->x
				fld	float ptr[esi];			//st(0):=pMax1->x
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->x < pMin2->x)	then bHit = FALSE;

				fld	float ptr[edi+4];		//st(1):=pMin2->y
				fld	float ptr[esi+4];		//st(0):=pMax1->y
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->y < pMin2->y)	then bHit = FALSE;

				fld	float ptr[edi+8];		//st(1):=pMin2->z
				fld	float ptr[esi+8];		//st(0):=pMax1->z
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->z < pMin2->z)	then bHit = FALSE;

				fistp	bHit	;
				fstp	st(0)	;
			}
			if (!bHit)
				continue;
			for (j = 0; j < 3 ; ++j){
				vecTmp.x = vecVertice[j].n.x;
				vecTmp.y = vecVertice[j].n.y;
				vecTmp.z = vecVertice[j].n.z;
				vecTmp.w = 0.0f;
				D3DXVec4Transform(&vecTmp,&vecTmp,&m_matWorld);
				vecVertice[j].n = (D3DXVECTOR3)vecTmp;
			}

			//	Op`Ƃ̓蔻
			if (ProbeTheTriangleDistanceWithSegment(vecVertice,&fDist,pVec1,pVec2,fRadius)){
				bRet = true;
				break;
			}

		}
		pVB->Unlock();
		pIB->Unlock();

	}
UNSUPPORTED_INDEX_BUFFER:
UNSUPPORTED_VERTEX_FORMAT:
	SAFE_RELEASE(pIB);
	SAFE_RELEASE(pVB);
	return	bRet;
}

//-------------------------------------------------------------
//	Name: ProbeTheTriangleDistanceWithSegment
//  Desc: w肳ꂽƃ|SƂ̓蔻B
//		eۂȂǍňړ镨̂Ƃ̓蔻ɎgpB
//		̍WńA[hWnɓꂳ
//		Ȃ΂ȂȂB
//-------------------------------------------------------------
BOOL	CWall::ProbeTheTriangleDistanceWithSegment(WALLCOLLISIONVERTEX *pTri, FLOAT *pDist, D3DXVECTOR3 *pVec1, D3DXVECTOR3 *pVec2, FLOAT fRadius)
{
	D3DXVECTOR3	vecMin, vecMax, vecTmp, vecPos1, vecPos2, vecPos;
	D3DXVECTOR3	vecX, vecY, vecZ;
	FLOAT		len1, len2, len3, dx, dy, dz;
	FLOAT		fDist;
	WALLCOLLISIONVERTEX	vTmp;
	UINT	i;

	vecPos1 = *pVec1;
	vecPos2 = *pVec2;
	//	|S̊eӂ̒ZoB
	dx = pTri[1].p.x - pTri[0].p.x;
	dy = pTri[1].p.y - pTri[0].p.y;
	dz = pTri[1].p.z - pTri[0].p.z;
	len1 = dx * dx + dy * dy + dz * dz;
	dx = pTri[2].p.x - pTri[1].p.x;
	dy = pTri[2].p.y - pTri[1].p.y;
	dz = pTri[2].p.z - pTri[1].p.z;
	len2 = dx * dx + dy * dy + dz * dz;
	dx = pTri[0].p.x - pTri[2].p.x;
	dy = pTri[0].p.y - pTri[2].p.y;
	dz = pTri[0].p.z - pTri[2].p.z;
	len3 = dx * dx + dy * dy + dz * dz;

	//	|Sȏ傫̂݁AB
	if ((fabs(len1) >= FLT_MIN)&&(fabs(len2) >= FLT_MIN)&&(fabs(len3) >= FLT_MIN)){
		//	|S̈ԒӂTA
		//	p0-p1-p2 ̎Op|S
		//	p0-p1 ɂB
		if ((len2 >= len1)&&(len2 >= len3)){
			//	p1-p2 Ԓꍇ
			vTmp = pTri[0];
			pTri[0] = pTri[1];
			pTri[1] = pTri[2];
			pTri[2] = vTmp;
		}else if ((len3 >= len1)&&(len3 >= len2)){
			//	p2-p0 Ԓꍇ
			vTmp = pTri[2];
			pTri[2] = pTri[1];
			pTri[1] = pTri[0];
			pTri[0] = vTmp;
		}

		//	p0-p1  ZƕsɂȂ悤ȉ]}gNXZo
		
		D3DXMATRIX	matRot;
		D3DXVECTOR3	vecOrd;
		//	p0 - p1 ȂAyxNgƂB
		vecZ = pTri[1].p - pTri[0].p;
		D3DXVec3Normalize(&vecZ, &vecZ);

		//	ʖ@ xxNgƂB
		vecX = pTri[2].p - pTri[0].p;
		D3DXVec3Cross(&vecY,&vecZ,&vecX);

		//	ʖ@ZołȂ́AŒZ_̓|S̕ӏ
		if ((fabs(vecY.x) + fabs(vecY.y) + fabs(vecY.z) ) <= FLT_MIN)
			goto	TRIANGLE_HAS_NO_AREA;
		
		D3DXVec3Normalize(&vecY,&vecY);

		//	wxNg𒲐B
		D3DXVec3Cross(&vecX,&vecY,&vecZ);
		D3DXVec3Normalize(&vecX,&vecX);

		MatrixInverseRotation(&matRot, &vecX, &vecY, &vecZ);
		//	P0 ̈ʒuۑ
		vecOrd = pTri[0].p;

		//	_|SƓWnɕϊB
		vecPos1 -= vecOrd;
		D3DXVec3TransformCoord(&vecPos1,&vecPos1,&matRot);
		vecPos2 -= vecOrd;
		D3DXVec3TransformCoord(&vecPos2,&vecPos2,&matRot);

		//	
		if ((vecPos1.y > fRadius)&&(vecPos2.y > fRadius))
			return	false;

		if ((vecPos1.y < -fRadius)&&(vecPos2.y < -fRadius))
			return	false;

		if ((vecPos1.y * vecPos2.y)<=0){
			//	|S̑O̓_|S̕ʂтƂ
			FLOAT t;
			if (fabs(vecPos1.y - vecPos2.y) > FLT_MIN){
				t = vecPos2.y / (vecPos2.y - vecPos1.y);
				vecPos = t * vecPos1 + (1-t) * vecPos2;
			}else{
				vecPos = vecPos1;
			}
		}else if ((vecPos1.y > 0)&&(vecPos2.y > 0)){
			vecPos = vecPos1;
		}else{
			vecPos = vecPos2;
		}

		//	_p0 _ɂāAASĂ̓_A
		//	XZ ʂɒt悤ɑSĂ̒_
		//	AtBϊB
		//	ӁI@@͕ϊȂB
		for (i = 0; i < 3 ; ++i){
			vecTmp = pTri[i].p - vecOrd;
			D3DXVec3TransformCoord(&pTri[i].p,&vecTmp,&matRot);
		}


		//	XZ ʏɃ|SIɓ\tB̂߁A
		//	ŒZ_́A_̐^ɂȂB
		//	|S̓B

		//	XZ ʏŁA|S̃oE_N^OZo
		vecMin.x = FLT_MAX, vecMin.z = FLT_MAX;
		vecMax.x = -FLT_MAX, vecMax.z = -FLT_MAX;
		for (i = 0; i < 3; ++i){
			if (vecMin.x > pTri[i].p.x)	vecMin.x = pTri[i].p.x;
			if (vecMin.z > pTri[i].p.z)	vecMin.z = pTri[i].p.z;
			if (vecMax.x < pTri[i].p.x)	vecMax.x = pTri[i].p.x;
			if (vecMax.z < pTri[i].p.z)	vecMax.z = pTri[i].p.z;
		}

		//	_oE_N^ȌɏdȂꍇ
		if ((vecPos.x >= vecMin.x) && (vecPos.x <= vecMax.x)){
			if ((vecPos.z >= vecMin.z) && (vecPos.z <= vecMax.z)){

				//	_̓oE_N^O̓
				double	fZ1, fZ2, dx, dz;
				double	t;
				D3DXVECTOR3	vecPosA, vecPosB;

				dx = pTri[2].p.x - pTri[0].p.x;
				dz = pTri[2].p.z - pTri[0].p.z;
				t = (vecPos.x - pTri[0].p.x)/dx;
				fZ1 = (dz * t) + pTri[0].p.z;
				vecPosA = pTri[0].p + (pTri[2].p - pTri[0].p) * (float)t;
				//	_|S̒ł
				//	_ZẂAP0-P2 傫ȂB
				if (vecPos.z >= fZ1){
					dx = pTri[2].p.x - pTri[1].p.x;
					dz = pTri[2].p.z - pTri[1].p.z;
					t = (vecPos.x - pTri[1].p.x)/dx;
					fZ2 = (dz * t) + pTri[1].p.z;

					//	_|S̒ł
					//	_ZẂAP1-P2 菬ȂB
					if (vecPos.z <= fZ2){
						vecPosB = pTri[1].p + (pTri[2].p - pTri[1].p) * (float)t;
						//	|S̓ɂ_łƊmFꂽB
						//	|S̍ZoB
						*pDist = vecPos.y;
						return	true;
					}
				}
			}
		}

		BOOL	bF0=FALSE, bF1=FALSE, bF2=FALSE;
		D3DXVECTOR3	vecDir1, vecDir2;
		FLOAT	fTmp;
		vecDir1 = vecPos - pTri[0].p;
		vecDir2 = pTri[1].p - pTri[0].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		fTmp = D3DXVec3Dot(&vecTmp,&vecY);
		if (vecTmp.y > -FLT_MIN){
			bF0=TRUE;
		}
		vecDir1 = vecPos - pTri[1].p;
		vecDir2 = pTri[2].p - pTri[1].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		if (vecTmp.y > -FLT_MIN){
			bF1=TRUE;
		}

		vecDir1 = vecPos - pTri[2].p;
		vecDir2 = pTri[0].p - pTri[2].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		if (vecTmp.y > -FLT_MIN){
			bF2=TRUE;
		}

		fDist = FLT_MAX;

		D3DXVECTOR3	vecNormal;
		if (bF0){
			CalcShortestDistance(&vecPos,&pTri[1], &pTri[0], &fTmp,&vecTmp,&vecNormal);
			if (fTmp < fDist){
				fDist = fTmp;
			}
		}
		if (bF1){
			CalcShortestDistance(&vecPos,&pTri[2], &pTri[1], &fTmp,&vecTmp,&vecNormal);
			if (fTmp < fDist){
				fDist = fTmp;
			}
		}
		if (bF2){
			CalcShortestDistance(&vecPos,&pTri[0], &pTri[2], &fTmp,&vecTmp,&vecNormal);
			if (fTmp < fDist){
				fDist = fTmp;
			}
		}
		if (fDist < FLT_MAX){
			fDist = (FLOAT)sqrt(fDist);
			if (fDist > fRadius)
				return	FALSE;
			*pDist = fDist;
			return	TRUE;
		}
	}
TRIANGLE_HAS_NO_AREA:
	return	FALSE;	//	̏ʐς̖|Sɂ͂ȂB
}
#if	0
//-------------------------------------------------------------
//	Name: CalcShortestDistance2
//  Desc: w肳ꂽƁA_Ƃ̊Ԃ̍ŏ߂B
//		
//		͂RcōsȂB
//-------------------------------------------------------------
void	CWall::CalcShortestDistance2(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, float *pDist){
	double	t;
	double	dx1, dy1, dz1, dx2, dy2, dz2;
	double	len, len1, len2;	
	double	px, py, pz;

	dx1 = vecP2->p.x - vecP1->p.x;
	dy1 = vecP2->p.y - vecP1->p.y;
	dz1 = vecP2->p.z - vecP1->p.z;

	dx2 = vecP1->p.x - vecPos->x;
	dy2 = vecP1->p.y - vecPos->y;
	dz2 = vecP1->p.z - vecPos->z;

	len = dx1*dx1 + dy1*dy1 + dz1*dz1;
	if (len < FLT_MIN){
		*pDist = (float)(dx2*dx2 + dy2*dy2 + dz2 * dz2);
		return;
	}

	//	̔Cӂ̓_vecPos Ŏ_Ƃ̋A
	//	Zo鎮āA
	//	ꂪOɂȂ_߂ƁAŒZł_
	//	߂鎖łB
	t = -(dx1 * dx2 + dy1*dy2 + dz1*dz2);
	t /= len;
	if ((t >= 0.0f) && (t <= 1.0f)){
		//	̓_ŏꍇ

		//	ŏƂȂP1-P2 ̓_߂
		px = vecP1->p.x + (dx1*t);
		py = vecP1->p.y + (dy1*t);
		pz = vecP1->p.z + (dz1*t);

		//	߂ꂽ_Ƃ̋Zo
		dx1 = px - vecPos->x;		//	߂ꂽ_Ƃ
		dy1 = py - vecPos->y;		//	Zo
		dz1 = pz - vecPos->z;		//
		len = dx1*dx1 + dy1*dy1 + dz1*dz1;
		*pDist = (float)len;		//	Ăяo
		return;
	}else{
		//	ꂩ̒_ŏłꍇB
		dx1  = vecP2->p.x - vecPos->x;
		dy1  = vecP2->p.y - vecPos->y;
		dz1  = vecP2->p.z - vecPos->z;
		len1  = dx2*dx2 + dy2 * dy2 + dz2*dz2;	//	P1 ܂ł̋
		len2 = dx1*dx1 + dy1 * dy1 + dz1*dz1;	//	P2 ܂ł̋
		if ( len2 < len1 ){
			//	P2܂ł̋ƁAP2 ̍xԂ
			*pDist = (float)len2;
			return;
		}
		//	P1 ܂ł̋ƁAP1 ̍xԂ
		*pDist   = (float)len1;
	}
	return;
}
#endif
//-------------------------------------------------------------
//	Name: CalcDistanceSegmentToSegment
//  Desc: sȂQԂ̍ŒZZoB
//		͂RcōsȂB
//		Ԃ͋̎łB
//-------------------------------------------------------------
FLOAT	CWall::CalcDistanceTwoParallelSegments(D3DXVECTOR3 *pveca0, D3DXVECTOR3*pveca1, D3DXVECTOR3 *pveca, D3DXVECTOR3 *pvecb0, D3DXVECTOR3 *pvecb1, D3DXVECTOR3 *pvecb){
	FLOAT distance,t,disttmp;;
	D3DXVECTOR3	va, vb;
	D3DXVECTOR3	vp,vd;
	va = *pveca0;
	vp = va - *pvecb0;
	vd = *pvecb1 - *pvecb0;
	t = ::D3DXVec3Dot(&vp, &vd);
	t /= D3DXVec3LengthSq(&vd);
	if (t < 0){
		vb = *pvecb0;
	}else if (t > 1.0f){
		vb = *pvecb1;
	}else{
		vb = t * vd + *pvecb0;
	}
	distance = D3DXVec3LengthSq(&(vb - va));
	*pveca = va;
	*pvecb = vb;

	va = *pveca1;
	vp = va - *pvecb0;
	vd = *pvecb1 - *pvecb0;
	t = ::D3DXVec3Dot(&vp, &vd);
	t /= D3DXVec3LengthSq(&vd);
	if (t < 0){
		vb = *pvecb0;
	}else if (t > 1.0f){
		vb = *pvecb1;
	}else{
		vb = t * vd + *pvecb0;
	}
	disttmp = D3DXVec3LengthSq(&(vb - va));
	if (disttmp < distance){
		distance = disttmp;
		*pveca = va;
		*pvecb = vb;
	}

	vb = *pvecb0;
	vp = vb - *pveca0;
	vd = *pveca1 - *pveca0;
	t = ::D3DXVec3Dot(&vp, &vd);
	t /= D3DXVec3LengthSq(&vd);
	if (t < 0){
		va = *pveca0;
	}else if (t > 1.0f){
		va = *pveca1;
	}else{
		va = t * vd + *pveca0;
	}
	disttmp = D3DXVec3LengthSq(&(vb - va));
	if (disttmp < distance){
		distance = disttmp;
		*pveca = va;
		*pvecb = vb;
	}

	vb = *pvecb1;
	vp = vb - *pveca0;
	vd = *pveca1 - *pveca0;
	t = ::D3DXVec3Dot(&vp, &vd);
	t /= D3DXVec3LengthSq(&vd);
	if (t < 0){
		va = *pveca0;
	}else if (t > 1.0f){
		va = *pveca1;
	}else{
		va = t * vd + *pveca0;
	}
	disttmp = D3DXVec3LengthSq(&(vb - va));
	if (disttmp < distance){
		distance = disttmp;
		*pveca = va;
		*pvecb = vb;
	}
	return	distance;
}
//-------------------------------------------------------------
//	Name: CalcDistanceSegmentToSegment
//  Desc: Q̐Ԃ̍ŒZZoB
//		͂RcōsȂB
//		Ԃ͋̎łB
//  param: 
//
//-------------------------------------------------------------
FLOAT	CWall::CalcDistanceSegmentToSegment(D3DXVECTOR3 *pveca0, D3DXVECTOR3*pveca1, D3DXVECTOR3 *pveca, D3DXVECTOR3 *pvecb0, D3DXVECTOR3 *pvecb1, D3DXVECTOR3 *pvecb){
	FLOAT	a, b, c, d, e, f;	//	A񎟕߂̕ϐ
	FLOAT	A;					//	Aׂ |A|is񎮁j
	D3DXVECTOR3	vd, ve;
	//	
	//	Ԃ̋i̎j߂֐D(t,u)SčŒZ߂B
	//	̓Iɂ́AD(t,u) tŕΔ̂ƁAuŕΔ̂Ƃ0ɂȂ
	//	tȗgݍ킹Aŋ߂鎖ŋŋ߂ƂȂ_߂B
	//
	vd = *pveca1-*pveca0;
	ve = *pvecb1-*pvecb0;

    //  ȉ̊֐At  u ŕΔċ߂铱֐oO
    //	t  u ̑gݍ킹߂AB
	//	D(t,u) = LengthSq((a0+vd*t) - (b0 + ve*u));

	a =  2.0f * D3DXVec3LengthSq(&ve);	//	u ŕΔƂ u ̍
	b = -2.0f * D3DXVec3Dot(&vd,&ve);	//	u ŕΔƂ t ̍
	c = b;								//	t ŕΔƂ u ̍
	d =  2.0f * D3DXVec3LengthSq(&vd);	//	t ŕΔƂ t ̍

	e = -2.0f*D3DXVec3Dot(pvecb0,&ve) + 2.0f*D3DXVec3Dot(pveca0,&ve);	//  u ŕΔƂ̒萔
	f =  2.0f*D3DXVec3Dot(pvecb0,&vd) - 2.0f*D3DXVec3Dot(pveca0,&vd);	//  t ŕΔƂ̒萔

	//	ȉ̍s񎮂AẢ𓾂
	//	| a b |
	//	| c d |

	A = a*d - b*c;
	if (fabsf(A)<FLT_MIN){
		//	s܂͂ǂ炩̐_̎
		return	CalcDistanceTwoParallelSegments(pveca0,pveca1,pveca,pvecb0,pvecb1,pvecb);
	}
	FLOAT	t, u;
	u = (e*d-b*f) / A;
	t = (a*f-e*c) / A;
	BOOL	b0 = true, b1 = true;;
	D3DXVECTOR3	v0, v1;

	if (t < 0){
		t = 0;
		b0 = false;
		v0 = *pveca0;
	}else if (t > 1.0f){
		t = 1.0f;
		b0 = false;
		v0 = *pveca1;
	}
	if (u < 0){
		u = 0;
		b1 = false;
		v1 = *pvecb0;
	}else if (u > 1.0f){
		u = 1.0f;
		b1 = false;
		v1 = *pvecb1;
	}
	if (b0 && b1){
		v0 = *pveca0 + (t * vd);
		v1 = *pvecb0 + (u * ve);
	}else if (b1){
		//	ÂݐO̎
		u = D3DXVec3Dot(&ve, &(v0-*pvecb0)) / D3DXVec3LengthSq(&ve);
		if (u < 0.0f)
			u = 0.0f;
		else if (u > 1.0f)
			u = 1.0f;
		v1 = *pvecb0 + (u * ve);
	}else if (b0){
		//	B̂ݐO̎
		t = D3DXVec3Dot(&vd, &(v1-*pveca0)) / D3DXVec3LengthSq(&vd);
		if (t < 0.0f)
			t = 0.0f;
		else if (t > 1.0f)
			t = 1.0f;
		v0 = *pveca0 + (t * vd);
	}
	*pveca = v0;
	*pvecb = v1;
	return	D3DXVec3LengthSq(&(v1 - v0));
}

//-------------------------------------------------------------
//	Name: CheckCollisionWithSegment
//  Desc: n`ƐƂ̓蔻sB
//		蔻̂݁B
//	<<<<<<   쐬  >>>>>>
//		pVec1   :
//		pVec2   : 
//		fErrorCapacity : |SGbW̋e덷
//		pVecOut : Փ˓_
//-------------------------------------------------------------
BOOL CWall::CheckCollisionWithSegment(D3DXVECTOR3 *pVec1, D3DXVECTOR3 *pVec2,FLOAT fErrorCapacity,D3DXVECTOR3 *pVecOut)
{
	D3DXVECTOR3	vecMin, vecMax;
	D3DXVECTOR3	vecBoxMin, vecBoxMax;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	D3DINDEXBUFFER_DESC	ixDesc;
	DWORD	numFaces;
	DWORD	dwStride,dwMeshFVF;
	BOOL	bRet = false;
	HRESULT	hr;
	D3DXVECTOR4	vecTmp;
	D3DXVECTOR3	vec3Tmp;
	static const BOOL	bFalse = false;
	static const DWORD	dwPitch = sizeof(WALLCOLLISIONVERTEX);
	WALLCOLLISIONVERTEX	vecVertice[3];
	FLOAT	fT = 1.0f;
	D3DXVECTOR3	vecTmpOut;
	FLOAT	fTmp;
	*pVecOut = *pVec2;
	if (m_pMeshSysMem == NULL)
		return	false;

	//	̃oEfBO{bNX쐬
	vecBoxMin.x = pVec1->x;
	vecBoxMin.y = pVec1->y;
	vecBoxMin.z = pVec1->z;
	vecBoxMax.x = pVec1->x;
	vecBoxMax.y = pVec1->y;
	vecBoxMax.z = pVec1->z;

	if (vecBoxMin.x > pVec2->x)	vecBoxMin.x = pVec2->x;
	if (vecBoxMin.y > pVec2->y)	vecBoxMin.y = pVec2->y;
	if (vecBoxMin.z > pVec2->z)	vecBoxMin.z = pVec2->z;
	if (vecBoxMax.x < pVec2->x)	vecBoxMax.x = pVec2->x;
	if (vecBoxMax.y < pVec2->y)	vecBoxMax.y = pVec2->y;
	if (vecBoxMax.z < pVec2->z)	vecBoxMax.z = pVec2->z;

	vecBoxMin -= D3DXVECTOR3(fErrorCapacity,fErrorCapacity,fErrorCapacity);
	vecBoxMax += D3DXVECTOR3(fErrorCapacity,fErrorCapacity,fErrorCapacity);

	//	n`̃oEfBO{bNX
	GetBoundingBox(&vecMin, &vecMax);

	//	^ꂽƂ̒n`̃oE_{bNXƂ
	//	Փ˔
	if (!Collide2Box(&vecMin,&vecMax,&vecBoxMin,&vecBoxMax)){
		return	false;
	}

	//	bVʂɃ|S𒊏oB
	numFaces = GetNumFaces();
	dwStride = D3DXGetFVFVertexSize(GetFVF());
	dwMeshFVF = GetFVF();
	GetVertexBuffer(&pVB);
	GetIndexBuffer(&pIB);
	hr = pIB->GetDesc(&ixDesc);

	//	EGCgt_ɂ͑ΉĂȂEEEEAGɂȂ̂邽߁B
	if (dwMeshFVF & ((~D3DFVF_XYZ)&(D3DFVF_XYZB1|D3DFVF_XYZB2|D3DFVF_XYZB3|D3DFVF_XYZB4|D3DFVF_XYZB5)))
		goto	UNSUPPORTED_VERTEX_FORMAT;


	//	\bhProbeTheTriangleDistanceWithSegment2 ɓnۋe덷悵ĂKvB
	fErrorCapacity *= fErrorCapacity;
	if (ixDesc.Format == D3DFMT_INDEX16){
		WORD	*pIx;
		BYTE	*pVertex;
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		UINT	i,j;

		for(i = 0; i < numFaces; ++i){
			for (j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
				D3DXVec3TransformCoord(&vecVertice[j].p,&vecVertice[j].p,&m_matWorld);
			}
			//	|S̃oE_{bNXZo
			BOOL	bHit = TRUE;
			__asm{
				lea	esi, vecVertice;
				lea edi, vecMin;
				lea ebx, vecMax;
				
				mov	eax, dword ptr [esi];
				mov	dword ptr [edi], eax;		/*	pMin->x = pVertices[0].p.x;	*/
				mov	dword ptr [ebx], eax;		/*	pMax->x = pVertices[0].p.x;	*/
				mov	eax, dword ptr [esi+4];
				mov	dword ptr [edi+4], eax;		/*	pMin->y = pVertices[0].p.y;	*/
				mov	dword ptr [ebx+4], eax;		/*	pMax->y = pVertices[0].p.y;	*/
				mov	eax, dword ptr [esi+8];
				mov	dword ptr [edi+8], eax;		/*	pMin->z = pVertices[0].p.z;	*/
				mov	dword ptr [ebx+8], eax;		/*	pMax->z = pVertices[0].p.z;	*/
				add	esi, dwPitch;				/*	pVertices++	*/
				/*if (vecMin.x > pTri[1].p.x)	vecMin.x = pTri[1].p.x;*/
				fld		float ptr [esi];		/*	st(1) = pTri[1].p.x*/
				fld		float ptr [edi];		/*	st(0) = pMin->x;*/
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[1].p.x then st(0):=st(1)*/
				fstp	float ptr [edi];		/*	pMin->x = st(0)*/
				/*if (pMax->x < pTri[1].p.x)	pMax->x = pTri[1].p.x;*/
				fld		float ptr [ebx];		/* st(0) = pMax->x;*/
				fcomi	st,st(1);				/*	*/
				fcmovb	st(0),st(1);			/*	pMax->x < pTri[1].p.x then st(0):=st(1)*/
				fstp	float ptr [ebx];		/*	*/
				fstp	st(0)					/*	*/
				/*if (pMin->y > pTri[1].p.y)	pMin->y = pTri[1].p.y;*/
				fld		[esi+4];				/* st(1) = pTri[1].p.y*/
				fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
				fcomi	st,st(1);				/*	if (pMin->y > pTri[1].p.y) st(0) = pTri[1].p.y;*/
				fcmovnbe	st(0),st(1);
				fstp	float ptr [edi+4];
				/*if (pMax->y < pTri[1].p.y)	pMax->y = pTri[1].p.y;*/
				fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
				fcomi	st,st(1);				/**/
				fcmovb	st(0),st(1);			/*	if pMax->y < pTri[1].p.y st(0) = pTri[1].p.y*/
				fstp	float ptr [ebx+4];
				fstp	st(0)
				/*if (pMin->z > pTri[1].p.z)	pMin->z = pTri[1].p.z;*/
				fld		float ptr [esi+8];		/* st(1) = pTri[1].p.z*/
				fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
				fcomi	st,st(1);				/**/
				fcmovnbe	st(0),st(1);		/*	if pTri[1].p.z > pMin->z st(0) = pTri[1].p.z*/
				fstp	float ptr [edi+8];
				/*if (pMax->z < pTri[1].p.z)	pMax->z = pTri[1].p.z;*/
				fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
				fcomi	st,st(1);	/**/
				fcmovb	st(0),st(1);			/*	if pMax->z < pTri[1].p.z st(0) = pTri[1].x*/
				fstp	float ptr [ebx+8];
				fstp	st(0)

				add	esi, dwPitch;			/*	pVertices++*/
				/*if (vecMin.x > pTri[2].p.x)	vecMin.x = pTri[2].p.x;*/
				fld		float ptr [esi];		/*	st(1) = pTri[2].p.x*/
				fld		float ptr [edi];		/*	st(0) = pMin->x*/;
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[2].p.x then st(0):=st(1)*/
				fstp	float ptr [edi];		/*	pMin->x = st(0)*/
				/*if (pMax->x < pTri[2].p.x)	pMax->x = pTri[2].p.x;*/
				fld		float ptr [ebx];		/* st(0) = pMax->x;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	pMax->x < pTri[2].p.x then st(0):=st(1)*/
				fstp	float ptr [ebx];		/*	*/
				fstp	st(0)					/*	*/
				/*if (pMin->y > pTri[2].p.y)	pMin->y = pTri[2].p.y;*/
				fld		[esi+4];				/* st(1) = pTri[2].p.y*/
				fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
				fcomi	st,st(1);				/*	if (pMin->y > pTri[2].p.y) st(0) = pTri[2].p.y;*/
				fcmovnbe	st(0),st(1);
				fstp	float ptr [edi+4];
				/*if (pMax->y < pTri[2].p.y)	pMax->y = pTri[2].p.y;*/
				fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	if pMax->y < pTri[2].p.y st(0) = pTri[2].p.y*/
				fstp	float ptr [ebx+4];
				fstp	st(0)
				/*if (pMin->z > pTri[2].p.z)	pMin->z = pTri[2].p.z;*/
				fld		float ptr [esi+8];		/* st(1) = pTri[2].p.z*/
				fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	if pTri[2].p.z > pMin->z st(0) = pTri[2].p.z*/
				fstp	float ptr [edi+8];
				/*if (pMax->z < pTri[2].p.z)	pMax->z = pTri[2].p.z;*/
				fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	if pMax->z < pTri[2].p.z st(0) = pTri[2].x*/
				fstp	float ptr [ebx+8];	
				fstp	st(0)

				//	Collide2Box

				fild	bFalse;				//	st(3) := 0
				fild	bHit;				//	st(2) := 1
				lea	esi,	vecMin;
				lea	edi,	vecBoxMax;
				fld	float ptr[edi];			//	st(1):=pMax2->x
				fld	float ptr[esi];			//	st(0):=pMin1->x
				fcomip	st, st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->x > pMax2->x)	then bHit = FALSE;

				fld	float ptr[edi+4];		//	st(1):= pMax2->y
				fld float ptr[esi+4];		//	st(0):= pMin1->y
				fcomip	st,st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->y > pMax2->y)	then bHit = FALSE;	

				fld	float ptr[edi+8];		//	st(1):= pMax2->z
				fld float ptr[esi+8];		//	st(0):= pMin1->z
				fcomip	st,st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->z > pMax2->z)	then bHit = FALSE;	

				lea	esi,	vecMax;
				lea	edi,	vecBoxMin;
				fld	float ptr[edi];			//st(1):=pMin2->x
				fld	float ptr[esi];			//st(0):=pMax1->x
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->x < pMin2->x)	then bHit = FALSE;

				fld	float ptr[edi+4];		//st(1):=pMin2->y
				fld	float ptr[esi+4];		//st(0):=pMax1->y
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->y < pMin2->y)	then bHit = FALSE;

				fld	float ptr[edi+8];		//st(1):=pMin2->z
				fld	float ptr[esi+8];		//st(0):=pMax1->z
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->z < pMin2->z)	then bHit = FALSE;

				fistp	bHit	;
				fstp	st(0)	;
			}
			if (!bHit)
				continue;

			//	Op`Ƃ̓蔻
			if (ProbeTheTriangleDistanceWithSegment2(vecVertice,pVec1,pVec2,fErrorCapacity,&vecTmpOut,&fTmp)){
				if (fTmp < fT){
					fT = fTmp;
					*pVecOut = vecTmpOut;
				}
				bRet = true;
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}else{
		DWORD	*pIx;
		BYTE	*pVertex;
		if (ixDesc.Format != D3DFMT_INDEX32){
			goto	UNSUPPORTED_INDEX_BUFFER;
		}
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		UINT	i,j;

		for(i = 0; i < numFaces; ++i){
			for (j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
				D3DXVec3TransformCoord(&vecVertice[j].p,&vecVertice[j].p,&m_matWorld);
			}
			BOOL	bHit = TRUE;
			__asm{
				lea	esi, vecVertice;
				lea edi, vecMin;
				lea ebx, vecMax;
				
				mov	eax, dword ptr [esi];
				mov	dword ptr [edi], eax;		/*	pMin->x = pVertices[0].p.x;	*/
				mov	dword ptr [ebx], eax;		/*	pMax->x = pVertices[0].p.x;	*/
				mov	eax, dword ptr [esi+4];
				mov	dword ptr [edi+4], eax;		/*	pMin->y = pVertices[0].p.y;	*/
				mov	dword ptr [ebx+4], eax;		/*	pMax->y = pVertices[0].p.y;	*/
				mov	eax, dword ptr [esi+8];
				mov	dword ptr [edi+8], eax;		/*	pMin->z = pVertices[0].p.z;	*/
				mov	dword ptr [ebx+8], eax;		/*	pMax->z = pVertices[0].p.z;	*/
				add	esi, dwPitch;				/*	pVertices++	*/
				/*if (vecMin.x > pTri[1].p.x)	vecMin.x = pTri[1].p.x;*/
				fld		float ptr [esi];		/*	st(1) = pTri[1].p.x*/
				fld		float ptr [edi];		/*	st(0) = pMin->x;*/
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[1].p.x then st(0):=st(1)*/
				fstp	float ptr [edi];		/*	pMin->x = st(0)*/
				/*if (pMax->x < pTri[1].p.x)	pMax->x = pTri[1].p.x;*/
				fld		float ptr [ebx];		/* st(0) = pMax->x;*/
				fcomi	st,st(1);				/*	*/
				fcmovb	st(0),st(1);			/*	pMax->x < pTri[1].p.x then st(0):=st(1)*/
				fstp	float ptr [ebx];		/*	*/
				fstp	st(0)					/*	*/
				/*if (pMin->y > pTri[1].p.y)	pMin->y = pTri[1].p.y;*/
				fld		[esi+4];				/* st(1) = pTri[1].p.y*/
				fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
				fcomi	st,st(1);				/*	if (pMin->y > pTri[1].p.y) st(0) = pTri[1].p.y;*/
				fcmovnbe	st(0),st(1);
				fstp	float ptr [edi+4];
				/*if (pMax->y < pTri[1].p.y)	pMax->y = pTri[1].p.y;*/
				fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
				fcomi	st,st(1);				/**/
				fcmovb	st(0),st(1);			/*	if pMax->y < pTri[1].p.y st(0) = pTri[1].p.y*/
				fstp	float ptr [ebx+4];
				fstp	st(0)
				/*if (pMin->z > pTri[1].p.z)	pMin->z = pTri[1].p.z;*/
				fld		float ptr [esi+8];		/* st(1) = pTri[1].p.z*/
				fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
				fcomi	st,st(1);				/**/
				fcmovnbe	st(0),st(1);		/*	if pTri[1].p.z > pMin->z st(0) = pTri[1].p.z*/
				fstp	float ptr [edi+8];
				/*if (pMax->z < pTri[1].p.z)	pMax->z = pTri[1].p.z;*/
				fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
				fcomi	st,st(1);	/**/
				fcmovb	st(0),st(1);			/*	if pMax->z < pTri[1].p.z st(0) = pTri[1].x*/
				fstp	float ptr [ebx+8];
				fstp	st(0)

				add	esi, dwPitch;			/*	pVertices++*/
				/*if (vecMin.x > pTri[2].p.x)	vecMin.x = pTri[2].p.x;*/
				fld		float ptr [esi];		/*	st(1) = pTri[2].p.x*/
				fld		float ptr [edi];		/*	st(0) = pMin->x*/;
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[2].p.x then st(0):=st(1)*/
				fstp	float ptr [edi];		/*	pMin->x = st(0)*/
				/*if (pMax->x < pTri[2].p.x)	pMax->x = pTri[2].p.x;*/
				fld		float ptr [ebx];		/* st(0) = pMax->x;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	pMax->x < pTri[2].p.x then st(0):=st(1)*/
				fstp	float ptr [ebx];		/*	*/
				fstp	st(0)					/*	*/
				/*if (pMin->y > pTri[2].p.y)	pMin->y = pTri[2].p.y;*/
				fld		[esi+4];				/* st(1) = pTri[2].p.y*/
				fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
				fcomi	st,st(1);				/*	if (pMin->y > pTri[2].p.y) st(0) = pTri[2].p.y;*/
				fcmovnbe	st(0),st(1);
				fstp	float ptr [edi+4];
				/*if (pMax->y < pTri[2].p.y)	pMax->y = pTri[2].p.y;*/
				fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	if pMax->y < pTri[2].p.y st(0) = pTri[2].p.y*/
				fstp	float ptr [ebx+4];
				fstp	st(0)
				/*if (pMin->z > pTri[2].p.z)	pMin->z = pTri[2].p.z;*/
				fld		float ptr [esi+8];		/* st(1) = pTri[2].p.z*/
				fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
				fcomi	st,st(1);				
				fcmovnbe	st(0),st(1);		/*	if pTri[2].p.z > pMin->z st(0) = pTri[2].p.z*/
				fstp	float ptr [edi+8];
				/*if (pMax->z < pTri[2].p.z)	pMax->z = pTri[2].p.z;*/
				fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
				fcomi	st,st(1);				
				fcmovb	st(0),st(1);			/*	if pMax->z < pTri[2].p.z st(0) = pTri[2].x*/
				fstp	float ptr [ebx+8];	
				fstp	st(0)

				//	Collide2Box

				fild	bFalse;				//	st(3) := 0
				fild	bHit;				//	st(2) := 1
				lea	esi,	vecMin;
				lea	edi,	vecBoxMax;
				fld	float ptr[edi];			//	st(1):=pMax2->x
				fld	float ptr[esi];			//	st(0):=pMin1->x
				fcomip	st, st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->x > pMax2->x)	then bHit = FALSE;

				fld	float ptr[edi+4];		//	st(1):= pMax2->y
				fld float ptr[esi+4];		//	st(0):= pMin1->y
				fcomip	st,st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->y > pMax2->y)	then bHit = FALSE;	

				fld	float ptr[edi+8];		//	st(1):= pMax2->z
				fld float ptr[esi+8];		//	st(0):= pMin1->z
				fcomip	st,st(1);
				fstp	st(0);
				fcmovnbe	st(0),st(1);	//	if (pMin1->z > pMax2->z)	then bHit = FALSE;	

				lea	esi,	vecMax;
				lea	edi,	vecBoxMin;
				fld	float ptr[edi];			//st(1):=pMin2->x
				fld	float ptr[esi];			//st(0):=pMax1->x
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->x < pMin2->x)	then bHit = FALSE;

				fld	float ptr[edi+4];		//st(1):=pMin2->y
				fld	float ptr[esi+4];		//st(0):=pMax1->y
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->y < pMin2->y)	then bHit = FALSE;

				fld	float ptr[edi+8];		//st(1):=pMin2->z
				fld	float ptr[esi+8];		//st(0):=pMax1->z
				fcomip	st,st(1);
				fstp	st(0);
				fcmovb	st(0),st(1);		//	if (pMax1->z < pMin2->z)	then bHit = FALSE;

				fistp	bHit	;
				fstp	st(0)	;
			}
			if (!bHit)
				continue;
			//	Op`Ƃ̓蔻
			if (ProbeTheTriangleDistanceWithSegment2(vecVertice,pVec1,pVec2,fErrorCapacity,&vecTmpOut,&fTmp)){
				if (fTmp < fT){
					fT = fTmp;
					*pVecOut = vecTmpOut;
				}
				bRet = true;
			}
		}
		pVB->Unlock();
		pIB->Unlock();

	}
UNSUPPORTED_INDEX_BUFFER:
UNSUPPORTED_VERTEX_FORMAT:
	SAFE_RELEASE(pIB);
	SAFE_RELEASE(pVB);
	return	bRet;
}

//-------------------------------------------------------------
//	Name: ProbeTheTriangleDistanceWithSegment2
//  Desc: w肳ꂽƃ|SƂ̓蔻B
//		̍WńA[hWnɓꂳ
//		Ȃ΂ȂȂB
//	pTri[3]  Op|S
//	pvec1    ̋N_
//  pvec2    ̏I_
//	fErrorCapacity  |SGbWł̋e덷iꂪƁA|ŠpڂŔj
//  pVecOut   Փ˓_
//  pT        ̏Փ˓_܂ł̔䗦  vecOut = vec1 + (vec2 - vec1)*t
//-------------------------------------------------------------
BOOL	CWall::ProbeTheTriangleDistanceWithSegment2(WALLCOLLISIONVERTEX *pTri, D3DXVECTOR3 *pvec1, D3DXVECTOR3 *pvec2, FLOAT fErrorCapacity, D3DXVECTOR3 *pVecOut, FLOAT *pT)
{
    //  ʂӖ
    //  V = V1 + (V2-V1)u + (V3-V1)v@
    //  ̕
    //  V = Vp + Vr*t  
    //  @(V2-V1)u + (V3 - V1)v + (-Vr)t = Vp - V1
    //   u, v, t ɂĉ𓾂鎖ŁA_ZoB

    double D,D1,D2,D3;
    
    FLOAT    a,b,c,d;
    FLOAT    e,f,g,h;
    FLOAT    i,j,k,l;
	D3DXVECTOR3	vr = *pvec2 - *pvec1;
    a = pTri[1].p.x - pTri[0].p.x;
    b = pTri[2].p.x - pTri[0].p.x;
    c = -vr.x;
    d = pvec1->x - pTri[0].p.x;

    e = pTri[1].p.y - pTri[0].p.y;
    f = pTri[2].p.y - pTri[0].p.y;
    g = -vr.y;
    h = pvec1->y - pTri[0].p.y;

    i = pTri[1].p.z - pTri[0].p.z;
    j = pTri[2].p.z - pTri[0].p.z;
    k = -vr.z;
    l = pvec1->z - pTri[0].p.z;


	D = a*f*k + e*j*c + b*g*i - c*f*i - b*e*k - a*j*g;
    if (fabs(D) < FLT_MIN){
        //    _ꍇ
		*pT = 0;
		*pVecOut = *pvec1;
		return    false;
    }


	D1 = d*f*k + h*j*c + b*g*l - c*f*l - b*h*k - d*j*g;
	D2 = a*h*k + e*l*c + d*g*i - c*h*i - d*e*k - a*l*g;
	D3 = a*f*l + e*j*d + b*h*i - d*f*i - b*e*l - a*j*h;

    D = 1.0f/D;
	FLOAT	u,v,t;
	u = (FLOAT)(D1 * D);
    v = (FLOAT)(D2 * D);
	t = (FLOAT)(D3 * D);

	D3DXVECTOR3	vecOut(a*u+b*v,e*u+f*v,i*u+j*v);
	vecOut += pTri[0].p;
	*pT = t;
	*pVecOut = vecOut;
	if ( t < 0 || t > 1.0f)
		return	false;
	if ( u >= 0 && v >= 0 && (u+v) <= 1.0f){
		return	true;
	}
	if ( u < 0 && v < 0){
		if (D3DXVec3LengthSq(&(vecOut - pTri[0].p)) < fErrorCapacity)
			return	true;
	}else if ( u > 1.0f && v < 0.0f){
		if (D3DXVec3LengthSq(&(vecOut - pTri[1].p)) < fErrorCapacity)
			return	true;
	}else if ( u < 0.0f && v > 1.0f){
		if (D3DXVec3LengthSq(&(vecOut - pTri[2].p)) < fErrorCapacity)
			return	true;
	}else if ( u >= 0.0f && v < 0.0f){
		D3DXVECTOR3	vecTmp = pTri[1].p - pTri[0].p;
		vecOut -= pTri[0].p;
		//	􉽓IɌāA͔œoĂ
		FLOAT	n = D3DXVec3Dot(&vecTmp, &vecOut);
		n /= D3DXVec3LengthSq(&vecTmp);
		if (D3DXVec3LengthSq(&(vecOut - n*vecTmp)) < fErrorCapacity)
			return true;
	}else if ( u < 0.0f && v >= 0.0f){
		D3DXVECTOR3	vecTmp = pTri[2].p - pTri[0].p;
		vecOut -= pTri[0].p;
		//	􉽓IɌāA͔œoĂ
		FLOAT	n = D3DXVec3Dot(&vecTmp, &vecOut);
		n /= D3DXVec3LengthSq(&vecTmp);
		if (D3DXVec3LengthSq(&(vecOut - n*vecTmp)) < fErrorCapacity)
			return true;
	}else{
		D3DXVECTOR3	vecTmp = pTri[2].p - pTri[1].p;
		vecOut -= pTri[1].p;
		//	􉽓IɌāA͔œoĂ
		FLOAT	n = D3DXVec3Dot(&vecTmp, &vecOut);
		n /= D3DXVec3LengthSq(&vecTmp);
		if (D3DXVec3LengthSq(&(vecOut - n*vecTmp)) < fErrorCapacity)
			return true;
	}
	return false;
}


#if	0
//	sv
void	CWall::ProbeTheTriangleNearestPosition(WALLCOLLISIONVERTEX *pTri, D3DXVECTOR3 *pPos, D3DXVECTOR3 *pPosOut)
{
	D3DXVECTOR3	vecMin, vecMax, vecTmp, vecPos;
	FLOAT		len1, len2, len3, dx, dy, dz;
	FLOAT		fDist,fTmp;
	BOOL	bF0=false, bF1=false, bF2=false;
	D3DXVECTOR3	vecNormal, vecDir1, vecDir2;
	WALLCOLLISIONVERTEX	vTmp;

	vecPos = *pPos;

	//	eӂ̒ZoB
	dx = pTri[1].p.x - pTri[0].p.x;
	dy = pTri[1].p.y - pTri[0].p.y;
	dz = pTri[1].p.z - pTri[0].p.z;
	len1 = dx * dx + dy * dy + dz * dz;
	dx = pTri[2].p.x - pTri[1].p.x;
	dy = pTri[2].p.y - pTri[1].p.y;
	dz = pTri[2].p.z - pTri[1].p.z;
	len2 = dx * dx + dy * dy + dz * dz;
	dx = pTri[0].p.x - pTri[2].p.x;
	dy = pTri[0].p.y - pTri[2].p.y;
	dz = pTri[0].p.z - pTri[2].p.z;
	len3 = dx * dx + dy * dy + dz * dz;

	//	|Sȏ傫̂ݔΏۂƂB
	if ((fabs(len1) >= FLT_MIN)&&(fabs(len2) >= FLT_MIN)&&(fabs(len3) >= FLT_MIN)){

		//	ʖ@ZoB
		vecDir1 = pTri[1].p - pTri[0].p;
		vecDir2 = pTri[2].p - pTri[0].p;
		D3DXVec3Cross(&vecNormal,&vecDir1,&vecDir2);

		//	ʖ@ZołȂ́AŒZ_̓|S̕ӏ
		if ((fabs(vecNormal.x) + fabs(vecNormal.y) + fabs(vecNormal.z) ) <= FLT_MIN)
			goto	TRIANGLE_HAS_NO_AREA;
		
		//	ʖ@𐳋K
		D3DXVec3Normalize(&vecNormal,&vecNormal);

		vecDir1 = vecPos - pTri[0].p;
		vecDir2 = vecNormal;
		fDist = D3DXVec3Dot(&vecDir1,&vecDir2);

		//	ʏ̍ŋߓ_߂
		*pPosOut = vecPos - (vecNormal * fDist);

		vecDir1 = vecPos - pTri[0].p;
		vecDir2 = pTri[1].p - pTri[0].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		fTmp = D3DXVec3Dot(&vecTmp,&vecNormal);
		if (fTmp > -FLT_MIN){
			bF0=TRUE;
		}
		vecDir1 = vecPos - pTri[1].p;
		vecDir2 = pTri[2].p - pTri[1].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		fTmp = D3DXVec3Dot(&vecTmp,&vecNormal);
		if (fTmp > -FLT_MIN){
			bF1=TRUE;
		}

		vecDir1 = vecPos - pTri[2].p;
		vecDir2 = pTri[0].p - pTri[2].p;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		fTmp = D3DXVec3Dot(&vecTmp,&vecNormal);
		if (fTmp > -FLT_MIN){
			bF2=TRUE;
		}

		if (!bF0 && !bF1 && !bF2){
			return;
		}
		fDist = FLT_MAX;
		D3DXVECTOR3	vecPosTmp;	
		if (bF0){
			CalcNearestPosition(&vecPos,&pTri[1], &pTri[0], &vecPosTmp, &fTmp);
			//CalcShortestDistance(&vecPos,&pTri[1], &pTri[0], &fTmp,pNormal);
			if (fTmp < fDist){
				*pPosOut = vecPosTmp;
				fDist = fTmp;
			}
		}
		if (bF1){
			CalcNearestPosition(&vecPos,&pTri[2], &pTri[1], &vecPosTmp, &fTmp);
			//CalcShortestDistance(&vecPos,&pTri[2], &pTri[1], &fTmp,pNormal);
			if (fTmp < fDist){
				*pPosOut = vecPosTmp;
				fDist = fTmp;
			}
		}
		if (bF2){
			CalcNearestPosition(&vecPos,&pTri[0], &pTri[2], &vecPosTmp, &fTmp);
			//CalcShortestDistance(&vecPos,&pTri[0], &pTri[2], &fTmp,pNormal);
			if (fTmp < fDist){
				*pPosOut = vecPosTmp;
				fDist = fTmp;
			}
		}
		if (fDist < FLT_MAX){
			fDist = (FLOAT)sqrt(fDist);

			return;
		}
	}
TRIANGLE_HAS_NO_AREA:
	//	|Sɗ
	FLOAT	fDistTmp, fDistMin;
	D3DXVECTOR3	vecPosTmp;

	CalcNearestPosition(&vecPos,&pTri[1], &pTri[0], pPosOut,&fDistMin);
	CalcNearestPosition(&vecPos,&pTri[2], &pTri[1], &vecPosTmp, &fDistTmp);
	if (fDistTmp < fDistMin){
		*pPosOut = vecPosTmp;
		fDistMin = fDistTmp;
	}
	CalcNearestPosition(&vecPos,&pTri[0], &pTri[2], &vecPosTmp, &fDistTmp);
	if (fDistTmp < fDistMin){
		*pPosOut = vecPosTmp;
		fDistMin = fDistTmp;
	}

	fDist = sqrt(fDistMin);
	return;
}


//-------------------------------------------------------------
//	Name: CalcNearestPosition
//  Desc: w肳ꂽƁA_Ƃ̊Ԃ̍ŏ߂B
//		͂RcōsȂB
//	param:
//		vecPos v[uW
//		vecP1  WP
//		vecP2  WQ
//		pPosOut  ŋߓ_
//		pDist  ŏ
//-------------------------------------------------------------
void	CWall::CalcNearestPosition(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, D3DXVECTOR3 *pPosOut, float *pDist){
	double	t;
	double	dx1, dy1, dz1, dx2, dy2, dz2;
	double	len, len1, len2;	
	double	px, py, pz;

	dx1 = vecP2->p.x - vecP1->p.x;
	dy1 = vecP2->p.y - vecP1->p.y;
	dz1 = vecP2->p.z - vecP1->p.z;

	dx2 = vecP1->p.x - vecPos->x;
	dy2 = vecP1->p.y - vecPos->y;
	dz2 = vecP1->p.z - vecPos->z;

	len = dx1*dx1 + dy1*dy1 + dz1*dz1;
	if (len < FLT_MIN){
		*pDist = (float)(dx2*dx2 + dy2*dy2 + dz2 * dz2);
		*pPosOut = vecP1->p;
		return;
	}

	//	̔Cӂ̓_vecPos Ŏ_Ƃ̋A
	//	Zo鎮āA
	//	ꂪOɂȂ_߂ƁAŒZł_
	//	߂鎖łB
	t = -(dx1 * dx2 + dy1*dy2 + dz1*dz2);
	t /= len;
	if ((t >= 0.0f) && (t <= 1.0f)){
		//	̓_ŏꍇ

		//	ŏƂȂP1-P2 ̓_߂
		px = vecP1->p.x + (dx1*t);
		py = vecP1->p.y + (dy1*t);
		pz = vecP1->p.z + (dz1*t);
		pPosOut->x = (FLOAT)px;
		pPosOut->y = (FLOAT)py;
		pPosOut->z = (FLOAT)pz;
		//	߂ꂽ_Ƃ̋Zo
		dx1 = px - vecPos->x;		//	߂ꂽ_Ƃ
		dy1 = py - vecPos->y;		//	Zo
		dz1 = pz - vecPos->z;		//
		len = dx1*dx1 + dy1*dy1 + dz1*dz1;
		*pDist = (float)len;		//	Ăяo
		return;
	}else{
		//	ꂩ̒_ŏłꍇB
		dx1  = vecP2->p.x - vecPos->x;
		dy1  = vecP2->p.y - vecPos->y;
		dz1 = vecP2->p.z - vecPos->z;
		len1  = dx2*dx2 + dy2 * dy2 + dz2*dz2;	//	P1 ܂ł̋
		len2 = dx1*dx1 + dy1 * dy1 + dz1*dz1;	//	P2 ܂ł̋
		if ( len2 < len1 ){
			//	P2܂ł̋ƁAP2 ̍xԂ
			*pDist = (float)len2;
			*pPosOut = vecP2->p;
			return;
		}
		//	P1 ܂ł̋ƁAP1 ̍xԂ
		*pDist   = (float)len1;
		*pPosOut = vecP1->p;
	}
	return;
}

#endif
