#include "StdAfx.h"
#include <d3dx9.h>
#include <dxfile.h>
#include <tchar.h>
#include <crtdbg.h>
#include "D3DQuickLib.h"
#include ".\vertexshaderfrommemory.h"

CVertexShaderFromMemory::CVertexShaderFromMemory(CD3DEnv *pEnv, const unsigned char *pData, int len, GUID guid)
:CShaderContainer(pEnv,guid)
{
	m_pData = (unsigned char*)pData;
	m_iLen = len;
	m_pVertexShader = NULL;
}

CVertexShaderFromMemory::~CVertexShaderFromMemory(void)
{
	InvalidateDeviceObjects();
}

HRESULT CVertexShaderFromMemory::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	if (m_pVertexShader != NULL)
		return	S_OK;	//	No need to Restore
	lpd3ddev->CreateVertexShader((DWORD*)m_pData,&m_pVertexShader);
	return	S_OK;
}

HRESULT CVertexShaderFromMemory::InvalidateDeviceObjects(){
	SAFE_RELEASE(m_pVertexShader);
	return	S_OK;
}

LPDIRECT3DVERTEXSHADER9 CVertexShaderFromMemory::GetDXVertexShader(){
	return	m_pVertexShader;
}
