#include "stdafx.h"
#include <d3dx9.h>
#include <dxfile.h>
#include <tchar.h>
#include "TextureDB.h"

CTextureDB::CTextureDB(){
	m_pSentinel = NULL;
	m_pNode = NULL;
	if (NULL != (m_pSentinel = new CTextureNode(""))){
		m_pSentinel->m_pLeft = m_pSentinel;
		m_pSentinel->m_pRight = m_pSentinel;
		m_pSentinel->m_ppParent = NULL;
		m_pSentinel->m_pTextureDB = this;
		m_pNode = m_pSentinel;
	}
	dwNumNodes = 0L;
	dwUnique = 0L;
}

CTextureDB::~CTextureDB(){
	if (m_pNode != NULL){
		InvalidateObjectsOfDecendants(m_pNode);
		DeleteDecendants(m_pNode);
		if(m_pSentinel->m_strFilename != NULL){
			delete[]	m_pSentinel->m_strFilename;
			m_pSentinel->m_strFilename = NULL;
		}
		if (m_pSentinel != NULL){
			delete	m_pSentinel;
			m_pSentinel = NULL;
		}
	}
}

void CTextureDB::DeleteDecendants(CTextureNode *pNode){
	if (pNode == m_pSentinel)
		return;
	DeleteDecendants(pNode->m_pLeft);
	DeleteDecendants(pNode->m_pRight);
	delete	pNode;
}

void	CTextureDB::DeleteTheNode(CTextureNode *pNode){

	if (pNode == this->m_pSentinel)
		return;		//	ԕ͂̊֐ł͍폜s\
	//	񕪖؂̐؂藣ivoO`FbNj
	if (pNode->m_pLeft == m_pSentinel){
		pNode->m_pRight->m_ppParent = pNode->m_ppParent;
		*(pNode->m_ppParent) = pNode->m_pRight;
	}else if (pNode->m_pRight == m_pSentinel){
		pNode->m_pLeft->m_ppParent = pNode->m_ppParent;
		*(pNode->m_ppParent) = pNode->m_pLeft;
	}else{
		CTextureNode	*q,*r;	//	q:ړm[h
		q = pNode->m_pRight;	//	pNode:폜m[h
		r = NULL;
		while(q->m_pLeft != m_pSentinel){
			r = q;
			q = q->m_pLeft;
		}
		*(pNode->m_ppParent) = q;
		q->m_ppParent = pNode->m_ppParent;

		if (r != NULL){
			r->m_pLeft = q->m_pRight;
			r->m_pLeft->m_ppParent = &(r->m_pLeft);
			q->m_pRight = pNode->m_pRight;
			q->m_pRight->m_ppParent = &(q->m_pRight);
		}
		q->m_pLeft = pNode->m_pLeft;
		q->m_pLeft->m_ppParent = &(q->m_pLeft);
	}
	//	eNX`̏
	if (NULL != pNode->m_pTexture){
		pNode->m_pTexture->Release();
		pNode->m_pTexture = NULL;
	}
	--dwNumNodes;
	delete	pNode->m_strFilename;
	delete	pNode;
}

HRESULT	CTextureDB::RestoreObjectsOfDecendants(LPDIRECT3DDEVICE9 lpd3ddev,CTextureNode *pNode)
{
	HRESULT	hr1, hr2, hr3;

	if (pNode == this->m_pSentinel){
		return S_OK;
	}
	hr1 = RestoreObjectsOfDecendants(lpd3ddev,pNode->m_pLeft);
	hr2 = RestoreObjectsOfDecendants(lpd3ddev,pNode->m_pRight);
	hr3 = S_OK;
	if (pNode->m_pTexture == NULL){
		hr3 = D3DXCreateTextureFromFile( lpd3ddev, 
					pNode->m_strFilename, 
					&pNode->m_pTexture );
	}
	if (FAILED(hr3)){
		pNode->m_pTexture = NULL;
		return	hr3;
	}
	if (FAILED(hr1)){
		return	hr1;
	}
	if (FAILED(hr2)){
		return	hr2;
	}
	return	S_OK;
}

HRESULT	CTextureDB::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	return RestoreObjectsOfDecendants(lpd3ddev,this->m_pNode);
}

HRESULT CTextureDB::InvalidateObjectsOfDecendants(CTextureNode *pNode)
{
	if (pNode == m_pSentinel)
		return S_OK;
	
	InvalidateObjectsOfDecendants(pNode->m_pLeft);
	InvalidateObjectsOfDecendants(pNode->m_pRight);
	if ( pNode->m_pTexture != NULL){
		pNode->m_pTexture->Release();
		pNode->m_pTexture = NULL;
	}
	return	S_OK;
}

HRESULT	CTextureDB::InvalidateDeviceObjects()
{
	return InvalidateObjectsOfDecendants(this->m_pNode);
}


//=====================================================================
// Name: RegisterNewKey
// Desc: L[l̓o^AԒlFtrue Vm[h false:L[lo^ς
// Note: L[lNULL ͋󕶎̏ꍇ́ApRet  NULL Ԃ
//=====================================================================
BOOL CTextureDB::RegisterNewKey(LPSTR key,CTextureNode **pRet){
	CTextureNode **pNode;
	int		f;
	int		len;
	if ((key == NULL)||(key[0] == '\0')){
		*pRet = NULL;
		return	false;
	}
	if (m_pSentinel->m_strFilename != NULL){
		delete[]	m_pSentinel->m_strFilename;
		m_pSentinel->m_strFilename = NULL;
	}
	len = _tcslen(key)+1;
	if (NULL == (m_pSentinel->m_strFilename = new TCHAR[len])){
		*pRet = NULL;	//	sŃG[
		return	false;	//
	}
	_tcscpy_s(m_pSentinel->m_strFilename,len,key);
	pNode = &m_pNode;
	while((f = _tcscmp(key,(*pNode)->m_strFilename))!=0){
		if (f < 0)
			pNode = &((*pNode)->m_pLeft);
		else
			pNode = &((*pNode)->m_pLeft);
	}
	if ((*pNode) != m_pSentinel){
		(*pNode)->m_iRefCount++;
		*pRet = *pNode;
		return	false;
	}
	CTextureNode *newNode;
	newNode = new CTextureNode(key);
	if (newNode == NULL){
		*pRet = NULL;
		return	false;
	}
	newNode->m_ppParent = pNode;
	newNode->m_pLeft = m_pSentinel;
	newNode->m_pRight = m_pSentinel;
	newNode->m_pTextureDB = this;
	*pNode = newNode;
	++dwUnique;
	++dwNumNodes;
	*pRet = newNode;
	return	true;
}

//=====================================================================
// Name: Release
// Desc: eNX`̎gpI
//=====================================================================
void	CTextureNode::Release(){
	if (0 >= --m_iRefCount){
		if (m_pTexture != NULL){
			m_pTexture->Release();
			m_pTexture = NULL;
		}
		this->m_pTextureDB->DeleteTheNode(this);
	}
}
