//-----------------------------------------------------------------------
//	class CSkinMeshFrameTracker
//
//	o^ꂽSkinnedMesh ̖̒̓̂ FRAME Aێ
//	ׂ̃NXB Device Lost AȂǂAێ鎖łB
//------------------------------------------------------------------------
#include "stdafx.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "d3d9env.h"
#include "SkinMeshFrameTracker.h"


//
//	RXgN^
//	: pEnv     : `
//	      pMesh    : ǐՑΏۂCSkinnedMesh
//	      pStrName : Frame 
//
CSkinMeshFrameTracker::CSkinMeshFrameTracker(CD3DEnv *pEnv, CSkinnedMesh *pMesh, TCHAR *pStrName)
{
	m_pTargetMesh = pMesh;
	m_pParentFrame = NULL;
	m_pTargetFrame = NULL;
	int	len = _tcslen(pStrName)+1;
	m_strTargetName = new TCHAR[len];
	_tcscpy_s(m_strTargetName,len,pStrName);
	m_pD3DEnv = pEnv;
	pEnv->AddGraphicsObject(this);
}

CSkinMeshFrameTracker::~CSkinMeshFrameTracker()
{
	delete	m_strTargetName;
	m_pD3DEnv->RemoveGraphicsObject(this);
}

HRESULT	CSkinMeshFrameTracker::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	if (m_pParentFrame != NULL && m_pTargetFrame != NULL)
		return S_OK;
	if (m_pTargetMesh != NULL && m_pTargetMesh->m_pFrameRoot != NULL)
		FindFrame(m_pTargetMesh->m_pFrameRoot, NULL);
	return	S_OK;
}

//----------------------------------------------------------------
//	Name : FindFrame
//	Desc : o^ꂽOƈv閼OFrame TB
//----------------------------------------------------------------
BOOL	CSkinMeshFrameTracker::FindFrame(LPD3DXFRAME pFrame, LPD3DXFRAME pFrameParent){
	
	if (_tcscmp(pFrame->Name,this->m_strTargetName) == 0){
		m_pTargetFrame = (SKINNEDMESH_FRAME*)pFrame;
		m_pParentFrame = (SKINNEDMESH_FRAME*)pFrameParent;
		return	TRUE;
	}
	BOOL	bResult = FALSE;
    if (pFrame->pFrameSibling != NULL)
    {
        bResult = FindFrame(pFrame->pFrameSibling, pFrameParent);
    }

    if (!bResult && pFrame->pFrameFirstChild != NULL)
    {
        bResult = FindFrame(pFrame->pFrameFirstChild, pFrame);
    }

	return	bResult;
}

HRESULT	CSkinMeshFrameTracker::InvalidateDeviceObjects(){
	m_pParentFrame = NULL;
	m_pTargetFrame = NULL;
	return	S_OK;
}

//-----------------------------------------------
//	Name : GetFrame
//	Desc : ǐՂĂFrame ւ̃|C^Ԃ
//-----------------------------------------------
LPD3DXFRAME	CSkinMeshFrameTracker::GetFrame(){
	return	(LPD3DXFRAME)m_pTargetFrame;
}

//-----------------------------------------------
//	Name : GetParentFrame
//	Desc : ǐՂĂFrame ̐et[ւ
//		|C^Ԃ
//-----------------------------------------------
LPD3DXFRAME	CSkinMeshFrameTracker::GetParentFrame(){
	return	(LPD3DXFRAME)m_pParentFrame;
}

//-----------------------------------------------
//	Name : GetFrameMatrix
//	Desc : ǐՂĂFrame ̕ϊsԂ
//-----------------------------------------------
HRESULT	CSkinMeshFrameTracker::GetFrameMatrix(LPD3DXMATRIX pMat){
	if (m_pTargetFrame == NULL)
		return	E_FAIL;
	*pMat = m_pTargetFrame->CombinedTransformationMatrix;
	return	S_OK;
}

//----------------------------------------------------------
//	Name : GetParentFrameMatrix
//	Desc : ǐՂĂFrame ̐e Frame ̕ϊsԂ
//----------------------------------------------------------
HRESULT	CSkinMeshFrameTracker::GetParentFrameMatrix(LPD3DXMATRIX pMat){
	if (m_pParentFrame == NULL)
		return	E_FAIL;
	*pMat = m_pParentFrame->CombinedTransformationMatrix;
	return	S_OK;
}
