#include "StdAfx.h"
#include <d3dx9.h>
#include <dxfile.h>
#include <tchar.h>
#include <crtdbg.h>
#include "d3d9env.h"
#include ".\pixelshaderfrommemory.h"

CPixelShaderFromMemory::CPixelShaderFromMemory(CD3DEnv *pEnv, const unsigned char *pData, int len, GUID guid)
: CShaderContainer(pEnv,guid)
{
	m_pData = (unsigned char*)pData;
	m_iLen = len;
	m_pPixelShader = NULL;
}

CPixelShaderFromMemory::~CPixelShaderFromMemory(void)
{
	InvalidateDeviceObjects();
}

HRESULT	CPixelShaderFromMemory::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	if (m_pPixelShader != NULL)
		return	S_OK;
	return	lpd3ddev->CreatePixelShader((DWORD*)m_pData,&m_pPixelShader);
}

HRESULT	CPixelShaderFromMemory::InvalidateDeviceObjects(){
	SAFE_RELEASE(m_pPixelShader);
	return	S_OK;
}

LPDIRECT3DPIXELSHADER9 CPixelShaderFromMemory::GetDXPixelShader(){
	return	m_pPixelShader;
}
