
#include "stdafx.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "d3d9env.h"
#include <tchar.h>
#include "Mesh.h"
#include "ShaderContainer.h"
#include "OTScrollMesh.h"
#include "TextureDB.h"


COTScrollMesh::COTScrollMesh(CD3DEnv *pEnv, TCHAR *fname) : COTMesh(pEnv, fname)
{
	m_fU = 0;
	m_fV = 0;
	m_fFogStart = 1.0f;	//	Disable the fog	
	m_fFogEnd = 0.0f;
	m_pShader = pEnv->GetShaderContainer(__uuidof(CLSID_ScrollMeshVS));
}

COTScrollMesh::~COTScrollMesh(void)
{
	SAFE_RELEASE(m_pShader);
}

void	COTScrollMesh::SetUV(FLOAT u, FLOAT v){
	u = u - (FLOAT)((int)u);
	v = v - (FLOAT)((int)v);
	m_fU = u;
	m_fV = v;
}

HRESULT	COTScrollMesh::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
    LPD3DXMESH pTempMesh;
	HRESULT	hr;
	if (m_pMeshSysMem != NULL
		&& m_pAttribTableRemap != NULL
		&& m_pMeshAttributeRange != NULL){
		m_uiMeshStatus = MESH_IS_INITIALIZED;
		return	S_OK;
	}
	hr = COTMesh::InitDeviceObjects(lpd3ddev);
    // _tH[}bg̏CE_VF[_ɍ킹B_J[ɂ͑ΉĂȂB
    if( SUCCEEDED(hr) && m_pMeshSysMem!= NULL)
    {
        hr = m_pMeshSysMem->CloneMeshFVF( m_pMeshSysMem->GetOptions(), 
                                          (m_pMeshSysMem->GetFVF() &  D3DFVF_POSITION_MASK) | D3DFVF_NORMAL | D3DFVF_TEX1, 
                                          lpd3ddev, &pTempMesh );
		if (SUCCEEDED(hr)){
			m_pMeshSysMem->Release();
			m_pMeshSysMem = pTempMesh;
		}
    }
	return	hr;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void    COTScrollMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX	*pMatWorld)
{
	D3DXMATRIX	matWorldView = *pMatWorld * *m_lpD3DEnv->GetSystemView();
	if (m_pMeshSysMem == NULL)
		return;
#if	0
	//	݂̌Œ蒸_VF[_́Asɂ]̂ݑΉĂlłA
	//	ł̓_
	D3DXMATRIX	matTmp;
	D3DXMatrixTranslation(&matTmp,m_fU,m_fV,0.0f);
	lpd3ddev->SetTextureStageState(0,D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );
	lpd3ddev->SetTransform(D3DTS_TEXTURE0,&matTmp);
	COTMesh::Render(lpd3ddev,&matWorldView);
	D3DXMatrixIdentity(&matTmp);
	lpd3ddev->SetTransform(D3DTS_TEXTURE0,&matTmp);
	lpd3ddev->SetTextureStageState(0,D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );
#else
	lpd3ddev->SetVertexShader(m_pShader->GetDXVertexShader());
	D3DXMATRIX	matTmp;

    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);
	lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}

	lpd3ddev->SetSamplerState( 0, D3DSAMP_ADDRESSU,D3DTADDRESS_WRAP);
	lpd3ddev->SetSamplerState( 0, D3DSAMP_ADDRESSV,D3DTADDRESS_WRAP);
	lpd3ddev->SetRenderState( D3DRS_WRAP0, 0);

	DWORD	dwFaceIx = 0;
	DWORD	dwNumFaces;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	D3DINDEXBUFFER_DESC	ixDesc;
	HRESULT	hr;
	DWORD	dwNumWholeVertices = m_pMeshSysMem->GetNumVertices();
	if (FAILED(m_pMeshSysMem->GetVertexBuffer(&pVB))
	|| FAILED(m_pMeshSysMem->GetIndexBuffer(&pIB))){
		SAFE_RELEASE(pVB);
		SAFE_RELEASE(pIB);	
		return;
	}

	hr = pIB->GetDesc(&ixDesc);
	float	fOneOverThree = 1.0f / 3.0f;
	D3DXVECTOR3	vecTmp;
	DWORD	dwStride = D3DXGetFVFVertexSize(m_pMeshSysMem->GetFVF());
	lpd3ddev->SetFVF(m_pMeshSysMem->GetFVF());
	FLOAT	fZ;
	UINT	ix,i,j,k;
	UINT	dwOrderingTableIndex = 0;
    int		matNo;
	//	_VF[_萔ݒɎgp
    D3DXVECTOR4 vConst0( 0.0f, 0.0f, 0.0f, 0.0f );
    D3DXVECTOR4 vConst1( 1.0f, 0.5f, 2.0f, 4.0f );
	D3DXVECTOR4	vLightDir;

	OrderingTable	*pOT = m_lpD3DEnv->GetOT();
	if (pOT == NULL)
		return;

	if (ixDesc.Format == D3DFMT_INDEX16){
		WORD	*pIx;
		BYTE	*pVertex;
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);
		for( i = 0; i < m_dwNumMaterials; i++ ){
			j = m_pAttribTableRemap[i];
			if (j >= m_dwNumMaterials)
				continue;
			dwNumFaces = m_pMeshAttributeRange[j].FaceCount;
			k = m_pMeshAttributeRange[j].FaceStart;
			k *= 3;
			for (j = 0; j < dwNumFaces ; ++j){
				pOT[dwOrderingTableIndex].m_usMaterial = i;
				pOT[dwOrderingTableIndex].m_usIndex = k;
				ix = pIx[k++];
				vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
				D3DXVec3TransformCoord(&vecTmp,&vecTmp,&matWorldView);
				fZ = vecTmp.z;
				ix = pIx[k++];
				vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
				D3DXVec3TransformCoord(&vecTmp,&vecTmp,&matWorldView);
				fZ += vecTmp.z;
				ix = pIx[k++];
				vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
				D3DXVec3TransformCoord(&vecTmp,&vecTmp,&matWorldView);
				fZ += vecTmp.z;
				fZ *= fOneOverThree;
				pOT[dwOrderingTableIndex++].m_fZ = fZ;
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}else if (ixDesc.Format == D3DFMT_INDEX32){
		DWORD	*pIx;
		BYTE	*pVertex;
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);
		for( i = 0; i < m_dwNumMaterials; i++ ){
			j = m_pAttribTableRemap[i];
			if (j >= m_dwNumMaterials)
				continue;
			dwNumFaces = m_pMeshAttributeRange[j].FaceCount;
			k = m_pMeshAttributeRange[j].FaceStart;
			k *= 3;
			for (j = 0; j < dwNumFaces ; ++j){
				pOT[dwOrderingTableIndex].m_usMaterial = i;
				pOT[dwOrderingTableIndex].m_usIndex = k;
				ix = pIx[k++];
				vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
				D3DXVec3TransformCoord(&vecTmp,&vecTmp,&matWorldView);
				fZ = vecTmp.z;
				ix = pIx[k++];
				vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
				D3DXVec3TransformCoord(&vecTmp,&vecTmp,&matWorldView);
				fZ += vecTmp.z;
				ix = pIx[k++];
				vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
				D3DXVec3TransformCoord(&vecTmp,&vecTmp,&matWorldView);
				fZ += vecTmp.z;
				fZ *= fOneOverThree;
				pOT[dwOrderingTableIndex++].m_fZ = fZ;
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}else{
		goto	unsupported_index_format;
	}

	qsort((void*)pOT,dwOrderingTableIndex,sizeof(OrderingTable),COTMesh::CompareMeshZSort);

	//	Set Common Vertex Shader Constant
    lpd3ddev->SetVertexShaderConstantF(0, (float*)&vConst0, 1);
    lpd3ddev->SetVertexShaderConstantF(1, (float*)&vConst1, 1);

	//	Scroll
	vConst0.x = m_fU;
	vConst0.y = m_fV;
    lpd3ddev->SetVertexShaderConstantF(2, (float*)&vConst0, 1);
	//	Fog
	vConst0.x = m_fFogStart;
	vConst0.y = m_fFogEnd;
	vConst0.z = 1.0f / (m_fFogEnd - m_fFogStart);
    lpd3ddev->SetVertexShaderConstantF(3, (float*)&vConst0, 1);

	//	World s
	D3DXMatrixTranspose(&matTmp, pMatWorld);
    lpd3ddev->SetVertexShaderConstantF(16, (float*)&matTmp, 4);
	//	WorldView s
	D3DXMatrixTranspose(&matTmp, &matWorldView);
    lpd3ddev->SetVertexShaderConstantF(8, (float*)&matTmp, 4);
	//	WorldViewProjection
	D3DXMatrixMultiplyTranspose(&matTmp,&matWorldView,m_lpD3DEnv->GetSystemProjection());
    lpd3ddev->SetVertexShaderConstantF(4, (float*)&matTmp, 4);

	//	sɑΉ
	vLightDir = (D3DXVECTOR4)*m_lpD3DEnv->GetSystemLightDirection();
	vLightDir.w = 0;
	vLightDir *= -1.0f;
    lpd3ddev->SetVertexShaderConstantF(20, (float*)&vLightDir, 1);

	matNo = -1;
	lpd3ddev->SetStreamSource(0,pVB,0,dwStride);
	lpd3ddev->SetIndices(pIB);
	for (i = 0; i < dwOrderingTableIndex; ++i){
		if (matNo != (int)pOT[i].m_usMaterial){
			matNo = (int)pOT[i].m_usMaterial;
			//	lpd3ddev->SetMaterial( &m_pMaterials[matNo] );
			//	Set Vertex Shader Constant for each materials.
            D3DXCOLOR	color1(m_pMaterials[matNo].Ambient);
			D3DCOLOR	c = m_lpD3DEnv->GetAmbientColor();
			D3DXCOLOR	color2(	((c>>16)&0xff) * (1/255.0f), 
								((c>>8)&0xff) * (1/255.0f), 
								((c)&0xff) * (1/255.0f), 1.0);
            D3DXCOLOR ambEmm;
            D3DXColorModulate(&ambEmm, &color1, &color2);
            ambEmm += D3DXCOLOR(m_pMaterials[matNo].Emissive);
			D3DXCOLOR	diffuse;
			D3DXColorModulate(&diffuse,&D3DXCOLOR(m_pMaterials[matNo].Diffuse),&D3DXCOLOR(m_lpD3DEnv->GetSystemLight()->Diffuse));
			diffuse.a *= m_fOpacity;
            lpd3ddev->SetVertexShaderConstantF(21, (float*)&diffuse, 1);
            lpd3ddev->SetVertexShaderConstantF(22, (float*)&ambEmm, 1);
			//
			if (m_ppTextures[matNo]){
				lpd3ddev->SetTexture( 0, m_ppTextures[matNo]->GetTexture() );
			}else{
				lpd3ddev->SetTexture( 0, NULL );
			}
		}
		k = pOT[i].m_usIndex;
		lpd3ddev->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,dwNumWholeVertices,k,1);
	}
unsupported_index_format:
	SAFE_RELEASE(pIB);
	SAFE_RELEASE(pVB);
#endif
}

void COTScrollMesh::SetFog(FLOAT fStart, FLOAT fEnd){
	m_fFogStart = fStart;
	m_fFogEnd = fEnd;
}
