/*
 *	class COTMesh
 *		bVɋ@\ǉ郆[eBeB[NX
 *
*/
#include "stdafx.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "d3d9env.h"
#include <tchar.h>
#include "Mesh.h"
#include "OTMesh.h"
#include "TextureDB.h"


//-------------------------------------------------------------
//	Name: COTMesh
//  Desc: RXgN^
//-------------------------------------------------------------
COTMesh::COTMesh(CD3DEnv *pEnv, TCHAR *fname) : CMesh(pEnv,fname)
{
	m_pMeshAttributeRange = NULL;
	m_pAttribTableRemap = NULL;
	m_uiBlendMethod = MESH_SEMI_TRANS;
}

COTMesh::~COTMesh()
{
	InvalidateDeviceObjects();
	DeleteDeviceObjects();
}

//-------------------------------------------------------------
//	Name: InitDeviceObjects
//  Desc: foCXˑIuWFNg̐
//-------------------------------------------------------------

HRESULT	COTMesh::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	if (m_pMeshSysMem != NULL
		&& m_pAttribTableRemap != NULL
		&& m_pMeshAttributeRange != NULL){
		m_uiMeshStatus = MESH_IS_INITIALIZED;
		return	S_OK;
	}
	DeleteDeviceObjects();
	LPD3DXBUFFER	lpAdjacency;
	CMesh::InitDeviceObjectsOfMesh(lpd3ddev,&lpAdjacency);

	DWORD	dwNumFaces = m_pMeshSysMem->GetNumFaces();

	m_lpD3DEnv->RequireOT(dwNumFaces);
	m_pAttribTableRemap = new UINT[m_dwNumMaterials];


	m_pMeshSysMem->GetAttributeTable(NULL,&m_dwAttribTableSize);

    if (m_dwAttribTableSize == 0){
    //  e[uȂꍇ̏
        LPD3DXMESH  pNewMesh = NULL;
        DWORD    *pdwAdjacency = NULL;
        if (lpAdjacency == NULL){
            //  אڏ񂪖΍쐬EEEԂ͂܂B
            DWORD    dwNumFaces = m_pMeshSysMem->GetNumFaces();
            pdwAdjacency = new DWORD[dwNumFaces*3];
            HRESULT hr = m_pMeshSysMem->GenerateAdjacency(FLT_MIN*2.0f,pdwAdjacency);
        }else{
            //  אڏ񂪂΂̂܂ܗp
            DWORD    dwSize = lpAdjacency->GetBufferSize();
            pdwAdjacency = (DWORD*)new BYTE[dwSize];
            memcpy((void*)pdwAdjacency,lpAdjacency->GetBufferPointer(),dwSize);
        }
        m_pMeshSysMem->Optimize(D3DXMESHOPT_ATTRSORT,pdwAdjacency,NULL,NULL,NULL,&pNewMesh);
        if (pNewMesh != NULL){
            m_pMeshSysMem->Release();
            m_pMeshSysMem = pNewMesh;
            m_pMeshSysMem->GetAttributeTable(NULL,&m_dwAttribTableSize);
        }
        delete    pdwAdjacency;
    }

	m_pMeshAttributeRange = new D3DXATTRIBUTERANGE[m_dwAttribTableSize];
	m_uiMeshStatus = MESH_IS_INITIALIZED;
 	m_pMeshSysMem->GetAttributeTable(m_pMeshAttributeRange,&m_dwAttribTableSize);

	SAFE_RELEASE(lpAdjacency);

	for (UINT i = 0; i < m_dwNumMaterials ; ++i){
		m_pAttribTableRemap[i] = m_dwNumMaterials;
		for (UINT j = 0; j < m_dwAttribTableSize; ++j){
			if (m_pMeshAttributeRange[j].AttribId == i){
				m_pAttribTableRemap[i] = j;
			}
		}
	}
	return S_OK;
}

//-------------------------------------------------------------
//	Name: RestoreDeviceObjects
//  Desc: foCXˑrfIIuWFNg̐
//-------------------------------------------------------------
HRESULT COTMesh::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	return	CMesh::RestoreDeviceObjects(lpd3ddev);
}

//-------------------------------------------------------------
//	Name: InvalidateDeviceObjects
//  Desc: foCXˑrfIIuWFNg̏
//-------------------------------------------------------------
HRESULT COTMesh::InvalidateDeviceObjects()
{
	return	CMesh::InvalidateDeviceObjects();
}

//-------------------------------------------------------------
//	Name: DeleteDeviceObjects
//  Desc: foCXˑIuWFNg̏
//-------------------------------------------------------------
HRESULT COTMesh::DeleteDeviceObjects()
{
	InvalidateDeviceObjects();
	if (m_pAttribTableRemap != NULL){
		delete []	m_pAttribTableRemap;
		m_pAttribTableRemap = NULL;
	}
	if (m_pMeshAttributeRange != NULL){
		delete	[]	m_pMeshAttributeRange;
		m_pMeshAttributeRange = NULL;
	}
	CMesh::DeleteDeviceObjects();
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void    COTMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev)
{
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB

    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);
	lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);

	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}

    if (m_pMeshSysMem){
        for( UINT i = 0; i < m_dwNumMaterials; i++ ){
			FLOAT	oldAlpha = m_pMaterials[i].Diffuse.a;
			m_pMaterials[i].Diffuse.a *= m_fOpacity;
            lpd3ddev->SetMaterial( &m_pMaterials[i] );
			if (m_ppTextures[i]){
	            lpd3ddev->SetTexture( 0, m_ppTextures[i]->GetTexture() );
			}else{
				lpd3ddev->SetTexture( 0, NULL);
			}
            m_pMeshSysMem->DrawSubset( i );
			m_pMaterials[i].Diffuse.a = oldAlpha;
        }
    }
}
//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void    COTMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX	*matWorldView,D3DXMATRIX *matWorldViewProjection)
{
	if (m_pMeshSysMem == NULL)
		return;
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
	
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);
	lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}

	DWORD	dwFaceIx = 0;
	DWORD	dwNumFaces;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	D3DINDEXBUFFER_DESC	ixDesc;
	HRESULT	hr;
	DWORD	dwNumWholeVertices = m_pMeshSysMem->GetNumVertices();
	if (FAILED(m_pMeshSysMem->GetVertexBuffer(&pVB))
	|| FAILED(m_pMeshSysMem->GetIndexBuffer(&pIB))){
		SAFE_RELEASE(pVB);
		SAFE_RELEASE(pIB);	
		return;
	}
	hr = pIB->GetDesc(&ixDesc);
	float	fOneOverThree = 1.0f / 3.0f;
	D3DXVECTOR3	vecTmp,vecTmp0,vecTmp1,vecTmp2;
	D3DXVECTOR4	vecProj0,vecProj1,vecProj2;
	FLOAT		rhw;
	DWORD	dwStride = D3DXGetFVFVertexSize(m_pMeshSysMem->GetFVF());
	lpd3ddev->SetFVF(m_pMeshSysMem->GetFVF());
	FLOAT	fZ;
	UINT	ix,i,j,k;
	UINT	dwOrderingTableIndex = 0;
    int		matNo;
	OrderingTable	*pOT = m_lpD3DEnv->GetOT();
	if (pOT == NULL)
		return;

	if (m_pMeshSysMem){
		if (ixDesc.Format == D3DFMT_INDEX16){
			WORD	*pIx;
			BYTE	*pVertex;
			pIB->Lock(0,0,(VOID**)&pIx, 0);
			pVB->Lock(0,0,(VOID**)&pVertex, 0);
			for( i = 0; i < m_dwNumMaterials; i++ ){
				j = m_pAttribTableRemap[i];
				if (j >= m_dwNumMaterials)
					continue;
				dwNumFaces = m_pMeshAttributeRange[j].FaceCount;
				k = m_pMeshAttributeRange[j].FaceStart;
				k *= 3;
				for (j = 0; j < dwNumFaces ; ++j){
					pOT[dwOrderingTableIndex].m_usMaterial = i;
					pOT[dwOrderingTableIndex].m_usIndex = k;
					ix = pIx[k++];
					vecTmp0 =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					ix = pIx[k++];
					vecTmp1 =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					ix = pIx[k++];
					vecTmp2 =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					
					D3DXVec3Transform(&vecProj0,&vecTmp0,matWorldViewProjection);
					rhw = 1.0f / vecProj0.w;
					vecProj0.x *= rhw;
					vecProj0.y *= rhw;
					vecProj0.z *= rhw;
					D3DXVec3Transform(&vecProj1,&vecTmp1,matWorldViewProjection);
					rhw = 1.0f / vecProj1.w;
					vecProj1.x *= rhw;
					vecProj1.y *= rhw;
					vecProj1.z *= rhw;
					D3DXVec3Transform(&vecProj2,&vecTmp2,matWorldViewProjection);
					rhw = 1.0f / vecProj2.w;
					vecProj2.x *= rhw;
					vecProj2.y *= rhw;
					vecProj2.z *= rhw;

					if (vecProj0.z < 0.0f && vecProj1.z < 0.0f && vecProj2.z < 0.0f)
						continue;
					if (vecProj0.z > 1.0f && vecProj1.z > 1.0f && vecProj2.z > 1.0f)
						continue;
					if (vecProj0.x < -1.0f && vecProj1.x < -1.0f && vecProj2.x < -1.0f)
						continue;
					if (vecProj0.x > 1.0f && vecProj1.x > 1.0f && vecProj2.x > 1.0f)
						continue;
					if (vecProj0.y < -1.0f && vecProj1.y < -1.0f && vecProj2.y < -1.0f)
						continue;
					if (vecProj0.y > 1.0f && vecProj1.y > 1.0f && vecProj2.y > 1.0f)
						continue;

					D3DXVec3TransformCoord(&vecTmp,&vecTmp0,matWorldView);
					fZ = vecTmp.z;
					D3DXVec3TransformCoord(&vecTmp,&vecTmp1,matWorldView);
					fZ += vecTmp.z;
					D3DXVec3TransformCoord(&vecTmp,&vecTmp2,matWorldView);
					fZ += vecTmp.z;
					fZ *= fOneOverThree;
					pOT[dwOrderingTableIndex++].m_fZ = fZ;
				}
			}
			pVB->Unlock();
			pIB->Unlock();
		}else if (ixDesc.Format == D3DFMT_INDEX32){
			DWORD	*pIx;
			BYTE	*pVertex;
			pIB->Lock(0,0,(VOID**)&pIx, 0);
			pVB->Lock(0,0,(VOID**)&pVertex, 0);
			for( i = 0; i < m_dwNumMaterials; i++ ){
				j = m_pAttribTableRemap[i];
				if (j >= m_dwNumMaterials)
					continue;
				dwNumFaces = m_pMeshAttributeRange[j].FaceCount;
				k = m_pMeshAttributeRange[j].FaceStart;
				k *= 3;
				for (j = 0; j < dwNumFaces ; ++j){
					pOT[dwOrderingTableIndex].m_usMaterial = i;
					pOT[dwOrderingTableIndex].m_usIndex = k;
					ix = pIx[k++];
					vecTmp0 =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					ix = pIx[k++];
					vecTmp1 =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					ix = pIx[k++];
					vecTmp2 =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					
					D3DXVec3Transform(&vecProj0,&vecTmp0,matWorldViewProjection);
					rhw = 1.0f / vecProj0.w;
					vecProj0.x *= rhw;
					vecProj0.y *= rhw;
					vecProj0.z *= rhw;
					D3DXVec3Transform(&vecProj1,&vecTmp1,matWorldViewProjection);
					rhw = 1.0f / vecProj1.w;
					vecProj1.x *= rhw;
					vecProj1.y *= rhw;
					vecProj1.z *= rhw;
					D3DXVec3Transform(&vecProj2,&vecTmp2,matWorldViewProjection);
					rhw = 1.0f / vecProj2.w;
					vecProj2.x *= rhw;
					vecProj2.y *= rhw;
					vecProj2.z *= rhw;

					if (vecProj0.z < 0.0f && vecProj1.z < 0.0f && vecProj2.z < 0.0f)
						continue;
					if (vecProj0.z > 1.0f && vecProj1.z > 1.0f && vecProj2.z > 1.0f)
						continue;
					if (vecProj0.x < -1.0f && vecProj1.x < -1.0f && vecProj2.x < -1.0f)
						continue;
					if (vecProj0.x > 1.0f && vecProj1.x > 1.0f && vecProj2.x > 1.0f)
						continue;
					if (vecProj0.y < -1.0f && vecProj1.y < -1.0f && vecProj2.y < -1.0f)
						continue;
					if (vecProj0.y > 1.0f && vecProj1.y > 1.0f && vecProj2.y > 1.0f)
						continue;

					D3DXVec3TransformCoord(&vecTmp,&vecTmp0,matWorldView);
					fZ = vecTmp.z;
					D3DXVec3TransformCoord(&vecTmp,&vecTmp1,matWorldView);
					fZ += vecTmp.z;
					D3DXVec3TransformCoord(&vecTmp,&vecTmp2,matWorldView);
					fZ += vecTmp.z;
					fZ *= fOneOverThree;
					pOT[dwOrderingTableIndex++].m_fZ = fZ;
				}
			}
			pVB->Unlock();
			pIB->Unlock();
		}else{
			goto	unsupported_index_format;
		}
	}
	qsort((void*)pOT,dwOrderingTableIndex,sizeof(OrderingTable),COTMesh::CompareMeshZSort);
	matNo = -1;
	lpd3ddev->SetStreamSource(0,pVB,0,dwStride);
	lpd3ddev->SetIndices(pIB);
	for (i = 0; i < dwOrderingTableIndex; ++i){
		if (matNo != (int)pOT[i].m_usMaterial){
			matNo = (int)pOT[i].m_usMaterial;
			FLOAT	oldAlpha = m_pMaterials[matNo].Diffuse.a;
			m_pMaterials[matNo].Diffuse.a *= m_fOpacity;
			lpd3ddev->SetMaterial( &m_pMaterials[matNo] );
			m_pMaterials[matNo].Diffuse.a = oldAlpha;
			if (m_ppTextures[matNo]){
				lpd3ddev->SetTexture( 0, m_ppTextures[matNo]->GetTexture() );
			}else{
				lpd3ddev->SetTexture( 0, NULL );
			}
		}
		k = pOT[i].m_usIndex;
		lpd3ddev->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,dwNumWholeVertices,k,1);
	}
unsupported_index_format:
	SAFE_RELEASE(pVB);
	SAFE_RELEASE(pIB);	
}


//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void    COTMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX	*matWorldView)
{
	if (m_pMeshSysMem == NULL)
		return;
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
	
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);
	lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}

	DWORD	dwFaceIx = 0;
	DWORD	dwNumFaces;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	D3DINDEXBUFFER_DESC	ixDesc;
	HRESULT	hr;
	DWORD	dwNumWholeVertices = m_pMeshSysMem->GetNumVertices();
	if (FAILED(m_pMeshSysMem->GetVertexBuffer(&pVB))
	|| FAILED(m_pMeshSysMem->GetIndexBuffer(&pIB))){
		SAFE_RELEASE(pVB);
		SAFE_RELEASE(pIB);	
		return;
	}
	hr = pIB->GetDesc(&ixDesc);
	float	fOneOverThree = 1.0f / 3.0f;
	D3DXVECTOR3	vecTmp;
	DWORD	dwStride = D3DXGetFVFVertexSize(m_pMeshSysMem->GetFVF());
	lpd3ddev->SetFVF(m_pMeshSysMem->GetFVF());
	FLOAT	fZ;
	UINT	ix,i,j,k;
	UINT	dwOrderingTableIndex = 0;
    int		matNo;
	OrderingTable	*pOT = m_lpD3DEnv->GetOT();
	if (pOT == NULL)
		return;

	if (m_pMeshSysMem){
		if (ixDesc.Format == D3DFMT_INDEX16){
			WORD	*pIx;
			BYTE	*pVertex;
			pIB->Lock(0,0,(VOID**)&pIx, 0);
			pVB->Lock(0,0,(VOID**)&pVertex, 0);
			for( i = 0; i < m_dwNumMaterials; i++ ){
				j = m_pAttribTableRemap[i];
				if (j >= m_dwNumMaterials)
					continue;
				dwNumFaces = m_pMeshAttributeRange[j].FaceCount;
				k = m_pMeshAttributeRange[j].FaceStart;
				k *= 3;
				for (j = 0; j < dwNumFaces ; ++j){
					pOT[dwOrderingTableIndex].m_usMaterial = i;
					pOT[dwOrderingTableIndex].m_usIndex = k;
					ix = pIx[k++];
					vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					D3DXVec3TransformCoord(&vecTmp,&vecTmp,matWorldView);
					

					fZ = vecTmp.z;
					ix = pIx[k++];
					vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					D3DXVec3TransformCoord(&vecTmp,&vecTmp,matWorldView);
					fZ += vecTmp.z;
					ix = pIx[k++];
					vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					D3DXVec3TransformCoord(&vecTmp,&vecTmp,matWorldView);
					fZ += vecTmp.z;
					fZ *= fOneOverThree;
					pOT[dwOrderingTableIndex++].m_fZ = fZ;
				}
			}
			pVB->Unlock();
			pIB->Unlock();
		}else if (ixDesc.Format == D3DFMT_INDEX32){
			DWORD	*pIx;
			BYTE	*pVertex;
			pIB->Lock(0,0,(VOID**)&pIx, 0);
			pVB->Lock(0,0,(VOID**)&pVertex, 0);
			for( i = 0; i < m_dwNumMaterials; i++ ){
				j = m_pAttribTableRemap[i];
				if (j >= m_dwNumMaterials)
					continue;
				dwNumFaces = m_pMeshAttributeRange[j].FaceCount;
				k = m_pMeshAttributeRange[j].FaceStart;
				k *= 3;
				for (j = 0; j < dwNumFaces ; ++j){
					pOT[dwOrderingTableIndex].m_usMaterial = i;
					pOT[dwOrderingTableIndex].m_usIndex = k;
					ix = pIx[k++];
					vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					D3DXVec3TransformCoord(&vecTmp,&vecTmp,matWorldView);
					fZ = vecTmp.z;
					ix = pIx[k++];
					vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					D3DXVec3TransformCoord(&vecTmp,&vecTmp,matWorldView);
					fZ += vecTmp.z;
					ix = pIx[k++];
					vecTmp =*(D3DXVECTOR3*)(pVertex+(ix*dwStride));
					D3DXVec3TransformCoord(&vecTmp,&vecTmp,matWorldView);
					fZ += vecTmp.z;
					fZ *= fOneOverThree;
					pOT[dwOrderingTableIndex++].m_fZ = fZ;
				}
			}
			pVB->Unlock();
			pIB->Unlock();
		}else{
			goto	unsupported_index_format;
		}
	}
	qsort((void*)pOT,dwOrderingTableIndex,sizeof(OrderingTable),COTMesh::CompareMeshZSort);
	matNo = -1;
	lpd3ddev->SetStreamSource(0,pVB,0,dwStride);
	lpd3ddev->SetIndices(pIB);
	for (i = 0; i < dwOrderingTableIndex; ++i){
		if (matNo != (int)pOT[i].m_usMaterial){
			matNo = (int)pOT[i].m_usMaterial;
			FLOAT	oldAlpha = m_pMaterials[matNo].Diffuse.a;
			m_pMaterials[matNo].Diffuse.a *= m_fOpacity;
			lpd3ddev->SetMaterial( &m_pMaterials[matNo] );
			m_pMaterials[matNo].Diffuse.a = oldAlpha;
			if (m_ppTextures[matNo]){
				lpd3ddev->SetTexture( 0, m_ppTextures[matNo]->GetTexture() );
			}else{
				lpd3ddev->SetTexture( 0, NULL );
			}
		}
		k = pOT[i].m_usIndex;
		lpd3ddev->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,dwNumWholeVertices,k,1);
	}
unsupported_index_format:
	SAFE_RELEASE(pVB);
	SAFE_RELEASE(pIB);	
}


int	COTMesh::CompareMeshZSort(const void *pa, const void*pb)
{
	OrderingTable *p1, *p2;
	p1 = (OrderingTable*)pa;
	p2 = (OrderingTable*)pb;
	if (p1->m_fZ > p2->m_fZ){
		return -1;
	}
	if (p1->m_fZ < p2->m_fZ){
		return 1;
	}
	return 0;
}

void	COTMesh::SetAlpha(BOOL bUse,DWORD method)
{
	m_bUseAlpha = bUse;
	m_uiBlendMethod = method;
}