/*
 *	class CMesh
 *		bVɋ@\ǉ郆[eBeB[NX
 *
 *		First edition: February.19.2004
 *
*/
#include "stdafx.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "d3d9env.h"
#include "Mesh.h"
#include <tchar.h>
#include "TextureDB.h"
#include "FilenameDecoder.h"
//-------------------------------------------------------------
//	Name: CMesh
//  Desc: RXgN^
//-------------------------------------------------------------
CMesh::CMesh(CD3DEnv *pEnv, TCHAR *fname)
{
	m_lpD3DEnv = pEnv;
 	//TCHAR	filepath[MAX_PATH];
	INT	app_path_len = _tcslen(m_lpD3DEnv->GetAppPathName());
	INT mesh_path_len = _tcslen(fname);
	TCHAR	*filepath = new TCHAR[app_path_len + mesh_path_len + 2];
	TCHAR	*p = filepath;
	DWORD	dwTemp;
	_tcscpy_s(p,app_path_len + mesh_path_len + 2, m_lpD3DEnv->GetAppPathName());
	p += app_path_len;
	*p++ = _T('\\');
	_tcscpy_s(p,mesh_path_len + 1,fname);

	//TCHAR	*p;
	CFilenameDecoder	*dec = new CFilenameDecoder(filepath,true);
	SAFE_DELETE(filepath);

	dwTemp = 0;
	dec->GetFilename(&dwTemp,NULL);
	m_strMeshFilename = new TCHAR[dwTemp+1];
	dec->GetFilename(&dwTemp,m_strMeshFilename);

	dwTemp = 0;
	dec->GetPath(&dwTemp,NULL);
	
	if (dwTemp > 0){
		m_strMeshPath = new TCHAR[dwTemp];
		dec->GetPath(&dwTemp,m_strMeshPath);
	}
	SAFE_DELETE(dec);	

	/*
	int	len = _tcslen(fname);
	len++;
	len = (len + 7) & 0xfffffff8;
	m_strMeshFilename = new TCHAR[len];
	_tcscpy_s(m_strMeshFilename,len,fname);
	m_lpD3DEnv->GetFileName(m_strMeshFilename,filepath);
	if (filepath[0] != '\0'){
		_tcscat_s(m_strMeshPath,_countof(m_strMeshPath),_T("\\"));
		_tcscat_s(m_strMeshPath,_countof(m_strMeshPath),filepath);
	}
	*/
    m_dwNumMaterials = 0;
    m_pMaterials = NULL;
    m_pMeshSysMem = NULL;
    m_ppTextures = NULL;
	m_ppFilenames = NULL;		//
	m_pFilenameBuffer = NULL;	//
	m_uiMeshStatus = MESH_IS_UNINITIALIZED;
	m_fOpacity = 1.0f;			
	m_uiBlendMethod = MESH_OPAQUE;

	m_lpD3DEnv->AddGraphicsObject(this);
}


CMesh::~CMesh()
{
	this->InvalidateDeviceObjects();
	this->DeleteDeviceObjects();
	if (m_strMeshFilename != NULL){
		delete m_strMeshFilename;
		m_strMeshFilename = NULL;
	}
	SAFE_DELETE(m_strMeshPath);
	m_lpD3DEnv->RemoveGraphicsObject(this);
}

//-------------------------------------------------------------
//	Name: InitDeviceObjects
//  Desc: foCXˑIuWFNg̐
//-------------------------------------------------------------
HRESULT	CMesh::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	return	InitDeviceObjectsOfMesh(lpd3ddev,NULL);
}


HRESULT	CMesh::InitDeviceObjectsOfMesh(LPDIRECT3DDEVICE9 lpd3ddev,LPD3DXBUFFER *ppAdjacency)
{
    LPDIRECT3DVERTEXBUFFER9 pVB = NULL;
    BYTE*      pVertices = NULL;
    LPD3DXMESH pTempMesh;
    HRESULT    hr;
	TCHAR	strMeshPath[512];

	if (m_pMeshSysMem != NULL){
		m_uiMeshStatus = MESH_IS_INITIALIZED;
		return	S_OK;
	}
	//	bV̓ǂݍ
	_tcscpy_s(strMeshPath,_countof(strMeshPath),m_strMeshPath);
    _tcscat_s(strMeshPath,_countof(strMeshPath),_T("\\"));
    _tcscat_s(strMeshPath,_countof(strMeshPath),m_strMeshFilename);
	LPD3DXBUFFER	pMtrlBuffer=NULL;
    hr = D3DXLoadMeshFromX( strMeshPath, D3DXMESH_SYSTEMMEM, lpd3ddev, 
			ppAdjacency, &pMtrlBuffer, NULL, &m_dwNumMaterials, 
			&m_pMeshSysMem );

	if (FAILED(hr)){
		return	hr;
    }

	//	oE_̒S_єaZo
    hr = m_pMeshSysMem->GetVertexBuffer( &pVB );
	if( FAILED(hr) ){
		SAFE_RELEASE(pMtrlBuffer);
		return	hr;
	}
    hr = pVB->Lock( 0, 0, (VOID**)&pVertices, 0 );
    if( FAILED(hr) ){
        if ( pVB != NULL){ pVB->Release();	pVB=NULL;	}
		SAFE_RELEASE(pMtrlBuffer);
		return	hr;
    }
    hr = D3DXComputeBoundingSphere( (LPD3DXVECTOR3)pVertices, m_pMeshSysMem->GetNumVertices(), 
                                    D3DXGetFVFVertexSize(m_pMeshSysMem->GetFVF()), 
									&m_vObjectCenter, &m_fObjectRadius );
    hr = D3DXComputeBoundingBox((LPD3DXVECTOR3)pVertices, m_pMeshSysMem->GetNumVertices(), 
                                    D3DXGetFVFVertexSize(m_pMeshSysMem->GetFVF()), 
									&m_vecObjectMin, &m_vecObjectMax);
    pVB->Unlock();
    if ( pVB != NULL){ pVB->Release(); pVB=NULL;	}
    if( FAILED(hr) ){
		SAFE_RELEASE(pMtrlBuffer);
		return	hr;
	}

	//	ǂݍ݂Ɏs
    if( 0 == m_dwNumMaterials ){
		SAFE_RELEASE(pMtrlBuffer);
		return	E_FAIL;
    }

	//	}eÃZbgAbv
	D3DXMATERIAL	*pMaterial;
	pMaterial = (D3DXMATERIAL*)pMtrlBuffer->GetBufferPointer();
    m_pMaterials = new D3DMATERIAL9[m_dwNumMaterials];
    m_ppFilenames = new LPSTR[m_dwNumMaterials];
    m_ppTextures = new CTextureNode*[m_dwNumMaterials];
    ZeroMemory(m_ppTextures,sizeof(CTextureNode*)*m_dwNumMaterials);

	//	}eARs[ĕۑB
	int	len = 0;
	DWORD	i;
	for (i = 0; i < m_dwNumMaterials ; ++i){
		if (pMaterial[i].pTextureFilename!= NULL){
			len += (int)strlen(pMaterial[i].pTextureFilename);
			len++;
		}
		m_pMaterials[i] = pMaterial[i].MatD3D;
		m_pMaterials[i].Ambient = m_pMaterials[i].Diffuse;
	}
	//	eNX`t@Cl[Rs[ĕۑB
	LPSTR	p1, p2;
	p1 = m_pFilenameBuffer = new TCHAR[len];
	for (i = 0; i < m_dwNumMaterials; ++i){
		p2 = pMaterial[i].pTextureFilename;
		if (p2 == NULL){
			m_ppFilenames[i] = NULL;
		}else{
			m_ppFilenames[i] = p1;
			while(NULL != (*p1++ = *p2++));
			TCHAR	fname[MAX_PATH];
			TCHAR	tmp[MAX_PATH],*p;
			_tcscpy_s(tmp,_countof(tmp),m_ppFilenames[i]);
			p = tmp;
			if (tmp[0] == _T('\"')){
				++p;
			}
			if ((p[0] == _T('\\') && p[1] == _T('\\')) || (p[1] == _T(':'))){
				m_lpD3DEnv->GetFileName(tmp,NULL);
			}
			_tcscpy_s(fname,_countof(fname),m_strMeshPath);
			_tcscat_s(fname,_countof(fname),_T("\\"));
			_tcscat_s(fname,_countof(fname),tmp);
			CFilenameDecoder	*dec = new CFilenameDecoder(fname,true);
			TCHAR	*text;
			DWORD	dwTemp = 0;
			dec->GetFullname(&dwTemp,NULL);
			text = new TCHAR[dwTemp];
			dec->GetFullname(&dwTemp,text);
			SAFE_DELETE(dec);
			m_lpD3DEnv->TextureDBRegisterNewKey(text,&m_ppTextures[i]);
			SAFE_DELETE(text);
		}
	}

	SAFE_RELEASE(pMtrlBuffer);

    // _tH[}bg̏CE@ΒǉB
    if( !(m_pMeshSysMem->GetFVF() & D3DFVF_NORMAL) )
    {
        hr = m_pMeshSysMem->CloneMeshFVF( m_pMeshSysMem->GetOptions(), 
                                          m_pMeshSysMem->GetFVF() | D3DFVF_NORMAL, 
                                          lpd3ddev, &pTempMesh );
		if( FAILED(hr) ){
			return	hr;
		}
        D3DXComputeNormals( pTempMesh,NULL );

		if ( m_pMeshSysMem != NULL)
            m_pMeshSysMem->Release();
        m_pMeshSysMem = pTempMesh;
    }
	m_uiMeshStatus = MESH_IS_INITIALIZED;
    return S_OK;
}
//-------------------------------------------------------------
//	Name: RestoreDeviceObjects
//  Desc: foCXˑrfIIuWFNg̐
//-------------------------------------------------------------
HRESULT CMesh::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	m_uiMeshStatus = MESH_IS_RESTORED;
    return S_OK;
}

//-------------------------------------------------------------
//	Name: InvalidateDeviceObjects
//  Desc: foCXˑrfIIuWFNg̏
//-------------------------------------------------------------
HRESULT CMesh::InvalidateDeviceObjects()
{
	m_uiMeshStatus = MESH_IS_INITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: DeleteDeviceObjects
//  Desc: foCXˑIuWFNg̏
//-------------------------------------------------------------
HRESULT CMesh::DeleteDeviceObjects()
{
	//InvalidateDeviceObjects();
    if (m_ppTextures != NULL){
        for( UINT i = 0; i < m_dwNumMaterials; i++ ){
            if (m_ppTextures[i] != NULL){
                m_ppTextures[i]->Release();
                m_ppTextures[i] = NULL;
            }
        }
        delete [] m_ppTextures;
        m_ppTextures = NULL;
    }
	if (m_pMaterials != NULL){
        delete [] m_pMaterials;
        m_pMaterials = NULL;
	}
	if (m_ppFilenames != NULL){
        delete [] m_ppFilenames;
        m_ppFilenames = NULL;
	}
	if (m_pFilenameBuffer != NULL){
        delete [] m_pFilenameBuffer;
        m_pFilenameBuffer = NULL;
	}
    if (m_pMeshSysMem != NULL){
        m_pMeshSysMem->Release();
        m_pMeshSysMem = NULL;
    }
    m_dwNumMaterials = 0L;
	m_uiMeshStatus = MESH_IS_UNINITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void    CMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev)
{
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB

    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_CCW);

	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}
    if (m_pMeshSysMem){
        for( UINT i = 0; i < m_dwNumMaterials; i++ ){
			FLOAT	oldAlpha = m_pMaterials[i].Diffuse.a;
			m_pMaterials[i].Diffuse.a *= m_fOpacity;
            lpd3ddev->SetMaterial( &m_pMaterials[i] );
			if (m_ppTextures[i]){
	            lpd3ddev->SetTexture( 0, m_ppTextures[i]->GetTexture() );
			}else{
				lpd3ddev->SetTexture( 0, NULL);
			}
            m_pMeshSysMem->DrawSubset( i );
			m_pMaterials[i].Diffuse.a = oldAlpha;
        }
    }
}

//-------------------------------------------------------------
//	Name: RenderWithoutMaterials
//  Desc: eNX`}eAł̕`揈
//-------------------------------------------------------------
void    CMesh::RenderWithoutMaterials(LPDIRECT3DDEVICE9 lpd3ddev, D3DMATERIAL9 *pMaterial)
{
	if (m_pMeshSysMem == NULL)
		return;
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB

    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG2);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_CCW);

	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}

	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	DWORD	dwNumVertices = m_pMeshSysMem->GetNumVertices();
	DWORD	dwNumFaces = m_pMeshSysMem->GetNumFaces();
	if (FAILED(m_pMeshSysMem->GetVertexBuffer(&pVB))
	|| FAILED(m_pMeshSysMem->GetIndexBuffer(&pIB))){
		SAFE_RELEASE(pVB);
		SAFE_RELEASE(pIB);
		return;
	}

	lpd3ddev->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE, D3DMCS_MATERIAL);
	FLOAT	oldAlpha = pMaterial->Diffuse.a;
	pMaterial->Diffuse.a = m_fOpacity;
	lpd3ddev->SetMaterial( pMaterial );
	
	
	DWORD	dwFVF = m_pMeshSysMem->GetFVF();

	lpd3ddev->SetStreamSource(0,pVB,0,D3DXGetFVFVertexSize(dwFVF));
	lpd3ddev->SetIndices(pIB);
	lpd3ddev->SetFVF(dwFVF);
	DWORD	dwNumPrimitives = dwNumFaces;
	DWORD	dwNumToDraw = m_lpD3DEnv->GetCurrentDeviceCaps()->MaxPrimitiveCount;
	DWORD	dwStartIx = 0;
	while(dwNumPrimitives >0){
		if (dwNumToDraw > dwNumPrimitives)
			dwNumToDraw = dwNumPrimitives;

		lpd3ddev->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,
			dwNumVertices,dwStartIx,dwNumToDraw);
		dwStartIx += dwNumToDraw * 3;
		dwNumPrimitives -= dwNumToDraw;
	}
	SAFE_RELEASE(pVB);
	SAFE_RELEASE(pIB);
	pMaterial->Diffuse.a = oldAlpha;
	lpd3ddev->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE, D3DMCS_COLOR1);
}

//-------------------------------------------------------------
//	Name: GetObjectCenter
//  Desc: bV̒S_i̍Wnj̒
//-------------------------------------------------------------
void	CMesh::GetObjectCenter(D3DXVECTOR3 *pPos){
	*pPos = this->m_vObjectCenter;
}

//-------------------------------------------------------------
//	Name: GetBoundingBox
//  Desc: bṼoE_{bNXi̍WnjԂ
//-------------------------------------------------------------
void	CMesh::GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax){
	*pMin = m_vecObjectMin;
	*pMax = m_vecObjectMax;
}

//-------------------------------------------------------------
//	Name: GetVertexBuffer
//  Desc: bṼ VertexBuffer 擾B
//-------------------------------------------------------------
HRESULT	CMesh::GetVertexBuffer(LPDIRECT3DVERTEXBUFFER9 *ppVB)
{
	HRESULT	hr;
	if (m_pMeshSysMem == NULL)
		return	E_FAIL;
    hr = m_pMeshSysMem->GetVertexBuffer( ppVB );
	return	hr;
}

//-------------------------------------------------------------
//	Name: GetIndexBuffer
//  Desc: bṼ IndexBuffer 擾B
//-------------------------------------------------------------
HRESULT	CMesh::GetIndexBuffer(LPDIRECT3DINDEXBUFFER9 *ppIB)
{
	if (m_pMeshSysMem == NULL)
		return	E_FAIL;
	return	m_pMeshSysMem->GetIndexBuffer(ppIB);
}

//-------------------------------------------------------------
//	Name: GetFVF
//  Desc: bṼ̒_tH[}bg擾B
//-------------------------------------------------------------
DWORD	CMesh::GetFVF()
{
	if (m_pMeshSysMem == NULL)
		return	0;
	return	m_pMeshSysMem->GetFVF();
}

//-------------------------------------------------------------
//	Name: GetNumVertices
//  Desc: bṼ̃bV̒_̐ԂB
//-------------------------------------------------------------
DWORD	CMesh::GetNumVertices(){
	if (m_pMeshSysMem == NULL)
		return	0;
	return	m_pMeshSysMem->GetNumVertices();
}

//-------------------------------------------------------------
//	Name: GetNumFaces
//  Desc: bṼ̃bV̖ʂ̐ԂB
//-------------------------------------------------------------
DWORD	CMesh::GetNumFaces(){
	if (m_pMeshSysMem == NULL)
		return	0;
	return	m_pMeshSysMem->GetNumFaces();
}
