//
//	HighResTimer.cpp: CHighResTimer NX̃Cve[V
//
//		64 rbgVXeJE^px^C}[
//		񋟂B
//	
//	ڍׂ́ALtqkQ
//	http://www5b.biglobe.ne.jp/~u-hei/d3d2d/HighResTimer.html
//
//
#include "stdafx.h"
#include "HighResTimer.h"

CHighResTimer::CHighResTimer()
{
    Reset();
}

CHighResTimer::~CHighResTimer()
{

}

void    CHighResTimer::Reset()
{
    LARGE_INTEGER   liFreq;
    int             i60 = 60;
    ::QueryPerformanceFrequency(&liFreq);
    __asm{
        fild    i60                     ;
        fild    liFreq.QuadPart         ;
        fdivp   st(1), st(0)            ;
        mov     esi, this
        fstp    double ptr [esi].m_dbFrequency    ;
    }
    ::QueryPerformanceCounter(&m_liCounter);
}

float    CHighResTimer::GetElapsedTime()
{
    LARGE_INTEGER  tmp, old;
    float          frame;
    ::QueryPerformanceCounter(&tmp);
    old.QuadPart = m_liCounter.QuadPart;
    __asm{
        mov     eax, tmp.LowPart;
        mov     edx, tmp.HighPart;
        sub     eax, old.LowPart;
        sbb     edx, old.HighPart;
        mov     tmp.LowPart, eax;
        mov     tmp.HighPart, edx;

        fild    tmp.QuadPart;
        mov     esi, this
        fmul    double ptr [esi].m_dbFrequency;
        fstp    frame;
    }
    return    frame;
}

float    CHighResTimer::GetElapsedTimeAndReset()
{
    LARGE_INTEGER  tmp, old;
    float          frame;
    ::QueryPerformanceCounter(&tmp);
    old.QuadPart = m_liCounter.QuadPart    ;
    m_liCounter.QuadPart = tmp.QuadPart    ;
    __asm{
        mov     eax, tmp.LowPart;
        mov     edx, tmp.HighPart;
        sub     eax, old.LowPart;
        sbb     edx, old.HighPart;
        mov     tmp.LowPart, eax;
        mov     tmp.HighPart, edx;

        fild    tmp.QuadPart;
        mov     esi, this
        fmul    double ptr [esi].m_dbFrequency;
        fstp    frame;
    }
    return    frame;
}
