#include "StdAfx.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "d3d9env.h"
#include <tchar.h>
#include "Mesh.h"
#include "TextureDB.h"
#include "HierarchicalMesh.h"
#include "FilenameDecoder.h"

//-----------------------------------------------------------------------------
// Name: AllocateName()
// Desc: mۂāARs[B
//-----------------------------------------------------------------------------
static HRESULT AllocateName( LPCTSTR Name, LPTSTR *pNewName )
{
    UINT uiLength;
	if (Name != NULL){
		uiLength = lstrlen(Name) + 1;
		*pNewName = new TCHAR[uiLength];
		if (*pNewName == NULL)
            return E_OUTOFMEMORY;
        memcpy(*pNewName, Name, uiLength*sizeof(TCHAR));
    }else{
        *pNewName = NULL;
    }
	return S_OK;
}


//-----------------------------------------------------------------------------
// Name: CAllocateHierarchy2::CreateFrame()
// Desc: Frame ̐B
//-----------------------------------------------------------------------------
HRESULT CAllocateHierarchy2::CreateFrame(LPCTSTR Name, LPD3DXFRAME *ppNewFrame)
{
	HRESULT hr = S_OK;
	HIERARCHICAL_FRAME *pFrame = NULL;

	*ppNewFrame = NULL;

	pFrame = new HIERARCHICAL_FRAME;
	if (pFrame == NULL){
        hr = E_OUTOFMEMORY;
        goto e_Exit;
    }
    hr = AllocateName(Name, &pFrame->Name);
    if (FAILED(hr))
        goto e_Exit;

    // initialize other data members of the frame
    D3DXMatrixIdentity(&pFrame->TransformationMatrix);
    D3DXMatrixIdentity(&pFrame->CombinedTransformationMatrix);

    pFrame->pMeshContainer = NULL;
    pFrame->pFrameSibling = NULL;
    pFrame->pFrameFirstChild = NULL;

    *ppNewFrame = pFrame;
    pFrame = NULL;
    return hr;
e_Exit:
	SAFE_DELETE(pFrame);
    return hr;
}




//-----------------------------------------------------------------------------
// Name: CAllocateHierarchy::CreateMeshContainer()
// Desc: MeshContainer ̐
//-----------------------------------------------------------------------------
#if D3DX_VERSION < 0x0902
HRESULT CAllocateHierarchy::CreateMeshContainer(LPCTSTR Name, 
							LPD3DXMESHDATA pMeshData,
                            LPD3DXMATERIAL pMaterials, 
							LPD3DXEFFECTINSTANCE pEffectInstances,
							DWORD NumMaterials, 
                            DWORD *pAdjacency, 
							LPD3DXSKININFO pSkinInfo, 
                            LPD3DXMESHCONTAINER *ppNewMeshContainer)
#else
HRESULT CAllocateHierarchy2::CreateMeshContainer(LPCTSTR Name, 
							CONST D3DXMESHDATA *pMeshData,
                            CONST D3DXMATERIAL *pMaterials, 
							CONST D3DXEFFECTINSTANCE *pEffectInstances,
							DWORD NumMaterials, 
                            CONST DWORD *pAdjacency, 
							LPD3DXSKININFO pSkinInfo, 
                            LPD3DXMESHCONTAINER *ppNewMeshContainer) 
#endif
{
    HRESULT hr;
    CMeshContainer *pMeshContainer = NULL;
    UINT NumFaces;
    UINT iMaterial;
    LPDIRECT3DDEVICE9 pd3dDevice = NULL;

    LPD3DXMESH pMesh = NULL;
    *ppNewMeshContainer = NULL;

    // ̃vÓAPatch Mesh  Progressive Mesh T|[gȂB
    if (pMeshData->Type != D3DXMESHTYPE_MESH){
        hr = E_FAIL;
        goto errot_exit;
    }

    // bVf[^ bVoB
    pMesh = pMeshData->pMesh;

    // FVF ΎgpłȂB
    if (pMesh->GetFVF() == 0){
        hr = E_FAIL;
        goto errot_exit;
    }

    //	m
    pMeshContainer = new CMeshContainer;
    if (pMeshContainer == NULL){
        hr = E_OUTOFMEMORY;
        goto errot_exit;
    }
    memset(pMeshContainer, 0, sizeof(CMeshContainer));

    // MeshContainer ֖ORs[
    hr = AllocateName(Name, &pMeshContainer->Name);
    if (FAILED(hr))
        goto errot_exit;

    pMesh->GetDevice(&pd3dDevice);
    NumFaces = pMesh->GetNumFaces();

    //	bVɖ@ΒǉB
    if (!(pMesh->GetFVF() & D3DFVF_NORMAL)){
        pMeshContainer->MeshData.Type = D3DXMESHTYPE_MESH;

        //	ԂׁAbV𕡐B
        hr = pMesh->CloneMeshFVF( pMesh->GetOptions(), 
                                    pMesh->GetFVF() | D3DFVF_NORMAL, 
                                    pd3dDevice, &pMeshContainer->MeshData.pMesh );
        if (FAILED(hr))
            goto errot_exit;

        // VbVւ̃|C^擾
        // NOTE: ̃bVւ̃t@X͒ǉĂȂ̂ŁA
		//		ÂbVRelease ͂ȂB
		//		iĂяoŔjBj
        pMesh = pMeshContainer->MeshData.pMesh;

        //	@xNg̎Zo
        D3DXComputeNormals( pMesh, NULL );
    }else{
		// ɖ@ݒ肳Ă΁APɃt@XǉB
        pMeshContainer->MeshData.pMesh = pMesh;
        pMeshContainer->MeshData.Type = D3DXMESHTYPE_MESH;

        pMesh->AddRef();	//	t@Xǉ
					//	Note:̃bV͌ĂяoReleaseB
    }
        
    //	}eÂ߂̃mہB
    pMeshContainer->NumMaterials = max(1, NumMaterials);
    pMeshContainer->pMaterials = new D3DXMATERIAL[pMeshContainer->NumMaterials];
    pMeshContainer->ppTextures = new CTextureNode*[pMeshContainer->NumMaterials];
    pMeshContainer->pAdjacency = new DWORD[NumFaces*3];
    ZeroMemory(pMeshContainer->ppTextures,sizeof(CTextureNode*)*pMeshContainer->NumMaterials);

    if ((pMeshContainer->pAdjacency == NULL) || (pMeshContainer->pMaterials == NULL)){
        hr = E_OUTOFMEMORY;
        goto errot_exit;
    }

    memcpy(pMeshContainer->pAdjacency, pAdjacency, sizeof(DWORD) * NumFaces*3);

    // }eA񂪂΃Rs[B
    if (NumMaterials > 0){
        memcpy(pMeshContainer->pMaterials, pMaterials, sizeof(D3DXMATERIAL) * NumMaterials);
        for (iMaterial = 0; iMaterial < NumMaterials; iMaterial++){
			if (pMeshContainer->pMaterials[iMaterial].pTextureFilename != NULL)
            {
                TCHAR strTexturePath[MAX_PATH] = _T("");
				TCHAR	tmp[MAX_PATH], *p;
				_tcscpy_s( tmp, _countof(tmp), pMeshContainer->pMaterials[iMaterial].pTextureFilename );
				p = tmp;
				if (tmp[0] == _T('\"')){
					++p;
				}
				if ((p[0] == _T('\\') && p[1] == _T('\\')) || (p[1] == _T(':'))){
					m_pParent->m_lpD3DEnv->GetFileName(tmp,NULL);
				}
				_tcscpy_s(strTexturePath,this->m_pParent->m_strMeshPath );
				_tcscat_s(strTexturePath,"\\");
				_tcscat_s(strTexturePath,tmp);

				CFilenameDecoder	*dec = new CFilenameDecoder(strTexturePath,true);
				TCHAR	*text;
				DWORD	dwTemp = 0;
				dec->GetFullname(&dwTemp,NULL);
				text = new TCHAR[dwTemp];
				dec->GetFullname(&dwTemp,text);
				SAFE_DELETE(dec);

				m_pParent->m_lpD3DEnv->TextureDBRegisterNewKey(text,&pMeshContainer->ppTextures[iMaterial]);

				SAFE_DELETE(text);

				//	t@C폜
                 pMeshContainer->pMaterials[iMaterial].pTextureFilename = NULL;
            }
			pMeshContainer->pMaterials[iMaterial].MatD3D.Ambient
				= pMeshContainer->pMaterials[iMaterial].MatD3D.Diffuse;
		}
	}else{
		// bVf[^Ƀ}eA񂪖΃ftHg쐬
        pMeshContainer->pMaterials[0].pTextureFilename = NULL;
        memset(&pMeshContainer->pMaterials[0].MatD3D, 0, sizeof(D3DMATERIAL9));
        pMeshContainer->pMaterials[0].MatD3D.Diffuse.r = 0.5f;
        pMeshContainer->pMaterials[0].MatD3D.Diffuse.g = 0.5f;
        pMeshContainer->pMaterials[0].MatD3D.Diffuse.b = 0.5f;
        pMeshContainer->pMaterials[0].MatD3D.Specular = pMeshContainer->pMaterials[0].MatD3D.Diffuse;
		pMeshContainer->pMaterials[0].MatD3D.Ambient
			= pMeshContainer->pMaterials[0].MatD3D.Diffuse;
    }

    *ppNewMeshContainer = pMeshContainer;
    pMeshContainer = NULL;
errot_exit:
    SAFE_RELEASE(pd3dDevice);
    // G[΁AMeshContainer 폜B
    if (pMeshContainer != NULL){
        DestroyMeshContainer(pMeshContainer);
    }
    return hr;
}

//-----------------------------------------------------------------------------
// Name: CAllocateHierarchy::DestroyFrame()
// Desc: 
//-----------------------------------------------------------------------------
HRESULT CAllocateHierarchy2::DestroyFrame(LPD3DXFRAME pFrameToFree) 
{
    SAFE_DELETE_ARRAY( pFrameToFree->Name );
    SAFE_DELETE( pFrameToFree );
    return S_OK; 
}

//-----------------------------------------------------------------------------
// Name: CAllocateHierarchy::DestroyMeshContainer()
// Desc: 
//-----------------------------------------------------------------------------
HRESULT CAllocateHierarchy2::DestroyMeshContainer(LPD3DXMESHCONTAINER pMeshContainerBase)
{
    UINT iMaterial;
    CMeshContainer *pMeshContainer = (CMeshContainer*)pMeshContainerBase;

    SAFE_DELETE_ARRAY( pMeshContainer->Name );
    SAFE_DELETE_ARRAY( pMeshContainer->pAdjacency );
    SAFE_DELETE_ARRAY( pMeshContainer->pMaterials );

    // SẴeNX`
    if (pMeshContainer->ppTextures != NULL)
    {
        for (iMaterial = 0; iMaterial < pMeshContainer->NumMaterials; iMaterial++)
        {
			if (pMeshContainer->ppTextures[iMaterial] ){
				pMeshContainer->ppTextures[iMaterial]->Release();
				pMeshContainer->ppTextures[iMaterial] = NULL;
			}
        }
    }

    SAFE_DELETE_ARRAY( pMeshContainer->ppTextures );
    SAFE_RELEASE( pMeshContainer->MeshData.pMesh );
    SAFE_RELEASE( pMeshContainer->pSkinInfo );
    SAFE_RELEASE( pMeshContainer->pOrigMesh );
    SAFE_DELETE( pMeshContainer );
    return S_OK;
}



CHierarchicalMesh::CHierarchicalMesh(CD3DEnv *pEnv, TCHAR *pFilenae) : CMesh(pEnv,pFilenae)
{
	m_uiMeshStatus = MESH_IS_UNINITIALIZED;
    m_pFrameRoot = NULL;
	m_vObjectCenter = D3DXVECTOR3(0,0,0);
	m_fObjectRadius = 0;
	m_vecObjectMax = m_vObjectCenter;
	m_vecObjectMin = m_vObjectCenter;
}


CHierarchicalMesh::~CHierarchicalMesh(void)
{
	InvalidateDeviceObjects();
	DeleteDeviceObjects();
}


//-------------------------------------------------------------
//	Name: InitDeviceObjects
//  Desc: foCXˑIuWFNg̐
//-------------------------------------------------------------
HRESULT	CHierarchicalMesh::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
    LPDIRECT3DVERTEXBUFFER9 pVB = NULL;
    BYTE*      pVertices = NULL;
    HRESULT    hr;
    CAllocateHierarchy2 Alloc(this);

	TCHAR	strMeshPath[512];
	if (m_pFrameRoot != NULL){
		m_uiMeshStatus = MESH_IS_INITIALIZED;
		return S_OK;
	}
    InvalidateDeviceObjects();
    DeleteDeviceObjects();

	//	bV̓ǂݍ
	_tcscpy_s(strMeshPath,_countof(strMeshPath),m_strMeshPath);
    _tcscat_s(strMeshPath,_countof(strMeshPath),_T("\\"));
    _tcscat_s(strMeshPath,_countof(strMeshPath),m_strMeshFilename);

	//	bV̓ǂݍ
	ID3DXAnimationController	*pAnim;	//	gpȂ_~[
	hr = D3DXLoadMeshHierarchyFromX(strMeshPath, D3DXMESH_MANAGED, lpd3ddev, &Alloc, NULL, &m_pFrameRoot, &pAnim);
    if (FAILED(hr))
        return hr;

    hr = D3DXFrameCalculateBoundingSphere(m_pFrameRoot, &m_vObjectCenter, &m_fObjectRadius);
    if (FAILED(hr))
        return hr;

	m_vecObjectMin.x = m_vObjectCenter.x - m_fObjectRadius;
	m_vecObjectMin.y = m_vObjectCenter.y - m_fObjectRadius;
	m_vecObjectMin.z = m_vObjectCenter.z - m_fObjectRadius;

	m_vecObjectMax.x = m_vObjectCenter.x + m_fObjectRadius;
	m_vecObjectMax.y = m_vObjectCenter.y + m_fObjectRadius;
	m_vecObjectMax.z = m_vObjectCenter.z + m_fObjectRadius;

	m_uiMeshStatus = MESH_IS_INITIALIZED;
    return hr;
}

//-------------------------------------------------------------
//	Name: RestoreDeviceObjects
//  Desc: foCXˑrfIIuWFNg̐
//-------------------------------------------------------------
HRESULT CHierarchicalMesh::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	m_uiMeshStatus = MESH_IS_RESTORED;
    return S_OK;
}


//-------------------------------------------------------------
//	Name: InvalidateDeviceObjects
//  Desc: foCXˑrfIIuWFNg̏
//-------------------------------------------------------------
HRESULT CHierarchicalMesh::InvalidateDeviceObjects()
{
	m_uiMeshStatus = MESH_IS_INITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: DeleteDeviceObjects
//  Desc: foCXˑIuWFNg̏
//-------------------------------------------------------------
HRESULT CHierarchicalMesh::DeleteDeviceObjects()
{
    CAllocateHierarchy2 Alloc(this);
	if (m_pFrameRoot != NULL){
		D3DXFrameDestroy(m_pFrameRoot, &Alloc);
		m_pFrameRoot = NULL;
	}

	m_uiMeshStatus = MESH_IS_UNINITIALIZED;
    return  S_OK;
}


void	CHierarchicalMesh::UpdateMatrices(D3DXMATRIX *pMat){
	HRESULT	hr = S_OK;
     // Setup world matrix
	LPDIRECT3DDEVICE9	lpd3ddev = NULL;
	if (m_pFrameRoot == NULL)
		return;
	m_matWorld = *pMat;
    UpdateFrameMatrices(m_pFrameRoot, pMat);
}



void	CHierarchicalMesh::UpdateFrameMatrices(LPD3DXFRAME pFrameBase, LPD3DXMATRIX pParentMatrix)
{
    HIERARCHICAL_FRAME *pFrame = (HIERARCHICAL_FRAME*)pFrameBase;

    if (pParentMatrix != NULL)
        D3DXMatrixMultiply(&pFrame->CombinedTransformationMatrix, &pFrame->TransformationMatrix, pParentMatrix);
    else
        pFrame->CombinedTransformationMatrix = pFrame->TransformationMatrix;

    if (pFrame->pFrameSibling != NULL){
        UpdateFrameMatrices(pFrame->pFrameSibling, pParentMatrix);
    }

    if (pFrame->pFrameFirstChild != NULL){
        UpdateFrameMatrices(pFrame->pFrameFirstChild, &pFrame->CombinedTransformationMatrix);
    }
}


void	CHierarchicalMesh::RenderFrame(LPDIRECT3DDEVICE9 lpd3ddev,D3DXFRAME *pFrame){
	HIERARCHICAL_FRAME	*pHFrame = (HIERARCHICAL_FRAME*)pFrame;
	if (pFrame->pFrameSibling != NULL)
		RenderFrame(lpd3ddev,pFrame->pFrameSibling);
	if (pFrame->pFrameFirstChild != NULL)
		RenderFrame(lpd3ddev,pFrame->pFrameFirstChild);
	if (pFrame->pMeshContainer != NULL){
	    CMeshContainer *pMeshContainer = (CMeshContainer*)pFrame->pMeshContainer;
	    UINT iMaterial;
		HRESULT hr;
		lpd3ddev->SetTransform(D3DTS_WORLD,&pHFrame->CombinedTransformationMatrix);
		hr = lpd3ddev->SetVertexShader(NULL);

		for (iMaterial = 0; iMaterial < pMeshContainer->NumMaterials; iMaterial++)
		{
			FLOAT	oldAlpha = pMeshContainer->pMaterials[iMaterial].MatD3D.Diffuse.a;
			pMeshContainer->pMaterials[iMaterial].MatD3D.Diffuse.a *= m_fOpacity;
			lpd3ddev->SetMaterial( &pMeshContainer->pMaterials[iMaterial].MatD3D );

			if (pMeshContainer->ppTextures[iMaterial])
				lpd3ddev->SetTexture( 0, pMeshContainer->ppTextures[iMaterial]->GetTexture() );
			else
				lpd3ddev->SetTexture( 0, NULL);
			pMeshContainer->MeshData.pMesh->DrawSubset(iMaterial);
			pMeshContainer->pMaterials[iMaterial].MatD3D.Diffuse.a = oldAlpha;
		}
		
	}
}


void	CHierarchicalMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev){
	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_CCW);
	RenderFrame(lpd3ddev, m_pFrameRoot);
}

void	CHierarchicalMesh::RenderFrame(LPDIRECT3DDEVICE9 lpd3ddev,D3DXFRAME *pFrame, D3DMATERIAL9 *pMaterial){
	HIERARCHICAL_FRAME	*pHFrame = (HIERARCHICAL_FRAME*)pFrame;
	if (pFrame->pFrameSibling != NULL)
		RenderFrame(lpd3ddev,pFrame->pFrameSibling,pMaterial);
	if (pFrame->pFrameFirstChild != NULL)
		RenderFrame(lpd3ddev,pFrame->pFrameFirstChild,pMaterial);
	if (pFrame->pMeshContainer != NULL){
	    CMeshContainer *pMeshContainer = (CMeshContainer*)pFrame->pMeshContainer;
	    UINT iMaterial;
		HRESULT hr;
		lpd3ddev->SetTransform(D3DTS_WORLD,&pHFrame->CombinedTransformationMatrix);
		hr = lpd3ddev->SetVertexShader(NULL);

		for (iMaterial = 0; iMaterial < pMeshContainer->NumMaterials; iMaterial++)
		{
			lpd3ddev->SetMaterial( pMaterial );

			lpd3ddev->SetTexture( 0, NULL);
			pMeshContainer->MeshData.pMesh->DrawSubset(iMaterial);
		}
		
	}
}

void	CHierarchicalMesh::RenderWithoutMaterials(LPDIRECT3DDEVICE9 lpd3ddev,D3DMATERIAL9 *pMaterial){
	FLOAT	oldAlpha = pMaterial->Diffuse.a;
	pMaterial->Diffuse.a = m_fOpacity;
	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_CCW);
	lpd3ddev->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE, D3DMCS_MATERIAL);
	lpd3ddev->SetMaterial(pMaterial);
	RenderFrame(lpd3ddev, m_pFrameRoot,pMaterial);
	lpd3ddev->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE, D3DMCS_COLOR1);
	pMaterial->Diffuse.a = oldAlpha;
}