#include "StdAfx.h"
#include <d3dx9.h>
#include <dxfile.h>
#include <tchar.h>
#include <crtdbg.h>
#include "D3DQuickLib.h"

#include "HLSLPixelShaderFromFile.h"


CHLSLPixelShaderFromFile::CHLSLPixelShaderFromFile(CD3DEnv *pEnv, TCHAR *strFilename, TCHAR *strEntryPoint, GUID guid, DWORD dwOpt)
	: CHLSLShaderContainer(pEnv,guid)
{
	int	len;
	len = (int)_tcslen(strFilename)+1;
	m_pFilename = new TCHAR[len];
	_tcscpy_s(m_pFilename,len,strFilename);
	len = (int)_tcslen(strEntryPoint)+1;
	m_pEntryPoint = new TCHAR[len];
	_tcscpy_s(m_pEntryPoint,len,strEntryPoint);
	m_pPixelShader = NULL;
	m_pConstantTable = NULL;
	m_dwCompileOption = dwOpt;
}


CHLSLPixelShaderFromFile::~CHLSLPixelShaderFromFile(void)
{
	InvalidateDeviceObjects();
	SAFE_DELETE(m_pFilename);
	SAFE_DELETE(m_pEntryPoint);
}

//----------------------------------------------------
//	萔e[uԂ
//----------------------------------------------------
LPD3DXCONSTANTTABLE	CHLSLPixelShaderFromFile::GetDXConstantTable(){
	return	m_pConstantTable;
}

//--------------------------------------------
//	method : Restore
//	Note   : VF[_̓ǂݍ
//--------------------------------------------
HRESULT CHLSLPixelShaderFromFile::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	TCHAR	strPath[MAX_PATH];
	LPD3DXBUFFER	pCode;
	LPD3DXBUFFER	pError= NULL;
	HRESULT	hr;
	char	*str;
	CD3DEnv	*pEnv;
	if (m_pPixelShader != NULL)
		return	S_OK;	//	No need to Restore

	pEnv = m_pDB->GetEnv();
	_tcscpy_s(strPath, _countof(strPath), pEnv->GetAppPathName());
	_tcscat_s(strPath, _countof(strPath), _T("\\"));
	_tcscat_s(strPath, _countof(strPath), m_pFilename);

	// Compile the pixel shader file
    if (FAILED( hr = D3DXCompileShaderFromFile( strPath, NULL, NULL, m_pEntryPoint,
                                         "ps_2_0", m_dwCompileOption, &pCode,
                                         &pError, &m_pConstantTable ) )
	){
		str = (char*)pError->GetBufferPointer();
        _RPT1(_CRT_WARN,"Compile Error. %s\n",str);
		SAFE_RELEASE(pError);
		return hr;
	}
	SAFE_RELEASE(pError);

	hr = lpd3ddev->CreatePixelShader((DWORD*)pCode->GetBufferPointer(),
		&m_pPixelShader);
    pCode->Release();
	if (FAILED( hr ))
		return	hr;

	return	S_OK;
}

//--------------------------------------------
//	method : Invalidate
//	Note   : VF[_̔j
//--------------------------------------------
HRESULT CHLSLPixelShaderFromFile::InvalidateDeviceObjects(){
	SAFE_RELEASE(m_pPixelShader);
	return	S_OK;
}

//----------------------------------------------------
//	萔e[uԂ
//----------------------------------------------------
LPDIRECT3DPIXELSHADER9 CHLSLPixelShaderFromFile::GetDXPixelShader(){
	return	m_pPixelShader;
}

//----------------------------------------------------------------------------
//	萔̏lZbg(ShaderCompiler does not output the initial value)
//----------------------------------------------------------------------------
HRESULT	CHLSLPixelShaderFromFile::SetDefaults(LPDIRECT3DDEVICE9 lpd3ddev){
	HRESULT	hr = E_FAIL;
	if (m_pConstantTable != NULL)
		hr = m_pConstantTable->SetDefaults(lpd3ddev);
	return	hr;
}
