/*
 *	class CFloor
 *		̎NX
 *
 *		First edition: June.20.2005
 *
 */
#ifndef __FLOOR_H__
#define	__FLOOR_H__

#ifndef	__WALL_H__
#include "Wall.h"
#endif
struct	COLLISIONVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DXVECTOR3	n;	//	normal
};

class CFloor : public CWall
{
public:
	CFloor(CD3DEnv *pEnv, TCHAR *pFname);
	virtual ~CFloor();
	virtual BOOL	ProbeTheGroundAltitude(D3DXVECTOR3 *pVec, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, D3DXVECTOR3 *pVecNormal, FLOAT *pAlt, FLOAT *pDist);
	virtual BOOL	ProbeTheGroundAltitudeOneSide(D3DXVECTOR3 *pVec, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, D3DXVECTOR3 *pVecNormal, FLOAT *pAlt, FLOAT *pDist);
	virtual BOOL	ProbeTheGroundAltitudeVerticallyNearest(D3DXVECTOR3 *pVec, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, D3DXVECTOR3 *pVecNormal, FLOAT *pAlt, FLOAT *pDist);
	static  BOOL	FitLineToBox(COLLISIONVERTEX *vecP1, COLLISIONVERTEX *vecP2, D3DXVECTOR3 *vecMin, D3DXVECTOR3 *vecMax);
protected:
	virtual BOOL	ProbeTheTriangleHeight(COLLISIONVERTEX *pTri, FLOAT *pDist, FLOAT *pAlt, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax, D3DXVECTOR3 *pNormal, FLOAT x, FLOAT y, FLOAT z);
	virtual BOOL	ProbeTheTriangleHeightOneSide(COLLISIONVERTEX *pTri, FLOAT *pDist, FLOAT *pAlt, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax, D3DXVECTOR3 *pNormal, FLOAT x, FLOAT y, FLOAT z);
	//virtual BOOL	Collide2Box(D3DXVECTOR3 *pMin1, D3DXVECTOR3 *pMax1, D3DXVECTOR3 *pMin2, D3DXVECTOR3 *pMax2);
	virtual void	MatrixTriangleInverseRotation(D3DXMATRIX *pOut, D3DXVECTOR3 *vecZ);
	virtual void	CalcShortestDistanceAndAltitude(D3DXVECTOR3 *vecPos, COLLISIONVERTEX *vecP1, COLLISIONVERTEX *vecP2, float *pAlt, float *pDist, D3DXVECTOR3 *pNormal);
	//	D3DXMATRIX	m_matWorld;
};

#endif