/*
 *	class CFloor
 *		n`̎NX
 *
 *		First edition: February.19.2004
 *
*/
#include "stdafx.h"

#include <tchar.h>
#include <d3dx9.h>
#include "Floor.h"

//-------------------------------------------------------------
//	Name: CFloor
//  Desc: RXgN^
//-------------------------------------------------------------
CFloor::CFloor(CD3DEnv *pEnv, TCHAR *fname) : CWall(pEnv, fname)
{
	D3DXMatrixIdentity(&m_matWorld);
}

CFloor::~CFloor()
{
}
#if	0
//-------------------------------------------------------------
//	Name: SetWorldMatrix
//  Desc: t[
//-------------------------------------------------------------
void	CFloor::SetWorldMatrix(D3DXMATRIX *pMat)
{
	m_matWorld = *pMat;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void	CFloor::Render(LPDIRECT3DDEVICE9 lpd3ddev)
{
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );

	lpd3ddev->SetTransform( D3DTS_WORLD, &m_matWorld );
	CMesh::Render(lpd3ddev);
#if	0
	//	fobOpɃoE_{bNX\B
	D3DXVECTOR3	vecMin, vecMax;
	GetBoundingBox(&vecMin,&vecMax);
	RenderBoundingBoxForDebug(&vecMin,&vecMax);
#endif
}

//-------------------------------------------------------------
//	Name: GetBoundingSphere
//  Desc: 蔻ׂ̈̋񋟂
//	Return: float a, D3DXVECTOR3 S
//-------------------------------------------------------------
float	CFloor::GetBoundingSphere(D3DXVECTOR3 *pVec)
{
	//	bV̒S_擾
	CMesh::GetObjectCenter(pVec);

	//	[hW֕ϊ
	D3DXVec3TransformCoord(pVec, pVec, &m_matWorld);

	//	aԂ
	return	GetRadius();
}

//-------------------------------------------------------------
//	Name: GetBoundingBox
//  Desc: 蔻ׂ̈̃oE_{bNX񋟂
//		oE_{bNX́A[hWŕ\B
//-------------------------------------------------------------
void	CFloor::GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax)
{
	D3DXVECTOR3	pVec[8];
	D3DXVECTOR3	vecMin, vecMax;
	
	CMesh::GetBoundingBox(&vecMin, &vecMax);

	pVec[3].z = pVec[2].z = pVec[1].z = pVec[0].z = vecMin.z;
	pVec[1].x = pVec[0].x = vecMin.x;
	pVec[3].x = pVec[2].x = vecMax.x;
	pVec[2].y = pVec[1].y = vecMax.y;
	pVec[3].y = pVec[0].y = vecMin.y;

	pVec[7].z = pVec[6].z = pVec[5].z = pVec[4].z = vecMax.z;
	pVec[5].x = pVec[4].x = vecMin.x;
	pVec[7].x = pVec[6].x = vecMax.x;
	pVec[6].y = pVec[5].y = vecMax.y;
	pVec[7].y = pVec[4].y = vecMin.y;

	//	[hW֕ϊ
	UINT	i;
	for (i = 0; i < 8 ; ++i){
		D3DXVec3TransformCoord(&pVec[i], &pVec[i], &m_matWorld);
	}
	vecMin.x = vecMin.y = vecMin.z = FLT_MAX;
	vecMax.x = vecMax.y = vecMax.z = -FLT_MAX;
	for (i = 0; i < 8 ; ++i){
		if (vecMin.x > pVec[i].x){
			vecMin.x = pVec[i].x;
		}
		if (vecMin.y > pVec[i].y){
			vecMin.y = pVec[i].y;
		}

		if (vecMin.z > pVec[i].z){
			vecMin.z = pVec[i].z;
		}
		if (vecMax.x < pVec[i].x){
			vecMax.x = pVec[i].x;
		}
		if (vecMax.y < pVec[i].y){
			vecMax.y = pVec[i].y;
		}
		if (vecMax.z < pVec[i].z){
			vecMax.z = pVec[i].z;
		}
	}
	*pMin = vecMin;
	*pMax = vecMax;
}
#endif

//-------------------------------------------------------------
//	Name: ProbeTheGroundAltitude
//  Desc: w肳ꂽʒu̒nʂ̍xԂB
//		͈͂́Aw肳ꂽ{bNX͈͓̔ɌB
//-------------------------------------------------------------
BOOL CFloor::ProbeTheGroundAltitude(D3DXVECTOR3 *pVec, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, D3DXVECTOR3 *pVecNormal, FLOAT *pAlt, FLOAT *pDist)
{
	D3DXVECTOR3	vecMin, vecMax, vecNormal, vecNormalTmp;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	D3DINDEXBUFFER_DESC	ixDesc;
	DWORD	numFaces;
	DWORD	dwStride,dwMeshFVF;
	FLOAT	fDist,fMinDist,fAlt, fAltTmp;
	BOOL	bRet = false;
	HRESULT	hr;

	COLLISIONVERTEX	vecVertice[3];

	if (m_pMeshSysMem == NULL)
		return	false;
	vecNormalTmp = *pVecNormal;
	GetBoundingBox(&vecMin, &vecMax);
	//	^ꂽƂ̒n`̃oE_{bNXƂ
	//	Փ˔
	if (vecMin.x > pBoxMax->x)
		return	false;
	if (vecMin.y > pBoxMax->y)
		return	false;
	if (vecMin.z > pBoxMax->z)
		return	false;
	if (vecMax.x < pBoxMin->x)
		return	false;
	if (vecMax.y < pBoxMin->y)
		return	false;
	if (vecMax.z < pBoxMin->z)
		return	false;

	//	bVʂɃ|S𒊏oB
	numFaces = GetNumFaces();
	dwStride = D3DXGetFVFVertexSize(GetFVF());
	dwMeshFVF = GetFVF();
	GetVertexBuffer(&pVB);
	GetIndexBuffer(&pIB);
	hr = pIB->GetDesc(&ixDesc);

	fMinDist = FLT_MAX;
	fAlt = 0.0f;
	//	EGCgt_ɂ͑ΉĂȂEEEEAGɂȂ̂邽߁B
	if (dwMeshFVF & ((~D3DFVF_XYZ)&(D3DFVF_XYZB1|D3DFVF_XYZB2|D3DFVF_XYZB3|D3DFVF_XYZB4|D3DFVF_XYZB5)))
		goto	UNSUPPORTED_VERTEX_FORMAT;
	if (ixDesc.Format == D3DFMT_INDEX16){
		WORD	*pIx;
		BYTE	*pVertex;
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		for(UINT i = 0; i < numFaces; ++i){
			for (UINT j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
			}
			if (ProbeTheTriangleHeight(vecVertice,&fDist,&fAltTmp,pBoxMin,pBoxMax,&vecNormalTmp, pVec->x, pVec->y, pVec->z)){
				if (fDist == 0.0f){
					bRet = true;
					fMinDist = 0.0f;
					fAlt = fAltTmp;
					vecNormal = vecNormalTmp;
					break;
				}
				if (fDist < fMinDist){
					bRet = true;
					fMinDist = fDist;
					fAlt = fAltTmp;
					vecNormal = vecNormalTmp;
				}
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}else{
		DWORD	*pIx;
		BYTE	*pVertex;
		if (ixDesc.Format != D3DFMT_INDEX32){
			goto	UNSUPPORTED_INDEX_BUFFER;
		}
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		for(UINT i = 0; i < numFaces; ++i){
			for (UINT j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
			}
			if (ProbeTheTriangleHeight(vecVertice,&fDist,&fAltTmp,pBoxMin,pBoxMax,&vecNormalTmp,pVec->x, pVec->y, pVec->z)){
				if (fDist == 0.0f){
					bRet = true;
					fMinDist = 0.0f;
					fAlt = fAltTmp;
					vecNormal = vecNormalTmp;
					break;
				}
				if (fDist < fMinDist){
					bRet = true;
					fMinDist = fDist;
					fAlt = fAltTmp;
					vecNormal = vecNormalTmp;
				}
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}
UNSUPPORTED_INDEX_BUFFER:
UNSUPPORTED_VERTEX_FORMAT:
	SAFE_RELEASE(pIB);
	SAFE_RELEASE(pVB);
	if (bRet){
		*pAlt = fAlt;
		*pDist = fMinDist;
		*pVecNormal = vecNormal;
	}
	return	bRet;
}

//-------------------------------------------------------------
//	Name: ProbeTheGroundAltitude
//  Desc: w肳ꂽʒu̒nʂ̍xԂB
//		͈͂́Aw肳ꂽ{bNX͈͓̔ɌB
//-------------------------------------------------------------
BOOL CFloor::ProbeTheGroundAltitudeOneSide(D3DXVECTOR3 *pVec, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, D3DXVECTOR3 *pVecNormal, FLOAT *pAlt, FLOAT *pDist)
{
	D3DXVECTOR3	vecMin, vecMax, vecNormal, vecNormalTmp;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	D3DINDEXBUFFER_DESC	ixDesc;
	DWORD	numFaces;
	DWORD	dwStride,dwMeshFVF;
	FLOAT	fDist,fMinDist,fAlt, fAltTmp;
	BOOL	bRet = false;
	HRESULT	hr;

	COLLISIONVERTEX	vecVertice[3];

	if (m_pMeshSysMem == NULL)
		return	false;
	vecNormalTmp = *pVecNormal;
	GetBoundingBox(&vecMin, &vecMax);
	//	^ꂽƂ̒n`̃oE_{bNXƂ
	//	Փ˔
	if (vecMin.x > pBoxMax->x)
		return	false;
	if (vecMin.y > pBoxMax->y)
		return	false;
	if (vecMin.z > pBoxMax->z)
		return	false;
	if (vecMax.x < pBoxMin->x)
		return	false;
	if (vecMax.y < pBoxMin->y)
		return	false;
	if (vecMax.z < pBoxMin->z)
		return	false;

	//	bVʂɃ|S𒊏oB
	numFaces = GetNumFaces();
	dwStride = D3DXGetFVFVertexSize(GetFVF());
	dwMeshFVF = GetFVF();
	GetVertexBuffer(&pVB);
	GetIndexBuffer(&pIB);
	hr = pIB->GetDesc(&ixDesc);

	fMinDist = FLT_MAX;
	fAlt = 0.0f;
	//	EGCgt_ɂ͑ΉĂȂEEEEAGɂȂ̂邽߁B
	if (dwMeshFVF & ((~D3DFVF_XYZ)&(D3DFVF_XYZB1|D3DFVF_XYZB2|D3DFVF_XYZB3|D3DFVF_XYZB4|D3DFVF_XYZB5)))
		goto	UNSUPPORTED_VERTEX_FORMAT;
	if (ixDesc.Format == D3DFMT_INDEX16){
		WORD	*pIx;
		BYTE	*pVertex;
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		for(UINT i = 0; i < numFaces; ++i){
			for (UINT j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
			}
			if (ProbeTheTriangleHeightOneSide(vecVertice,&fDist,&fAltTmp,pBoxMin,pBoxMax,&vecNormalTmp, pVec->x, pVec->y, pVec->z)){
				if (fDist == 0.0f){
					bRet = true;
					fMinDist = 0.0f;
					fAlt = fAltTmp;
					vecNormal = vecNormalTmp;
					break;
				}
				if (fDist < fMinDist){
					bRet = true;
					fMinDist = fDist;
					fAlt = fAltTmp;
					vecNormal = vecNormalTmp;
				}
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}else{
		DWORD	*pIx;
		BYTE	*pVertex;
		if (ixDesc.Format != D3DFMT_INDEX32){
			goto	UNSUPPORTED_INDEX_BUFFER;
		}
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		for(UINT i = 0; i < numFaces; ++i){
			for (UINT j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
			}
			if (ProbeTheTriangleHeightOneSide(vecVertice,&fDist,&fAltTmp,pBoxMin,pBoxMax,&vecNormalTmp,pVec->x, pVec->y, pVec->z)){
				if (fDist == 0.0f){
					bRet = true;
					fMinDist = 0.0f;
					fAlt = fAltTmp;
					vecNormal = vecNormalTmp;
					break;
				}
				if (fDist < fMinDist){
					bRet = true;
					fMinDist = fDist;
					fAlt = fAltTmp;
					vecNormal = vecNormalTmp;
				}
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}
UNSUPPORTED_INDEX_BUFFER:
UNSUPPORTED_VERTEX_FORMAT:
	SAFE_RELEASE(pIB);
	SAFE_RELEASE(pVB);
	if (bRet){
		*pAlt = fAlt;
		*pDist = fMinDist;
		*pVecNormal = vecNormal;
	}
	return	bRet;
}

//-------------------------------------------------------------
//	Name: ProbeTheGroundAltitude
//  Desc: w肳ꂽʒu̒nʂ̍xԂB
//		͈͂́Aw肳ꂽ{bNX͈͓̔ɌB
//		_Ɉԋ߂x|S̍𔻒
//-------------------------------------------------------------
BOOL CFloor::ProbeTheGroundAltitudeVerticallyNearest(D3DXVECTOR3 *pVec, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, D3DXVECTOR3 *pVecNormal, FLOAT *pAlt, FLOAT *pDist)
{
	D3DXVECTOR3	vecMin, vecMax, vecNormal, vecNormalTmp;
	LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
	LPDIRECT3DINDEXBUFFER9	pIB = NULL;
	D3DINDEXBUFFER_DESC	ixDesc;
	DWORD	numFaces;
	DWORD	dwStride,dwMeshFVF;
	FLOAT	fTmp, fDist, fNearest, fAlt, fAltTmp;
	FLOAT	fDistRange,w,d;
	BOOL	bRet = false;
	HRESULT	hr;

	COLLISIONVERTEX	vecVertice[3];

	if (m_pMeshSysMem == NULL)
		return	false;
	vecNormalTmp = *pVecNormal;
	GetBoundingBox(&vecMin, &vecMax);
	w = (vecMax.x - vecMin.x) * .5f;
	w *= w;
	d = (vecMax.z - vecMin.z) * .5f;
	d *= d;
	fDistRange = (w+d);

	//	^ꂽƂ̒n`̃oE_{bNXƂ
	//	Փ˔
	if (vecMin.x > pBoxMax->x)
		return	false;
	if (vecMin.y > pBoxMax->y)
		return	false;
	if (vecMin.z > pBoxMax->z)
		return	false;
	if (vecMax.x < pBoxMin->x)
		return	false;
	if (vecMax.y < pBoxMin->y)
		return	false;
	if (vecMax.z < pBoxMin->z)
		return	false;

	//	bVʂɃ|S𒊏oB
	numFaces = GetNumFaces();
	dwStride = D3DXGetFVFVertexSize(GetFVF());
	dwMeshFVF = GetFVF();
	GetVertexBuffer(&pVB);
	GetIndexBuffer(&pIB);
	hr = pIB->GetDesc(&ixDesc);

	fNearest = FLT_MAX;
	fAlt = 0.0f;
	//	EGCgt_ɂ͑ΉĂȂEEEEAGɂȂ̂邽߁B
	if (dwMeshFVF & ((~D3DFVF_XYZ)&(D3DFVF_XYZB1|D3DFVF_XYZB2|D3DFVF_XYZB3|D3DFVF_XYZB4|D3DFVF_XYZB5)))
		goto	UNSUPPORTED_VERTEX_FORMAT;
	if (ixDesc.Format == D3DFMT_INDEX16){
		WORD	*pIx;
		BYTE	*pVertex;
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		for(UINT i = 0; i < numFaces; ++i){
			for (UINT j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
			}
			if (ProbeTheTriangleHeightOneSide(vecVertice,&fDist,&fAltTmp,pBoxMin,pBoxMax,&vecNormalTmp, pVec->x, pVec->y, pVec->z)){
				fTmp = fAltTmp - pVec->y;
				fTmp *= fTmp;
				if (fDist < fDistRange && fTmp < fNearest){
					fNearest = fTmp;
					fAlt = fAltTmp;
					bRet = true;
				}
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}else{
		DWORD	*pIx;
		BYTE	*pVertex;
		if (ixDesc.Format != D3DFMT_INDEX32){
			goto	UNSUPPORTED_INDEX_BUFFER;
		}
		pIB->Lock(0,0,(VOID**)&pIx, 0);
		pVB->Lock(0,0,(VOID**)&pVertex, 0);

		for(UINT i = 0; i < numFaces; ++i){
			for (UINT j = 0; j < 3 ; ++j){
				vecVertice[j].p = *(D3DXVECTOR3*)(pVertex + ((*pIx)*dwStride));
				vecVertice[j].n = *(D3DXVECTOR3*)((unsigned char*)pVertex + sizeof(D3DXVECTOR3) + ((*pIx++)*dwStride));
			}
			if (ProbeTheTriangleHeightOneSide(vecVertice,&fDist,&fAltTmp,pBoxMin,pBoxMax,&vecNormalTmp,pVec->x, pVec->y, pVec->z)){
				fTmp = fAltTmp - pVec->y;
				fTmp *= fTmp;
				if (fDist < fDistRange && fTmp < fNearest){
					fNearest = fTmp;
					fAlt = fAltTmp;
					bRet = true;
				}
			}
		}
		pVB->Unlock();
		pIB->Unlock();
	}
UNSUPPORTED_INDEX_BUFFER:
UNSUPPORTED_VERTEX_FORMAT:
	SAFE_RELEASE(pIB);
	SAFE_RELEASE(pVB);
	if (bRet){
		*pAlt = fAlt;
		*pDist = fNearest;
		*pVecNormal = vecNormal;
	}
	return	bRet;
}

//-------------------------------------------------------------
//	Name: ProbeTheTriangleHeight
//  Desc: w肳ꂽʒũ|S̍xԂB
//		͈͂́Aw肳ꂽ{bNX͈͓̔ɌB
//		̍WńA[hWnɓꂳĂȂ
//		ȂȂBXΔt
//-------------------------------------------------------------
BOOL	CFloor::ProbeTheTriangleHeight(COLLISIONVERTEX *pTri, FLOAT *pDist, FLOAT *pAlt, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax, D3DXVECTOR3 *pNormal, FLOAT x, FLOAT y, FLOAT z)
{
	D3DXVECTOR3	vecMin, vecMax, vecTmp;
	D3DXVECTOR3	vecPos;
	D3DXVECTOR3	vecNormal;
	BOOL	bF0=false, bF1=false, bF2=false;

	FLOAT		len1, len2, len3, dx, dz;
	int	i;
	D3DXVec3TransformCoord(&pTri[0].p,&pTri[0].p,&m_matWorld);
	D3DXVec3TransformCoord(&pTri[1].p,&pTri[1].p,&m_matWorld);
	D3DXVec3TransformCoord(&pTri[2].p,&pTri[2].p,&m_matWorld);

	//	|S̃oE_{bNXZo
	static const BOOL	bFalse = false;
	BOOL	bHit = TRUE;
	DWORD	dwPitch = sizeof(COLLISIONVERTEX);
	__asm{
		mov	esi, pTri;
		lea edi, vecMin;
		lea ebx, vecMax;
		
		mov	eax, dword ptr [esi];
		mov	dword ptr [edi], eax;		/*	pMin->x = pVertices[0].p.x;	*/
		mov	dword ptr [ebx], eax;		/*	pMax->x = pVertices[0].p.x;	*/
		mov	eax, dword ptr [esi+4];
		mov	dword ptr [edi+4], eax;		/*	pMin->y = pVertices[0].p.y;	*/
		mov	dword ptr [ebx+4], eax;		/*	pMax->y = pVertices[0].p.y;	*/
		mov	eax, dword ptr [esi+8];
		mov	dword ptr [edi+8], eax;		/*	pMin->z = pVertices[0].p.z;	*/
		mov	dword ptr [ebx+8], eax;		/*	pMax->z = pVertices[0].p.z;	*/
		add	esi, dwPitch;				/*	pVertices++	*/
		/*if (vecMin.x > pTri[1].p.x)	vecMin.x = pTri[1].p.x;*/
		fld		float ptr [esi];		/*	st(1) = pTri[1].p.x*/
		fld		float ptr [edi];		/*	st(0) = pMin->x;*/
		fcomi	st,st(1);				
		fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[1].p.x then st(0):=st(1)*/
		fstp	float ptr [edi];		/*	pMin->x = st(0)*/
		/*if (pMax->x < pTri[1].p.x)	pMax->x = pTri[1].p.x;*/
		fld		float ptr [ebx];		/* st(0) = pMax->x;*/
		fcomi	st,st(1);				/*	*/
		fcmovb	st(0),st(1);			/*	pMax->x < pTri[1].p.x then st(0):=st(1)*/
		fstp	float ptr [ebx];		/*	*/
		fstp	st(0)					/*	*/
		/*if (pMin->y > pTri[1].p.y)	pMin->y = pTri[1].p.y;*/
		fld		[esi+4];				/* st(1) = pTri[1].p.y*/
		fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
		fcomi	st,st(1);				/*	if (pMin->y > pTri[1].p.y) st(0) = pTri[1].p.y;*/
		fcmovnbe	st(0),st(1);
		fstp	float ptr [edi+4];
		/*if (pMax->y < pTri[1].p.y)	pMax->y = pTri[1].p.y;*/
		fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
		fcomi	st,st(1);				/**/
		fcmovb	st(0),st(1);			/*	if pMax->y < pTri[1].p.y st(0) = pTri[1].p.y*/
		fstp	float ptr [ebx+4];
		fstp	st(0)
		/*if (pMin->z > pTri[1].p.z)	pMin->z = pTri[1].p.z;*/
		fld		float ptr [esi+8];		/* st(1) = pTri[1].p.z*/
		fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
		fcomi	st,st(1);				/**/
		fcmovnbe	st(0),st(1);		/*	if pTri[1].p.z > pMin->z st(0) = pTri[1].p.z*/
		fstp	float ptr [edi+8];
		/*if (pMax->z < pTri[1].p.z)	pMax->z = pTri[1].p.z;*/
		fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
		fcomi	st,st(1);	/**/
		fcmovb	st(0),st(1);			/*	if pMax->z < pTri[1].p.z st(0) = pTri[1].x*/
		fstp	float ptr [ebx+8];
		fstp	st(0)

		add	esi, dwPitch;			/*	pVertices++*/
		/*if (vecMin.x > pTri[2].p.x)	vecMin.x = pTri[2].p.x;*/
		fld		float ptr [esi];		/*	st(1) = pTri[2].p.x*/
		fld		float ptr [edi];		/*	st(0) = pMin->x*/;
		fcomi	st,st(1);				
		fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[2].p.x then st(0):=st(1)*/
		fstp	float ptr [edi];		/*	pMin->x = st(0)*/
		/*if (pMax->x < pTri[2].p.x)	pMax->x = pTri[2].p.x;*/
		fld		float ptr [ebx];		/* st(0) = pMax->x;*/
		fcomi	st,st(1);				
		fcmovb	st(0),st(1);			/*	pMax->x < pTri[2].p.x then st(0):=st(1)*/
		fstp	float ptr [ebx];		/*	*/
		fstp	st(0)					/*	*/
		/*if (pMin->y > pTri[2].p.y)	pMin->y = pTri[2].p.y;*/
		fld		[esi+4];				/* st(1) = pTri[2].p.y*/
		fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
		fcomi	st,st(1);				/*	if (pMin->y > pTri[2].p.y) st(0) = pTri[2].p.y;*/
		fcmovnbe	st(0),st(1);
		fstp	float ptr [edi+4];
		/*if (pMax->y < pTri[2].p.y)	pMax->y = pTri[2].p.y;*/
		fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
		fcomi	st,st(1);				
		fcmovb	st(0),st(1);			/*	if pMax->y < pTri[2].p.y st(0) = pTri[2].p.y*/
		fstp	float ptr [ebx+4];
		fstp	st(0)
		/*if (pMin->z > pTri[2].p.z)	pMin->z = pTri[2].p.z;*/
		fld		float ptr [esi+8];		/* st(1) = pTri[2].p.z*/
		fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
		fcomi	st,st(1);				
		fcmovnbe	st(0),st(1);		/*	if pTri[2].p.z > pMin->z st(0) = pTri[2].p.z*/
		fstp	float ptr [edi+8];
		/*if (pMax->z < pTri[2].p.z)	pMax->z = pTri[2].p.z;*/
		fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
		fcomi	st,st(1);				
		fcmovb	st(0),st(1);			/*	if pMax->z < pTri[2].p.z st(0) = pTri[2].x*/
		fstp	float ptr [ebx+8];	
		fstp	st(0)

		//	Collide2Box

		fild	bFalse;				//	st(3) := 0
		fild	bHit;				//	st(2) := 1
		lea	esi,	vecMin;
		mov	edi,	pMax;
		fld	float ptr[edi];			//	st(1):=pMax2->x
		fld	float ptr[esi];			//	st(0):=pMin1->x
		fcomip	st, st(1);
		fstp	st(0);
		fcmovnbe	st(0),st(1);	//	if (pMin1->x > pMax2->x)	then bHit = FALSE;

		fld	float ptr[edi+4];		//	st(1):= pMax2->y
		fld float ptr[esi+4];		//	st(0):= pMin1->y
		fcomip	st,st(1);
		fstp	st(0);
		fcmovnbe	st(0),st(1);	//	if (pMin1->y > pMax2->y)	then bHit = FALSE;	

		fld	float ptr[edi+8];		//	st(1):= pMax2->z
		fld float ptr[esi+8];		//	st(0):= pMin1->z
		fcomip	st,st(1);
		fstp	st(0);
		fcmovnbe	st(0),st(1);	//	if (pMin1->z > pMax2->z)	then bHit = FALSE;	

		lea	esi,	vecMax;
		mov	edi,	pMin;
		fld	float ptr[edi];			//st(1):=pMin2->x
		fld	float ptr[esi];			//st(0):=pMax1->x
		fcomip	st,st(1);
		fstp	st(0);
		fcmovb	st(0),st(1);		//	if (pMax1->x < pMin2->x)	then bHit = FALSE;

		fld	float ptr[edi+4];		//st(1):=pMin2->y
		fld	float ptr[esi+4];		//st(0):=pMax1->y
		fcomip	st,st(1);
		fstp	st(0);
		fcmovb	st(0),st(1);		//	if (pMax1->y < pMin2->y)	then bHit = FALSE;

		fld	float ptr[edi+8];		//st(1):=pMin2->z
		fld	float ptr[esi+8];		//st(0):=pMax1->z
		fcomip	st,st(1);
		fstp	st(0);
		fcmovb	st(0),st(1);		//	if (pMax1->z < pMin2->z)	then bHit = FALSE;

		fistp	bHit	;
		fstp	st(0)	;
	}
	if (!bHit)
		return FALSE;

	COLLISIONVERTEX	cvec1, cvec2;
	FLOAT	fAlt, fTmp;
	FLOAT	fDist, fDistMin;

	D3DXVECTOR4	vec4Tmp;
	for (i = 0 ; i < 3 ; ++i){
		vec4Tmp.x = pTri[i].n.x;
		vec4Tmp.y = pTri[i].n.y;
		vec4Tmp.z = pTri[i].n.z;
		vec4Tmp.w = 0;
		D3DXVec4Transform(&vec4Tmp,&vec4Tmp,&m_matWorld);
		pTri[i].n = (D3DXVECTOR3)vec4Tmp;
	}

	//	|SA^ォAXZ ʂɓe
	//	eӂ̒ZoB
	dx = pTri[1].p.x - pTri[0].p.x;
	dz = pTri[1].p.z - pTri[0].p.z;
	len1 = dx * dx + dz * dz;
	dx = pTri[2].p.x - pTri[1].p.x;
	dz = pTri[2].p.z - pTri[1].p.z;
	len2 = dx * dx + dz * dz;
	dx = pTri[0].p.x - pTri[2].p.x;
	dz = pTri[0].p.z - pTri[2].p.z;
	len3 = dx * dx + dz * dz;

	//	|Sȏ傫̂݁A|S̏ɏ肤B
	if ((fabs(len1) > FLT_MIN)&&(fabs(len2) > FLT_MIN)&&(fabs(len3) > FLT_MIN)){
		
		D3DXVECTOR3	vecDir1;
		D3DXVECTOR3	vecDir2;

		//	|S̊Oł̋Zo
		//	̂Ƃ͍ł߂ӂ邢͒_߂B
		vecDir1.y = 0;
		vecDir2.y = 0;

		vecDir1.x = x - pTri[0].p.x;
		vecDir1.z = z - pTri[0].p.z;
		vecDir2.x = pTri[1].p.x - pTri[0].p.x;
		vecDir2.z = pTri[1].p.z - pTri[0].p.z;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		if (vecTmp.y > -FLT_MIN){
			bF0=TRUE;
		}
		vecDir1.x = x - pTri[1].p.x;
		vecDir1.z = z - pTri[1].p.z;
		vecDir2.x = pTri[2].p.x - pTri[1].p.x;
		vecDir2.z = pTri[2].p.z - pTri[1].p.z;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		if (vecTmp.y > -FLT_MIN){
			bF1=TRUE;
		}

		vecDir1.x = x - pTri[2].p.x;
		vecDir1.z = z - pTri[2].p.z;
		vecDir2.x = pTri[0].p.x - pTri[2].p.x;
		vecDir2.z = pTri[0].p.z - pTri[2].p.z;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		if (vecTmp.y > -FLT_MIN){
			bF2=TRUE;
		}

		vecPos = D3DXVECTOR3(x,y,z);

		fDistMin = FLT_MAX;
		//  Op`̏ɏĂƂ
		if (!bF0 && !bF1 && !bF2){
			double	t,u,inv;
			FLOAT	px = x - pTri[0].p.x;
			FLOAT	pz = z - pTri[0].p.z;
			vecDir1 = pTri[1].p - pTri[0].p;
			vecDir2 = pTri[2].p - pTri[0].p;
			FLOAT	x1 = vecDir1.x;
			FLOAT	z1 = vecDir1.z;
			FLOAT	x2 = vecDir2.x;
			FLOAT	z2 = vecDir2.z;
		
			inv = (x1*z2 - x2*z1);
			if (fabs(inv) > FLT_MIN){
				inv = 1.0 / inv;

				t = inv * (px*z2 - pz*x2);
				u = inv * (x1*pz - px*z1);
				//	ՓˈʒuvZ
				vecPos = vecDir1*(FLOAT)t + vecDir2*(FLOAT)u;
				vecPos += pTri[0].p;

				//	@̌vZ
				vecNormal = pTri[0].n * (1-(FLOAT)t) + pTri[1].n * (FLOAT)t;
				vecNormal += pTri[0].n * (1-(FLOAT)u) + pTri[2].n * (FLOAT)u;
				D3DXVec3Normalize(&vecNormal,&vecNormal);
				*pAlt = (FLOAT)vecPos.y;
				*pNormal = vecNormal;
				*pDist = 0;
				return	true;
			}
		}
	}

	//  Op`̏ɍڂĂȂƂ
	fDistMin = FLT_MAX;
	
	cvec1 = pTri[1];	cvec2 = pTri[0];
	if (FitLineToBox(&cvec1,&cvec2,pMin, pMax)){
		CalcShortestDistanceAndAltitude(&vecPos,&cvec1, &cvec2, &fTmp, &fDist,&vecNormal);
		if (fDist < fDistMin){
			fDistMin = fDist;
			fAlt = fTmp;
			*pNormal = vecNormal;
		}
	}
	cvec1 = pTri[2];	cvec2 = pTri[1];
	if (FitLineToBox(&cvec1,&cvec2,pMin, pMax)){
		CalcShortestDistanceAndAltitude(&vecPos,&cvec1, &cvec2, &fTmp, &fDist,&vecNormal);
		if (fDist < fDistMin){
			fDistMin = fDist;
			fAlt = fTmp;
			*pNormal = vecNormal;
		}
	}
	cvec1 = pTri[0];	cvec2 = pTri[2];
	if (FitLineToBox(&cvec1,&cvec2,pMin, pMax)){
		CalcShortestDistanceAndAltitude(&vecPos,&cvec1, &cvec2, &fTmp, &fDist,&vecNormal);
		if (fDist < fDistMin){
			fDistMin = fDist;
			fAlt = fTmp;
			*pNormal = vecNormal;
		}
	}
	if (fDistMin < FLT_MAX){
		fDist = (FLOAT)sqrt(fDistMin);
		*pNormal = vecNormal;
		*pDist = fDist;
		*pAlt = fAlt;
		return	TRUE;
	}
	return	false;
}

//-------------------------------------------------------------
//	Name: ProbeTheTriangleHeightOneSide
//  Desc: w肳ꂽʒũ|S̍xԂB
//		|S̗ʂƂ͓蔻sȂ
//		͈͂́Aw肳ꂽ{bNX͈͓̔ɌB
//		̍WńA[hWnɓꂳĂȂ
//		ȂȂBXΔt
//-------------------------------------------------------------
BOOL	CFloor::ProbeTheTriangleHeightOneSide(COLLISIONVERTEX *pTri, FLOAT *pDist, FLOAT *pAlt, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax, D3DXVECTOR3 *pNormal, FLOAT x, FLOAT y, FLOAT z)
{
	D3DXVECTOR3	vecMin, vecMax, vecTmp;
	D3DXVECTOR3	vecPos;
	D3DXVECTOR3	vecNormal;
	BOOL	bF0=false, bF1=false, bF2=false;

	FLOAT		len1, len2, len3, dx, dz;
	int	i;
	D3DXVec3TransformCoord(&pTri[0].p,&pTri[0].p,&m_matWorld);
	D3DXVec3TransformCoord(&pTri[1].p,&pTri[1].p,&m_matWorld);
	D3DXVec3TransformCoord(&pTri[2].p,&pTri[2].p,&m_matWorld);

	//	|S̃oE_{bNXZo
	static const BOOL	bFalse = false;
	BOOL	bHit = TRUE;
	DWORD	dwPitch = sizeof(COLLISIONVERTEX);
	__asm{
		mov	esi, pTri;
		lea edi, vecMin;
		lea ebx, vecMax;
		
		mov	eax, dword ptr [esi];
		mov	dword ptr [edi], eax;		/*	pMin->x = pVertices[0].p.x;	*/
		mov	dword ptr [ebx], eax;		/*	pMax->x = pVertices[0].p.x;	*/
		mov	eax, dword ptr [esi+4];
		mov	dword ptr [edi+4], eax;		/*	pMin->y = pVertices[0].p.y;	*/
		mov	dword ptr [ebx+4], eax;		/*	pMax->y = pVertices[0].p.y;	*/
		mov	eax, dword ptr [esi+8];
		mov	dword ptr [edi+8], eax;		/*	pMin->z = pVertices[0].p.z;	*/
		mov	dword ptr [ebx+8], eax;		/*	pMax->z = pVertices[0].p.z;	*/
		add	esi, dwPitch;				/*	pVertices++	*/
		/*if (vecMin.x > pTri[1].p.x)	vecMin.x = pTri[1].p.x;*/
		fld		float ptr [esi];		/*	st(1) = pTri[1].p.x*/
		fld		float ptr [edi];		/*	st(0) = pMin->x;*/
		fcomi	st,st(1);				
		fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[1].p.x then st(0):=st(1)*/
		fstp	float ptr [edi];		/*	pMin->x = st(0)*/
		/*if (pMax->x < pTri[1].p.x)	pMax->x = pTri[1].p.x;*/
		fld		float ptr [ebx];		/* st(0) = pMax->x;*/
		fcomi	st,st(1);				/*	*/
		fcmovb	st(0),st(1);			/*	pMax->x < pTri[1].p.x then st(0):=st(1)*/
		fstp	float ptr [ebx];		/*	*/
		fstp	st(0)					/*	*/
		/*if (pMin->y > pTri[1].p.y)	pMin->y = pTri[1].p.y;*/
		fld		[esi+4];				/* st(1) = pTri[1].p.y*/
		fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
		fcomi	st,st(1);				/*	if (pMin->y > pTri[1].p.y) st(0) = pTri[1].p.y;*/
		fcmovnbe	st(0),st(1);
		fstp	float ptr [edi+4];
		/*if (pMax->y < pTri[1].p.y)	pMax->y = pTri[1].p.y;*/
		fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
		fcomi	st,st(1);				/**/
		fcmovb	st(0),st(1);			/*	if pMax->y < pTri[1].p.y st(0) = pTri[1].p.y*/
		fstp	float ptr [ebx+4];
		fstp	st(0)
		/*if (pMin->z > pTri[1].p.z)	pMin->z = pTri[1].p.z;*/
		fld		float ptr [esi+8];		/* st(1) = pTri[1].p.z*/
		fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
		fcomi	st,st(1);				/**/
		fcmovnbe	st(0),st(1);		/*	if pTri[1].p.z > pMin->z st(0) = pTri[1].p.z*/
		fstp	float ptr [edi+8];
		/*if (pMax->z < pTri[1].p.z)	pMax->z = pTri[1].p.z;*/
		fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
		fcomi	st,st(1);	/**/
		fcmovb	st(0),st(1);			/*	if pMax->z < pTri[1].p.z st(0) = pTri[1].x*/
		fstp	float ptr [ebx+8];
		fstp	st(0)

		add	esi, dwPitch;			/*	pVertices++*/
		/*if (vecMin.x > pTri[2].p.x)	vecMin.x = pTri[2].p.x;*/
		fld		float ptr [esi];		/*	st(1) = pTri[2].p.x*/
		fld		float ptr [edi];		/*	st(0) = pMin->x*/;
		fcomi	st,st(1);				
		fcmovnbe	st(0),st(1);		/*	pMin->x > pTri[2].p.x then st(0):=st(1)*/
		fstp	float ptr [edi];		/*	pMin->x = st(0)*/
		/*if (pMax->x < pTri[2].p.x)	pMax->x = pTri[2].p.x;*/
		fld		float ptr [ebx];		/* st(0) = pMax->x;*/
		fcomi	st,st(1);				
		fcmovb	st(0),st(1);			/*	pMax->x < pTri[2].p.x then st(0):=st(1)*/
		fstp	float ptr [ebx];		/*	*/
		fstp	st(0)					/*	*/
		/*if (pMin->y > pTri[2].p.y)	pMin->y = pTri[2].p.y;*/
		fld		[esi+4];				/* st(1) = pTri[2].p.y*/
		fld		float ptr [edi+4];		/* st(0) = pMin->y;*/
		fcomi	st,st(1);				/*	if (pMin->y > pTri[2].p.y) st(0) = pTri[2].p.y;*/
		fcmovnbe	st(0),st(1);
		fstp	float ptr [edi+4];
		/*if (pMax->y < pTri[2].p.y)	pMax->y = pTri[2].p.y;*/
		fld		float ptr [ebx+4];		/* st(0) = pMax->y;*/
		fcomi	st,st(1);				
		fcmovb	st(0),st(1);			/*	if pMax->y < pTri[2].p.y st(0) = pTri[2].p.y*/
		fstp	float ptr [ebx+4];
		fstp	st(0)
		/*if (pMin->z > pTri[2].p.z)	pMin->z = pTri[2].p.z;*/
		fld		float ptr [esi+8];		/* st(1) = pTri[2].p.z*/
		fld		float ptr [edi+8];		/* st(0) = pMin->z;*/
		fcomi	st,st(1);				
		fcmovnbe	st(0),st(1);		/*	if pTri[2].p.z > pMin->z st(0) = pTri[2].p.z*/
		fstp	float ptr [edi+8];
		/*if (pMax->z < pTri[2].p.z)	pMax->z = pTri[2].p.z;*/
		fld		float ptr [ebx+8];		/* st(0) = pMax->z;*/
		fcomi	st,st(1);				
		fcmovb	st(0),st(1);			/*	if pMax->z < pTri[2].p.z st(0) = pTri[2].x*/
		fstp	float ptr [ebx+8];	
		fstp	st(0)

		//	Collide2Box

		fild	bFalse;				//	st(3) := 0
		fild	bHit;				//	st(2) := 1
		lea	esi,	vecMin;
		mov	edi,	pMax;
		fld	float ptr[edi];			//	st(1):=pMax2->x
		fld	float ptr[esi];			//	st(0):=pMin1->x
		fcomip	st, st(1);
		fstp	st(0);
		fcmovnbe	st(0),st(1);	//	if (pMin1->x > pMax2->x)	then bHit = FALSE;

		fld	float ptr[edi+4];		//	st(1):= pMax2->y
		fld float ptr[esi+4];		//	st(0):= pMin1->y
		fcomip	st,st(1);
		fstp	st(0);
		fcmovnbe	st(0),st(1);	//	if (pMin1->y > pMax2->y)	then bHit = FALSE;	

		fld	float ptr[edi+8];		//	st(1):= pMax2->z
		fld float ptr[esi+8];		//	st(0):= pMin1->z
		fcomip	st,st(1);
		fstp	st(0);
		fcmovnbe	st(0),st(1);	//	if (pMin1->z > pMax2->z)	then bHit = FALSE;	

		lea	esi,	vecMax;
		mov	edi,	pMin;
		fld	float ptr[edi];			//st(1):=pMin2->x
		fld	float ptr[esi];			//st(0):=pMax1->x
		fcomip	st,st(1);
		fstp	st(0);
		fcmovb	st(0),st(1);		//	if (pMax1->x < pMin2->x)	then bHit = FALSE;

		fld	float ptr[edi+4];		//st(1):=pMin2->y
		fld	float ptr[esi+4];		//st(0):=pMax1->y
		fcomip	st,st(1);
		fstp	st(0);
		fcmovb	st(0),st(1);		//	if (pMax1->y < pMin2->y)	then bHit = FALSE;

		fld	float ptr[edi+8];		//st(1):=pMin2->z
		fld	float ptr[esi+8];		//st(0):=pMax1->z
		fcomip	st,st(1);
		fstp	st(0);
		fcmovb	st(0),st(1);		//	if (pMax1->z < pMin2->z)	then bHit = FALSE;

		fistp	bHit	;
		fstp	st(0)	;
	}
	if (!bHit)
		return FALSE;

	//	̃|SƂ͓蔻sȂB
	D3DXVECTOR3	vec1, vec2,vec3;
  	vec1 = D3DXVECTOR3(pTri[2].p.x - pTri[1].p.x,0,pTri[2].p.z - pTri[1].p.z);
	vec2 = D3DXVECTOR3(pTri[0].p.x - pTri[1].p.x,0,pTri[0].p.z - pTri[1].p.z);
	D3DXVec3Cross(&vec3,&vec1,&vec2);
	if (vec3.y < -FLT_MIN)
		return	FALSE;


	COLLISIONVERTEX	cvec1, cvec2;
	FLOAT	fAlt, fTmp;
	FLOAT	fDist, fDistMin;

	D3DXVECTOR4	vec4Tmp;
	for (i = 0 ; i < 3 ; ++i){
		vec4Tmp.x = pTri[i].n.x;
		vec4Tmp.y = pTri[i].n.y;
		vec4Tmp.z = pTri[i].n.z;
		vec4Tmp.w = 0;
		D3DXVec4Transform(&vec4Tmp,&vec4Tmp,&m_matWorld);
		pTri[i].n = (D3DXVECTOR3)vec4Tmp;
	}

	//	|SA^ォAXZ ʂɓe
	//	eӂ̒ZoB
	dx = pTri[1].p.x - pTri[0].p.x;
	dz = pTri[1].p.z - pTri[0].p.z;
	len1 = dx * dx + dz * dz;
	dx = pTri[2].p.x - pTri[1].p.x;
	dz = pTri[2].p.z - pTri[1].p.z;
	len2 = dx * dx + dz * dz;
	dx = pTri[0].p.x - pTri[2].p.x;
	dz = pTri[0].p.z - pTri[2].p.z;
	len3 = dx * dx + dz * dz;

	//	|Sȏ傫̂݁A|S̏ɏ肤B
	if ((fabs(len1) > FLT_MIN)&&(fabs(len2) > FLT_MIN)&&(fabs(len3) > FLT_MIN)){
		
		D3DXVECTOR3	vecDir1;
		D3DXVECTOR3	vecDir2;

		//	|S̊Oł̋Zo
		//	̂Ƃ͍ł߂ӂ邢͒_߂B
		vecDir1.y = 0;
		vecDir2.y = 0;

		vecDir1.x = x - pTri[0].p.x;
		vecDir1.z = z - pTri[0].p.z;
		vecDir2.x = pTri[1].p.x - pTri[0].p.x;
		vecDir2.z = pTri[1].p.z - pTri[0].p.z;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		if (vecTmp.y > -FLT_MIN){
			bF0=TRUE;
		}
		vecDir1.x = x - pTri[1].p.x;
		vecDir1.z = z - pTri[1].p.z;
		vecDir2.x = pTri[2].p.x - pTri[1].p.x;
		vecDir2.z = pTri[2].p.z - pTri[1].p.z;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		if (vecTmp.y > -FLT_MIN){
			bF1=TRUE;
		}

		vecDir1.x = x - pTri[2].p.x;
		vecDir1.z = z - pTri[2].p.z;
		vecDir2.x = pTri[0].p.x - pTri[2].p.x;
		vecDir2.z = pTri[0].p.z - pTri[2].p.z;
		D3DXVec3Cross(&vecTmp,&vecDir1,&vecDir2);
		if (vecTmp.y > -FLT_MIN){
			bF2=TRUE;
		}

		vecPos = D3DXVECTOR3(x,y,z);

		fDistMin = FLT_MAX;
		//  Op`̏ɏĂƂ
		if (!bF0 && !bF1 && !bF2){
			double	t,u,inv;
			FLOAT	px = x - pTri[0].p.x;
			FLOAT	pz = z - pTri[0].p.z;
			vecDir1 = pTri[1].p - pTri[0].p;
			vecDir2 = pTri[2].p - pTri[0].p;
			FLOAT	x1 = vecDir1.x;
			FLOAT	z1 = vecDir1.z;
			FLOAT	x2 = vecDir2.x;
			FLOAT	z2 = vecDir2.z;
		
			inv = (x1*z2 - x2*z1);
			if (fabs(inv) > FLT_MIN){
				inv = 1.0 / inv;

				t = inv * (px*z2 - pz*x2);
				u = inv * (x1*pz - px*z1);
				//	ՓˈʒuvZ
				vecPos = vecDir1*(FLOAT)t + vecDir2*(FLOAT)u;
				vecPos += pTri[0].p;

				//	@̌vZ
				vecNormal = pTri[0].n * (1-(FLOAT)t) + pTri[1].n * (FLOAT)t;
				vecNormal += pTri[0].n * (1-(FLOAT)u) + pTri[2].n * (FLOAT)u;
				D3DXVec3Normalize(&vecNormal,&vecNormal);
				*pAlt = (FLOAT)vecPos.y;
				*pNormal = vecNormal;
				*pDist = 0;
				return	true;
			}
		}
	}

	//  Op`̏ɍڂĂȂƂ
	fDistMin = FLT_MAX;
	
	cvec1 = pTri[1];	cvec2 = pTri[0];
	if (FitLineToBox(&cvec1,&cvec2,pMin, pMax)){
		CalcShortestDistanceAndAltitude(&vecPos,&cvec1, &cvec2, &fTmp, &fDist,&vecNormal);
		if (fDist < fDistMin){
			fDistMin = fDist;
			fAlt = fTmp;
			*pNormal = vecNormal;
		}
	}
	cvec1 = pTri[2];	cvec2 = pTri[1];
	if (FitLineToBox(&cvec1,&cvec2,pMin, pMax)){
		CalcShortestDistanceAndAltitude(&vecPos,&cvec1, &cvec2, &fTmp, &fDist,&vecNormal);
		if (fDist < fDistMin){
			fDistMin = fDist;
			fAlt = fTmp;
			*pNormal = vecNormal;
		}
	}
	cvec1 = pTri[0];	cvec2 = pTri[2];
	if (FitLineToBox(&cvec1,&cvec2,pMin, pMax)){
		CalcShortestDistanceAndAltitude(&vecPos,&cvec1, &cvec2, &fTmp, &fDist,&vecNormal);
		if (fDist < fDistMin){
			fDistMin = fDist;
			fAlt = fTmp;
			*pNormal = vecNormal;
		}
	}
	if (fDistMin < FLT_MAX){
		fDist = (FLOAT)sqrt(fDistMin);
		*pNormal = vecNormal;
		*pDist = fDist;
		*pAlt = fAlt;
		return	TRUE;
	}
	return	false;
}


//  AABB󂯎Â݂oB
BOOL	CFloor::FitLineToBox(COLLISIONVERTEX *pVec1, COLLISIONVERTEX *pVec2, D3DXVECTOR3 *vecMin, D3DXVECTOR3 *vecMax){
	BOOL	b1, b2;
	b1 = true;	b2 = true;
	D3DXVECTOR3	vp1=pVec1->p, vp2=pVec2->p;
	D3DXVECTOR3	vn1=pVec1->n, vn2=pVec2->n;
	D3DXVECTOR3	vtmp;
	double	ftmp;
	double	w,h,d;	//	width, height, depth

	//	Clip with minimum x plane
	b1 = vp1.x < vecMin->x;
	b2 = vp2.x < vecMin->x;
	if (b1 && b2)
		return	false;

	if (b1!=b2){
		if (b1){
			ftmp = (vecMin->x - vp1.x) / (vp2.x - vp1.x);
			vp1 += (vp2 - vp1) * (FLOAT)ftmp;
		}else{
			ftmp = (vecMin->x - vp2.x) / (vp1.x - vp2.x);
			vp2 += (vp1 - vp2) * (FLOAT)ftmp;
		}
	}
	//	Clip with maximum x plane
	b1 = vp1.x > vecMax->x;
	b2 = vp2.x > vecMax->x;
	if (b1 && b2)
		return	false;

	if (b1!=b2){
		if (b1){
			ftmp = (vecMax->x - vp1.x) / (vp2.x - vp1.x);
			vp1 += (vp2 - vp1) * (FLOAT)ftmp;
		}else{
			ftmp = (vecMax->x - vp2.x) / (vp1.x - vp2.x);
			vp2 += (vp1 - vp2) * (FLOAT)ftmp;
		}
	}


	//	Clip with minimum y plane
	b1 = vp1.y < vecMin->y;
	b2 = vp2.y < vecMin->y;
	if (b1 && b2)
		return	false;

	if (b1!=b2){
		if (b1){
			ftmp = (vecMin->y - vp1.y) / (vp2.y - vp1.y);
			vp1 += (vp2 - vp1) * (FLOAT)ftmp;
		}else{
			ftmp = (vecMin->y - vp2.y) / (vp1.y - vp2.y);
			vp2 += (vp1 - vp2) * (FLOAT)ftmp;
		}
	}

	//	Clip with maximum y plane
	b1 = vp1.y > vecMax->y;
	b2 = vp2.y > vecMax->y;
	if (b1 && b2)
		return	false;

	if (b1!=b2){
		if (b1){
			ftmp = (vecMax->y - vp1.y) / (vp2.y - vp1.y);
			vp1 += (vp2 - vp1) * (FLOAT)ftmp;
		}else{
			ftmp = (vecMax->y - vp2.y) / (vp1.y - vp2.y);
			vp2 += (vp1 - vp2) * (FLOAT)ftmp;
		}
	}

	//	Clip with minimum z plane
	b1 = vp1.z < vecMin->z;
	b2 = vp2.z < vecMin->z;
	if (b1 && b2)
		return	false;

	if (b1!=b2){
		if (b1){
			ftmp = (vecMin->z - vp1.z) / (vp2.z - vp1.z);
			vp1 += (vp2 - vp1) * (FLOAT)ftmp;
		}else{
			ftmp = (vecMin->z - vp2.z) / (vp1.z - vp2.z);
			vp2 += (vp1 - vp2) * (FLOAT)ftmp;
		}
	}

	//	Clip with maximum z plane
	b1 = vp1.z > vecMax->z;
	b2 = vp2.z > vecMax->z;
	if (b1 && b2)
		return	false;

	if (b1!=b2){
		if (b1){
			ftmp = (vecMax->z - vp1.z) / (vp2.z - vp1.z);
			vp1 += (vp2 - vp1) * (FLOAT)ftmp;
		}else{
			ftmp = (vecMax->z - vp2.z) / (vp1.z - vp2.z);
			vp2 += (vp1 - vp2) * (FLOAT)ftmp;
		}
	}
	w = pVec2->p.x - pVec1->p.x;
	h = pVec2->p.y - pVec1->p.y;
	d = pVec2->p.z - pVec1->p.z;
	w *= w;	h *= h;	d *= d;
	if (w > h && w > d){

		//	x 
		w = 1.0 / w;
		ftmp = (vp1.x - pVec1->p.x) * w;
		vtmp = pVec2->n * (FLOAT)ftmp + pVec1->n * (FLOAT)(1.0 - ftmp);
		D3DXVec3Normalize(&vn1,&vtmp);

		ftmp = (vp2.x - pVec1->p.x) + w;
		vtmp = pVec2->n * (FLOAT)ftmp + pVec1->n * (FLOAT)(1.0 - ftmp);
		D3DXVec3Normalize(&vn2,&vtmp);

	}else if (h > d && h > w){
		//	y 
		h = 1.0 / h;
		ftmp = (vp1.y - pVec1->p.y) * h;
		vtmp = pVec2->n * (FLOAT)ftmp + pVec1->n * (FLOAT)(1.0 - ftmp);
		D3DXVec3Normalize(&vn1,&vtmp);

		ftmp = (vp2.y - pVec1->p.y) * h;
		vtmp = pVec2->n * (FLOAT)ftmp + pVec1->n * (FLOAT)(1.0 - ftmp);
		D3DXVec3Normalize(&vn2,&vtmp);

	}else{
		//	z 
		d = 1.0 / d;
		ftmp = (vp1.z - pVec1->p.z) * d;
		vtmp = pVec2->n * (FLOAT)ftmp + pVec1->n * (FLOAT)(1.0 - ftmp);
		D3DXVec3Normalize(&vn1,&vtmp);

		ftmp = (vp2.z - pVec1->p.z) * d;
		vtmp = pVec2->n * (FLOAT)ftmp + pVec1->n * (FLOAT)(1.0 - ftmp);
		D3DXVec3Normalize(&vn2,&vtmp);

	}
	//  _o
	pVec1->p = vp1;		pVec1->n = vn1;
	pVec2->p = vp2;		pVec2->n = vn2;
	return true;
}

#if	1
//-------------------------------------------------------------
//	Name: CalcShortestDistanceAndAltitude
//  Desc: w肳ꂽƁA_Ƃ̊Ԃ̍ŏ߂B
//		XZ ʂɓeē񎟌IɍsȂB
//-------------------------------------------------------------
void	CFloor::CalcShortestDistanceAndAltitude(D3DXVECTOR3 *vecPos, COLLISIONVERTEX *vecP1, COLLISIONVERTEX *vecP2, float *pAlt, float *pDist, D3DXVECTOR3 *pNormal){
	double	t;
	double	dx1, dy1, dz1, dx2, dz2;
	double	len, len1, len2;	
	double	px, py, pz;

	dx1 = vecP2->p.x - vecP1->p.x;
	dy1 = vecP2->p.y - vecP1->p.y;
	dz1 = vecP2->p.z - vecP1->p.z;

	dx2 = vecP1->p.x - vecPos->x;
//	dy2 = vecP1->p.y - vecPos->y;
	dz2 = vecP1->p.z - vecPos->z;

	len = dx1*dx1 + dz1*dz1;
	if (len < FLT_MIN){
		*pDist = (float)(dx2*dx2 + dz2 * dz2);
		*pAlt = (float)vecP1->p.y;
		*pNormal = vecP1->n;
		D3DXVec3Normalize(pNormal,pNormal);
		return;
	}

	//	̔Cӂ̓_vecPos Ŏ_Ƃ̋A
	//	Zo鎮āA
	//	ꂪOɂȂ_߂ƁAŒZł_
	//	߂鎖łB
	t = -(dx1 * dx2 + dz1*dz2);
	t /= len;
	if ((t >= 0.0f) && (t <= 1.0f)){
		//	̓_ŏꍇ

		//	ŏƂȂP1-P2 ̓_߂
		px = vecP1->p.x + (dx1*t);
		py = vecP1->p.y + (dy1*t);
		pz = vecP1->p.z + (dz1*t);

		//	߂ꂽ_Ƃ̋Zo
		dx1 = px - vecPos->x;		//	߂ꂽ_Ƃ
		dz1 = pz - vecPos->z;		//	Zo
		len = dx1*dx1 + dz1*dz1;
		*pDist = (float)len;		//	Ăяo
		*pAlt = (float)py;			//	lԂB
		*pNormal = vecP1->n + ((vecP2->n - vecP1->n) * (float)t);
		D3DXVec3Normalize(pNormal, pNormal);
		return;
	}else{
		//	ꂩ̒_ŏłꍇB
		dx1  = vecP2->p.x - vecPos->x;
		dz1  = vecP2->p.z - vecPos->z;
		len1  = dx2*dx2 + dz2*dz2;	//	P1 ܂ł̋
		len2 = dx1*dx1 + dz1*dz1;	//	P2 ܂ł̋
		if ( len2 < len1 ){
			//	P2܂ł̋ƁAP2 ̍xԂ
			*pNormal = vecP2->n;
			*pDist = (float)len2;
			*pAlt = vecP2->p.y;
			D3DXVec3Normalize(pNormal,pNormal);
			return;
		}
		//	P1 ܂ł̋ƁAP1 ̍xԂ
		*pDist   = (float)len1;
		*pAlt    = vecP1->p.y;
		*pNormal = vecP1->n;
		D3DXVec3Normalize(pNormal,pNormal);
	}
	return;
}
#else
//-------------------------------------------------------------
//	Name: CalcShortestDistanceAndAltitude
//  Desc: w肳ꂽƁA_Ƃ̊Ԃ̍ŏ߂B
//		͂RcōsȂB
//-------------------------------------------------------------
void	CFloor::CalcShortestDistanceAndAltitude(D3DXVECTOR3 *vecPos, COLLISIONVERTEX *vecP1, COLLISIONVERTEX *vecP2, float *pAlt, float *pDist, D3DXVECTOR3 *pNormal){
	double	t;
	double	dx1, dy1, dz1, dx2, dy2, dz2;
	double	len, len1, len2;	
	double	px, py, pz;

	dx1 = vecP2->p.x - vecP1->p.x;
	dy1 = vecP2->p.y - vecP1->p.y;
	dz1 = vecP2->p.z - vecP1->p.z;

	dx2 = vecP1->p.x - vecPos->x;
	dy2 = vecP1->p.y - vecPos->y;
	dz2 = vecP1->p.z - vecPos->z;

	len = dx1*dx1 + dy1*dy1 + dz1*dz1;
	if (len < FLT_MIN){
		*pDist = (float)(dx2*dx2 + dy2*dy2 + dz2 * dz2);
		*pAlt = (float)vecP1->p.y;
		*pNormal = vecP1->n;
		D3DXVec3Normalize(pNormal,pNormal);
		return;
	}

	//	̔Cӂ̓_vecPos Ŏ_Ƃ̋A
	//	Zo鎮āA
	//	ꂪOɂȂ_߂ƁAŒZł_
	//	߂鎖łB
	t = -(dx1 * dx2 + dy1*dy2 + dz1*dz2);
	t /= len;
	if ((t >= 0.0f) && (t <= 1.0f)){
		//	̓_ŏꍇ

		//	ŏƂȂP1-P2 ̓_߂
		px = vecP1->p.x + (dx1*t);
		py = vecP1->p.y + (dy1*t);
		pz = vecP1->p.z + (dz1*t);

		//	߂ꂽ_Ƃ̋Zo
		dx1 = px - vecPos->x;		//	߂ꂽ_Ƃ
		dy1 = py - vecPos->y;		//	Zo
		dz1 = pz - vecPos->z;		//
		len = dx1*dx1 + dy1*dy1 + dz1*dz1;
		*pDist = (float)len;		//	Ăяo
		*pAlt = (float)py;			//	lԂB
		*pNormal = vecP1->n + ((vecP2->n - vecP1->n) * (float)t);
		D3DXVec3Normalize(pNormal, pNormal);
		return;
	}else{
		//	ꂩ̒_ŏłꍇB
		dx1  = vecP2->p.x - vecPos->x;
		dy1  = vecP2->p.y - vecPos->y;
		dz1  = vecP2->p.z - vecPos->z;
		len1  = dx2*dx2 + dy2 * dy2 + dz2*dz2;	//	P1 ܂ł̋
		len2 = dx1*dx1 + dy1 * dy1 + dz1*dz1;	//	P2 ܂ł̋
		if ( len2 < len1 ){
			//	P2܂ł̋ƁAP2 ̍xԂ
			*pNormal = vecP2->n;
			*pDist = (float)len2;
			*pAlt = vecP2->p.y;
			D3DXVec3Normalize(pNormal,pNormal);
			return;
		}
		//	P1 ܂ł̋ƁAP1 ̍xԂ
		*pDist   = (float)len1;
		*pAlt    = vecP1->p.y;
		*pNormal = vecP1->n;
		D3DXVec3Normalize(pNormal,pNormal);
	}
	return;
}
#endif
//-------------------------------------------------------------
//	Name: MatrixTriangleInverseRotation
//  Desc: |SP0-P1-P2 ̐p0-p1 ZɕsɂȂ悤
//		]}gbNXvZB
//-------------------------------------------------------------
void	CFloor::MatrixTriangleInverseRotation(D3DXMATRIX *pOut, D3DXVECTOR3 *vecZ)
{
	pOut->_11 = vecZ->z;
	pOut->_21 = 0.0f;
	pOut->_31 = -vecZ->x;
	pOut->_41 = 0.0f;

	pOut->_12 = 0.0f;
	pOut->_22 = 1.0f;
	pOut->_32 = 0.0f;
	pOut->_42 = 0.0f;

	pOut->_13 = vecZ->x;
	pOut->_23 = 0.0f;
	pOut->_33 = vecZ->z;
	pOut->_43 = 0.0f;

	pOut->_14 = 0.0f;
	pOut->_24 = 0.0f;
	pOut->_34 = 0.0f;
	pOut->_44 = 1.0f;
}

#if	0
//-------------------------------------------------------------
//	Name: Collide2Box
//  Desc: Q̃{bNX̂蔻
//-------------------------------------------------------------
BOOL	CFloor::Collide2Box(D3DXVECTOR3 *pMin1, D3DXVECTOR3 *pMax1, D3DXVECTOR3 *pMin2, D3DXVECTOR3 *pMax2)
{
	if (pMin1->x > pMax2->x)
		return	false;
	if (pMin1->y > pMax2->y)
		return	false;
	if (pMin1->z > pMax2->z)
		return	false;
	if (pMax1->x < pMin2->x)
		return	false;
	if (pMax1->y < pMin2->y)
		return	false;
	if (pMax1->z < pMin2->z)
		return	false;
	return	true;
}
#endif