#include "StdAfx.h"
#include <d3dx9.h>
#include <dxfile.h>
#include <tchar.h>
#include <crtdbg.h>
#include "D3DQuickLib.h"
#include ".\filevertexshader.h"

CFileVertexShader::CFileVertexShader(CD3DEnv *pEnv, TCHAR *strFilename, GUID guid)
: CShaderContainer(pEnv,guid)
{
	int	len;
	len = (int)_tcslen(strFilename);
	len++;
	m_pFilename = new TCHAR[len];
	_tcscpy_s(m_pFilename,len,strFilename);
	m_pVertexShader = NULL;
}

CFileVertexShader::~CFileVertexShader(void)
{
	InvalidateDeviceObjects();
	if (m_pFilename != NULL)
		delete	[]m_pFilename;
}

//--------------------------------------------
//	method : Restore
//	Note   : VF[_̓ǂݍ
//--------------------------------------------
HRESULT CFileVertexShader::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	TCHAR	strPath[MAX_PATH];
	LPD3DXBUFFER	pCode;
	LPD3DXBUFFER	pError= NULL;
	HRESULT	hr;
	char	*str;
	CD3DEnv	*pEnv;
	if (m_pVertexShader != NULL)
		return	S_OK;	//	No need to Restore

	pEnv = m_pDB->GetEnv();
	_tcscpy_s(strPath, _countof(strPath), pEnv->GetAppPathName());
	_tcscat_s(strPath, _countof(strPath), _T("\\"));
	_tcscat_s(strPath, _countof(strPath), m_pFilename);

	// Assemble the vertex shader file
    if( FAILED( hr = D3DXAssembleShaderFromFile( strPath, NULL, NULL, 0, &pCode, &pError ) ) ){
        _RPT0(_CRT_WARN,"Assemble Error.\n");
		str = (char*)pError->GetBufferPointer();
		SAFE_RELEASE(pError);
		return hr;
	}
	SAFE_RELEASE(pError);

	hr = lpd3ddev->CreateVertexShader((DWORD*)pCode->GetBufferPointer(),
		&m_pVertexShader);
    pCode->Release();
	if (FAILED( hr ))
		return	hr;

	return	S_OK;
}

//--------------------------------------------
//	method : Invalidate
//	Note   : VF[_̔j
//--------------------------------------------
HRESULT CFileVertexShader::InvalidateDeviceObjects(){
	SAFE_RELEASE(m_pVertexShader);
	return	S_OK;
}

//--------------------------------------------
//	method : Invalidate
//	Note   : VF[_̔j
//--------------------------------------------
LPDIRECT3DVERTEXSHADER9 CFileVertexShader::GetDXVertexShader(){
	return	m_pVertexShader;
}
