/*
 *	class CEnhancedMesh
 *		bVɋ@\ǉ郆[eBeB[NX
 *
 *		First edition: February.19.2004
 *
*/
#include "stdafx.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "d3d9env.h"
#include "EnhancedMesh.h"
#include <tchar.h>
#include "TextureDB.h"


CEnhancedMesh::CEnhancedMesh(CD3DEnv *pEnv, TCHAR *fname) : CMesh(pEnv, fname)
{
	m_bUseHWNPatches = FALSE;
    m_dwNumSegs = 2;

    m_pMeshEnhanced = NULL;
}

CEnhancedMesh::~CEnhancedMesh()
{
	InvalidateDeviceObjects();
	DeleteDeviceObjects();
}

//-------------------------------------------------------------
//	Name: InitDeviceObjects
//  Desc: foCXˑIuWFNg̐
//-------------------------------------------------------------
HRESULT	CEnhancedMesh::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	return	CMesh::InitDeviceObjects(lpd3ddev);
}

//-------------------------------------------------------------
//	Name: RestoreDeviceObjects
//  Desc: foCXˑrfIIuWFNg̐
//-------------------------------------------------------------
HRESULT CEnhancedMesh::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
    HRESULT    hr;
    D3DCAPS9    d3dCaps;

	CMesh::RestoreDeviceObjects(lpd3ddev);
    if (m_pMeshSysMem == NULL){
        return E_FAIL;
    }
	if (this->m_pMeshEnhanced != NULL){
		m_uiMeshStatus = MESH_IS_RESTORED;
		return	S_OK;
	}

    lpd3ddev->GetDeviceCaps(&d3dCaps);

    m_bUseHWNPatches = (d3dCaps.DevCaps & D3DDEVCAPS_NPATCHES);
	hr = GenerateEnhancedMesh( lpd3ddev, m_dwNumSegs );
    if( FAILED(hr) )
		return	hr;
	m_uiMeshStatus = MESH_IS_RESTORED;
	return hr;
}

//-------------------------------------------------------------
//	Name: GenerateEnhancedMesh
//  Desc: n[hEFA NPatch  \tgEFAɂ
//		eZ[Vi|SjgpāAbV
//		gBɒ_obt@rfIJ[hɓ]B
//-------------------------------------------------------------
HRESULT CEnhancedMesh::GenerateEnhancedMesh( LPDIRECT3DDEVICE9 lpd3ddev, UINT dwNewNumSegs )
{
    LPD3DXMESH pMeshTemp=NULL,pMeshTemp2=NULL;
    HRESULT    hr;

    if (m_bUseHWNPatches){
        // n[hEFAT|[gȂA|S𕪊ărfIJ[hցB
        hr = m_pMeshSysMem->CloneMeshFVF( D3DXMESH_WRITEONLY | D3DXMESH_NPATCHES, 
                                m_pMeshSysMem->GetFVF(), lpd3ddev, &pMeshTemp );
        if( FAILED(hr) )
            return hr;
    }else{
		if (this->m_dwNumSegs != 0){
		//	\tgEFAeZ[VB
			if (SUCCEEDED(D3DXTessellateNPatches(m_pMeshSysMem,NULL,(float)m_dwNumSegs,
				FALSE,&pMeshTemp2, NULL))){
				hr = pMeshTemp2->CloneMeshFVF( D3DXMESH_WRITEONLY, 
		             pMeshTemp2->GetFVF(), lpd3ddev, &pMeshTemp );
				pMeshTemp2->Release();
				pMeshTemp2 = NULL;
			}
		}
		if (pMeshTemp ==NULL){
        // n[hEFAT|[gȂA_f[^rfIJ[hցB
			hr = m_pMeshSysMem->CloneMeshFVF( D3DXMESH_WRITEONLY, 
		             m_pMeshSysMem->GetFVF(), lpd3ddev, &pMeshTemp );
		}
	}
    if (m_pMeshEnhanced != NULL){
        m_pMeshEnhanced->Release();
        m_pMeshEnhanced = NULL;
    }
    m_pMeshEnhanced = pMeshTemp;
    m_dwNumSegs     = dwNewNumSegs;
    return S_OK;
}

//-------------------------------------------------------------
//	Name: InvalidateDeviceObjects
//  Desc: foCXˑrfIIuWFNg̏
//-------------------------------------------------------------
HRESULT CEnhancedMesh::InvalidateDeviceObjects()
{
    if (m_pMeshEnhanced != NULL){
        m_pMeshEnhanced->Release();
        m_pMeshEnhanced = NULL;
    }
	CMesh::InvalidateDeviceObjects();
	m_uiMeshStatus = MESH_IS_INITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: DeleteDeviceObjects
//  Desc: foCXˑIuWFNg̏
//-------------------------------------------------------------
HRESULT CEnhancedMesh::DeleteDeviceObjects()
{
	InvalidateDeviceObjects();
	CMesh::DeleteDeviceObjects();
	m_uiMeshStatus = MESH_IS_UNINITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void    CEnhancedMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev)
{
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB

    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_CCW);
	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}
    if (m_bUseHWNPatches){
        float fNumSegs;
        fNumSegs = (float)m_dwNumSegs;
		lpd3ddev->SetNPatchMode(fNumSegs);
    }
    if (m_pMeshEnhanced){
        for( UINT i = 0; i < m_dwNumMaterials; i++ ){
			FLOAT	oldAlpha = m_pMaterials[i].Diffuse.a;
			m_pMaterials[i].Diffuse.a *= m_fOpacity;
            lpd3ddev->SetMaterial( &m_pMaterials[i] );
			if (m_ppTextures[i]){
	            lpd3ddev->SetTexture( 0, m_ppTextures[i]->GetTexture() );
			}else{
				lpd3ddev->SetTexture( 0, NULL);
			}
            m_pMeshEnhanced->DrawSubset( i );
			m_pMaterials[i].Diffuse.a = oldAlpha;
        }
    }
    if (m_bUseHWNPatches){
		lpd3ddev->SetNPatchMode(0);
    }
}

