/*
 *	class
 *
 *		CDeviceInformation
 *
 *		  ̃NX́AVXeɃCXg[ꂽ
 *		OtBbNXfoCXɂĂ̏WA
 *		񋟂@\B
 *
 *	ڍׂ́ALtqkQ
 *	http://www5b.biglobe.ne.jp/~u-hei/d3d2d/devinfo.html
 *
 *		First Edition: August.12.2002
 */

#include "stdafx.h"
#include <math.h>
#include <d3d9.h>
#include <d3dx9.h>
#include "DeviceInformation.h"
#include <crtdbg.h>

//	STL gp悤߂ March.31.2014
#include <list>

static int SortModesCallback( const VOID* arg1, const VOID* arg2 );
#define	SAFE_DELETE(o)	{if (o){	delete (o); (o) = NULL;	}}
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }

CDeviceInformation::CDeviceInformation(LPDIRECT3D9 lpd3d, BOOL useD, DWORD minD, DWORD minS, ConfirmDeviceCallback cb, LPVOID ref)
{
	m_lpD3D = lpd3d;
	m_dwNumAdapters = 0;
	m_Adapters = NULL;
	m_bWindowed = false;
	m_dwMinDepthBits = minD;
	m_dwMinStencilBits = minS;
	m_bUseDepthBuffer = useD;
	m_lpRefPtr = ref;
	m_procCallback = cb;

	if (FAILED(BuildDeviceList())){
		ReleaseDeviceList();
	}
}

CDeviceInformation::~CDeviceInformation(){
	ReleaseDeviceList();
}

//-----------------------------------------------------------------------------
// Name: BuildDeviceList()
// Desc:
//-----------------------------------------------------------------------------
HRESULT CDeviceInformation::BuildDeviceList()
{
	HRESULT	hr;
    const DWORD dwNumDeviceTypes = 2;
    const D3DDEVTYPE DeviceTypes[] = { D3DDEVTYPE_HAL, D3DDEVTYPE_REF };
	std::list<D3DDISPLAYMODE>*pvecmodes = NULL;
	std::list<D3DFORMAT>*pvecformats = NULL;
	D3DDISPLAYMODE	*pmodes = NULL;
	D3DFORMAT		*pformats = NULL;

	DWORD dwNumFormats;
    DWORD dwNumModes;
    DWORD dwNumAdapterModes;

    bHALExists = FALSE;
    bHALIsWindowedCompatible = FALSE;
    bHALIsDesktopCompatible = FALSE;
    bHALIsSampleCompatible = FALSE;

	m_Adapters = new D3DAdapterInfo[m_dwNumAllAdapters = m_lpD3D->GetAdapterCount()];
    ZeroMemory( m_Adapters, sizeof(D3DAdapterInfo)*m_dwNumAllAdapters);
	UINT	iAdapter;
	for( iAdapter = 0; iAdapter < m_dwNumAllAdapters; iAdapter++)
	{
		if (
			NULL == (m_Adapters[iAdapter].devices = new D3DDeviceInfo[dwNumDeviceTypes])
		){
			return	E_OUTOFMEMORY;
		}
		ZeroMemory( m_Adapters[iAdapter].devices, sizeof(D3DDeviceInfo)*dwNumDeviceTypes);
	}
    for( iAdapter = 0; iAdapter < m_dwNumAllAdapters; iAdapter++ )
    {
        // A_v^̊i[
        D3DAdapterInfo* pAdapter  = &m_Adapters[m_dwNumAdapters];
        m_lpD3D->GetAdapterIdentifier( iAdapter, 0, &pAdapter->d3dAdapterIdentifier );
        m_lpD3D->GetAdapterDisplayMode( iAdapter, &pAdapter->d3ddmDesktop );

		pvecmodes = new std::list<D3DDISPLAYMODE>;
		pvecformats = new std::list<D3DFORMAT>;
		pAdapter->dwNumDevices    = 0;
        pAdapter->dwCurrentDevice = 0;

        // SfBXvC[h񋓂B
        dwNumFormats      = 0;
        dwNumModes        = 0;
        dwNumAdapterModes = 0;

        // ݃fXNgbvŎgpĂtH[}bgۑ
		pvecformats->push_back(pAdapter->d3ddmDesktop.Format);
		dwNumFormats++;

		//	fBXvC[h
		D3DFORMAT prefFormats[]={
			D3DFMT_R5G6B5,
			D3DFMT_A1R5G5B5,
			D3DFMT_A8R8G8B8,
			D3DFMT_X8R8G8B8,
			D3DFMT_A2B10G10R10,
			D3DFMT_X1R5G5B5
		};
		int		iFormat;
		for (iFormat = 0; iFormat < (sizeof(prefFormats)/sizeof(D3DFORMAT)) ; ++iFormat){
			dwNumAdapterModes = m_lpD3D->GetAdapterModeCount( iAdapter, prefFormats[iFormat] );
			BuildModes(iAdapter, dwNumAdapterModes, &dwNumModes, &dwNumFormats, (VOID*)pvecmodes, (VOID*)pvecformats, prefFormats[iFormat] );
		}

#ifdef	_DEBUG
		//	`FbNp
		if (dwNumModes != pvecmodes->size()){
			_RPT0(_CRT_WARN,"NumModes Collapsed!\n");
		}
		if (dwNumFormats != pvecformats->size()){
			_RPT0(_CRT_WARN,"NumFomats Collapsed!\n");
		}
#endif

		//	sւȂ̂Œʏ̔zɓWJȂ
		pmodes   = new D3DDISPLAYMODE[max(pvecmodes->size(),1)];
		pformats = new D3DFORMAT[max(pvecformats->size(),1)];
		int	iMode=0;
		for (std::list<D3DDISPLAYMODE>::iterator i = pvecmodes->begin(); i != pvecmodes->end() ; ++i)
			pmodes[iMode++] = *i;
		iFormat = 0;
		for (std::list<D3DFORMAT>::iterator i = pvecformats->begin(); i != pvecformats->end() ; ++i)
			pformats[iFormat++] = *i;
		
		SAFE_DELETE(pvecmodes);
		SAFE_DELETE(pvecformats);

		//	ʃ[h̃\[g
		qsort((VOID*)pmodes,dwNumModes,sizeof(D3DDISPLAYMODE),::SortModesCallback);

		// A_v^ɃfoCXi[
        for( UINT iDevice = 0; iDevice < dwNumDeviceTypes; iDevice++ )
        {
            // foCXɂďi[
            D3DDeviceInfo* pDevice;
            pDevice                 = &pAdapter->devices[pAdapter->dwNumDevices];
            pDevice->DeviceType     = DeviceTypes[iDevice];
            m_lpD3D->GetDeviceCaps( iAdapter, DeviceTypes[iDevice], &pDevice->d3dCaps );
            pDevice->dwNumModes     = 0;
            pDevice->dwCurrentMode  = 0;
            pDevice->bCanDoWindowed = FALSE;
            pDevice->bWindowed      = FALSE;
            pDevice->MultiSampleType = D3DMULTISAMPLE_NONE;

			//	tH[}bg`FbNpɕKvȃm
            BOOL		*bFormatConfirmed = new BOOL[dwNumFormats];
            DWORD		*dwBehavior       = new DWORD[dwNumFormats];
            D3DFORMAT	*fmtDepthStencil  = new D3DFORMAT[dwNumFormats];

			ConfirmFormats(	iAdapter, pDevice, pformats, bFormatConfirmed,
							fmtDepthStencil, dwBehavior, dwNumFormats);

			SAFE_DELETE_ARRAY(pDevice->modes);

			hr = AddValidModes(pDevice,pmodes,pformats,dwBehavior,fmtDepthStencil,bFormatConfirmed,dwNumModes,dwNumFormats);
			if (FAILED(hr))
				return	hr;

			// 𑜓x 640x480 ̃[hlƂB
			//(sNZtH[}bg16rbg̃[hD悷)
			for(DWORD m=0L; m<pDevice->dwNumModes; m++ ){
				if( pDevice->modes[m].Width==640 && pDevice->modes[m].Height==480 )
				{
					pDevice->dwCurrentMode = m;
					if( pDevice->modes[m].Format == D3DFMT_R5G6B5 ||
						pDevice->modes[m].Format == D3DFMT_X1R5G5B5 ||
						pDevice->modes[m].Format == D3DFMT_A1R5G5B5 )
					{
						break;
					}
				}
			}

			// foCXfXNgbṽ[hƌ݊邩`FbNB
			// ݊ɂẮAformats[0]ɕۑĂB
			if( bFormatConfirmed[0]){
				hr = S_OK;
				if (pDevice->DeviceType == D3DDEVTYPE_HAL){
					hr = m_lpD3D->CheckDeviceType(iAdapter,D3DDEVTYPE_HAL,pAdapter->d3ddmDesktop.Format,D3DFMT_UNKNOWN,TRUE);
				}
				if (SUCCEEDED(hr)){
					pDevice->bCanDoWindowed = TRUE;
					pDevice->bWindowed      = TRUE;
				}
			}

			// gp\ȃ[h΁Aۑ܂B
			if( pDevice->dwNumModes > 0 ){
				pAdapter->dwNumDevices++;
			}else{
				delete[] pDevice->modes;
				pDevice->modes = NULL;
			}

			//	delete confirmation
			delete	bFormatConfirmed;
			delete	dwBehavior;
			delete	fmtDepthStencil;
		}

		SAFE_DELETE(pmodes);
		SAFE_DELETE(pformats);

		// foCXgp\łΕۑ܂B
		if( pAdapter->dwNumDevices > 0 )
			m_dwNumAdapters++;
	}

	// gp\ȃfoCX΃G[Ԃ܂B
	if( 0L == m_dwNumAdapters )
		return E_FAIL;

	// foCXƂăEBhEɃ_[\HAL foCXԂ܂B
	DWORD	a;
	for( a=0; a<m_dwNumAdapters; a++ ){
		for( DWORD d=0; d < m_Adapters[a].dwNumDevices; d++ ){
			if( m_Adapters[a].devices[d].bWindowed ){
				if( m_Adapters[a].devices[d].DeviceType == D3DDEVTYPE_HAL ){
					m_Adapters[a].dwCurrentDevice = d;
					m_dwAdapter = a;
					m_bWindowed = TRUE;
					return S_OK;
				}
			}
		}
	}
	// foCXƂăEBhEɃ_[s\HAL foCXԂ܂B
	for( a=0; a<m_dwNumAdapters; a++ ){
		for( DWORD d=0; d < m_Adapters[a].dwNumDevices; d++ ){
			if( m_Adapters[a].devices[d].DeviceType == D3DDEVTYPE_HAL ){
				m_Adapters[a].dwCurrentDevice = d;
				m_dwAdapter = a;
				m_bWindowed = FALSE;
				return S_OK;
			}
		}
	}
	// foCXƂăEBhEɃ_[\ȃfoCXԂ܂B
	for( a=0; a<m_dwNumAdapters; a++ ){
		for(DWORD d=0; d < m_Adapters[a].dwNumDevices; d++ ){
			if( m_Adapters[a].devices[d].bWindowed ){
				m_Adapters[a].dwCurrentDevice = d;
		        m_dwAdapter = a;
			    m_bWindowed = TRUE;
	            return S_OK;
            }
        }
    }
	//	EChEɃ_[\ȃfoCXꍇB
	//	itXN[ REF 𗘗pj
    m_Adapters[a].dwCurrentDevice = 0;
    m_dwAdapter = 0;
    m_bWindowed = FALSE;
	return	S_OK;
}

HRESULT	CDeviceInformation::BuildModes(UINT iAdapter, DWORD dwNumAdapterModes, 
							DWORD *dwNumModes, DWORD *dwNumFormats, 
							VOID *pvecmodes, VOID *pvecformats,D3DFORMAT fmt)
{
	DWORD	nm = *dwNumModes;
	DWORD	nf = *dwNumFormats;

	std::list<D3DDISPLAYMODE>*pmodes = (std::list<D3DDISPLAYMODE>*)pvecmodes;
	std::list<D3DFORMAT>*pformats = (std::list<D3DFORMAT>*)pvecformats;
	for( UINT iMode = 0; iMode < dwNumAdapterModes; iMode++ )
    {
        D3DDISPLAYMODE DisplayMode;
        m_lpD3D->EnumAdapterModes( iAdapter, fmt, iMode, &DisplayMode );

        // 𑜓x[h𖳎
        if( DisplayMode.Width  < 640 || DisplayMode.Height < 400 )
            continue;

        //	  ̓t[[gӎĂȂ߁A
		//	̃[hԂꍇ邪A𖳎B
		//	i𑜓xEsNZtH[}bgfps ݈̂قȂ郂[hj
		std::list<D3DDISPLAYMODE>::iterator i;
		for( i = pmodes->begin(); i != pmodes->end(); ++i ){
			
            if( ( i->Width  == DisplayMode.Width  )
                && ( i->Height == DisplayMode.Height )
                && ( i->Format == DisplayMode.Format )
				&& ( i->RefreshRate == DisplayMode.RefreshRate )
				)
                break;
        }

        // [hAۑ
        if( i == pmodes->end() )
		{
			//DisplayMode.RefreshRate = 0;
			pmodes->push_back(DisplayMode);
            nm++;

            // VtH[}bg`FbNB
			std::list<D3DFORMAT>::iterator i;
			for(i = pformats->end(); i != pformats->end();++i){
                if( DisplayMode.Format == *i )
                    break;
			}

            // tH[}bgV΃Xg֒ǉ
            if( i == pformats->end() ){
				pformats->push_back(DisplayMode.Format);
				++nf;
			}
		}
    }

	// fBXvC[hĂяoɕԂB
	*dwNumModes = nm;
	*dwNumFormats = nf;
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name: ConfirmFormats()
// Desc: SẴtH[}bgeXgB
//-----------------------------------------------------------------------------
void	CDeviceInformation::ConfirmFormats(int iAdapter, D3DDeviceInfo *pDevice, 
					D3DFORMAT *formats, BOOL *confirmed, 
					D3DFORMAT *fmtDepthStencil, DWORD *behavior, 
					DWORD numFormats)
{
	HRESULT	hr;
	for( DWORD f=0; f<numFormats; f++ )
    {
		confirmed[f] = FALSE;
		fmtDepthStencil[f] = D3DFMT_UNKNOWN;

		// Skip formats that cannot be used as render targets on this device
		if( FAILED( m_lpD3D->CheckDeviceType( iAdapter, pDevice->DeviceType,
									formats[f], formats[f], FALSE ) ) )
			continue;

		if( pDevice->DeviceType == D3DDEVTYPE_HAL ){
			bHALExists = TRUE;
			hr = m_lpD3D->CheckDeviceType(iAdapter,D3DDEVTYPE_HAL,formats[f], formats[f], TRUE);

			if (SUCCEEDED(hr)){
				bHALIsWindowedCompatible = TRUE;
				if( f == 0 ){
					bHALIsDesktopCompatible = TRUE;
				}
			}
		}
		//	foCX̊mF n[hEFAo[ebNXvZbVO
		if( pDevice->d3dCaps.DevCaps&D3DDEVCAPS_HWTRANSFORMANDLIGHT )
		{	
			//	n[hEFAWIgZECeBOT|[gĂB
			if( pDevice->d3dCaps.DevCaps&D3DDEVCAPS_PUREDEVICE )
			{
				behavior[f] = D3DCREATE_HARDWARE_VERTEXPROCESSING |
									D3DCREATE_PUREDEVICE;

				if( SUCCEEDED( ConfirmDevice( &pDevice->d3dCaps, behavior[f],
                                                      formats[f] ) ) )
					confirmed[f] = TRUE;
			}

			if ( FALSE == confirmed[f] )
			{
				behavior[f] = D3DCREATE_HARDWARE_VERTEXPROCESSING;
				if( SUCCEEDED( ConfirmDevice( &pDevice->d3dCaps, behavior[f],
												formats[f] ) ) )
					confirmed[f] = TRUE;
			}

			if ( FALSE == confirmed[f] )
			{
				behavior[f] = D3DCREATE_MIXED_VERTEXPROCESSING;
				if( SUCCEEDED( ConfirmDevice( &pDevice->d3dCaps, behavior[f],
												formats[f] ) ) )
					confirmed[f] = TRUE;
			}
		}

		// \tgEFAo[ebNXvZbVOT|[gĂB
		if( FALSE == confirmed[f]){
			behavior[f] = D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			if( SUCCEEDED( ConfirmDevice( &pDevice->d3dCaps, behavior[f],
											formats[f] ) ) )
				confirmed[f] = TRUE;
		}

		//	̃foCXɓK[x^XeVobt@tH[}bg
		if( confirmed[f] && m_bUseDepthBuffer )
		{
			if( !FindDepthStencilFormat( iAdapter, pDevice->DeviceType,
						formats[f], &fmtDepthStencil[f] ) )
			{
				confirmed[f] = FALSE;
			}
		}
	}
}

//-----------------------------------------------------------------------------
// Name: AddValidModes()
// Desc: SẴfBXvC[hƗp\ȃsNZtH[}bg킹āA
//		f[^Ƃēo^B
//-----------------------------------------------------------------------------
HRESULT	CDeviceInformation::AddValidModes(D3DDeviceInfo	*pDevice, D3DDISPLAYMODE *modes, D3DFORMAT *formats, DWORD *behavior, D3DFORMAT *fmtDepthStencil, BOOL *confirmed, DWORD numModes, DWORD numFormats)
{
	DWORD	m,f,max;
	
	//	PASS 1,  Count the number of modes.
	max = 0;
	for( m=0L; m < numModes; m++ ){
        for( DWORD f=0; f < numFormats; f++ ){
            if (( modes[m].Format == formats[f] )&&( confirmed[f] == TRUE ))
				++max;
        }
    }

	//	PASS 2,  Add modes to the device's list of valid modes.
	pDevice->modes = new D3DModeInfo[max];
    if (pDevice->modes == NULL)
		return	E_OUTOFMEMORY;

	for( m=0L; m < numModes; m++ ){
        for( f=0L; f < numFormats; f++ ){
            if (( modes[m].Format == formats[f] )&&( confirmed[f] == TRUE ))
            {
				// Add this mode to the device's list of valid modes
                pDevice->modes[pDevice->dwNumModes].Width      = modes[m].Width;
                pDevice->modes[pDevice->dwNumModes].Height     = modes[m].Height;
                pDevice->modes[pDevice->dwNumModes].Format     = modes[m].Format;
                pDevice->modes[pDevice->dwNumModes].dwBehavior = behavior[f];
                pDevice->modes[pDevice->dwNumModes].DepthStencilFormat = fmtDepthStencil[f];
                pDevice->dwNumModes++;

                if( pDevice->DeviceType == D3DDEVTYPE_HAL )
                    bHALIsSampleCompatible = TRUE;
            }
        }
    }
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name: FindDepthStencilFormat()
// Desc: ŗ^ꂽfoCXɂĂ郌_O^[Qbg
//	Ŏgp\Ȑ[xobt@уXeVobt@̃tH[}bg
//	B
//-----------------------------------------------------------------------------
BOOL CDeviceInformation::FindDepthStencilFormat( UINT iAdapter, D3DDEVTYPE DeviceType,
    D3DFORMAT TargetFormat, D3DFORMAT* pDepthStencilFormat )
{
    if( m_dwMinDepthBits <= 16 && m_dwMinStencilBits == 0 )
    {
        if( SUCCEEDED( m_lpD3D->CheckDeviceFormat( iAdapter, DeviceType,
            TargetFormat, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, D3DFMT_D16 ) ) )
        {
            if( SUCCEEDED( m_lpD3D->CheckDepthStencilMatch( iAdapter, DeviceType,
                TargetFormat, TargetFormat, D3DFMT_D16 ) ) )
            {
                *pDepthStencilFormat = D3DFMT_D16;
                return TRUE;
            }
        }
    }

    if( m_dwMinDepthBits <= 15 && m_dwMinStencilBits <= 1 )
    {
        if( SUCCEEDED( m_lpD3D->CheckDeviceFormat( iAdapter, DeviceType,
            TargetFormat, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, D3DFMT_D15S1 ) ) )
        {
            if( SUCCEEDED( m_lpD3D->CheckDepthStencilMatch( iAdapter, DeviceType,
                TargetFormat, TargetFormat, D3DFMT_D15S1 ) ) )
            {
                *pDepthStencilFormat = D3DFMT_D15S1;
                return TRUE;
            }
        }
    }

    if( m_dwMinDepthBits <= 24 && m_dwMinStencilBits == 0 )
    {
        if( SUCCEEDED( m_lpD3D->CheckDeviceFormat( iAdapter, DeviceType,
            TargetFormat, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, D3DFMT_D24X8 ) ) )
        {
            if( SUCCEEDED( m_lpD3D->CheckDepthStencilMatch( iAdapter, DeviceType,
                TargetFormat, TargetFormat, D3DFMT_D24X8 ) ) )
            {
                *pDepthStencilFormat = D3DFMT_D24X8;
                return TRUE;
            }
        }
    }

    if( m_dwMinDepthBits <= 24 && m_dwMinStencilBits <= 8 )
    {
        if( SUCCEEDED( m_lpD3D->CheckDeviceFormat( iAdapter, DeviceType,
            TargetFormat, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, D3DFMT_D24S8 ) ) )
        {
            if( SUCCEEDED( m_lpD3D->CheckDepthStencilMatch( iAdapter, DeviceType,
                TargetFormat, TargetFormat, D3DFMT_D24S8 ) ) )
            {
                *pDepthStencilFormat = D3DFMT_D24S8;
                return TRUE;
            }
        }
    }

    if( m_dwMinDepthBits <= 24 && m_dwMinStencilBits <= 4 )
    {
        if( SUCCEEDED( m_lpD3D->CheckDeviceFormat( iAdapter, DeviceType,
            TargetFormat, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, D3DFMT_D24X4S4 ) ) )
        {
            if( SUCCEEDED( m_lpD3D->CheckDepthStencilMatch( iAdapter, DeviceType,
                TargetFormat, TargetFormat, D3DFMT_D24X4S4 ) ) )
            {
                *pDepthStencilFormat = D3DFMT_D24X4S4;
                return TRUE;
            }
        }
    }

    if( m_dwMinDepthBits <= 32 && m_dwMinStencilBits == 0 )
    {
        if( SUCCEEDED( m_lpD3D->CheckDeviceFormat( iAdapter, DeviceType,
            TargetFormat, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, D3DFMT_D32 ) ) )
        {
            if( SUCCEEDED( m_lpD3D->CheckDepthStencilMatch( iAdapter, DeviceType,
                TargetFormat, TargetFormat, D3DFMT_D32 ) ) )
            {
                *pDepthStencilFormat = D3DFMT_D32;
                return TRUE;
            }
        }
    }

    return FALSE;
}

//-----------------------------------------------------------------------------
// Name: ReleaseDeviceList()
// Desc: foCX񂪎gp郁J
//-----------------------------------------------------------------------------
void	CDeviceInformation::ReleaseDeviceList()
{
	D3DAdapterInfo	*pAdapter;
	D3DDeviceInfo	*pDevice;
	if (m_Adapters!=NULL){
		for( UINT iAdapter = 0; iAdapter < m_dwNumAllAdapters; iAdapter++)
		{
			pAdapter = &m_Adapters[iAdapter];
			if (pAdapter->devices != NULL){
				for (UINT iDevice = 0; iDevice < pAdapter->dwNumDevices;++iDevice){
					pDevice = &pAdapter->devices[iDevice];
					if (pDevice->modes!=NULL){
						delete[] pDevice->modes;
						pDevice->modes = NULL;
					}
				}
				delete[] m_Adapters[iAdapter].devices;
				m_Adapters[iAdapter].devices = NULL;
			}
		}
		delete[] m_Adapters;
		m_Adapters=NULL;
	}
}

HRESULT CDeviceInformation::ConfirmDevice(D3DCAPS9*pCaps,DWORD dwBehavior, D3DFORMAT fmt)
{ 
	if (m_procCallback!=NULL){
		if (SUCCEEDED( m_procCallback( pCaps, dwBehavior, fmt, m_lpRefPtr)))
			return	S_OK;
		else
			return	E_FAIL;
	}
	return S_OK;
}

//-----------------------------------------------------------------------------
// Name: SortModesCallback()
// Desc: fBXvC[h\[gۂɎgpR[obN.
//-----------------------------------------------------------------------------
static int SortModesCallback( const VOID* arg1, const VOID* arg2 )
{
    D3DDISPLAYMODE* p1 = (D3DDISPLAYMODE*)arg1;
    D3DDISPLAYMODE* p2 = (D3DDISPLAYMODE*)arg2;

	INT	fps1, fps2;
	fps1 = abs((long)p1->RefreshRate - PREFERABLE_REFRESH_RATE);
	fps2 = abs((long)p2->RefreshRate - PREFERABLE_REFRESH_RATE);
    if( fps1 < fps2 )   return -1;
    if( fps1 > fps2 )   return +1;
	if( p1->Format > p2->Format )   return -1;
    if( p1->Format < p2->Format )   return +1;
    if( p1->Width  < p2->Width )    return -1;
    if( p1->Width  > p2->Width )    return +1;
    if( p1->Height < p2->Height )   return -1;
    if( p1->Height > p2->Height )   return +1;

    return 0;
}

