//-----------------------------------------------------------------------------
// File: D3DKanjiFont2.cpp
//
// Desc: eNX`gptHg̎NX
//		tHgSeNX`ɍڂ͕̂s\ȈׁA
//		eNX`196̃tHgLbVB
//		D3DKanjiFont Ƃ́AIɈقȂAꕶɐFݒłijB
//-----------------------------------------------------------------------------

#include "StdAfx.h"
#include <tchar.h>
#include <d3d9.h>
#include <D3DX9.h>
#include "D3DFont.h"

#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#include ".\d3dkanjifont2.h"

//-----------------------------------------------------------------------------
//	JX^Ȓ_錾
//-----------------------------------------------------------------------------

static inline FONT2DVERTEX InitFont2DVertex( const D3DXVECTOR4& p, D3DCOLOR color,
                                      FLOAT tu, FLOAT tv )
{
    FONT2DVERTEX v;   v.p = p;   v.color = color;   v.tu = tu;   v.tv = tv;
    return v;
}

CD3DKanjiFont2::CD3DKanjiFont2( CD3DEnv *pEnv, TCHAR* strFontName, DWORD dwHeight, DWORD dwFlags )
: CD3DKanjiFont(pEnv,strFontName,dwHeight,dwFlags)
{
	m_pdwColors = NULL;
}

CD3DKanjiFont2::~CD3DKanjiFont2(){
}


//-----------------------------------------------------------------------------
// Name: DrawText()
// Desc: 2D eLXg̕`iXP[Oj
//-----------------------------------------------------------------------------
HRESULT CD3DKanjiFont2::DrawText( FLOAT sx, FLOAT sy, DWORD *pdwColor, TCHAR* strText, DWORD dwFlags )
{
	return DrawTextClippedScaled(NULL,sx,sy,1.0f,1.0f,pdwColor,strText,dwFlags);
}

HRESULT CD3DKanjiFont2::DrawTextClipped( LPRECT clipRect, FLOAT sx, FLOAT sy, DWORD *pdwColor, TCHAR* strText, DWORD dwFlags )
{
	return DrawTextClippedScaled(clipRect,sx,sy,1.0f,1.0f,pdwColor,strText,dwFlags);
}

//-----------------------------------------------------------------------------
// Name: DrawTextScaled()
// Desc: 2D eLXg̕`iXP[OLj
//-----------------------------------------------------------------------------
HRESULT CD3DKanjiFont2::DrawTextScaled( FLOAT sx, FLOAT sy, FLOAT scaleX, FLOAT scaleY, DWORD *pdwColor,
									  TCHAR* strText, DWORD dwFlags ){
	return	DrawTextClippedScaled(NULL,sx,sy,scaleX,scaleY,pdwColor,strText,dwFlags);
}

//-----------------------------------------------------------------------------
// Name: DrawTextScaled()
// Desc: 2D eLXg̕`iXP[OLj
//-----------------------------------------------------------------------------
HRESULT CD3DKanjiFont2::DrawTextClippedScaled( LPRECT clipRect, FLOAT sx, FLOAT sy, FLOAT scaleX, FLOAT scaleY, DWORD *pdwColor,
                            TCHAR* strText, DWORD dwFlags )
{
	DWORD	dwCharCode = 0L;
	LPDIRECT3DDEVICE9	lpd3ddev = NULL;
	HRESULT	hr;
	FLOAT fStartX = sx;

	DrawCache		pDrawCache[DRAW_CACHE_NUM];
	TextureCache	pTextureCache[DRAW_CACHE_NUM];
	DWORD			pdwColorCache[DRAW_CACHE_NUM];
	DWORD	dwColor;
	m_iDrawCacheIx = 0;
	m_iTexCacheIx = 0;
	m_pTexCache = pTextureCache;
	m_pDrawCache = pDrawCache;
	m_pdwColors = pdwColorCache;

	DWORD dwNumTriangles = 0;
	hr = m_lpD3DEnv->GetD3DDevice(&lpd3ddev);
	if (SUCCEEDED(hr)){
		//	_OXe[gݒ肷
		SetRenderingState(lpd3ddev);
		lpd3ddev->SetFVF( D3DFVF_FONT2DVERTEX );
		lpd3ddev->SetVertexShader(NULL);
		lpd3ddev->SetPixelShader(NULL);

		//	gptB^ݒ肷
		if( dwFlags & D3DFONT_FILTERED )
		{
			lpd3ddev->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
			lpd3ddev->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
		}

		DWORD	charcode;
		TCHAR	c;
		while( *strText )
		{
			c = *strText++;
			dwColor = *pdwColor++;
#ifdef	_UNICODE
			charcode = c;
#else
			charcode = c & 0xff;
			if ((charcode >= 0x81 && charcode <= 0x9f)||(charcode >= 0xe0 && charcode <= 0xfc)){
				charcode <<= 8;
				if (*strText == '\0')
					break;		//	G[̑Ή
				charcode |= *strText++ & 0xff;	
				pdwColor++;	//	F͍XVȂ
			}
#endif
			m_pdwColors[m_iDrawCacheIx] = dwColor;
			DrawChar(charcode);
			if (m_iDrawCacheIx >= (DRAW_CACHE_NUM - 1)){
				sx = FlushCache(lpd3ddev,clipRect,fStartX,sy,sx,scaleX,scaleY);
			}
		}
		// Unlock and render the vertex buffer
		FlushCache(lpd3ddev,clipRect,fStartX,sy,sx,scaleX,scaleY);
 		hr = S_OK;
	}
	SAFE_RELEASE(lpd3ddev);
	m_pTexCache = NULL;
	m_pDrawCache = NULL;
	m_pdwColors = NULL;
	return	hr;
}

//-----------------------------------------------------------------------------
// Name: FlushCache()
// Desc: LbVɋlߍ܂ꂽ 2D LN^`
//-----------------------------------------------------------------------------
FLOAT	CD3DKanjiFont2::FlushCache(LPDIRECT3DDEVICE9 lpd3ddev, LPRECT clipRect, FLOAT sx, FLOAT &sy, FLOAT cx, FLOAT scale_x, FLOAT scale_y){
	int	i;
	D3DCOLOR dwColor;
	if (m_iTexCacheIx != 0){
		//	Uobt@ɗ߂鎖ŁAeNX`KvꍇɁA
		//	LockRectȂčςނ悤ɂB
		D3DLOCKED_RECT	d3dlr;
		m_pTexture->LockRect( 0, &d3dlr, 0, 0 );
		for (i = 0; i < m_iTexCacheIx ; ++i){
			PrepareCharacterTexture(this->m_pTexCache[i].pCache,&d3dlr);
		}
		m_pTexture->UnlockRect(0);
	}
 	FONT2DVERTEX	vertices[4];
	FLOAT tx1,ty1,tx2,ty2,w,h;
	FLOAT	t,l,b,r;
	DrawCache	*p = m_pDrawCache;
	FontCache	*pCache;
	FLOAT	fTexWidth = m_dwTexWidth / m_fTextScale;
	FLOAT	fTexHeight = m_dwTexHeight / m_fTextScale;
	FLOAT	fTexWidthInv = 1.0f / fTexWidth;
	FLOAT	fTexHeightInv = 1.0f / fTexHeight;
	FLOAT	fScaleInvX = 1.0f / scale_x;
	FLOAT	fScaleInvY = 1.0f / scale_y;

	for(i = 0; i < m_iDrawCacheIx ; ++i,++p){
		dwColor = m_pdwColors[i];
		pCache = p->pCache;
		if (pCache == NULL){
			if (p->fMove < 0){
				sy -= p->fMove * scale_y;
				cx = sx;
				continue;
			}
			cx += p->fMove * scale_x;
			continue;
		}
		tx1 = pCache->u;
		ty1 = pCache->v;
		tx2 = pCache->u + pCache->vw;
		ty2 = pCache->v + pCache->vh;

		w = (tx2-tx1) *	fTexWidth;
		h = (ty2-ty1) *	fTexHeight;
		w *= scale_x;
		h *= scale_y;

		t = sy - 0.5f;
		l = cx - 0.5f;
		b = sy + h - 0.5f;
		r = cx + w - 0.5f;
        cx += w;

		if (clipRect != NULL){
			FLOAT	fTmp;
			if (t > clipRect->bottom)
				continue;
			if (b < clipRect->top)
				continue;
			if (l > clipRect->right)
				continue;
			if (r < clipRect->left)
				continue;
			if (t < clipRect->top){
				fTmp = clipRect->top - t;
				fTmp *= fScaleInvY;
				ty1 += fTmp * fTexHeightInv;
				t = (FLOAT)clipRect->top;
			}
			if (b > clipRect->bottom){
				fTmp = b - clipRect->bottom;
				fTmp *= fScaleInvY;
				ty2 -= fTmp * fTexHeightInv;
				b = (FLOAT)clipRect->bottom;
			}
			if (l < clipRect->left){
				fTmp = clipRect->left - l;
				fTmp *= fScaleInvX;
				tx1 += fTmp * fTexWidthInv;
				l = (FLOAT)clipRect->left;
			}
			if ( r > clipRect->right){
				fTmp = r - clipRect->right;
				fTmp *= fScaleInvX;
				tx2 -= fTmp * fTexWidthInv;
				r = (FLOAT)clipRect->right;
			}
		}
		vertices[0] = InitFont2DVertex( D3DXVECTOR4(l,t,0.0f,1.0f), dwColor, tx1, ty1 );
		vertices[1] = InitFont2DVertex( D3DXVECTOR4(l,b,0.0f,1.0f), dwColor, tx1, ty2 );
		vertices[2] = InitFont2DVertex( D3DXVECTOR4(r,b,0.0f,1.0f), dwColor, tx2, ty2 );
		vertices[3] = InitFont2DVertex( D3DXVECTOR4(r,t,0.0f,1.0f), dwColor, tx2, ty1 );
		lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,2,vertices,sizeof(FONT2DVERTEX));
	}
	m_iTexCacheIx = 0;
	m_iDrawCacheIx = 0;
	return	cx;
}