//-----------------------------------------------------------------------------
// File: D3DKanjiFont.cpp
//
// Desc: eNX`gptHg̎NX
//		tHgSeNX`ɍڂ͕̂s\ȈׁA
//		eNX`196̃tHgLbVB
//-----------------------------------------------------------------------------
#include "StdAfx.h"
#include <tchar.h>
#include <d3d9.h>
#include <D3DX9.h>
#include "D3DFont.h"

#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#include ".\d3dkanjifont.h"


//-----------------------------------------------------------------------------
//	JX^Ȓ_錾
//-----------------------------------------------------------------------------

static inline FONT2DVERTEX InitFont2DVertex( const D3DXVECTOR4& p, D3DCOLOR color,
                                      FLOAT tu, FLOAT tv )
{
    FONT2DVERTEX v;   v.p = p;   v.color = color;   v.tu = tu;   v.tv = tv;
    return v;
}


//-----------------------------------------------------------------------------
// Name: CD3DKanjiFont()
// Desc: tHgNX̃RXgN^
//-----------------------------------------------------------------------------
CD3DKanjiFont::CD3DKanjiFont(  CD3DEnv *pEnv, TCHAR* strFontName, DWORD dwHeight, DWORD dwFlags )
 : CD3DFont(pEnv,strFontName,dwHeight,dwFlags)
{
	m_fcCacheDummy.m_pPrevCache = &m_fcCacheDummy;
	m_fcCacheDummy.m_pNextCache = &m_fcCacheDummy;
	m_pCaches = (FontCache*)&m_fcCacheDummy;

	int	i;
	//	nbVe[uɃ_~[m[ho^B
	for(i = 0; i < kKanjiHashSize+1 ; ++i){
		m_fcHashDummy[i].m_pPrevChar = &m_fcHashDummy[i];
		m_fcHashDummy[i].m_pNextChar = &m_fcHashDummy[i];
		this->m_pHashTable[i] = (FontCache*)&m_fcHashDummy[i];
	}
	CreateFontCache();
	m_hFont = NULL;
	m_hDC = NULL;
	m_hbmBitmap = NULL;
}

void	CD3DKanjiFont::CreateFontCache(){
	int	i,j;
	FontCache *p;
	FLOAT	fInvCols = 1.0f / (FLOAT)FONT_CACHE_COLS;
	FLOAT	fInvRows = 1.0f / (FLOAT)FONT_CACHE_ROWS;
	for (i = 0; i < FONT_CACHE_ROWS;++i){
		for (j = 0; j < FONT_CACHE_COLS ; ++j){
			p = new FontCache;
			p->m_dwCharCode = 0;
			p->col = j;	//	
			p->row = i;	//	s

			AppendToFontCache(p);
			AppendToHashTable(kKanjiHashSize,p);
		}
	}
}
CD3DKanjiFont::~CD3DKanjiFont(void)
{
	InvalidateDeviceObjects();
    DeleteDeviceObjects();
	DeleteHashTable();
	DeleteFontCache();
	//	eNXŏĂ̂ŕsvEEE͏oȂEEEB
	//m_lpD3DEnv->RemoveGraphicsObject(this);
}

void	CD3DKanjiFont::ResizeFont(DWORD dwHeight, DWORD dwFlags ){

	//  Enter exclusive section.
	m_lpD3DEnv->EnterLoadingSection();

	DeleteHashTable();
	DeleteFontCache();
	CD3DFont::ResizeFont(dwHeight, dwFlags);
	CreateFontCache();

	//  Leave exclusive section.
	m_lpD3DEnv->LeaveLoadingSection();
}

//-------------------------------------------------------
//	nbVe[ũNA
//-------------------------------------------------------
void CD3DKanjiFont::DeleteHashTable(){
	FontCache	*p, *next;
	for(int i = 0; i < kKanjiHashSize+1 ; ++i){
		p = m_pHashTable[i]->m_pNextChar;
		while(p != m_pHashTable[i]){
			next = p->m_pNextChar;
			SnipFromHashTable(p);
			p = next;
		}

		//	nbVe[uɃ_~[m[ho^B
		m_fcHashDummy[i].m_pPrevChar = &m_fcHashDummy[i];
		m_fcHashDummy[i].m_pNextChar = &m_fcHashDummy[i];
		m_pHashTable[i] = (FontCache*)&m_fcHashDummy[i];		
	}
}
//-------------------------------------------------------
//	nbVe[ũNA
//-------------------------------------------------------
void CD3DKanjiFont::DeleteFontCache(){
	FontCache	*p, *next;
	p = this->m_pCaches->m_pNextCache;
	while( p != m_pCaches){
		next = p->m_pNextCache;
		SnipFromFontCache(p);
		delete p;
		p = next;
	}
	m_fcCacheDummy.m_pPrevCache = &m_fcCacheDummy;
	m_fcCacheDummy.m_pNextCache = &m_fcCacheDummy;
	m_pCaches = (FontCache*)&m_fcCacheDummy;
}
//--------------------------------------------------------
//	̃eNX`Wێ\̂NXg
//	o^B
//--------------------------------------------------------
void	CD3DKanjiFont::AppendToFontCache(FontCache *p){
	p->m_pPrevCache = m_pCaches->m_pPrevCache;
	p->m_pNextCache = m_pCaches;
	m_pCaches->m_pPrevCache->m_pNextCache = p;
	m_pCaches->m_pPrevCache = p;
}

//--------------------------------------------------------
//	tHgLbV̗Dxグ
//--------------------------------------------------------
void CD3DKanjiFont::IncrementCachePriority(FontCache *p){
	this->SnipFromFontCache(p);
	this->AppendToFontCache(p);
}

//--------------------------------------------------------
//	̃eNX`Wێ\̂NXg
//	菜B
//--------------------------------------------------------
void	CD3DKanjiFont::SnipFromFontCache(FontCache *p){
	p->m_pPrevCache->m_pNextCache = p->m_pNextCache;
	p->m_pNextCache->m_pPrevCache = p->m_pPrevCache;
}

//--------------------------------------------------------
//	tHgLbV\̂AR[hnbVe[u
//	o^B
//--------------------------------------------------------
void	CD3DKanjiFont::AppendToHashTable(int hashno, FontCache *p){
	FontCache *root = m_pHashTable[hashno];
	p->m_pPrevChar = root->m_pPrevChar;
	p->m_pNextChar = root;
	root->m_pPrevChar->m_pNextChar = p;
	root->m_pPrevChar = p;
}
//--------------------------------------------------------
//	tHgLbV\̂AR[hnbVe[u
//	菜B
//--------------------------------------------------------
void	CD3DKanjiFont::SnipFromHashTable(FontCache *p){
	p->m_pPrevChar->m_pNextChar = p->m_pNextChar;
	p->m_pNextChar->m_pPrevChar = p->m_pPrevChar;
}

//--------------------------------------------------------
//	tHgLbV\̂Ce[VA
//	eNX`WČvZB
//--------------------------------------------------------
void	CD3DKanjiFont::RecalcTextureCoords(){
	FontCache	*p = m_pCaches->m_pNextCache;
	FLOAT	fInvColAdjust = 1.0f / (FLOAT)(FONT_CACHE_COLS * m_dwTexWidth);
	FLOAT	fInvRowAdjust = 1.0f / (FLOAT)(FONT_CACHE_ROWS * m_dwTexHeight);
	while(p != m_pCaches){
		p->tx = (short)MulDiv(m_dwTexWidth * p->col,m_dwTextureValidWidth,FONT_CACHE_COLS * m_dwTexWidth);
		p->ty = (short)MulDiv(m_dwTexHeight * p->row,m_dwTextureValidHeight,FONT_CACHE_ROWS * m_dwTexHeight);
		p->w = (short)MulDiv(m_dwTexWidth * (p->col+1),m_dwTextureValidWidth,FONT_CACHE_COLS * m_dwTexWidth);
		p->h = (short)MulDiv(m_dwTexHeight * (p->row+1),m_dwTextureValidHeight,FONT_CACHE_ROWS * m_dwTexHeight);
		p->w -= p->tx;
		p->h -= p->ty;
		p->u = (FLOAT)(p->col * m_dwTextureValidWidth) * fInvColAdjust;
		p->v = (FLOAT)(p->row * m_dwTextureValidHeight) * fInvRowAdjust;
		p = p->m_pNextCache;
	}
}

//-------------------------------------------------------------
//	Name: InitDeviceObjects
//  Desc: foCXˑIuWFNg̐
//-------------------------------------------------------------
HRESULT CD3DKanjiFont::InitDeviceObjects( LPDIRECT3DDEVICE9 lpd3ddev )
{
    HRESULT hr;

	if (m_pTexture != NULL
		&& m_hDC != NULL
		&& m_hbmBitmap != NULL
		&& m_hFont != NULL){
		return	S_OK;
	}
	DeleteDeviceObjects();

	// eNX`̃TCY߂B
    m_fTextScale  = 1.0f; // XP[O1.0ɂ
    m_hDC       = CreateCompatibleDC( NULL );

	INT	nHeight;
	if (m_dwFontFlags & D3DFONT_SIZE_IN_PIXELS){
		nHeight = (INT)(m_dwFontHeight);
	}else{
		__int64	tmp64 = m_dwFontHeight;
		tmp64 *= (INT)(GetDeviceCaps(m_hDC, LOGPIXELSY));
		nHeight    = (INT)(tmp64 / 72);	//	tHg * dpi * testScale / 72
	}

    // 傫ȃtHgł΁A傫
    if( nHeight > 32 )
        m_dwTexWidth = m_dwTexHeight = 1024;
    else if( nHeight > 16 )
        m_dwTexWidth = m_dwTexHeight = 512;
    else
        m_dwTexWidth  = m_dwTexHeight = 256;

    // If requested texture is too big, use a smaller texture and smaller font,
    // and scale up when rendering.
    D3DCAPS9 d3dCaps;
    lpd3ddev->GetDeviceCaps( &d3dCaps );

    if( m_dwTexWidth > d3dCaps.MaxTextureWidth )
    {
        m_fTextScale = (FLOAT)d3dCaps.MaxTextureWidth / (FLOAT)m_dwTexWidth;
        m_dwTexWidth = m_dwTexHeight = d3dCaps.MaxTextureWidth;
    }
	nHeight = (INT)(nHeight * m_fTextScale);

	m_dwTextureValidWidth = m_dwTexWidth - m_dwTexWidth %10;
	m_dwTextureValidHeight = m_dwTexHeight - m_dwTexWidth %10;

	m_fInvTexWidth = 1.0f / (FLOAT)m_dwTexWidth;
	m_fInvTexHeight = 1.0f / (FLOAT)m_dwTexHeight;
    // Create a new texture for the font
    hr = lpd3ddev->CreateTexture( m_dwTexWidth, m_dwTexHeight, 1,
                                      0, D3DFMT_A4R4G4B4,
                                      D3DPOOL_MANAGED, &m_pTexture, NULL );
	if( FAILED(hr) ){
		return	hr;
	}
	RecalcTextureCoords();

    // Prepare to create a bitmap
    BITMAPINFO bmi;
    ZeroMemory( &bmi.bmiHeader,  sizeof(BITMAPINFOHEADER) );
    bmi.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
    bmi.bmiHeader.biWidth       =  (int)FONT_BITMAP_WIDTH;
    bmi.bmiHeader.biHeight      = -(int)FONT_BITMAP_HEIGHT;
    bmi.bmiHeader.biPlanes      = 1;
    bmi.bmiHeader.biCompression = BI_RGB;
    bmi.bmiHeader.biBitCount    = 16;

	// Create a DC and a bitmap for the font
    m_hbmBitmap = CreateDIBSection( m_hDC, &bmi, DIB_RGB_COLORS,
                                          (VOID**)&m_pBitmapBits, NULL, 0 );

	SetMapMode( m_hDC, MM_TEXT );	//	P_Pʂ͂PsNZ

	
	//	ANTIALIASED_QUALITYw肵ătHg𐶐B
    //	A`GCAXtHg𓾂悤Ƃ邪A
	//	A`GCAX͕ۏ؂ȂB
    DWORD dwBold   = (m_dwFontFlags&D3DFONT_BOLD)   ? FW_BOLD : FW_NORMAL;
    DWORD dwItalic = (m_dwFontFlags&D3DFONT_ITALIC) ? TRUE    : FALSE;

	INT	tmpHeight = nHeight;
	TEXTMETRIC	textMetric;
	SIZE	size;
	HGDIOBJ	hOldBmp, hOldFont;
RECREATE_FONT:
	m_hFont    = CreateFont( -tmpHeight, 0, 0, 0, dwBold, dwItalic,
                          FALSE, FALSE, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
                          CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY,
                          VARIABLE_PITCH, m_strFontName );
	m_iFontHeightInPixel = (INT)((FLOAT)nHeight/m_fTextScale);
	

	hOldBmp = SelectObject( m_hDC, m_hbmBitmap );
    hOldFont = SelectObject( m_hDC, m_hFont );
	if (GetTextMetrics(m_hDC,&textMetric)){
		if (textMetric.tmAscent+textMetric.tmDescent > nHeight && tmpHeight == nHeight){
			tmpHeight = nHeight * nHeight / (textMetric.tmAscent+textMetric.tmDescent);
			SelectObject(m_hDC,hOldBmp);
			SelectObject(m_hDC,hOldFont);
			if (m_hFont)
				DeleteObject(m_hFont);
			m_hFont = NULL;
			goto	RECREATE_FONT;
		}
	}

	SetTextColor( m_hDC, RGB(255,255,255) );
    SetBkColor(   m_hDC, 0x00000000 );
    SetTextAlign( m_hDC, TA_TOP );

	GetTextExtent(_T(" "),&size);
	m_fAnkSpcWidth = (FLOAT)size.cx;
	GetTextExtent(_T("@"),&size);
	m_fKnjSpcWidth = (FLOAT)size.cx;

	m_fAnkSpcWidth /= m_fTextScale;
	m_fKnjSpcWidth /= m_fTextScale;

	if( NULL==m_hFont ){
		return	E_FAIL;
	}
	hr = S_OK;
	m_dwState = D3DFONT_INITIALIZED;
    return S_OK;
}

//-------------------------------------------------------------
//	Name: DeleteDeviceObjects
//  Desc: foCXˑIuWFNg̏
//-------------------------------------------------------------
HRESULT CD3DKanjiFont::DeleteDeviceObjects()
{
	if (m_hDC)
	    DeleteDC( m_hDC );
	if (m_hbmBitmap)
	    DeleteObject( m_hbmBitmap );
	if (m_hFont)
	    DeleteObject( m_hFont );
	m_hDC = NULL;
	m_hbmBitmap = NULL;
	m_hFont = NULL;
	SAFE_RELEASE( m_pTexture );
	FontCache *p = m_pCaches->m_pNextCache;
	while(p != m_pCaches){
		SnipFromHashTable(p);
		AppendToHashTable(kKanjiHashSize,p);
		p = p->m_pNextCache;
	}
	m_dwState = D3DFONT_DELETED;
	return S_OK;
}


//-------------------------------------------------------------
//	Name: RestoreDeviceObjects
//  Desc: foCXˑrfIIuWFNg̐
//-------------------------------------------------------------
HRESULT CD3DKanjiFont::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{	
	if (m_dwState == D3DFONT_DELETED){
		InitDeviceObjects(lpd3ddev);
	}
	m_dwState = D3DFONT_RESTORED;
	return	S_OK;
}




//-------------------------------------------------------------
//	Name: InvalidateDeviceObjects
//  Desc: foCXˑrfIIuWFNg̏
//-------------------------------------------------------------
HRESULT CD3DKanjiFont::InvalidateDeviceObjects()
{
	m_dwState = D3DFONT_INITIALIZED;
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name: DrawText()
// Desc: 2D eLXg̕`iXP[Oj
//-----------------------------------------------------------------------------
HRESULT CD3DKanjiFont::DrawText( FLOAT sx, FLOAT sy, DWORD dwColor, TCHAR* strText, DWORD dwFlags )
{
	return DrawTextClippedScaled(NULL,sx,sy,1.0f,1.0f,dwColor,strText,dwFlags);
}

HRESULT CD3DKanjiFont::DrawTextClipped( LPRECT clipRect, FLOAT sx, FLOAT sy, DWORD dwColor, TCHAR* strText, DWORD dwFlags )
{
	return DrawTextClippedScaled(clipRect,sx,sy,1.0f,1.0f,dwColor,strText,dwFlags);
}

//-----------------------------------------------------------------------------
// Name: DrawTextScaled()
// Desc: 2D eLXg̕`iXP[OLj
//-----------------------------------------------------------------------------
HRESULT CD3DKanjiFont::DrawTextScaled( FLOAT sx, FLOAT sy, FLOAT scaleX, FLOAT scaleY, DWORD dwColor,
									  TCHAR* strText, DWORD dwFlags ){
	return	DrawTextClippedScaled(NULL,sx,sy,scaleX,scaleY,dwColor,strText,dwFlags);
}

//-----------------------------------------------------------------------------
// Name: DrawTextScaled()
// Desc: 2D eLXg̕`iXP[OLj
//-----------------------------------------------------------------------------
HRESULT CD3DKanjiFont::DrawTextClippedScaled( LPRECT clipRect, FLOAT sx, FLOAT sy, FLOAT scaleX, FLOAT scaleY, DWORD dwColor,
                            TCHAR* strText, DWORD dwFlags )
{
	DWORD	dwCharCode = 0L;
	LPDIRECT3DDEVICE9	lpd3ddev = NULL;
	HRESULT	hr;
	FLOAT fStartX = sx;

	DrawCache	pDrawCache[DRAW_CACHE_NUM];
	TextureCache	pTextureCache[DRAW_CACHE_NUM];
	m_iDrawCacheIx = 0;
	m_iTexCacheIx = 0;
	m_pTexCache = pTextureCache;
	m_pDrawCache = pDrawCache;

	DWORD dwNumTriangles = 0;
	hr = m_lpD3DEnv->GetD3DDevice(&lpd3ddev);
	if (SUCCEEDED(hr)){
		//	_OXe[gݒ肷
		SetRenderingState(lpd3ddev);
		lpd3ddev->SetFVF( D3DFVF_FONT2DVERTEX );
		lpd3ddev->SetVertexShader(NULL);
		lpd3ddev->SetPixelShader(NULL);

		//	gptB^ݒ肷
		if( dwFlags & D3DFONT_FILTERED )
		{
			lpd3ddev->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
			lpd3ddev->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
		}

		DWORD	charcode;
		TCHAR	c;
		while( *strText )
		{
			c = *strText++;

#ifdef	_UNICODE
			charcode = c;
#else
			charcode = c & 0xff;
			if ((charcode >= 0x81 && charcode <= 0x9f)||(charcode >= 0xe0 && charcode <= 0xfc)){
				charcode <<= 8;
				if (*strText == '\0')
					break;		//	G[̑Ή
				charcode |= *strText++ & 0xff;			
			}
#endif
			DrawChar(charcode);
			if (m_iDrawCacheIx >= (DRAW_CACHE_NUM - 1)){
				sx = FlushCache(lpd3ddev,clipRect,fStartX,sy,sx,dwColor,scaleX,scaleY);
			}
		}
		// Unlock and render the vertex buffer
		FlushCache(lpd3ddev,clipRect,fStartX,sy,sx,dwColor,scaleX,scaleY);
 		hr = S_OK;
	}
	SAFE_RELEASE(lpd3ddev);
	m_pTexCache = NULL;
	m_pDrawCache = NULL;
	return	hr;
}

//-----------------------------------------------------------------------------
// Name: DrawChar()
// Desc: 2D LN^LbVɓo^
//-----------------------------------------------------------------------------
void CD3DKanjiFont::DrawChar(DWORD charcode)
{
	int	hash_ix = Hash(charcode);
	if ((charcode < _T(' '))&&(charcode != _T('\n'))){
		return;
	}
	m_pDrawCache[m_iDrawCacheIx].pCache = NULL;

	if (charcode == _T(' ')){
		m_pDrawCache[m_iDrawCacheIx].fMove = m_fAnkSpcWidth;
	}
	else if (charcode == _T('\n')){
		m_pDrawCache[m_iDrawCacheIx].fMove = -(FLOAT)m_iFontHeightInPixel;
	}
#ifdef	_UNICODE
	else if (charcode == _T('@')){
		m_pDrawCache[m_iDrawCacheIx].fMove = m_fKnjSpcWidth;
	}
#else
	else if (charcode == 0x8140){
		m_pDrawCache[m_iDrawCacheIx].fMove = m_fKnjSpcWidth;
	}
#endif
	else{
		FontCache *root = m_pHashTable[hash_ix];
		FontCache *p = root->m_pNextChar;

		//	tHgLbV̒T
		while(p != root){
			if (p->m_dwCharCode == charcode)
				break;
			p = p->m_pNextChar;
		}
		//	LbVĂȂ΃tHg
		if (p == root){
			p = m_pCaches->m_pNextCache;
			SnipFromFontCache(p);
			SnipFromHashTable(p);

			p->m_dwCharCode = charcode;
			m_pTexCache[m_iTexCacheIx++].pCache = p;

			AppendToFontCache(p);
			AppendToHashTable(Hash(charcode),p);
		}else{
			IncrementCachePriority(p);
		}
		m_pDrawCache[m_iDrawCacheIx].pCache = p;
	}
	m_iDrawCacheIx++;
}

//-----------------------------------------------------------------------------
// Name: FlushCache()
// Desc: LbVɋlߍ܂ꂽ 2D LN^`
//-----------------------------------------------------------------------------
FLOAT	CD3DKanjiFont::FlushCache(LPDIRECT3DDEVICE9 lpd3ddev, LPRECT clipRect, FLOAT sx, FLOAT &sy, FLOAT cx, D3DCOLOR dwColor, FLOAT scale_x, FLOAT scale_y){
	int	i;
	if (m_pTexture == NULL)
		return	cx;
	if (m_iTexCacheIx != 0){
		//	Uobt@ɗ߂鎖ŁAeNX`KvꍇɁA
		//	LockRectȂčςނ悤ɂB
		D3DLOCKED_RECT	d3dlr;
		m_pTexture->LockRect( 0, &d3dlr, 0, 0 );
		for (i = 0; i < m_iTexCacheIx ; ++i){
			PrepareCharacterTexture(this->m_pTexCache[i].pCache,&d3dlr);
		}
		m_pTexture->UnlockRect(0);
	}
 	FONT2DVERTEX	vertices[4];
	FLOAT tx1,ty1,tx2,ty2,w,h;
	FLOAT	t,l,b,r;
	DrawCache	*p = m_pDrawCache;
	FontCache	*pCache;
	FLOAT	fTexWidth = m_dwTexWidth / m_fTextScale;
	FLOAT	fTexHeight = m_dwTexHeight / m_fTextScale;
	FLOAT	fTexWidthInv = 1.0f / fTexWidth;
	FLOAT	fTexHeightInv = 1.0f / fTexHeight;
	FLOAT	fScaleInvX = 1.0f / scale_x;
	FLOAT	fScaleInvY = 1.0f / scale_y;

	for(i = 0; i < m_iDrawCacheIx ; ++i,++p){
		pCache = p->pCache;
		if (pCache == NULL){
			if (p->fMove < 0){
				sy -= p->fMove * scale_y;
				cx = sx;
				continue;
			}
			cx += p->fMove * scale_x;
			continue;
		}
		tx1 = pCache->u;
		ty1 = pCache->v;
		tx2 = pCache->u + pCache->vw;
		ty2 = pCache->v + pCache->vh;

		w = (tx2-tx1) *	fTexWidth;
		h = (ty2-ty1) *	fTexHeight;
		w *= scale_x;
		h *= scale_y;

		t = sy - 0.5f;
		l = cx - 0.5f;
		b = sy + h - 0.5f;
		r = cx + w - 0.5f;
        cx += w;

		if (clipRect != NULL){
			FLOAT	fTmp;
			if (t > clipRect->bottom)
				continue;
			if (b < clipRect->top)
				continue;
			if (l > clipRect->right)
				continue;
			if (r < clipRect->left)
				continue;
			if (t < clipRect->top){
				fTmp = clipRect->top - t;
				fTmp *= fScaleInvY;
				ty1 += fTmp * fTexHeightInv;
				t = (FLOAT)clipRect->top;
			}
			if (b > clipRect->bottom){
				fTmp = b - clipRect->bottom;
				fTmp *= fScaleInvY;
				ty2 -= fTmp * fTexHeightInv;
				b = (FLOAT)clipRect->bottom;
			}
			if (l < clipRect->left){
				fTmp = clipRect->left - l;
				fTmp *= fScaleInvX;
				tx1 += fTmp * fTexWidthInv;
				l = (FLOAT)clipRect->left;
			}
			if ( r > clipRect->right){
				fTmp = r - clipRect->right;
				fTmp *= fScaleInvX;
				tx2 -= fTmp * fTexWidthInv;
				r = (FLOAT)clipRect->right;
			}
		}
		vertices[0] = InitFont2DVertex( D3DXVECTOR4(l,t,0.0f,1.0f), dwColor, tx1, ty1 );
		vertices[1] = InitFont2DVertex( D3DXVECTOR4(l,b,0.0f,1.0f), dwColor, tx1, ty2 );
		vertices[2] = InitFont2DVertex( D3DXVECTOR4(r,b,0.0f,1.0f), dwColor, tx2, ty2 );
		vertices[3] = InitFont2DVertex( D3DXVECTOR4(r,t,0.0f,1.0f), dwColor, tx2, ty1 );
		lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,2,vertices,sizeof(FONT2DVERTEX));
	}
	m_iTexCacheIx = 0;
	m_iDrawCacheIx = 0;
	return	cx;
}

void	CD3DKanjiFont::PrepareCharacterTexture(FontCache *p,D3DLOCKED_RECT *pd3dlr){
	DWORD charcode = p->m_dwCharCode;

	TCHAR str[4];
	int	count = 1;
#ifdef	_UNICODE
	str[0] = (TCHAR)charcode;
#else
	//	VtgJISΉ
	int	first_byte = (charcode & 0xff00) >> 8;
	int second_byte = charcode & 0xff;
	if (first_byte == 0){
		//	ANK
		str[0] = (TCHAR)second_byte;
	}else{
		//	̎
		str[0] = (TCHAR)first_byte;
		str[1] = second_byte;
		++count;		
	}
#endif
	str[count] = (TCHAR)0;
	RECT	r;
	r.left = 0;
	r.top = 0;
	r.right = FONT_BITMAP_WIDTH - 1;
	r.bottom = FONT_BITMAP_HEIGHT - 1;

    // ̏o
	//::DrawTextA(m_hDC,str,count,&r,DT_SINGLELINE|DT_BOTTOM);
	TextOut(m_hDC,0,0,str,count);
	int	width;
	if (!GetCharWidth32(m_hDC,charcode,charcode,&width)){
		width = m_iFontHeightInPixel;
	}

	short	vw = (short)width;
	short	vh = (short)this->m_iFontHeightInPixel;

	if (vw > p->w)
		vw = p->w;
	if (vh > p->h)
		vh = p->h;
	p->vw = (FLOAT)vw * this->m_fInvTexWidth;
	p->vh = (FLOAT)vh * this->m_fInvTexHeight;

	BYTE *pSourceBits = (BYTE*)m_pBitmapBits;
	//	rbg}bveNX`ɓ]
	_asm{
		mov	ebx, this;
		//mov	esi, [ebx].m_pBitmapBits;
		mov	esi, pSourceBits;
		mov	ebx, pd3dlr;
		mov	edi, D3DLOCKED_RECT[ebx].pBits;
		mov	ecx, D3DLOCKED_RECT[ebx].Pitch;

		xor	eax,eax;
		mov	ebx, p;			//	
		mov	ax, [ebx].ty;	//	eax = ty;
		mul	ecx;			//	edx: eax = ty * pitch
		add	edi, eax;		//	edi = d3dlr->pBits + (ty * pitch);

		xor	eax, eax;		//	
		mov	ax, [ebx].tx;	//	
		add	eax,eax;		//	eax: p->tx * 2;
		add	edi, eax;		//	edi = d3dlr->pBits + (ty * pitch) + tx * 2;
		mov	edx, ecx;		//	edx: pd3dlr->Pitch
		
		mov	cx, vh;			//	ecx: vh

transfer_loop_y:
		push	edi;
		push	esi;
		push	ecx;
		mov		cx, vw;
transfer_loop_x:
		mov	ax, word ptr[esi];
		and	ax, 0x1e;
		jz	write_zero;
		SHL	ax, 11;
		or	ax, 0x0fff;
write_zero:
		mov	word ptr[edi],ax;
		add	esi, 2;
		add	edi, 2;
		dec	cx;
		jnz	transfer_loop_x;

		pop		ecx;
		pop		esi;
		pop		edi;

		add		esi, (FONT_BITMAP_WIDTH*2);
		add		edi, edx;	//	edi += d3dlr->Pitch;
		dec		cx;
		jnz		transfer_loop_y;

	}
}

int CD3DKanjiFont::Hash(DWORD charcode){
	return	charcode % kKanjiHashSize;
}


//-----------------------------------------------------------------------------
// Name: GetTextExtent()
// Desc: ̃TCYԂBA܂萳mł͖B
//-----------------------------------------------------------------------------
HRESULT CD3DKanjiFont::GetTextExtent( TCHAR* strText, SIZE* pSize )
{
    if( NULL==strText || NULL==pSize )
        return E_FAIL;

	GetTextExtentPoint32(m_hDC,strText,_tcslen(strText),pSize);

	return S_OK;
}
