#include "StdAfx.h"
#include <d3dx9.h>
#include <dxfile.h>
#include <tchar.h>
#include <crtdbg.h>
#include "D3DQuickLib.h"
#include "ContainerDB.h"
#include "Container.h"

CContainerDB::CContainerDB(CD3DEnv *pEnv)
{
	m_numContainers = 0;
	m_numBuffers = 0;
	m_pContainers = new CContainer*[DEFAULT_VS_BUFFER_SIZE];
	if (m_pContainers != NULL)
		m_numBuffers = DEFAULT_VS_BUFFER_SIZE;
	m_pEnv = pEnv;
	pEnv->AddGraphicsObject(this);
}

CContainerDB::~CContainerDB(void)
{
	int	i;
	if (m_pContainers != NULL){
		for (i = 0; i < m_numContainers ; ++i){
			if (m_pContainers[i] != NULL){
				//	݂VF[_̓f[^x[XƂ̃NB
				_RPT0(_CRT_WARN,_T("Shader not deleted."));
				m_pContainers[i]->ClearDBReference();
			}
		}
		delete	[]m_pContainers;
	}
	m_pEnv->RemoveGraphicsObject(this);
}


//----------------------------------------------
//	method: Restore
//	Note: VF[_̍ēǂݍ
//----------------------------------------------
HRESULT	CContainerDB::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	
	//	VF[_z̍œK
	CContainer	**pContainer;
	int	numBuffers = (m_numContainers + DEFAULT_VS_BUFFER_SIZE-1) / DEFAULT_VS_BUFFER_SIZE;
	int	i;

	if (numBuffers == 0)
		numBuffers++;
	numBuffers *= DEFAULT_VS_BUFFER_SIZE;
	pContainer = new CContainer*[numBuffers];
	m_numBuffers = numBuffers;
	for (i = 0 ; i < m_numContainers ; ++i){
		pContainer[i] = m_pContainers[i];
	}
	if (m_pContainers != NULL)
		delete	[]m_pContainers;
	m_pContainers = pContainer;

	return	S_OK;
}

//------------------------------------------------------
//	method: SearchIndex
//	Note: VF[_̒Tipjz̗vfԍԂ
//------------------------------------------------------
int	CContainerDB::SearchIndex(GUID guid){
	UINT	top, end, middle;
	vsid128	key;
	if (m_numContainers == 0)
		return	-1;
	key = *(vsid128*)&guid;
	top = 0;
	end = m_numContainers - 1;
	while(top < end){
		middle = (top + end) >> 1;
		if (m_pContainers[middle]->m_guid < key)
			top = middle + 1;
		else
			end = middle;
	}
	if (m_pContainers[top]->m_guid == key)
		return	top;
	return	-1;
}

//----------------------------------------------------------
//	method: SearchShaderIndex
//	Note: VF[_̒Tipjz̗vfԍԂ
//		VF[_ΎQƃJEgCNgB
//----------------------------------------------------------
CContainer *CContainerDB::GetContainer(GUID guid){
	int	index = SearchIndex(guid);
	if (index < 0)
		return	NULL;
	CContainer *pContainer = m_pContainers[index];
	pContainer->AddRef();	//	QƃJEgCNg
	return	pContainer;
}

//------------------------------------------------------
//	method: RemoveContainer
//	Note: VF[_Ǘ͂B
//		VF[_̂̂̍폜͍sȂII
//------------------------------------------------------
void	CContainerDB::RemoveContainer(GUID guid){
	INT	index = SearchIndex(guid);
	if (index < 0 || m_numContainers == 0)
		return;
	--m_numContainers;
	while(index < m_numContainers){
		m_pContainers[index] = m_pContainers[index+1];
		++index;
	}
}

//-----------------------------------------------------
//	method: AddShaderContainer
//	Note :  VF[_̒ǉ
//-----------------------------------------------------
HRESULT	CContainerDB::AddContainer(CContainer *pContainer){
	GUID	guid = *(GUID*)&(pContainer->m_guid);
	INT	index = SearchIndex(guid);
	if (index >= 0){
		//	QƃJEǵEEE new ̂P͏O
		pContainer->m_iRefCount += m_pContainers[index]->m_iRefCount-1;
		delete	m_pContainers[index];
	}
	int	numShaders = m_numContainers;
	numShaders++;
	if (numShaders > m_numBuffers ){
		m_numBuffers += DEFAULT_VS_BUFFER_SIZE;
		CContainer	**ppContainer;
		ppContainer = new CContainer*[m_numBuffers];
		int	i;
		for (i = 0 ; i < m_numContainers ; ++i){
			ppContainer[i] = m_pContainers[i];
		}
		delete	[]m_pContainers;
		m_pContainers = ppContainer;
	}
	//	ɒǉ
	m_pContainers[m_numContainers] = pContainer;
	int	i = m_numContainers++;
	CContainer *pSwp;

	//	}\[gŏ킹
	while(i > 0){
		if (m_pContainers[i-1]->m_guid < m_pContainers[i]->m_guid)
			break;
		pSwp = m_pContainers[i];
		m_pContainers[i] = m_pContainers[i-1];
		m_pContainers[i-1] = pSwp;
		--i;
	}
	return	S_OK;
}
