/*
 *	class CBillboard
 *		r{[h̎
 *
 *		TL_̃NbsÓA_obt@gp
 *		Direct3D ɔCĂB
 *
 *		First edition: April.30.2004
 *
 */

#include "stdafx.h"
#include <stdio.h>
#include <d3dx9.h>
#include "d3d9env.h"
#include "Billboard.h"
#include <tchar.h>

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CBillboard::CBillboard(CD3DEnv *pEnv,int numTex)
{
	m_ppFilenames   = (TCHAR**)new long[numTex];
	ZeroMemory((VOID*)m_ppFilenames,sizeof(VOID*)*numTex);
	m_pTexture = new CBillboardTexture[numTex];
	for (int i = 0; i < numTex ; ++i){
		m_pTexture[i].m_lpTex = NULL;
		m_pTexture[i].m_sOrdHeight = 0;
		m_pTexture[i].m_sOrdWidth = 0;
		m_pTexture[i].m_sTexWidth = 0;
		m_pTexture[i].m_sTexHeight = 0;
	}

	m_lpD3DEnv = pEnv;
	m_dwNumTextures = numTex;
	m_dwNumSegs = 2;
	m_uiBlendMethod = BILLBOARD_SEMI_TRANS;
	m_vObjectCenter=D3DXVECTOR3(0.0f,0.0f,0.0f);
	m_uiBillboardStatus = BILLBOARD_IS_UNINITIALIZED;
	m_bUseHWNPatches = false;
	m_colorDiffuse = D3DCOLOR_XRGB(255,255,255);
	m_lpD3DEnv->AddGraphicsObject(this);
	m_fRotationAngle = 0.0f;
	m_dwVirtualScreenWidth = pEnv->GetBackBufferWidth();
	m_dwVirtualScreenHeight = pEnv->GetBackBufferHeight();

	m_dwVirtualScreenWidth  = m_dwDefaultScreenWidth;
	m_dwVirtualScreenHeight = m_dwDefaultScreenHeight;
	m_dwScreenFitMode = m_dwDefaultScreenFitMode;

	D3DXMatrixIdentity(&m_matRotation);
}

CBillboard::~CBillboard()
{
	InvalidateDeviceObjects();
	DeleteDeviceObjects();
	for(UINT i = 0; i < this->m_dwNumTextures;++i){
		if (m_ppFilenames[i] != NULL){
			delete	m_ppFilenames[i];
			m_ppFilenames[i] = NULL;
		}
		if (m_pTexture != NULL){
			delete m_pTexture;
			m_pTexture = NULL;
		}
	}
	SAFE_DELETE_ARRAY(m_ppFilenames);
	SAFE_DELETE_ARRAY(m_pTexture);
	m_lpD3DEnv->RemoveGraphicsObject(this);
}

void	CBillboard::SetDiffuse(D3DCOLOR diffuse){
	m_colorDiffuse = diffuse;
}
//-------------------------------------------------------------
//	Name: SetTexture
//  Desc: eNX`̓o^
//		dwTexNo:	eNX`ԍ
//		fName:		t@C
//-------------------------------------------------------------
HRESULT	CBillboard::SetTexture(DWORD dwTexNo, LPSTR fName)
{
	TCHAR	strFilename[MAX_PATH];
	TCHAR	strPath[MAX_PATH];
	if (dwTexNo >= m_dwNumTextures){
		return	E_FAIL;
	}
	if (m_ppFilenames[dwTexNo] != NULL){
		delete	m_ppFilenames[dwTexNo];
		m_ppFilenames[dwTexNo] = NULL;
	}
	_tcscpy_s(strFilename,MAX_PATH,fName);
	m_lpD3DEnv->GetFileName(strFilename, strPath);
	size_t len;
	_tcscat_s(strPath,MAX_PATH,_T("\\"));
	_tcscat_s(strPath,MAX_PATH,strFilename);
	len = _tcslen(strPath);
	len++;
	if (NULL != (m_ppFilenames[dwTexNo] = new TCHAR[len])){
		_tcscpy_s(m_ppFilenames[dwTexNo],len,strPath);
		return	S_OK;
	}
	return	E_FAIL;
}

//-------------------------------------------------------------
//	Name: InitDeviceObjects
//  Desc: foCXˑIuWFNg̐
//-------------------------------------------------------------
HRESULT	CBillboard::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	m_uiBillboardStatus = BILLBOARD_IS_INITIALIZED;
    return S_OK;
}


//-------------------------------------------------------------
//	Name: RestoreDeviceObjects
//  Desc: foCXˑrfIIuWFNg̐
//-------------------------------------------------------------
HRESULT CBillboard::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	D3DCAPS9    d3dCaps;
	TCHAR	strTexturePath[512];
	D3DSURFACE_DESC        d3dsDesc;
    D3DXIMAGE_INFO        srcImgInfo;

	lpd3ddev->GetDeviceCaps(&d3dCaps);
	m_bUseHWNPatches = (d3dCaps.DevCaps & D3DDEVCAPS_NPATCHES);

    HRESULT    hr;
    D3DFORMAT           TextureFormat[] = {D3DFMT_A8R8G8B8,D3DFMT_A4R4G4B4,D3DFMT_A1R5G5B5};
    int                 iFormat;

    for (iFormat = 0; iFormat < (sizeof(TextureFormat)/sizeof(D3DFORMAT)); ++iFormat){
		hr = m_lpD3DEnv->CheckDeviceFormat(0,D3DRTYPE_TEXTURE,TextureFormat[iFormat]);
        if (SUCCEEDED(hr))
			break;
    }
	if (iFormat == sizeof(TextureFormat)/sizeof(D3DFORMAT)){
		iFormat--;
	}

	for (UINT i = 0; i < this->m_dwNumTextures;++i){
		if ((m_pTexture[i].m_lpTex == NULL)&&(m_ppFilenames[i] != NULL)){
			_tcscpy_s(strTexturePath,_countof(strTexturePath),m_lpD3DEnv->GetAppPathName());
			_tcscat_s(strTexturePath,_countof(strTexturePath),_T("\\"));
			_tcscat_s(strTexturePath,_countof(strTexturePath),m_ppFilenames[i]);
			D3DXCreateTextureFromFileEx(lpd3ddev,
				strTexturePath,
				D3DX_DEFAULT,D3DX_DEFAULT,D3DX_DEFAULT,0,
				TextureFormat[iFormat],D3DPOOL_DEFAULT,
				D3DX_FILTER_NONE,D3DX_DEFAULT,
				0,        //    Color key.
				&srcImgInfo,NULL,&m_pTexture[i].m_lpTex);
			if (m_pTexture[i].m_lpTex != NULL){

				if (S_OK == m_pTexture[i].m_lpTex->GetLevelDesc(0,&d3dsDesc)){
					m_pTexture[i].m_sOrdWidth  = (USHORT)srcImgInfo.Width;
					m_pTexture[i].m_sOrdHeight = (USHORT)srcImgInfo.Height;
					m_pTexture[i].m_sTexWidth  = (USHORT)d3dsDesc.Width;
					m_pTexture[i].m_sTexHeight = (USHORT)d3dsDesc.Height;
				}
			}
		}
	}
	m_uiBillboardStatus = BILLBOARD_IS_RESTORED;
    return S_OK;
}

//-------------------------------------------------------------
//	Name: InvalidateDeviceObjects
//  Desc: foCXˑrfIIuWFNg̏
//-------------------------------------------------------------
HRESULT CBillboard::InvalidateDeviceObjects()
{
	for (UINT i = 0; i < this->m_dwNumTextures;++i){
		if (this->m_pTexture[i].m_lpTex != NULL){
			m_pTexture[i].m_lpTex->Release();
			m_pTexture[i].m_lpTex = NULL;
			m_pTexture[i].m_sOrdHeight = 0;
			m_pTexture[i].m_sOrdWidth  = 0;
			m_pTexture[i].m_sTexHeight = 0;
			m_pTexture[i].m_sTexWidth  = 0;
		}
	}
	m_uiBillboardStatus = BILLBOARD_IS_INITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: DeleteDeviceObjects
//  Desc: foCXˑIuWFNg̏
//-------------------------------------------------------------
HRESULT CBillboard::DeleteDeviceObjects()
{
	InvalidateDeviceObjects();
	m_uiBillboardStatus = BILLBOARD_IS_UNINITIALIZED;
    return  S_OK;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: 3D`揈
//		lpd3ddev:	LDirect3DfoCX
//		pMatWorld:	`Ɏgp郏[hs
//		pMatView:	`Ɏgpr[s
//		fW:			r{[h̕
//		fH:			r{[h̍
//			r{[h͍̕0w肷ƁA
//			eNX`̏ĉ܂܎gpāA
//			E0 ŖZoB
//		texNo:		gpeNX`ԍ
//-------------------------------------------------------------
void    CBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, int texNo)
{
	DWORD dwW=1, dwH=1;
	if (texNo >= (int)this->m_dwNumTextures)
		return;
	if (texNo >= 0){
		dwW = m_pTexture[texNo].m_sOrdWidth;
		dwH = m_pTexture[texNo].m_sOrdHeight;
	}
	Render(lpd3ddev,pMatWorld,pMatView,fW,fH,0,0,dwW,dwH,texNo);
}
//-------------------------------------------------------------
//	Name: Render
//  Desc: 3D`揈
//		lpd3ddev:	LDirect3DfoCX
//		pMatWorld:	`Ɏgp郏[hs
//		pMatView:	`Ɏgpr[s
//		fW:			r{[h̕
//		fH:			r{[h̍
//			r{[h͍̕0w肷ƁA
//			eNX`̏ĉ܂܎gpāA
//			E0 ŖZoB
//		dwU:		eNX`̎gp̍XW
//		dwV:		eNX`̎gp̍YW
//		dwW:		eNX`̎gp̕
//		dwH:		eNX`̎gp̍
//		texNo:		gpeNX`ԍ
//-------------------------------------------------------------
void    CBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, int texNo)
{
	FLOAT	fAspect;
	if (texNo >= (int)this->m_dwNumTextures)
		return;
	fAspect = (float)dwW;
	fAspect /= (float)dwH;
	float	fL=0, fT=0, fR=0, fB=0;

	if (fW == 0.0f && fH == 0.0f)
		return;

	if (fH == 0.0f)
		fH = fW / fAspect;
	if (fW == 0.0f)
		fW = fH * fAspect;

	D3DXMATRIX	matCamera,matBillboard;
	matCamera = *pMatWorld * *pMatView;
	MatrixInverseRotation(&matBillboard,&matCamera);
	matBillboard = matBillboard * *pMatWorld;

	if (m_fRotationAngle != 0.0f){
		D3DXMATRIX	matMove, matUnmove;
		D3DXMatrixTranslation(&matMove,0.0f,-0.5f * fH, 0.0f);
		D3DXMatrixTranslation(&matUnmove,0.0f,0.5f * fH, 0.0f);
		matBillboard = matMove * m_matRotation * matUnmove * matBillboard;	//	Kvł΃r{[h]B
	}

	lpd3ddev->SetTransform(D3DTS_WORLD,&matBillboard);
	lpd3ddev->SetTransform(D3DTS_VIEW,pMatView);
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB

    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
	lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
	if (m_uiBlendMethod == BILLBOARD_ADD_IN)
	    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
	else
	    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

    lpd3ddev->SetRenderState( D3DRS_ALPHATESTENABLE,  TRUE );
    lpd3ddev->SetRenderState( D3DRS_ALPHAREF,         0x08 );
    lpd3ddev->SetRenderState( D3DRS_ALPHAFUNC,  D3DCMP_GREATEREQUAL );
    lpd3ddev->SetRenderState( D3DRS_FILLMODE,   D3DFILL_SOLID );
	lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);

	if (texNo >= 0){
		if (this->m_pTexture[texNo].m_lpTex == NULL)
			return;
		float	fInvWidth  = 1.0f / (FLOAT)m_pTexture[texNo].m_sTexWidth;
		float	fInvHeight = 1.0f / (FLOAT)m_pTexture[texNo].m_sTexHeight;
		fL = (FLOAT)dwU * fInvWidth;
		fT = (FLOAT)dwV * fInvHeight;
		fR = (FLOAT)(dwU + dwW) * fInvWidth;
		fB = (FLOAT)(dwV + dwH) * fInvHeight;
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,  D3DTOP_MODULATE);

		lpd3ddev->SetTexture(0,m_pTexture[texNo].m_lpTex);

	}else{
	    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
	    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2);
		lpd3ddev->SetTexture(0,NULL);
	}

	BILLBOARDVERTEX	vertex[4];
	vertex[3].color = vertex[2].color = vertex[1].color
		= vertex[0].color=m_colorDiffuse;

	vertex[0].p = D3DXVECTOR3(-(fW * 0.5f),fH,0.0f);
	vertex[0].tu = fL;		//	
	vertex[0].tv = fT;		//
	vertex[0].n = D3DXVECTOR3(0.0f,0.0f,-1.0f);

	vertex[1].p = D3DXVECTOR3(-(fW * 0.5f),0.0f,0.0f);
	vertex[1].tu = fL;		//	
	vertex[1].tv = fB;		//	
	vertex[1].n = D3DXVECTOR3(0.0f,0.0f,-1.0f);

	vertex[2].p = D3DXVECTOR3(fW * 0.5f,fH,0.0f);
	vertex[2].tu = fR;		//	E
	vertex[2].tv = fT;		//	
	vertex[2].n = D3DXVECTOR3(0.0f,0.0f,-1.0f);


	vertex[3].p = D3DXVECTOR3(fW * 0.5f,0.0f,0.0f);
	vertex[3].tu = fR;		//	E
	vertex[3].tv = fB;		//
	vertex[3].n = D3DXVECTOR3(0.0f,0.0f,-1.0f);
	if (m_bUseHWNPatches){
        float fNumSegs;
        fNumSegs = (float)m_dwNumSegs;
		lpd3ddev->SetNPatchMode(fNumSegs);
    }
	lpd3ddev->SetFVF(BILLBOARDVERTEXFVF);
	lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,2,vertex,D3DXGetFVFVertexSize(BILLBOARDVERTEXFVF));

	if (m_bUseHWNPatches){
		lpd3ddev->SetNPatchMode(0);
    }
}
//-------------------------------------------------------------
//	Name: Render
//  Desc: 2D`揈
//		lpd3ddev:	LDirect3DfoCX
//		x:			\wW
//		y:			\xW
//		w:			\
//		h:			\
//		texNo:		gpeNX`ԍ
//-------------------------------------------------------------
void    CBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,FLOAT x, FLOAT y, FLOAT w, FLOAT h, int texNo)
{
	float	fL=0, fT=0, fR=0, fB=0;
	LPDIRECT3DTEXTURE9	pTex = NULL;

	if (texNo >= 0){
		DWORD dwW, dwH;

		if (texNo >= (int)this->m_dwNumTextures)
			return;
		pTex = m_pTexture[texNo].m_lpTex;
		if (pTex != NULL){
			dwW = m_pTexture[texNo].m_sOrdWidth;
			dwH = m_pTexture[texNo].m_sOrdHeight;
			dwW--;
			dwH--;
			fR = ((FLOAT)dwW) / (FLOAT)m_pTexture[texNo].m_sTexWidth;
			fB = ((FLOAT)dwH) / (FLOAT)m_pTexture[texNo].m_sTexHeight;
		}
	}

	//	TCYtBbg
	if (m_dwScreenFitMode != BILLBOARD_FIT_NONE)
		AdjustPositionAndSizeAndRender(lpd3ddev,x,y,w,h,fL,fT,fR,fB,pTex);
	else
		Render2D(lpd3ddev,x,y,w,h,fL,fT,fR,fB,pTex);

}

//-------------------------------------------------------------
//	Name: Render
//  Desc: 2D`揈
//		lpd3ddev:	LDirect3DfoCX
//		x:			\wW
//		y:			\xW
//		w:			\
//		h:			\
//		dwU:		eNX`XW
//		dwV:		eNX`YW
//		dwW:		eNX`
//		dwH:		eNX`
//		texNo:		gpeNX`ԍ
//-------------------------------------------------------------
void    CBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,FLOAT x, FLOAT y, FLOAT w, FLOAT h, DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, int texNo)
{
	LPDIRECT3DTEXTURE9	pTex = NULL;
	float	fL=0, fT=0, fR=0, fB=0;

	if (texNo >= 0){
		if (texNo >= (int)this->m_dwNumTextures)
			return;
		pTex = m_pTexture[texNo].m_lpTex;
		if (pTex != NULL && (dwW > 0 || dwH > 0)){
			float	fInvWidth  = 1.0f / (FLOAT)m_pTexture[texNo].m_sTexWidth;
			float	fInvHeight = 1.0f / (FLOAT)m_pTexture[texNo].m_sTexHeight;
			fL = ((FLOAT)dwU+0.5f) * fInvWidth;
			fT = ((FLOAT)dwV+0.5f) * fInvHeight;
			fR = ((FLOAT)(dwU + dwW)+0.5f) * fInvWidth;
			fB = ((FLOAT)(dwV + dwH)+0.5f) * fInvHeight;
		}
	}

	//	TCYtBbg
	if (m_dwScreenFitMode != BILLBOARD_FIT_NONE)
		AdjustPositionAndSizeAndRender(lpd3ddev,x,y,w,h,fL,fT,fR,fB,pTex);
	else
		Render2D(lpd3ddev,x,y,w,h,fL,fT,fR,fB,pTex);

}


//-------------------------------------------------------------
//	Name: Render
//  Desc: 2D`揈
//		lpd3ddev:	LDirect3DfoCX
//		x:			\wW
//		y:			\xW
//		w:			\
//		h:			\
//		dwU:		eNX`XW
//		dwV:		eNX`YW
//		dwW:		eNX`
//		dwH:		eNX`
//		pTex:		gpeNX`IuWFNg
//-------------------------------------------------------------
static inline void computebillboardvertex(BILLBOARD2DVERTEX *pvec, FLOAT x, FLOAT y, FLOAT w, FLOAT h, FLOAT fL, FLOAT fT, FLOAT fR, FLOAT fB, D3DCOLOR color, FLOAT a){
	if (a == 0.0f){
		pvec[0].x = x;		pvec[0].y = y;		pvec[0].z = 0.0f;	
		pvec[1].x = x+w;	pvec[1].y = y;		pvec[1].z = 0.0f;
		pvec[2].x = x;		pvec[2].y = y+h;	pvec[2].z = 0.0f;
		pvec[3].x = x+w;	pvec[3].y = y+h;	pvec[3].z = 0.0f;
	}else{
		FLOAT	fCenterX, fCenterY;
		FLOAT	x1, y1, x2, y2;
		FLOAT	fCos, fSin;

		fCenterX = x + (0.5f*w);
		fCenterY = y + (0.5f*h);
		fCos = cosf(a);
		fSin = sinf(a);

		x1 = x - fCenterX;
		y1 = y - fCenterY;
		x2 = x1 * fCos - y1 * fSin + fCenterX;
		y2 = x1 * fSin + y1 * fCos + fCenterY;
		pvec[0].x = x2;	pvec[0].y = y2;	pvec[0].z = 0.0f;

		x1 = x + w - fCenterX;
		y1 = y - fCenterY;
		x2 = x1 * fCos - y1 * fSin + fCenterX;
		y2 = x1 * fSin + y1 * fCos + fCenterY;
		pvec[1].x = x2;	pvec[1].y = y2;	pvec[1].z = 0.0f;

		x1 = x - fCenterX;
		y1 = y + h - fCenterY;
		x2 = x1 * fCos - y1 * fSin + fCenterX;
		y2 = x1 * fSin + y1 * fCos + fCenterY;
		pvec[2].x = x2;	pvec[2].y = y2;	pvec[2].z = 0.0f;

		x1 = x + w - fCenterX;
		y1 = y + h - fCenterY;
		x2 = x1 * fCos - y1 * fSin + fCenterX;
		y2 = x1 * fSin + y1 * fCos + fCenterY;
		pvec[3].x = x2;	pvec[3].y = y2;	pvec[3].z = 0.0f;
	}
	pvec[0].tu = fL;
	pvec[0].tv = fT;

	pvec[1].tu = fR;
	pvec[1].tv = fT;

	pvec[2].tu = fL;
	pvec[2].tv = fB;

	pvec[3].tu = fR;	
	pvec[3].tv = fB;

	pvec[0].rhw = 1.0f;		
	pvec[1].rhw = 1.0f;	
	pvec[2].rhw = 1.0f;	
	pvec[3].rhw = 1.0f;

	pvec[0].color 
		= pvec[1].color 
		= pvec[2].color 
		= pvec[3].color 
		= color;	//this->m_colorDiffuse;

}

void    CBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,FLOAT x, FLOAT y, FLOAT w, FLOAT h, DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, LPDIRECT3DTEXTURE9 pTex)
{
	float	fL=0, fT=0, fR=0, fB=0;

	if (dwW == 0 || dwH == 0)
			return;

	D3DSURFACE_DESC	ddesc;
	if (pTex != NULL){
		pTex->GetLevelDesc(0,&ddesc);

		INT	iTexW, iTexH;
		iTexW = ddesc.Width;
		iTexH = ddesc.Height;
		if (iTexW <= 0 || iTexH <= 0)
			return;
		float	fInvWidth  = 1.0f / (FLOAT)iTexW;
		float	fInvHeight = 1.0f / (FLOAT)iTexH;
		fL = ((FLOAT)dwU+0.5f) * fInvWidth;
		fT = ((FLOAT)dwV+0.5f) * fInvHeight;
		fR = ((FLOAT)(dwU + dwW)+0.5f) * fInvWidth;
		fB = ((FLOAT)(dwV + dwH)+0.5f) * fInvHeight;
	}

	//	TCYtBbg
	if (m_dwScreenFitMode != BILLBOARD_FIT_NONE)
		AdjustPositionAndSizeAndRender(lpd3ddev,x,y,w,h,fL,fT,fR,fB,pTex);
	else
		Render2D(lpd3ddev,x,y,w,h,fL,fT,fR,fB,pTex);
}


//-------------------------------------------------------------
//	Name: Render2D
//	Desc: 2D `ɂ܂Ƃ߂ׂ̓\bh
//-------------------------------------------------------------
void	CBillboard::Render2D(LPDIRECT3DDEVICE9 lpd3ddev, FLOAT x, FLOAT y, FLOAT w, FLOAT h, FLOAT fL, FLOAT fT, FLOAT fR, FLOAT fB, LPDIRECT3DTEXTURE9 pTex){
	BILLBOARD2DVERTEX	vertex[4];
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
	lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
	if (m_uiBlendMethod == BILLBOARD_ADD_IN)
	    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
	else
	    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
	lpd3ddev->SetRenderState( D3DRS_ALPHATESTENABLE,  TRUE );
    lpd3ddev->SetRenderState( D3DRS_ALPHAREF,         0x08 );
    lpd3ddev->SetRenderState( D3DRS_ALPHAFUNC,  D3DCMP_GREATEREQUAL );
    lpd3ddev->SetRenderState( D3DRS_FILLMODE,   D3DFILL_SOLID );
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);

	//	20100903	hLg ueNX`WvQ

	if (pTex != NULL){
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,  D3DTOP_MODULATE);
	}else{
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2);
	}
	lpd3ddev->SetTexture(0,pTex);

	if (m_fRotationAngle == 0.0f){
		vertex[0].x = x;	vertex[0].y = y;	vertex[0].z = 0.0f;	vertex[0].rhw = 1.0f;
		vertex[1].x = x+w;	vertex[1].y = y;	vertex[1].z = 0.0f;	vertex[1].rhw = 1.0f;
		vertex[2].x = x;	vertex[2].y = y+h;	vertex[2].z = 0.0f;	vertex[2].rhw = 1.0f;
		vertex[3].x = x+w;	vertex[3].y = y+h;	vertex[3].z = 0.0f;	vertex[3].rhw = 1.0f;
	}else{
		FLOAT	fCenterX, fCenterY;
		FLOAT	x1, y1, x2, y2;
		FLOAT	fCos, fSin;

		fCenterX = x + (0.5f*w);
		fCenterY = y + (0.5f*h);
		fCos = cosf(m_fRotationAngle);
		fSin = sinf(m_fRotationAngle);

		x1 = x - fCenterX;
		y1 = y - fCenterY;
		x2 = x1 * fCos - y1 * fSin + fCenterX;
		y2 = x1 * fSin + y1 * fCos + fCenterY;
		vertex[0].x = x2;	vertex[0].y = y2;	vertex[0].z = 0.0f;	vertex[0].rhw = 1.0f;

		x1 = x + w - fCenterX;
		y1 = y - fCenterY;
		x2 = x1 * fCos - y1 * fSin + fCenterX;
		y2 = x1 * fSin + y1 * fCos + fCenterY;
		vertex[1].x = x2;	vertex[1].y = y2;	vertex[1].z = 0.0f;	vertex[1].rhw = 1.0f;

		x1 = x - fCenterX;
		y1 = y + h - fCenterY;
		x2 = x1 * fCos - y1 * fSin + fCenterX;
		y2 = x1 * fSin + y1 * fCos + fCenterY;
		vertex[2].x = x2;	vertex[2].y = y2;	vertex[2].z = 0.0f;	vertex[2].rhw = 1.0f;

		x1 = x + w - fCenterX;
		y1 = y + h - fCenterY;
		x2 = x1 * fCos - y1 * fSin + fCenterX;
		y2 = x1 * fSin + y1 * fCos + fCenterY;
		vertex[3].x = x2;	vertex[3].y = y2;	vertex[3].z = 0.0f;	vertex[3].rhw = 1.0f;
	}
	vertex[0].tu = fL;
	vertex[0].tv = fT;

	vertex[1].tu = fR;
	vertex[1].tv = fT;

	vertex[2].tu = fL;
	vertex[2].tv = fB;

	vertex[3].tu = fR;	
	vertex[3].tv = fB;

	vertex[0].color 
		= vertex[1].color 
		= vertex[2].color 
		= vertex[3].color 
		= this->m_colorDiffuse;

	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);
	lpd3ddev->SetFVF(BILLBOARD2DVERTEXFVF);
    lpd3ddev->SetRenderState(D3DRS_ZENABLE,FALSE);
	lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,2,vertex,D3DXGetFVFVertexSize(BILLBOARD2DVERTEXFVF));
	if (m_lpD3DEnv->IsDepthBufferActive()){
	    lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
	}
}

//-------------------------------------------------------------
//	Name: Render2DVertex
//	Desc: 2D `ɂ܂Ƃ߂ׂ̓\bh
//-------------------------------------------------------------
static inline void render2dvertex(LPDIRECT3DDEVICE9 lpd3ddev, BILLBOARD2DVERTEX *pvec,UINT blendmethod, BOOL depthactive, LPDIRECT3DTEXTURE9 pTex){
	lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
	lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
	if (blendmethod == BILLBOARD_ADD_IN)
	    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
	else
	    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
	lpd3ddev->SetRenderState( D3DRS_ALPHATESTENABLE,  TRUE );
    lpd3ddev->SetRenderState( D3DRS_ALPHAREF,         0x08 );
    lpd3ddev->SetRenderState( D3DRS_ALPHAFUNC,  D3DCMP_GREATEREQUAL );
    lpd3ddev->SetRenderState( D3DRS_FILLMODE,   D3DFILL_SOLID );
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);

	if (pTex != NULL){
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,  D3DTOP_MODULATE);
	}else{
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2);
	}
	lpd3ddev->SetTexture(0,pTex);

	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);
	lpd3ddev->SetFVF(BILLBOARD2DVERTEXFVF);
    lpd3ddev->SetRenderState(D3DRS_ZENABLE,FALSE);
	lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,2,pvec,D3DXGetFVFVertexSize(BILLBOARD2DVERTEXFVF));
	if (depthactive){
	    lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
	}
}

//-------------------------------------------------------------
//	Name: MatrixInverseRotation
//  Desc: AtBϊsϊs pMat
//		󂯎Ả]ł]s
//		ZoB
//		ApMat XP[O܂ł
//		삵ȂB
//-------------------------------------------------------------
void	CBillboard::MatrixInverseRotation(D3DXMATRIX *pOut, D3DXMATRIX *pMat)
{
#if	1
	//	ϊs pMat Ă]ɑ΂Ă̋ts
	//	߂B
	//	]s̋ts͉]s]u邾ŋ߂B

	pOut->_11 = pMat->_11;
	pOut->_21 = pMat->_12;
	pOut->_31 = pMat->_13;
	pOut->_41 = 0.0f;

	pOut->_12 = pMat->_21;
	pOut->_22 = pMat->_22;
	pOut->_32 = pMat->_23;
	pOut->_42 = 0.0f;

	pOut->_13 = pMat->_31;
	pOut->_23 = pMat->_32;
	pOut->_33 = pMat->_33;
	pOut->_43 = 0.0f;

	pOut->_14 = 0.0f;
	pOut->_24 = 0.0f;
	pOut->_34 = 0.0f;
	pOut->_44 = 1.0f;
#else
	//	ϊs pMat Ă]𒊏oĂ̋ts
	//	߂B
	//	XP[OɑΉȂ炱ȊB

	D3DXVECTOR4	vecX, vecY, vecZ;

	vecX.x = pMat->_11;
	vecX.y = pMat->_12;
	vecX.z = pMat->_13;
	vecY.x = pMat->_21;
	vecY.y = pMat->_22;
	vecY.z = pMat->_23;
	vecZ.x = pMat->_31;
	vecZ.y = pMat->_32;
	vecZ.z = pMat->_33;
	::D3DXVec3Normalize(&vecX,&vecX);
	::D3DXVec3Normalize(&vecY,&vecY);
	::D3DXVec3Normalize(&vecZ,&vecZ);

	pOut->_11 = vecX.x;
	pOut->_21 = vecX.y;
	pOut->_31 = vecX.z;
	pOut->_41 = 0.0f;

	pOut->_12 = vecY.x;
	pOut->_22 = vecY.y;
	pOut->_32 = vecY.z;
	pOut->_42 = 0.0f;

	pOut->_13 = vecZ.x;
	pOut->_23 = vecZ.y;
	pOut->_33 = vecZ.z;
	pOut->_43 = 0.0f;

	pOut->_14 = 0.0f;
	pOut->_24 = 0.0f;
	pOut->_34 = 0.0f;
	pOut->_44 = 1.0f;
#endif
}

//-------------------------------------------------------------
//	Name: GetObjectCenter
//  Desc: r{[h̒S_i̍Wnj̒
//-------------------------------------------------------------
void	CBillboard::GetObjectCenter(D3DXVECTOR3 *pPos){
	*pPos = this->m_vObjectCenter;
}
//-------------------------------------------------------------
//	Name: GetTexture
//  Desc: eNX`摜𓾂B
//-------------------------------------------------------------

LPDIRECT3DTEXTURE9	CBillboard::GetTexture(UINT texNo){
	if (texNo >= m_dwNumTextures){
		return	NULL;
	}
	LPDIRECT3DTEXTURE9	lpTex = m_pTexture[texNo].m_lpTex;
	if (lpTex != NULL){
		lpTex->AddRef();
		return	lpTex;
	}
	return	NULL;
}

//-------------------------------------------------------------
//	Name: GetTextureSize
//  Desc: eNX`摜̃TCY𓾂B
//-------------------------------------------------------------
HRESULT	CBillboard::GetTextureSize(UINT texNo, DWORD *w, DWORD *h){
	if (texNo >= m_dwNumTextures|| m_pTexture[texNo].m_lpTex == NULL){
		return	E_FAIL;
	}
	*w = m_pTexture[texNo].m_sOrdWidth;
	*h = m_pTexture[texNo].m_sOrdHeight;
	return	S_OK;
}

//-------------------------------------------------------------
//	Name: GetOrdImageSize
//  Desc: {̃eNX`摜̃TCY𓾂B
//-------------------------------------------------------------
HRESULT	CBillboard::GetOrdImageSize(UINT texNo, SHORT *sW, SHORT *sH){
	if (texNo >= m_dwNumTextures|| m_pTexture[texNo].m_lpTex == NULL){
		return	E_FAIL;
	}
	*sW = this->m_pTexture[texNo].m_sOrdHeight;
	*sH = this->m_pTexture[texNo].m_sOrdWidth;
	return	S_OK;
}

//-------------------------------------------------------------
//	Name: SetBlendingMethod
//  Desc: At@ufBO̎@ݒB
//-------------------------------------------------------------
void	CBillboard::SetBlendingMethod(UINT method){
	m_uiBlendMethod = method;
}

//-------------------------------------------------------------
//	Name: SetBlendingMethod
//  Desc: At@ufBO̎@ݒB
//-------------------------------------------------------------
void	CBillboard::SetRotation(FLOAT fAngle){
	m_fRotationAngle = fAngle;
	D3DXMatrixRotationZ(&m_matRotation,fAngle);
}

//-------------------------------------------------------------
//	Name: SetVirtualScreenSize
//  Desc: zʂ̕ƍݒ
//-------------------------------------------------------------
void	CBillboard::SetVirtualScreenSize(DWORD w, DWORD h){
	m_dwVirtualScreenWidth = w;
	m_dwVirtualScreenHeight = h;
}

//-------------------------------------------------------------
//	Name: SetScreenFitMode
//  Desc: r[|[gփtBbg郂[h̐ݒ
//-------------------------------------------------------------
void	CBillboard::SetScreenFitMode(DWORD mode){
	m_dwScreenFitMode = mode;
}

//-------------------------------------------------------------
//	Name: SetDefaultScreenSize
//  Desc: zʂ̕ƍݒ
//-------------------------------------------------------------
void	CBillboard::SetDefaultScreenSize(DWORD w, DWORD h){
	m_dwDefaultScreenWidth = w;
	m_dwDefaultScreenHeight = h;
}

//-------------------------------------------------------------
//	Name: SetScreenFitMode
//  Desc: r[|[gփtBbg郂[h̐ݒ
//-------------------------------------------------------------
void	CBillboard::SetDefaultScreenFitMode(DWORD mode){
	m_dwDefaultScreenFitMode = mode;
}

//-------------------------------------------------------------
//	Name: CalculateScreenScaledViewport
//	Desc: ݂̃[hŁAw肳ꂽʒuƃTCỸr[|[g
//		_Oۂ́AʂƂĂ̕`̈
//		Ƀ_Oۂ̃XP[OWԂ
//-------------------------------------------------------------
void	CBillboard::CalculateScreenScaledViewport(RECT *rc, FLOAT *wscale, FLOAT *hscale){
	FLOAT	fL = 0, fT = 0, fR = 0, fB = 0;
	FLOAT	fWidth = (FLOAT)(rc->right - rc->left);
	FLOAT	fHeight = (FLOAT)(rc->bottom - rc->top);
	FLOAT	screenWidth = (FLOAT)m_dwVirtualScreenWidth;
	FLOAT	screenHeight = (FLOAT)m_dwVirtualScreenHeight;
	DWORD	mode = m_dwScreenFitMode;
	FLOAT	scale = 1.f;
	//	TCY̒
	
	if (!mode & BILLBOARD_FIT_SIZE){
		rc->left = 0;
		rc->top = 0;
		rc->right = this->m_lpD3DEnv->GetBackBufferWidth();
		rc->bottom = this->m_lpD3DEnv->GetBackBufferHeight();
		*wscale = 1.f;
		*hscale = 1.f;
		return;
	}
	FLOAT WScale = (FLOAT)fWidth / screenWidth;
	FLOAT HScale = (FLOAT)fHeight / screenHeight;
	if (!(mode & BILLBOARD_FIT_KEEP_ASPECT)){
		*wscale = WScale;
		*hscale = HScale;
		return;
	}else{
		if (mode & BILLBOARD_FIT_CUT){
			scale = max(WScale, HScale);
		}else{
			scale = min(WScale,HScale);
		}
		screenHeight *=scale;
		screenWidth  *=scale;
	}
	FLOAT	vpL=0, vpT=0, vpR=0, vpB=0;

	//	r[|[g̃TCYƈʒu𒲐EZo
	//	\ʒu̒
	switch(mode & BILLBOARD_FIT_HORIZONTAL_MASK){
	case	BILLBOARD_FIT_RIGHT:
		vpL = fWidth - screenWidth;
		break;
	case	BILLBOARD_FIT_CENTER:
		vpL =(fWidth - screenWidth) * 0.5f; 
		break;
	}
	vpL += (FLOAT)rc->left;

	switch(mode & BILLBOARD_FIT_VERTICAL_MASK){
	case	BILLBOARD_FIT_BOTTOM:
		vpT = fHeight - screenWidth;
		break;
	case	BILLBOARD_FIT_MIDDLE:
		vpT = (fHeight - screenHeight) * 0.5f;
		break;
	}
	vpT += (FLOAT)rc->top;
	vpR = vpL + screenWidth;
	vpB = vpT + screenHeight;
	rc->left = (INT)(vpL + 0.5f);
	rc->top = (INT)(vpT + 0.5f);
	rc->right = (INT)(vpR + 0.5f);
	rc->bottom = (INT)(vpB + 0.5f);
	*wscale = scale;
	*hscale = scale;
}

//-------------------------------------------------------------
//	Name: AdjustPositionAndSize
//  Desc: W̒@\
//-------------------------------------------------------------
void	CBillboard::AdjustPositionAndSizeAndRender(LPDIRECT3DDEVICE9 lpd3ddev, FLOAT x, FLOAT y, FLOAT w, FLOAT h, FLOAT fL, FLOAT fT, FLOAT fR, FLOAT fB, LPDIRECT3DTEXTURE9 pTex)
{
	D3DVIEWPORT9	vp;
	DWORD	mode = m_dwScreenFitMode;
	FLOAT	wscale, hscale;
	RECT	rc;
	BILLBOARD2DVERTEX	pvec[4];
	if (SUCCEEDED(lpd3ddev->GetViewport(&vp))){
		rc.left = vp.X;
		rc.top = vp.Y;
		rc.right = vp.X+vp.Width;
		rc.bottom = vp.Y + vp.Height;
		CalculateScreenScaledViewport(&rc,&wscale,&hscale);

		
		computebillboardvertex(pvec,x,y,w,h,fL,fT,fR,fB,m_colorDiffuse,m_fRotationAngle);
		for (int i = 0; i < 4 ; ++i){
			pvec[i].x *= wscale;
			pvec[i].y *= hscale;
			pvec[i].x += rc.left;
			pvec[i].y += rc.top;
		}
		
		if (m_dwScreenFitMode & BILLBOARD_FIT_CLIPPING){

			D3DVIEWPORT9	vp2;

			//	̃r[|[g傫Ȃ͉̂
			rc.left = max(rc.left, (LONG)vp.X);
			rc.top  = max(rc.top, (LONG)vp.Y);
			rc.right = min(rc.right, (LONG)(vp.X+vp.Width));
			rc.bottom = min(rc.bottom, (LONG)(vp.Y+vp.Height));

			vp2.X = rc.left;
			vp2.Y = rc.top;
			vp2.Width = rc.right - rc.left;
			vp2.Height = rc.bottom - rc.top;
			vp2.MinZ = vp.MinZ;
			vp2.MaxZ = vp.MaxZ;

			lpd3ddev->SetViewport(&vp2);
			render2dvertex(lpd3ddev,pvec,m_uiBlendMethod,m_lpD3DEnv->IsDepthBufferActive(),pTex);
			lpd3ddev->SetViewport(&vp);
		}else
			render2dvertex(lpd3ddev,pvec,m_uiBlendMethod,m_lpD3DEnv->IsDepthBufferActive(),pTex);
	}
}

//-------------------------------------------------------------
//	Name: Render2DVertices
//  Desc: 2D`揈
//		lpd3ddev:	LDirect3DfoCX
//		pVec:		l_OxNg(top-left,top-right,bottom-left,bottom-right ̏)
//		texNo:		gpeNX`ԍ
//-------------------------------------------------------------
void	CBillboard::Render2DVertices(LPDIRECT3DDEVICE9 lpd3ddev,D3DXVECTOR3 *pVec,int texNo){
	DWORD dwU = 0, dwV = 0, dwW = 0, dwH = 0;
	FLOAT	fL=0, fT=0, fR=0, fB=0;
	LPDIRECT3DTEXTURE9	pTex = NULL;
	if (texNo >= 0){
		if (texNo >= (int)this->m_dwNumTextures)
			return;
		pTex = m_pTexture[texNo].m_lpTex;
		if (pTex != NULL){
			float	fInvWidth  = 1.0f / (FLOAT)m_pTexture[texNo].m_sTexWidth;
			float	fInvHeight = 1.0f / (FLOAT)m_pTexture[texNo].m_sTexHeight;
			fL = 0.5f * fInvWidth;
			fT = 0.5f * fInvHeight;
			dwW = m_pTexture[texNo].m_sOrdWidth;
			dwH = m_pTexture[texNo].m_sOrdHeight;
			fR = ((FLOAT)dwW+0.5f) * fInvWidth;
			fB = ((FLOAT)dwH+0.5f) * fInvHeight;
		}
	}
	Render2DVerticesSub(lpd3ddev,pVec,fL,fT,fR,fB,pTex);
	//this->Render2DVertices(lpd3ddev,pVec,dwU,dwV,dwW,dwH,texNo);
}

//-------------------------------------------------------------
//	Name: Render2DVertices
//  Desc: 2D`揈
//		lpd3ddev:	LDirect3DfoCX
//		pVec:		l_OxNg(top-left,top-right,bottom-left,bottom-right ̏)
//		dwU:		eNX`XW
//		dwV:		eNX`YW
//		dwW:		eNX`
//		dwH:		eNX`
//		texNo:		gpeNX`ԍ
//-------------------------------------------------------------
void	CBillboard::Render2DVertices(LPDIRECT3DDEVICE9 lpd3ddev,D3DXVECTOR3 *pVec,DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, int texNo){
	LPDIRECT3DTEXTURE9	pTex = NULL;
	float	fL=0, fT=0, fR=0, fB=0;

	if (texNo >= 0){
		if (texNo >= (int)this->m_dwNumTextures)
			return;
		pTex = m_pTexture[texNo].m_lpTex;
		if (pTex != NULL && (dwW > 0 || dwH > 0)){
			float	fInvWidth  = 1.0f / (FLOAT)m_pTexture[texNo].m_sTexWidth;
			float	fInvHeight = 1.0f / (FLOAT)m_pTexture[texNo].m_sTexHeight;
			fL = ((FLOAT)dwU+0.5f) * fInvWidth;
			fT = ((FLOAT)dwV+0.5f) * fInvHeight;
			fR = ((FLOAT)(dwU + dwW)+0.5f) * fInvWidth;
			fB = ((FLOAT)(dwV + dwH)+0.5f) * fInvHeight;
		}
	}
	Render2DVerticesSub(lpd3ddev,pVec,fL,fT,fR,fB,pTex);
}

//-------------------------------------------------------------
//	Name: Render2DVertices
//  Desc: 2D`揈
//		lpd3ddev:	LDirect3DfoCX
//		pVec:		l_OxNg(top-left,top-right,bottom-left,bottom-right ̏)
//		dwU:		eNX`XW
//		dwV:		eNX`YW
//		dwW:		eNX`
//		dwH:		eNX`
//		pTex:		gpeNX`
//-------------------------------------------------------------
void	CBillboard::Render2DVertices(LPDIRECT3DDEVICE9 lpd3ddev,D3DXVECTOR3 *pVec,DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, LPDIRECT3DTEXTURE9 pTex){
	float	fL=0, fT=0, fR=0, fB=0;
	D3DSURFACE_DESC	ddesc;
	if (pTex != NULL){
		pTex->GetLevelDesc(0,&ddesc);

		INT	iTexW, iTexH;
		iTexW = ddesc.Width;
		iTexH = ddesc.Height;
		if (iTexW <= 0 || iTexH <= 0)
			return;
		float	fInvWidth  = 1.0f / (FLOAT)iTexW;
		float	fInvHeight = 1.0f / (FLOAT)iTexH;
		fL = ((FLOAT)dwU+0.5f) * fInvWidth;
		fT = ((FLOAT)dwV+0.5f) * fInvHeight;
		fR = ((FLOAT)(dwU + dwW)+0.5f) * fInvWidth;
		fB = ((FLOAT)(dwV + dwH)+0.5f) * fInvHeight;
	}
	Render2DVerticesSub(lpd3ddev,pVec,fL,fT,fR,fB,pTex);
}

//-------------------------------------------------------------
//	Name: Render2DVerticesSub
//  Desc: 2D`揈
//		lpd3ddev:	LDirect3DfoCX
//		pVec:		l_OxNg(top-left,top-right,bottom-left,bottom-right ̏)
//		fL:			eNX`
//		fT:			eNX`
//		fR:			eNX`E
//		fB:			eNX`
//		pTex:		gpeNX`
//-------------------------------------------------------------
void	CBillboard::Render2DVerticesSub(LPDIRECT3DDEVICE9 lpd3ddev, D3DXVECTOR3 *pVec, FLOAT fL, FLOAT fT, FLOAT fR, FLOAT fB, LPDIRECT3DTEXTURE9 pTex){
	BILLBOARD2DVERTEX	vertex[4];
	if (m_fRotationAngle == 0.0f){
		for (int i = 0; i < 4 ; ++i){
			vertex[i].x = pVec[i].x;
			vertex[i].y = pVec[i].y;
			vertex[i].z = pVec[i].z;
		}
	}else{
		FLOAT	fCenterX, fCenterY;
		FLOAT	x1, y1, x2, y2;
		FLOAT	fCos, fSin;
		fCenterX = 0;
		fCenterY = 0;
		for (int i = 0; i < 4 ; ++i){
			fCenterX += vertex[i].x = pVec[i].x;
			fCenterY += vertex[i].y = pVec[i].y;
			vertex[i].z = pVec[i].z;
		}
		fCenterX *= 0.25f;
		fCenterY *= 0.25f;
		fCos = cosf(m_fRotationAngle);
		fSin = sinf(m_fRotationAngle);

		for (int i = 0; i < 4 ; ++i){
			x1 = vertex[i].x - fCenterX;
			y1 = vertex[i].y - fCenterY;
			x2 = x1 * fCos - y1 * fSin + fCenterX;
			y2 = x1 * fSin + y1 * fCos + fCenterY;
			vertex[i].x = x2;
			vertex[i].y = y2;
		}
	}
	vertex[0].tu = fL;
	vertex[0].tv = fT;

	vertex[1].tu = fR;
	vertex[1].tv = fT;

	vertex[2].tu = fL;
	vertex[2].tv = fB;

	vertex[3].tu = fR;	
	vertex[3].tv = fB;

	vertex[0].rhw = 1.0f;		
	vertex[1].rhw = 1.0f;	
	vertex[2].rhw = 1.0f;	
	vertex[3].rhw = 1.0f;

	vertex[0].color 
		= vertex[1].color 
		= vertex[2].color 
		= vertex[3].color 
		= m_colorDiffuse;

	//	TCYtBbg
	if (m_dwScreenFitMode != BILLBOARD_FIT_NONE){
		RECT	rc;
		FLOAT	wscale,hscale;
		D3DVIEWPORT9	vp;
		if (SUCCEEDED(lpd3ddev->GetViewport(&vp))){
			rc.left = vp.X;
			rc.top = vp.Y;
			rc.right = vp.X + vp.Width;
			rc.bottom = vp.Y + vp.Height;
			CalculateScreenScaledViewport(&rc,&wscale,&hscale);
			for (int i = 0; i < 4 ; ++i){
				vertex[i].x *= wscale;
				vertex[i].x += rc.left;
				vertex[i].y *= hscale;
				vertex[i].y += rc.top;
			}
			//	NbsO𔺂ꍇ
			if (m_dwScreenFitMode & BILLBOARD_FIT_CLIPPING){
				D3DVIEWPORT9	vp2;
				//	̃r[|[g傫Ȃ͉̂
				rc.left = max(rc.left, (LONG)vp.X);
				rc.top  = max(rc.top, (LONG)vp.Y);
				rc.right = min(rc.right, (LONG)(vp.X+vp.Width));
				rc.bottom = min(rc.bottom, (LONG)(vp.Y+vp.Height));

				vp2.X = rc.left;
				vp2.Y = rc.top;
				vp2.Width = rc.right - rc.left;
				vp2.Height = rc.bottom - rc.top;
				vp2.MinZ = vp.MinZ;
				vp2.MaxZ = vp.MaxZ;

				lpd3ddev->SetViewport(&vp2);
				render2dvertex(lpd3ddev,vertex,m_uiBlendMethod,m_lpD3DEnv->IsDepthBufferActive(),pTex);
				lpd3ddev->SetViewport(&vp);
			}else
				render2dvertex(lpd3ddev,vertex,m_uiBlendMethod,m_lpD3DEnv->IsDepthBufferActive(),pTex);
		}
	}else{
		render2dvertex(lpd3ddev,vertex,this->m_uiBlendMethod,this->m_lpD3DEnv->IsDepthBufferActive(),pTex);
	}
}



//	ftHgl
DWORD	CBillboard::m_dwDefaultScreenWidth = 640;
DWORD	CBillboard::m_dwDefaultScreenHeight = 480;
DWORD	CBillboard::m_dwDefaultScreenFitMode = BILLBOARD_FIT_NONE;
